/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.jbig2;

import com.levigo.jbig2.Bitmap;
import com.levigo.jbig2.JBIG2Document;
import com.levigo.jbig2.JBIG2Globals;
import com.levigo.jbig2.JBIG2ImageMetadata;
import com.levigo.jbig2.JBIG2Page;
import com.levigo.jbig2.JBIG2ReadParam;
import com.levigo.jbig2.err.JBIG2Exception;
import com.levigo.jbig2.image.Bitmaps;
import com.levigo.jbig2.image.FilterType;
import com.levigo.jbig2.util.cache.CacheFactory;
import com.levigo.jbig2.util.log.Logger;
import com.levigo.jbig2.util.log.LoggerFactory;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class JBIG2ImageReader
extends ImageReader {
    private static final Logger log = LoggerFactory.getLogger(JBIG2ImageReader.class);
    public static final boolean DEBUG = false;
    public static final boolean PERFORMANCE_TEST = false;
    private JBIG2Document document;
    private JBIG2Globals globals;

    public JBIG2ImageReader(ImageReaderSpi imageReaderSpi) throws IOException {
        super(imageReaderSpi);
    }

    @Override
    public JBIG2ReadParam getDefaultReadParam() {
        return new JBIG2ReadParam();
    }

    private JBIG2ReadParam getDefaultReadParam(int n) {
        int n2;
        int n3;
        block2: {
            n3 = 1;
            n2 = 1;
            try {
                int n4 = n < this.getDocument().getAmountOfPages() ? n : 0;
                n3 = this.getWidth(n4);
                n2 = this.getHeight(n4);
            }
            catch (IOException iOException) {
                if (!log.isInfoEnabled()) break block2;
                log.info("Dimensions could not be determined. Returning read params with size " + n3 + "x" + n2);
            }
        }
        return new JBIG2ReadParam(1, 1, 0, 0, new Rectangle(0, 0, n3, n2), new Dimension(n3, n2));
    }

    @Override
    public int getWidth(int n) throws IOException {
        return this.getDocument().getPage(n + 1).getWidth();
    }

    @Override
    public int getHeight(int n) throws IOException {
        try {
            return this.getDocument().getPage(n + 1).getHeight();
        }
        catch (JBIG2Exception jBIG2Exception) {
            throw new IOException(jBIG2Exception.getMessage());
        }
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        return new JBIG2ImageMetadata(this.getDocument().getPage(n + 1));
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
        arrayList.add(ImageTypeSpecifier.createFromBufferedImageType(13));
        return arrayList.iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getNumImages(boolean bl) throws IOException {
        if (bl) {
            if (!this.getDocument().isAmountOfPagesUnknown()) return this.getDocument().getAmountOfPages();
            log.info("Amount of pages is unknown.");
            return -1;
        } else {
            log.info("Search is not allowed.");
        }
        return -1;
    }

    @Override
    public IIOMetadata getStreamMetadata() {
        log.info("No metadata recorded");
        return null;
    }

    public JBIG2Globals getGlobals() throws IOException {
        return this.getDocument().getGlobalSegments();
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        if (imageReadParam == null) {
            log.info("JBIG2ReadParam not specified. Default will be used.");
            imageReadParam = this.getDefaultReadParam(n);
        }
        JBIG2Page jBIG2Page = this.getPage(n);
        Bitmap bitmap = (Bitmap)CacheFactory.getCache().get(jBIG2Page);
        if (bitmap == null) {
            try {
                bitmap = jBIG2Page.getBitmap();
                CacheFactory.getCache().put(jBIG2Page, bitmap, bitmap.getMemorySize());
                jBIG2Page.clearPageData();
            }
            catch (JBIG2Exception jBIG2Exception) {
                throw new IOException(jBIG2Exception.getMessage());
            }
        }
        return Bitmaps.asBufferedImage(bitmap, imageReadParam, FilterType.Gaussian);
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    @Override
    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        if (imageReadParam == null) {
            log.info("JBIG2ReadParam not specified. Default will be used.");
            imageReadParam = this.getDefaultReadParam(n);
        }
        JBIG2Page jBIG2Page = this.getPage(n);
        Bitmap bitmap = (Bitmap)CacheFactory.getCache().get(jBIG2Page);
        if (bitmap == null) {
            try {
                bitmap = jBIG2Page.getBitmap();
                CacheFactory.getCache().put(jBIG2Page, bitmap, bitmap.getMemorySize());
                jBIG2Page.clearPageData();
            }
            catch (JBIG2Exception jBIG2Exception) {
                throw new IOException(jBIG2Exception.getMessage());
            }
        }
        return Bitmaps.asRaster(bitmap, imageReadParam, FilterType.Gaussian);
    }

    public JBIG2Globals processGlobals(ImageInputStream imageInputStream) throws IOException {
        JBIG2Document jBIG2Document = new JBIG2Document(imageInputStream);
        return jBIG2Document.getGlobalSegments();
    }

    public void setGlobals(JBIG2Globals jBIG2Globals) throws IOException {
        this.globals = jBIG2Globals;
        this.document = null;
    }

    @Override
    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.document = null;
    }

    private JBIG2Document getDocument() throws IOException {
        if (this.document == null) {
            if (this.input == null) {
                throw new IOException("Input not set.");
            }
            if (this.globals == null) {
                log.debug("Globals not set.");
            }
            this.document = new JBIG2Document((ImageInputStream)this.input, this.globals);
        }
        return this.document;
    }

    private JBIG2Page getPage(int n) throws IOException {
        JBIG2Page jBIG2Page = this.getDocument().getPage(n + 1);
        if (jBIG2Page == null) {
            throw new IndexOutOfBoundsException("Requested page at index=" + n + " does not exist.");
        }
        return jBIG2Page;
    }
}

