/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Dimension2D;
import jidefx.utils.converter.ConverterContext;
import jidefx.utils.converter.DefaultObjectConverter;
import jidefx.utils.converter.ObjectConverterManager;
import jidefx.utils.converter.RequiringConverterManager;
import jidefx.utils.converter.javafx.Dimension2DConverter;

public abstract class ValuesConverter<T, S>
extends DefaultObjectConverter<T>
implements RequiringConverterManager {
    private String _separator;
    private Class<?> _elementClass;
    private Class<?>[] _elementClasses;

    public ValuesConverter(String separator, Class<?> elementClass) {
        this._separator = separator;
        this._elementClass = elementClass;
    }

    public ValuesConverter(String separator, Class<?>[] elementClasses) {
        if (separator == null || separator.trim().length() == 0) {
            throw new IllegalArgumentException("separator cannot be empty.");
        }
        if (elementClasses == null) {
            throw new IllegalArgumentException("elementClasses cannot be null.");
        }
        this._separator = separator;
        this._elementClasses = elementClasses;
    }

    public String valuesToString(List<S> objects, ConverterContext context) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < objects.size(); ++i) {
            S o = objects.get(i);
            buffer.append(this.toString(i, o, context));
            if (i == objects.size() - 1) continue;
            buffer.append(this._separator);
        }
        return new String(buffer);
    }

    protected String toString(int i, S o, ConverterContext context) {
        ObjectConverterManager instance = this.getObjectConverterManager(context);
        return instance.toString(o, this.getElementClass(i), context);
    }

    public List<S> valuesFromString(String string, ConverterContext context) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String[] ss = string.split(this._separator.trim());
        ArrayList<S> objects = new ArrayList<S>();
        for (int i = 0; i < ss.length && i < ss.length; ++i) {
            String s = ss[i].trim();
            objects.add(this.fromString(i, s, context));
        }
        return objects;
    }

    protected S fromString(int i, String s, ConverterContext context) {
        ObjectConverterManager instance = this.getObjectConverterManager(context);
        return (S)instance.fromString(s, this.getElementClass(i), context);
    }

    public Class<?> getElementClass(int index) {
        return this._elementClasses != null ? this._elementClasses[index] : this._elementClass;
    }

    public static void main(String[] args) {
        ObjectConverterManager manager = new ObjectConverterManager();
        manager.setAutoInit(false);
        manager.unregisterAllConverters();
        manager.registerConverter(Dimension2D.class, new Dimension2DConverter("|"));
        String s = manager.toString(new Dimension2D(100.0, 200.0), Dimension2D.class);
        System.out.println(s);
    }
}

