/*
 * Decompiled with CFR 0.152.
 */
package jidefx.utils.converter;

import java.io.Serializable;
import java.util.HashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;

public class ConverterContext
implements Serializable {
    private static final long serialVersionUID = 8015351559541303641L;
    private String _name;
    public static final ConverterContext CONTEXT_DEFAULT = new ConverterContext("");
    public static final String PROPERTY_OBJECT_CONVERTER_MANAGER = "ObjectConverterManager";
    private ObservableMap<Object, Object> _properties;

    public ConverterContext(String name) {
        this._name = name;
    }

    public static boolean isArrayConverterContext(ConverterContext context) {
        return context != null && context.getName() != null && context.getName().endsWith("[]");
    }

    public static ConverterContext getElementConverterContext(ConverterContext context) {
        if (ConverterContext.isArrayConverterContext(context)) {
            return new ConverterContext(context.getName().substring(0, context.getName().length() - 2));
        }
        return context;
    }

    public static ConverterContext getArrayConverterContext(ConverterContext context) {
        if (!ConverterContext.isArrayConverterContext(context)) {
            return new ConverterContext(context.getName() + "[]");
        }
        return context;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this._properties == null) {
            this._properties = FXCollections.observableMap(new HashMap());
        }
        return this._properties;
    }

    public boolean hasProperties() {
        return this._properties != null && !this._properties.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConverterContext)) {
            return false;
        }
        ConverterContext context = (ConverterContext)o;
        return !(this._name == null ? context._name != null : !this._name.equals(context._name));
    }

    public int hashCode() {
        return this._name != null ? this._name.hashCode() : 0;
    }

    public String toString() {
        return this.getName();
    }
}

