/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.exceptions;

public enum LocalDBClientExceptionMessage {
    BAD_TABLE_NAME("Invalid table/index name.  Table/index names must be between 3 and 255 characters long, and may contain only the characters a-z, A-Z, 0-9, '_', '-', and '.'"),
    NO_KEY_SCHEMA("No defined key schema.  A key schema containing at least a hash key must be defined for all tables"),
    NO_ATTRIBUTE_SCHEMA("No Attribute Schema Defined"),
    UNSPECIFIED_KEY_TYPE("One or more keys is not specified as being hash or range."),
    NO_HASH_KEY("No Hash Key specified in schema.  All Dynamo DB tables must have exactly one hash key"),
    NON_SPECIFIED_HASH_KEY("Hash Key not specified in Attribute Definitions.  Type unknown."),
    NON_SPECIFIED_RANGE_KEY("Range Key not specified in Attribute Definitions.  Type unknown."),
    NON_SPECIFIED_LSI_RANGE_KEY("Local Secondary Index range key not specified in Attribute Definitons.Type unknown."),
    KEY_SCHEMA_TOO_BIG("Key Schema too big.  Key Schema must at most consist of the hash and range key of a table"),
    INCORRECT_KEY_SCHEMA_ORDER("Invalid key order.  Hash Key must be specified first in key schema, Range Key must be specifed second"),
    IDENTICALLY_NAMED_KEYS("Two keys can not have the same name"),
    TOO_MANY_HASH_KEYS("Too many hash keys specified.  All Dynamo DB tables must have exactly one hash key"),
    TOO_MANY_ATTRIBUTES("Unnecessary Attributes Defined"),
    INVALID_DATATYPE("Key datatypes must be scalars, not sets"),
    DOUBLE_DATATYPE("Attribute has two datatypes.  Only one datatype (and piece of data) allowed per attribute"),
    INVALID_PUT_NULL("Item to put in PutItem cannot be null"),
    NO_SPECIFED_KEY_VALUE("One of the required keys was not given a value"),
    INCONSISTENT_TYPES("Type of specified attribute inconsistent with type in table"),
    MISSING_KEY("Cannot have null key for GetItem, DeleteItem, or UpdateItem"),
    INCONSISTENT_GET_CONDITION_SIZE("The number of conditions on the keys is invalid"),
    BAD_GET_CONDITION("Get Condition for key not in key list"),
    NO_LSI_ALLOWED("Local Secondary indices are not allowed on hash tables, only hash and range tables"),
    INVALID_LSI("Local Secondary indices must have the same hash key as the main table"),
    INVALID_LSI_NO_RANGE("Local secondary indices must have a range key"),
    INVALID_LSI_NO_PROJECTION("Local secondary indices must have a projection specified"),
    SAME_NAME_LSI("Two local secondary indicies have the same name"),
    INVALID_THROUGHPUT_NULL("No provisioned throughput specified for the table"),
    IDENTICAL_ATTRIBUTE_NAMES("Cannot have two attributes with the same name"),
    INVALID_QUERY_TABLE("Queries may only be performed on hash and range tables"),
    INVALID_QUERY_NON_EXISTENT_INDEX("Specified Local Secondary Index is not part of table"),
    INVALID_QUERY_NO_CONDITIONS("Key Conditions on query must not be null"),
    INVALID_QUERY_EXCESS_CONDITIONS("There are too many conditions in this query"),
    INVALID_QUERY_NON_MATCHING_RANGE("Range Condition does not match range key"),
    INVALID_QUERY_NO_HASH("All queries must have a condition on the hash key, and it must be of type EQ"),
    INVALID_QUERY_KEY_NOT_SPECIFIED("Must specify an expected value and comparison type for the all keys being queried"),
    INVALID_EXCLUSIVE_START_HASH("Hash Key of Exclusive start key must matchhash key of table"),
    INVALID_EXCLUSIVE_START_RANGE("Range Key of Exclusive start key must match range key of table"),
    INVALID_RETURN_VALUES_TYPE("Return values set to invalid value"),
    NON_NUMERIC_VALUE("A value provided cannot be converted into a number"),
    INVALID_TOTAL_SEGMENTS_VALUE("If specified, total segments must be between 1 and 4096 inclusive"),
    SEGMENT_NOT_SET("If total segments is specfied, a particular segment must also be specified for this request"),
    INVALID_EXCLUSIVE_START_KEY_FOR_SCAN("Exclusive start key must lie within the segment"),
    TOTAL_SEGMENTS_NOT_SET("If segment is specified, total segment must also be specified"),
    INVALID_SEGMENT_VALUE("Specified segment must be a valid value >= 0 and less than the number of total segments"),
    INVALID_LIMIT_VALUE("Limit must be greater than or equal to 1"),
    INVALID_LIMIT_TOO_BIG("Limit in ListTables must be <= 100"),
    INVALID_EXCLUSIVE_START_SIZE("Exclusive Start Key must have same size as  table's key schema"),
    NOT_SAME_SCAN("To use the setNumPerSegment method, you must use a scan from the same table with the same segment values"),
    TABLE_ALREADY_EXISTS("Cannot create preexisting table"),
    INVALID_SET_EMPTY("Sets cannot be empty"),
    LSI_NOT_IN_TABLE("The specified index is not in the table"),
    INVALID_SET_DUPLICATES("Set contains duplicates"),
    TOO_MANY_LSI("Cannot have more than 5 local secondary indexes per table"),
    INVALID_PROJECTION_TYPE("Projection type must be INCLUDE, ALL, or KEYS_ONLY"),
    NO_PROJECTED_ATTRS("If Projection type INCLUDE is specified, some non-key attributes to include in the projection must be specified as well"),
    TOO_MANY_PROJECTED("No more than 20 attributes per table can be projected into Local Secondary Indices"),
    ATTRIBUTE_NAME_TOO_LONG("Names of key attributes and attributes projected into LSI must be between 1 and 255 characters, inclusive"),
    INVALID_PROJECTED_ATTRS("No attributes should be specified to be projected unless projection type is INCLUDE"),
    INVALID_THROUGHPUT_VALUES("Read and write throughput must be at least 1, and cannot be null"),
    TABLE_DOES_NOT_EXIST("Cannot do operations on a non-existent table"),
    INVALID_COMPARISON("Comparison type does not exist in DynamoDB"),
    INVALID_COMPARISON_QUERY("Comparison type not valid for query"),
    INVALID_EXPECTED_TRUE("Exists set to true but no value given"),
    INVALID_EXPECTED_FALSE("Cannot expect an attribute to both not exist and have a value"),
    ATTRIBUTES_EMPTY("AttributesToGet cannot be empty"),
    INVALID_SELECT("Select must be ALL_ATTRIBUTES, ALL_PROJECTED_ATTRIBUTES, COUNT, or SPECIFIC_ATTRIBUTES"),
    INVALID_SELECT_ATTRIBUTES("AttributesToGet may only be set if Select is SPECIFIC_ATTRIBUTES"),
    INVALID_SELECT_NO_ATTRIBUTES("If Select is set to SPECIFIC_ATTRIBUTES, AttributesToGet cannot be null"),
    INVALID_SELECT_INDEX("Select can only be ALL_PROJECTED_ATTRIBUTES when querying an index, not a table"),
    INVALID_COMPARISON_DATATYPE_BEGINS("Comparison Operator BEGINS can only be used withBinary or String values, not Numbers or Sets"),
    INVALID_COMPARISON_BETWEEN("Comparison Operator BETWEEN requires two pivots"),
    INVALID_BETWEEN_PIVOTS("First value in BETWEEN comparison must be less than or equal to second value"),
    INVALID_COMPARISON_NOT_BETWEEN_IN("Only Comparsion Operators BETWEEN and IN take more than one pivot"),
    INVALID_COMPARISON_NULL("Comparison Operators NULL and NOT_NULL do not take pivots"),
    CHECK_FAILED_EXISTS("Expected attribute not found."),
    CHECK_FAILED_NOT_EXISTS("Attribute found when none expected."),
    INVALID_ACTION_TYPE("Action must be PUT, DELETE, or ADD"),
    INVALID_ACTION_NO_VALUE("Only DELETE may specify no attribute value"),
    INVALID_ACTION_DELETE("DELETE only valid for no attribute value, or a set value"),
    INVALID_ACTION_ADD("ADD must specify an attribute value of type number or set"),
    INVALID_UPDATE_PRIMARY_KEY("Cannot update primary key attributes"),
    INVALID_UPDATE_INDEX_KEY("Updates on index keys must be of the same data type as the key attribute"),
    NUMBER_OUT_OF_RANGE("Dynamo DB only supports number scales between 10^-128 and 10^126"),
    NUMBER_TOO_PRECISE("DynamoDB only supports precision up to 38 digits"),
    INVALID_COMPARISON_SETS("Set types may not be used for scan filters or query comparisons"),
    INVALID_COMPARISON_IN_DATATYPES("AttributeValueList of ComparisonType IN must have all values of the same datatype"),
    INVALID_COMPARISON_NO_DATA("AttributeValueList must be non-null and have at least one member for all comparison types except NULL and NOT_NULL"),
    INVALID_EXCLUSIVE_START_QUERY("ExclusiveStartKey must fit the query conditions"),
    TOO_MANY_REQUESTED_ITEMS("BatchGetItem cannot fetch more than 100 items"),
    TOO_MUCH_THROUGHPUT("Cannot increase provisioned throughput to more than twice current value"),
    TOO_MUCH_THROUGHPUT_TABLE("Cannot increase provisioned throughput to more than 40,000 units per table"),
    TOO_MUCH_THROUGHPUT_ACCOUNT("Cannot increase provisioned throughput to more than 80,000 units per account"),
    MISSING_ITEM("Cannot put a null item"),
    BATCH_GET_NULL_REQUESTS("BatchGetItem must have some requests set"),
    BATCH_GET_NULL_REQUEST_ENTRY("BatchGetItem cannot have a null request in its requests set"),
    BATCH_GET_TOO_MANY_REQUESTED_ITEMS("BatchGetItem cannot fetch more than 100 items"),
    BATCH_WRITE_NULL_REQUESTS("BatchWriteItem cannot have a null or no requests set"),
    BATCH_WRITE_NULL_REQUEST_ENTRY("BatchWriteItem cannot have a null or empty list of requests in its requests set"),
    BATCH_WRITE_NULL_INDIVIDUAL_REQUEST("BatchWriteItem cannot have a null request in any part of its requests set"),
    BATCH_WRITE_TOO_MANY_REQUESTS("BatchWriteItem cannot write more than 25 items"),
    BATCH_WRITE_TWO_IN_ONE("Each request in a BatchWriteItem must be Put or Delete, not both"),
    BATCH_WRITE_NO_REQUEST_TYPE("Each request in a BatchWriteItem must be Put or Delete"),
    BATCH_WRITE_SAME_ITEM("Cannot perform multiple operations on the same item in a BatchWriteItem"),
    BATCH_WRITE_TOO_BIG("BatchWriteItem cannot have a request size of more than 1 MB"),
    ITEM_TOO_BIG("Item size is limited to 64 kB, including attribute names"),
    KEY_VALUE_TOO_BIG("Hash primary key values must be under 2048 bytes, and range primary key values must be under 1024 bytes"),
    NO_ATTRIBUTE_NAME("Attribute name must be specified."),
    NO_KEYS("Keys must be specified in the request items");

    private String message;

    private LocalDBClientExceptionMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }
}

