/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android;

import com.jayway.maven.plugins.android.InvalidNdkException;
import com.jayway.maven.plugins.android.configuration.NDKArchitectureToolchainMappings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class AndroidNdk {
    public static final String PROPER_NDK_HOME_DIRECTORY_MESSAGE = "Please provide a proper Android NDK directory path as configuration parameter <ndk><path>...</path></ndk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.ndk.path=... or set environment variable ANDROID_NDK_HOME.";
    public static final String[] NDK_ARCHITECTURES = new String[]{"armeabi", "armeabi-v7a", "mips", "x86"};
    public static final String[] ARM_TOOLCHAIN = new String[]{"arm-linux-androideabi-4.9", "arm-linux-androideabi-4.8", "arm-linux-androideabi-4.7", "arm-linux-androideabi-4.6", "arm-linux-androideabi-4.4.3"};
    public static final String[] X86_TOOLCHAIN = new String[]{"x86-4.9", "x86-4.8", "x86-4.7", "x86-4.6", "x86-4.4.3"};
    public static final String[] MIPS_TOOLCHAIN = new String[]{"mipsel-linux-android-4.9", "mipsel-linux-android-4.8", "mipsel-linux-android-4.7", "mipsel-linux-android-4.6", "mipsel-linux-android-4.4.3"};
    private static final String[] GDB_SERVER_LOCATIONS = new String[]{"toolchains/%s/prebuilt/gdbserver", "prebuilt/%s/gdbserver/gdbserver"};
    private final File ndkPath;

    public AndroidNdk(File ndkPath) {
        this.assertPathIsDirectory(ndkPath);
        this.ndkPath = ndkPath;
    }

    private void assertPathIsDirectory(File path) {
        if (path == null) {
            throw new InvalidNdkException(PROPER_NDK_HOME_DIRECTORY_MESSAGE);
        }
        if (!path.isDirectory()) {
            throw new InvalidNdkException("Path \"" + path + "\" is not a directory. " + PROPER_NDK_HOME_DIRECTORY_MESSAGE);
        }
    }

    private File findStripper(String toolchain) {
        ArrayList<String> osDirectories = new ArrayList<String>();
        String extension = "";
        if (SystemUtils.IS_OS_LINUX) {
            osDirectories.add("linux-x86");
            osDirectories.add("linux-x86_64");
        } else if (SystemUtils.IS_OS_WINDOWS) {
            osDirectories.add("windows");
            osDirectories.add("windows-x86_64");
            extension = ".exe";
        } else if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX) {
            osDirectories.add("darwin-x86");
            osDirectories.add("darwin-x86_64");
        }
        String fileName = "";
        if (toolchain.startsWith("arm")) {
            fileName = "arm-linux-androideabi-strip" + extension;
        } else if (toolchain.startsWith("x86")) {
            fileName = "i686-linux-android-strip" + extension;
        } else if (toolchain.startsWith("mips")) {
            fileName = "mipsel-linux-android-strip" + extension;
        }
        for (String osDirectory : osDirectories) {
            String stripperLocation = String.format("toolchains/%s/prebuilt/%s/bin/%s", toolchain, osDirectory, fileName);
            File stripper = new File(this.ndkPath, stripperLocation);
            if (!stripper.exists()) continue;
            return stripper;
        }
        return null;
    }

    public File getStripper(String toolchain) throws MojoExecutionException {
        File stripper = this.findStripper(toolchain);
        if (stripper == null) {
            throw new MojoExecutionException("Could not resolve stripper for current OS: " + SystemUtils.OS_NAME);
        }
        if (!stripper.exists()) {
            throw new MojoExecutionException("Strip binary " + stripper.getAbsolutePath() + " does not exist, please double check the toolchain and OS used");
        }
        return stripper;
    }

    private String resolveNdkToolchain(String[] toolchains) {
        for (String toolchain : toolchains) {
            File f = this.findStripper(toolchain);
            if (f == null || !f.exists()) continue;
            return toolchain;
        }
        return null;
    }

    public String getToolchain(File file) throws MojoExecutionException {
        String resolvedNdkToolchain = null;
        String ndkArchitecture = file.getParentFile().getName();
        if (ndkArchitecture.startsWith("arm")) {
            resolvedNdkToolchain = this.resolveNdkToolchain(ARM_TOOLCHAIN);
        } else if (ndkArchitecture.startsWith("x86")) {
            resolvedNdkToolchain = this.resolveNdkToolchain(X86_TOOLCHAIN);
        } else if (ndkArchitecture.startsWith("mips")) {
            resolvedNdkToolchain = this.resolveNdkToolchain(MIPS_TOOLCHAIN);
        }
        if (resolvedNdkToolchain == null) {
            throw new MojoExecutionException("Can not resolve automatically a toolchain to use. Please specify one.");
        }
        return resolvedNdkToolchain;
    }

    public String getNdkBuildPath() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return new File(this.ndkPath, "/ndk-build.cmd").getAbsolutePath();
        }
        return new File(this.ndkPath, "/ndk-build").getAbsolutePath();
    }

    public File getGdbServer(String ndkArchitecture) throws MojoExecutionException {
        ArrayList<String> gdbServerLocations = new ArrayList<String>();
        if (ndkArchitecture.startsWith("arm")) {
            gdbServerLocations.add("android-arm");
            gdbServerLocations.addAll(Arrays.asList(ARM_TOOLCHAIN));
        } else if (ndkArchitecture.startsWith("x86")) {
            gdbServerLocations.add("android-x86");
            gdbServerLocations.addAll(Arrays.asList(X86_TOOLCHAIN));
        } else if (ndkArchitecture.startsWith("mips")) {
            gdbServerLocations.add("android-mips");
            gdbServerLocations.addAll(Arrays.asList(MIPS_TOOLCHAIN));
        }
        for (String location : GDB_SERVER_LOCATIONS) {
            for (String gdbServerLocation : gdbServerLocations) {
                File gdbServerFile = new File(this.ndkPath, String.format(location, gdbServerLocation));
                if (!gdbServerFile.exists()) continue;
                return gdbServerFile;
            }
        }
        throw new MojoExecutionException("gdbserver binary for architecture " + ndkArchitecture + " does not exist, please double check the toolchain and OS used");
    }

    public String getToolchainFromArchitecture(String ndkArchitecture, NDKArchitectureToolchainMappings ndkArchitectureToolchainMappings) throws MojoExecutionException {
        if (ndkArchitecture.startsWith("arm")) {
            if (ndkArchitectureToolchainMappings != null) {
                return ndkArchitectureToolchainMappings.getArmeabi();
            }
            return ARM_TOOLCHAIN[0];
        }
        if (ndkArchitecture.startsWith("x86")) {
            if (ndkArchitectureToolchainMappings != null) {
                return ndkArchitectureToolchainMappings.getX86();
            }
            return X86_TOOLCHAIN[0];
        }
        if (ndkArchitecture.startsWith("mips")) {
            if (ndkArchitectureToolchainMappings != null) {
                return ndkArchitectureToolchainMappings.getMips();
            }
            return MIPS_TOOLCHAIN[0];
        }
        throw new MojoExecutionException("Toolchain for architecture " + ndkArchitecture + " does not exist, please double check the setup");
    }
}

