/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.sparql.util.Named;
import com.hp.hpl.jena.tdb.TDBException;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.io.Printable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BlockType implements Printable,
Named
{
    BTREE_NODE{

        public String getName() {
            return "BTreeNode";
        }

        public int id() {
            return 5;
        }
    }
    ,
    BPTREE_BRANCH{

        public String getName() {
            return "BPlusTreeBranch";
        }

        public int id() {
            return 6;
        }
    }
    ,
    BPTREE_LEAF{

        public String getName() {
            return "BPlusTreeLeaf";
        }

        public int id() {
            return 7;
        }
    }
    ,
    DICTIONARY{

        public String getName() {
            return "Dictionary";
        }

        public int id() {
            return 10;
        }
    }
    ,
    RECORD_BLOCK{

        public String getName() {
            return "RecordBlock";
        }

        public int id() {
            return 99;
        }
    };


    public void output(IndentedWriter out) {
        out.print((Object)this.getName());
    }

    public abstract int id();

    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    public static BlockType extract(int x) {
        if (x == BTREE_NODE.id()) {
            return BTREE_NODE;
        }
        if (x == BPTREE_BRANCH.id()) {
            return BPTREE_BRANCH;
        }
        if (x == BPTREE_LEAF.id()) {
            return BPTREE_LEAF;
        }
        if (x == RECORD_BLOCK.id()) {
            return RECORD_BLOCK;
        }
        if (x == DICTIONARY.id()) {
            return DICTIONARY;
        }
        throw new TDBException("No known block type for " + x);
    }
}

