/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeConst;

public class AggCountVarDistinct
extends AggregatorBase {
    private Expr expr;

    public AggCountVarDistinct(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy(Expr expr) {
        return new AggCountVarDistinct(expr);
    }

    public String toString() {
        return "count(distinct " + this.expr + ")";
    }

    public String toPrefixString() {
        return "(count distinct " + this.expr + ")";
    }

    protected Accumulator createAccumulator() {
        return new AccCountVarDistinct();
    }

    public Expr getExpr() {
        return this.expr;
    }

    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    public int hashCode() {
        return 0x174 ^ this.expr.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AggCountVarDistinct)) {
            return false;
        }
        AggCountVarDistinct agg = (AggCountVarDistinct)other;
        return agg.getExpr().equals(this.getExpr());
    }

    class AccCountVarDistinct
    extends AccumulatorDistinctExpr {
        private long count;

        public AccCountVarDistinct() {
            super(AggCountVarDistinct.this.expr);
            this.count = 0L;
        }

        public void accumulateDistinct(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        public NodeValue getAccValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

