/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.common.catalog;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CatalogResponse {
    private int responseCode;
    private String responseMessage;
    private Object entity;
    private Collection<?> entities;

    private CatalogResponse() {
    }

    public static Builder newResponse(ResponseMessage msg) {
        return new Builder(msg);
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Object getEntity() {
        return this.entity;
    }

    public Collection<?> getEntities() {
        return this.entities;
    }

    public static class Builder {
        private final ResponseMessage responseMessage;
        private Object entity;
        private Collection<?> entities;
        private final String DOC_LINK_MESSAGE = " Please check webservice/ErrorCodes.md for more details.";

        public Builder(ResponseMessage responseMessage) {
            this.responseMessage = responseMessage;
        }

        public Builder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        public Builder entities(Collection<?> entities) {
            this.entities = entities;
            return this;
        }

        public CatalogResponse format(String ... args) {
            CatalogResponse response = new CatalogResponse();
            response.responseCode = this.responseMessage.code;
            response.responseMessage = ResponseMessage.format(this.responseMessage, args);
            response.entity = this.entity;
            response.entities = this.entities;
            return response;
        }
    }

    public static enum ResponseMessage {
        SUCCESS(1000, "Success", 0),
        ENTITY_NOT_FOUND(1101, "Entity with id [%s] not found.", 1),
        EXCEPTION(1102, "An exception was thrown while processing request with message: [%s]", 1),
        BAD_REQUEST_PARAM_MISSING(1103, "Bad request - %s.", 1),
        DATASOURCE_TYPE_FILTER_NOT_FOUND(1104, "Datasource not found for type [%s], query params [%s].", 2),
        ENTITY_NOT_FOUND_FOR_FILTER(1105, "Entity not found for query params [%s].", 1),
        INCOMPATIBLE_SCHEMA(1106, "%s", 1),
        INVALID_SCHEMA(1107, "Given schema is invalid. %s", 1),
        UNSUPPORTED_SCHEMA_TYPE(1108, "Given schema type is not supported.", 0),
        UNSUPPORTED_MEDIA_TYPE(1109, "Unsupported Media Type.", 0),
        BAD_REQUEST(1110, "Bad Request.", 0),
        ENTITY_CONFLICT(1111, "An entity with id [%s] already exists", 1),
        BAD_REQUEST_WITH_MESSAGE(1112, "Bad Request - %s", 1);

        private final int code;
        private final String msg;
        private final int nargs;

        private ResponseMessage(int code, String msg, int nargs) {
            this.code = code;
            this.msg = msg;
            this.nargs = nargs;
        }

        private boolean isError() {
            return this.code > 1100;
        }

        public int getCode() {
            return this.code;
        }

        public static String format(ResponseMessage responseMessage, String ... args) {
            return String.format(responseMessage.msg, args);
        }
    }
}

