package com.herbocailleau.sgq.entities;

import java.util.Collection;
import org.nuiton.topia.persistence.TopiaEntity;

public interface Product extends TopiaEntity {

    String PROPERTY_CODE = "code";

    String PROPERTY_NAME = "name";

    String PROPERTY_CATEGORY = "category";

    String PROPERTY_LATIN_NAME = "latinName";

    String PROPERTY_FAMILY = "family";

    String PROPERTY_BOTANIC_CONTROL = "botanicControl";

    String PROPERTY_IDENTIFICATION_CONTROL = "identificationControl";

    String PROPERTY_COMMENT = "comment";

    String PROPERTY_ARCHIVED = "archived";

    String PROPERTY_PRODUCT_STATUS = "productStatus";

    String PROPERTY_ANALYZE_TYPE = "analyzeType";

    String PROPERTY_PLACE_PRODUCT_PLACE = "placeProductPlace";

    void setCode(String code);

    String getCode();

    void setName(String name);

    String getName();

    void setCategory(String category);

    String getCategory();

    void setLatinName(String latinName);

    String getLatinName();

    void setFamily(String family);

    String getFamily();

    void setBotanicControl(boolean botanicControl);

    boolean isBotanicControl();

    boolean getBotanicControl();

    void setIdentificationControl(boolean identificationControl);

    boolean isIdentificationControl();

    boolean getIdentificationControl();

    void setComment(String comment);

    String getComment();

    void setArchived(boolean archived);

    boolean isArchived();

    boolean getArchived();

    void addProductStatus(ProductStatus productStatus);

    void addAllProductStatus(Collection<ProductStatus> productStatus);

    void setProductStatus(Collection<ProductStatus> productStatus);

    void removeProductStatus(ProductStatus productStatus);

    void clearProductStatus();

    Collection<ProductStatus> getProductStatus();

    ProductStatus getProductStatusByTopiaId(String topiaId);

    int sizeProductStatus();

    boolean isProductStatusEmpty();

    void addAnalyzeType(AnalyzeType analyzeType);

    void addAllAnalyzeType(Collection<AnalyzeType> analyzeType);

    void setAnalyzeType(Collection<AnalyzeType> analyzeType);

    void removeAnalyzeType(AnalyzeType analyzeType);

    void clearAnalyzeType();

    Collection<AnalyzeType> getAnalyzeType();

    AnalyzeType getAnalyzeTypeByTopiaId(String topiaId);

    int sizeAnalyzeType();

    boolean isAnalyzeTypeEmpty();

} //Product
