package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PresentationDAOAbstract<E extends Presentation> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Presentation.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Presentation;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Expedition> list = getContext()
                                                    .getDAO(Expedition.class)
                                                    .findAllByProperties(Expedition.PROPERTY_PRESENTATION, entity);
                                            for (Expedition item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getPresentation())) {
                                                    item.setPresentation(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Production> list = getContext()
                                                    .getDAO(Production.class)
                                                    .findAllByProperties(Production.PROPERTY_PRESENTATION, entity);
                                            for (Production item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getPresentation())) {
                                                    item.setPresentation(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Production> list = getContext()
                                                    .getDAO(Production.class)
                                                    .findAllByProperties(Production.PROPERTY_CORRECTION, entity);
                                            for (Production item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getCorrection())) {
                                                    item.setCorrection(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Expedition> list = getContext()
                                                    .getDAO(Expedition.class)
                                                    .findAllByProperties(Expedition.PROPERTY_CORRECTION, entity);
                                            for (Expedition item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getCorrection())) {
                                                    item.setCorrection(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(Batch batch, PresentationCode presentationCode) throws TopiaException {
        return findByProperties(Presentation.PROPERTY_BATCH, batch, Presentation.PROPERTY_PRESENTATION_CODE, presentationCode);
    }

    public boolean existByNaturalId(Batch batch, PresentationCode presentationCode) throws TopiaException {
        return existByProperties(Presentation.PROPERTY_BATCH, batch, Presentation.PROPERTY_PRESENTATION_CODE, presentationCode);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param batch 
     * @param presentationCode 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(Batch batch, PresentationCode presentationCode) throws TopiaException {
        return create(Presentation.PROPERTY_BATCH, batch, Presentation.PROPERTY_PRESENTATION_CODE, presentationCode);
    }

    public E createByNaturalId(Batch batch, PresentationCode presentationCode) throws TopiaException {
        return create(Presentation.PROPERTY_BATCH, batch, Presentation.PROPERTY_PRESENTATION_CODE, presentationCode);
    }

    public E createByNotNull(Batch batch, PresentationCode presentationCode) throws TopiaException {
        return create(Presentation.PROPERTY_BATCH, batch, Presentation.PROPERTY_PRESENTATION_CODE, presentationCode);
    }

    public E findByQuantity(double v) throws TopiaException {
        E result = findByProperty(Presentation.PROPERTY_QUANTITY, v);
        return result;
    }

    public List<E> findAllByQuantity(double v) throws TopiaException {
        List<E> result = findAllByProperty(Presentation.PROPERTY_QUANTITY, v);
        return result;
    }

    public E findByDmesd(Date v) throws TopiaException {
        E result = findByProperty(Presentation.PROPERTY_DMESD, v);
        return result;
    }

    public List<E> findAllByDmesd(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Presentation.PROPERTY_DMESD, v);
        return result;
    }

    public E findByOriginal(boolean v) throws TopiaException {
        E result = findByProperty(Presentation.PROPERTY_ORIGINAL, v);
        return result;
    }

    public List<E> findAllByOriginal(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Presentation.PROPERTY_ORIGINAL, v);
        return result;
    }

    public E findByBatch(Batch v) throws TopiaException {
        E result = findByProperty(Presentation.PROPERTY_BATCH, v);
        return result;
    }

    public List<E> findAllByBatch(Batch v) throws TopiaException {
        List<E> result = findAllByProperty(Presentation.PROPERTY_BATCH, v);
        return result;
    }

    public E findByPresentationCode(PresentationCode v) throws TopiaException {
        E result = findByProperty(Presentation.PROPERTY_PRESENTATION_CODE, v);
        return result;
    }

    public List<E> findAllByPresentationCode(PresentationCode v) throws TopiaException {
        List<E> result = findAllByProperty(Presentation.PROPERTY_PRESENTATION_CODE, v);
        return result;
    }

    public E findContainsInventoryPlaces(Place v) throws TopiaException {
        E result = findContains(Presentation.PROPERTY_INVENTORY_PLACES, v);
        return result;
    }

    public List<E> findAllContainsInventoryPlaces(Place v) throws TopiaException {
        List<E> result = findAllContains(Presentation.PROPERTY_INVENTORY_PLACES, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Production.class) {
            ProductionDAO dao = (ProductionDAO)
                getContext().getDAO(Production.class);
            tmp = dao.findAllByPresentation(entity);
            result.addAll(tmp);
        }

        if (type == Production.class) {
            ProductionDAO dao = (ProductionDAO)
                getContext().getDAO(Production.class);
            tmp = dao.findAllByCorrection(entity);
            result.addAll(tmp);
        }

        if (type == Expedition.class) {
            ExpeditionDAO dao = (ExpeditionDAO)
                getContext().getDAO(Expedition.class);
            tmp = dao.findAllByPresentation(entity);
            result.addAll(tmp);
        }

        if (type == Expedition.class) {
            ExpeditionDAO dao = (ExpeditionDAO)
                getContext().getDAO(Expedition.class);
            tmp = dao.findAllByCorrection(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(Production.class, entity);
        if (!list.isEmpty()) {
            result.put(Production.class, list);
        }

        list = findUsages(Expedition.class, entity);
        if (!list.isEmpty()) {
            result.put(Expedition.class, list);
        }

        return result;
    }

} //PresentationDAOAbstract<E extends Presentation>
