/*
 * #%L
 * SGQ :: Business
 * $Id: PlaceDAOImpl.java 342 2013-04-29 16:57:59Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.0/sgq-business/src/main/java/com/herbocailleau/sgq/entities/PlaceDAOImpl.java $
 * %%
 * Copyright (C) 2012, 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */
package com.herbocailleau.sgq.entities;

import java.util.List;

import org.nuiton.topia.TopiaException;

/**
 * Operations specifiques au emplacements.
 * 
 * @author echatellier
 */
public class PlaceDAOImpl<E extends Place> extends PlaceDAOAbstract<E> {

    /**
     * Delete all Place entities.
     * 
     * @throws TopiaException
     */
    public void deleteAll() throws TopiaException {
        String query = "delete from " + Place.class.getName();
        context.execute(query);
    }

    /**
     * Renvoie les emplacements pour une zone.
     * 
     * @param zone zone (can be null)
     * @throws TopiaException 
     */
    public List<Place> findAllForZone(Zone zone) throws TopiaException {
        String query = "from " + Place.class.getName();

        if (zone != null) {
            query += " WHERE " + Place.PROPERTY_ZONE + " = :zone";
        }
        
        query += " ORDER BY " + Place.PROPERTY_ZONE + " ASC, " + Place.PROPERTY_CODE + " ASC";
        
        List<Place> result;
        if (zone != null) {
            result = context.findAll(query, "zone", zone);
        } else {
            result = context.findAll(query);
        }
        return result;
    }
} //PlaceDAOImpl<E extends Place>
