package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class LabelErrorDAOAbstract<E extends LabelError> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)LabelError.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.LabelError;
    }

    public E findByLine(String v) throws TopiaException {
        E result = findByProperty(LabelError.PROPERTY_LINE, v);
        return result;
    }

    public List<E> findAllByLine(String v) throws TopiaException {
        List<E> result = findAllByProperty(LabelError.PROPERTY_LINE, v);
        return result;
    }

    public E findByMessage(String v) throws TopiaException {
        E result = findByProperty(LabelError.PROPERTY_MESSAGE, v);
        return result;
    }

    public List<E> findAllByMessage(String v) throws TopiaException {
        List<E> result = findAllByProperty(LabelError.PROPERTY_MESSAGE, v);
        return result;
    }

    public E findByLabelDate(Date v) throws TopiaException {
        E result = findByProperty(LabelError.PROPERTY_LABEL_DATE, v);
        return result;
    }

    public List<E> findAllByLabelDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(LabelError.PROPERTY_LABEL_DATE, v);
        return result;
    }

    public E findByModified(boolean v) throws TopiaException {
        E result = findByProperty(LabelError.PROPERTY_MODIFIED, v);
        return result;
    }

    public List<E> findAllByModified(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(LabelError.PROPERTY_MODIFIED, v);
        return result;
    }

    public E findByDeleted(boolean v) throws TopiaException {
        E result = findByProperty(LabelError.PROPERTY_DELETED, v);
        return result;
    }

    public List<E> findAllByDeleted(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(LabelError.PROPERTY_DELETED, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(LabelError.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(LabelError.PROPERTY_COMMENT, v);
        return result;
    }

    public E findBySource(Zone v) throws TopiaException {
        E result = findByProperty(LabelError.PROPERTY_SOURCE, v);
        return result;
    }

    public List<E> findAllBySource(Zone v) throws TopiaException {
        List<E> result = findAllByProperty(LabelError.PROPERTY_SOURCE, v);
        return result;
    }

    public E findByAfterBatchExpiration(Batch v) throws TopiaException {
        E result = findByProperty(LabelError.PROPERTY_AFTER_BATCH_EXPIRATION, v);
        return result;
    }

    public List<E> findAllByAfterBatchExpiration(Batch v) throws TopiaException {
        List<E> result = findAllByProperty(LabelError.PROPERTY_AFTER_BATCH_EXPIRATION, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //LabelErrorDAOAbstract<E extends LabelError>
