package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class BatchAbstract extends TopiaEntityAbstract implements Batch {

    /**
     * Nom de l'attribut en BD : number
     */
    protected int number;

    /**
     * Nom de l'attribut en BD : entryDate
     */
    protected Date entryDate;

    /**
     * Nom de l'attribut en BD : dmes
     */
    protected Date dmes;

    /**
     * Nom de l'attribut en BD : dpmes
     */
    protected Date dpmes;

    /**
     * Nom de l'attribut en BD : dluo
     */
    protected Date dluo;

    /**
     * Nom de l'attribut en BD : spentDate
     */
    protected Date spentDate;

    /**
     * Nom de l'attribut en BD : newAttr
     */
    protected int newAttr;

    /**
     * Nom de l'attribut en BD : analyze
     */
    protected Collection<Analyze> analyze;

    /**
     * Nom de l'attribut en BD : presentation
     */
    protected Collection<Presentation> presentation;

    /**
     * Nom de l'attribut en BD : supplier
     */
    protected Supplier supplier;

    /**
     * Nom de l'attribut en BD : product
     */
    protected Product product;

    private static final long serialVersionUID = 7234243577027901745L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NUMBER, int.class, number);
        visitor.visit(this, ENTRY_DATE, Date.class, entryDate);
        visitor.visit(this, DMES, Date.class, dmes);
        visitor.visit(this, DPMES, Date.class, dpmes);
        visitor.visit(this, DLUO, Date.class, dluo);
        visitor.visit(this, SPENT_DATE, Date.class, spentDate);
        visitor.visit(this, NEW_ATTR, int.class, newAttr);
        visitor.visit(this, ANALYZE, Collection.class, Analyze.class, analyze);
        visitor.visit(this, PRESENTATION, Collection.class, Presentation.class, presentation);
        visitor.visit(this, SUPPLIER, Supplier.class, supplier);
        visitor.visit(this, PRODUCT, Product.class, product);
        visitor.end(this);
    }

    @Override
    public void setNumber(int number) {
        int oldValue = this.number;
        fireOnPreWrite(NUMBER, oldValue, number);
        this.number = number;
        fireOnPostWrite(NUMBER, oldValue, number);
    }

    @Override
    public int getNumber() {
        fireOnPreRead(NUMBER, number);
        int result = this.number;
        fireOnPostRead(NUMBER, number);
        return result;
    }

    @Override
    public void setEntryDate(Date entryDate) {
        Date oldValue = this.entryDate;
        fireOnPreWrite(ENTRY_DATE, oldValue, entryDate);
        this.entryDate = entryDate;
        fireOnPostWrite(ENTRY_DATE, oldValue, entryDate);
    }

    @Override
    public Date getEntryDate() {
        fireOnPreRead(ENTRY_DATE, entryDate);
        Date result = this.entryDate;
        fireOnPostRead(ENTRY_DATE, entryDate);
        return result;
    }

    @Override
    public void setDmes(Date dmes) {
        Date oldValue = this.dmes;
        fireOnPreWrite(DMES, oldValue, dmes);
        this.dmes = dmes;
        fireOnPostWrite(DMES, oldValue, dmes);
    }

    @Override
    public Date getDmes() {
        fireOnPreRead(DMES, dmes);
        Date result = this.dmes;
        fireOnPostRead(DMES, dmes);
        return result;
    }

    @Override
    public void setDpmes(Date dpmes) {
        Date oldValue = this.dpmes;
        fireOnPreWrite(DPMES, oldValue, dpmes);
        this.dpmes = dpmes;
        fireOnPostWrite(DPMES, oldValue, dpmes);
    }

    @Override
    public Date getDpmes() {
        fireOnPreRead(DPMES, dpmes);
        Date result = this.dpmes;
        fireOnPostRead(DPMES, dpmes);
        return result;
    }

    @Override
    public void setDluo(Date dluo) {
        Date oldValue = this.dluo;
        fireOnPreWrite(DLUO, oldValue, dluo);
        this.dluo = dluo;
        fireOnPostWrite(DLUO, oldValue, dluo);
    }

    @Override
    public Date getDluo() {
        fireOnPreRead(DLUO, dluo);
        Date result = this.dluo;
        fireOnPostRead(DLUO, dluo);
        return result;
    }

    @Override
    public void setSpentDate(Date spentDate) {
        Date oldValue = this.spentDate;
        fireOnPreWrite(SPENT_DATE, oldValue, spentDate);
        this.spentDate = spentDate;
        fireOnPostWrite(SPENT_DATE, oldValue, spentDate);
    }

    @Override
    public Date getSpentDate() {
        fireOnPreRead(SPENT_DATE, spentDate);
        Date result = this.spentDate;
        fireOnPostRead(SPENT_DATE, spentDate);
        return result;
    }

    @Override
    public void setNewAttr(int newAttr) {
        int oldValue = this.newAttr;
        fireOnPreWrite(NEW_ATTR, oldValue, newAttr);
        this.newAttr = newAttr;
        fireOnPostWrite(NEW_ATTR, oldValue, newAttr);
    }

    @Override
    public int getNewAttr() {
        fireOnPreRead(NEW_ATTR, newAttr);
        int result = this.newAttr;
        fireOnPostRead(NEW_ATTR, newAttr);
        return result;
    }

    @Override
    public void addAnalyze(Analyze analyze) {
        fireOnPreWrite(ANALYZE, null, analyze);
        if (this.analyze == null) {
            this.analyze = new ArrayList<Analyze>();
        }

        analyze.setBatch(this);

        this.analyze.add(analyze);
        fireOnPostWrite(ANALYZE, this.analyze.size(), null, analyze);
    }

    @Override
    public void addAllAnalyze(Collection<Analyze> analyze) {
        if (analyze == null) {
            return;
        }
        for (Analyze item : analyze) {
            addAnalyze(item);
        }
    }

    @Override
    public void setAnalyze(Collection<Analyze> analyze) {
        // Copy elements to keep data for fire with new reference
        Collection<Analyze> oldValue = this.analyze != null ? new ArrayList<Analyze>(this.analyze) : null;
        fireOnPreWrite(ANALYZE, oldValue, analyze);
        this.analyze = analyze;
        fireOnPostWrite(ANALYZE, oldValue, analyze);
    }

    @Override
    public void removeAnalyze(Analyze analyze) {
        fireOnPreWrite(ANALYZE, analyze, null);
        if (this.analyze == null || !this.analyze.remove(analyze)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        analyze.setBatch(null);

        fireOnPostWrite(ANALYZE, this.analyze.size() + 1, analyze, null);
    }

    @Override
    public void clearAnalyze() {
        if (this.analyze == null) {
            return;
        }
        for (Analyze item : this.analyze) {
            item.setBatch(null);
        }
        Collection<Analyze> oldValue = new ArrayList<Analyze>(this.analyze);
        fireOnPreWrite(ANALYZE, oldValue, this.analyze);
        this.analyze.clear();
        fireOnPostWrite(ANALYZE, oldValue, this.analyze);
    }

    @Override
    public Collection<Analyze> getAnalyze() {
        return analyze;
    }

    @Override
    public Analyze getAnalyzeByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(analyze, topiaId);
    }

    @Override
    public int sizeAnalyze() {
        if (analyze == null) {
            return 0;
        }
        return analyze.size();
    }

    @Override
    public boolean isAnalyzeEmpty() {
        int size = sizeAnalyze();
        return size == 0;
    }

    @Override
    public void addPresentation(Presentation presentation) {
        fireOnPreWrite(PRESENTATION, null, presentation);
        if (this.presentation == null) {
            this.presentation = new ArrayList<Presentation>();
        }

        presentation.setBatch(this);

        this.presentation.add(presentation);
        fireOnPostWrite(PRESENTATION, this.presentation.size(), null, presentation);
    }

    @Override
    public void addAllPresentation(Collection<Presentation> presentation) {
        if (presentation == null) {
            return;
        }
        for (Presentation item : presentation) {
            addPresentation(item);
        }
    }

    @Override
    public void setPresentation(Collection<Presentation> presentation) {
        // Copy elements to keep data for fire with new reference
        Collection<Presentation> oldValue = this.presentation != null ? new ArrayList<Presentation>(this.presentation) : null;
        fireOnPreWrite(PRESENTATION, oldValue, presentation);
        this.presentation = presentation;
        fireOnPostWrite(PRESENTATION, oldValue, presentation);
    }

    @Override
    public void removePresentation(Presentation presentation) {
        fireOnPreWrite(PRESENTATION, presentation, null);
        if (this.presentation == null || !this.presentation.remove(presentation)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        presentation.setBatch(null);

        fireOnPostWrite(PRESENTATION, this.presentation.size() + 1, presentation, null);
    }

    @Override
    public void clearPresentation() {
        if (this.presentation == null) {
            return;
        }
        for (Presentation item : this.presentation) {
            item.setBatch(null);
        }
        Collection<Presentation> oldValue = new ArrayList<Presentation>(this.presentation);
        fireOnPreWrite(PRESENTATION, oldValue, this.presentation);
        this.presentation.clear();
        fireOnPostWrite(PRESENTATION, oldValue, this.presentation);
    }

    @Override
    public Collection<Presentation> getPresentation() {
        return presentation;
    }

    @Override
    public Presentation getPresentationByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(presentation, topiaId);
    }

    @Override
    public int sizePresentation() {
        if (presentation == null) {
            return 0;
        }
        return presentation.size();
    }

    @Override
    public boolean isPresentationEmpty() {
        int size = sizePresentation();
        return size == 0;
    }

    @Override
    public void setSupplier(Supplier supplier) {
        Supplier oldValue = this.supplier;
        fireOnPreWrite(SUPPLIER, oldValue, supplier);
        this.supplier = supplier;
        fireOnPostWrite(SUPPLIER, oldValue, supplier);
    }

    @Override
    public Supplier getSupplier() {
        fireOnPreRead(SUPPLIER, supplier);
        Supplier result = this.supplier;
        fireOnPostRead(SUPPLIER, supplier);
        return result;
    }

    @Override
    public void setProduct(Product product) {
        Product oldValue = this.product;
        fireOnPreWrite(PRODUCT, oldValue, product);
        this.product = product;
        fireOnPostWrite(PRODUCT, oldValue, product);
    }

    @Override
    public Product getProduct() {
        fireOnPreRead(PRODUCT, product);
        Product result = this.product;
        fireOnPostRead(PRODUCT, product);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NUMBER, this.number).
            append(ENTRY_DATE, this.entryDate).
            append(DMES, this.dmes).
            append(DPMES, this.dpmes).
            append(DLUO, this.dluo).
            append(SPENT_DATE, this.spentDate).
            append(NEW_ATTR, this.newAttr).
            append(SUPPLIER, this.supplier).
            append(PRODUCT, this.product).
         toString();
        return result;
    }

} //BatchAbstract
