/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.ECSSSelectorCombinator;
import com.helger.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelectorMemberPseudoHas
implements ICSSSelectorMember,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final ECSSSelectorCombinator m_eCombinator;
    private final ICommonsList<CSSSelector> m_aNestedSelectors;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberPseudoHas(@Nullable ECSSSelectorCombinator eCSSSelectorCombinator, @Nonnull CSSSelector cSSSelector) {
        ValueEnforcer.notNull((Object)cSSSelector, (String)"NestedSelector");
        this.m_eCombinator = eCSSSelectorCombinator;
        this.m_aNestedSelectors = new CommonsArrayList((Object)cSSSelector);
    }

    public CSSSelectorMemberPseudoHas(@Nullable ECSSSelectorCombinator eCSSSelectorCombinator, CSSSelector ... cSSSelectorArray) {
        ValueEnforcer.notNull((Object)cSSSelectorArray, (String)"NestedSelectors");
        this.m_eCombinator = eCSSSelectorCombinator;
        this.m_aNestedSelectors = new CommonsArrayList((Object[])cSSSelectorArray);
    }

    public CSSSelectorMemberPseudoHas(@Nullable ECSSSelectorCombinator eCSSSelectorCombinator, @Nonnull Iterable<CSSSelector> iterable) {
        ValueEnforcer.notNull(iterable, (String)"NestedSelectors");
        this.m_eCombinator = eCSSSelectorCombinator;
        this.m_aNestedSelectors = new CommonsArrayList(iterable);
    }

    @Nullable
    public ECSSSelectorCombinator getCombinator() {
        return this.m_eCombinator;
    }

    public boolean hasSelectors() {
        return this.m_aNestedSelectors.isNotEmpty();
    }

    @Nonnegative
    public int getSelectorCount() {
        return this.m_aNestedSelectors.size();
    }

    @Nonnull
    public CSSSelectorMemberPseudoHas addSelector(@Nonnull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(new CSSSelector().addMember(iCSSSelectorMember));
    }

    @Nonnull
    public CSSSelectorMemberPseudoHas addSelector(@Nonnull CSSSelector cSSSelector) {
        ValueEnforcer.notNull((Object)cSSSelector, (String)"Selector");
        this.m_aNestedSelectors.add((Object)cSSSelector);
        return this;
    }

    @Nonnull
    public CSSSelectorMemberPseudoHas addSelector(@Nonnegative int n, @Nonnull ICSSSelectorMember iCSSSelectorMember) {
        ValueEnforcer.notNull((Object)iCSSSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(n, new CSSSelector().addMember(iCSSSelectorMember));
    }

    @Nonnull
    public CSSSelectorMemberPseudoHas addSelector(@Nonnegative int n, @Nonnull CSSSelector cSSSelector) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSSelector, (String)"Selector");
        if (n >= this.getSelectorCount()) {
            this.m_aNestedSelectors.add((Object)cSSSelector);
        } else {
            this.m_aNestedSelectors.add(n, (Object)cSSSelector);
        }
        return this;
    }

    @Nonnull
    public EChange removeSelector(@Nonnull CSSSelector cSSSelector) {
        return this.m_aNestedSelectors.removeObject((Object)cSSSelector);
    }

    @Nonnull
    public EChange removeSelector(@Nonnegative int n) {
        return this.m_aNestedSelectors.removeAtIndex(n);
    }

    @Nonnull
    public EChange removeAllSelectors() {
        return this.m_aNestedSelectors.removeAll();
    }

    @Nullable
    public CSSSelector getSelectorAtIndex(@Nonnegative int n) {
        return (CSSSelector)this.m_aNestedSelectors.getAtIndex(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CSSSelector> getAllSelectors() {
        return (ICommonsList)this.m_aNestedSelectors.getClone();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        iCSSWriterSettings.checkVersionRequirements(this);
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder(":has(");
        if (this.m_eCombinator != null) {
            stringBuilder.append(this.m_eCombinator.getAsCSSString(iCSSWriterSettings));
        }
        boolean bl2 = true;
        for (CSSSelector cSSSelector : this.m_aNestedSelectors) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(bl ? "," : ", ");
            }
            stringBuilder.append(cSSSelector.getAsCSSString(iCSSWriterSettings, 0));
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorMemberPseudoHas cSSSelectorMemberPseudoHas = (CSSSelectorMemberPseudoHas)object;
        return EqualsHelper.equals((Object)this.m_eCombinator, (Object)cSSSelectorMemberPseudoHas.m_eCombinator) && this.m_aNestedSelectors.equals(cSSSelectorMemberPseudoHas.m_aNestedSelectors);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eCombinator).append(this.m_aNestedSelectors).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Combinator", (Enum)this.m_eCombinator).append("NestedSelectors", this.m_aNestedSelectors).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

