/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.helper;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.CollectionHelper;
import com.helger.collection.commons.CollectionCommonsHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsIterableIterator;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.helper.CollectionHelperExt;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class CollectionSort {
    private CollectionSort() {
    }

    @ReturnsMutableObject(value="design")
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>, LISTTYPE extends List<ELEMENTTYPE>> @Nullable LISTTYPE getSortedInline(@Nullable LISTTYPE LISTTYPE) {
        if (CollectionHelper.isNotEmpty(LISTTYPE)) {
            LISTTYPE.sort(null);
        }
        return LISTTYPE;
    }

    @ReturnsMutableObject(value="design")
    @CodingStyleguideUnaware
    public static <ELEMENTTYPE, LISTTYPE extends List<ELEMENTTYPE>> @Nullable LISTTYPE getSortedInline(@Nullable LISTTYPE LISTTYPE, @NonNull Comparator<? super ELEMENTTYPE> comparator) {
        ValueEnforcer.notNull(comparator, (String)"Comparator");
        if (CollectionHelper.isNotEmpty(LISTTYPE)) {
            LISTTYPE.sort(comparator);
        }
        return LISTTYPE;
    }

    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> @NonNull ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return CollectionCommonsHelper.getSortedByKey(map);
    }

    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> @NonNull ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> map, @NonNull Comparator<? super KEYTYPE> comparator) {
        return CollectionCommonsHelper.getSortedByKey(map, comparator);
    }

    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>> @NonNull ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> map) {
        return CollectionCommonsHelper.getSortedByValue(map);
    }

    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> @NonNull ICommonsOrderedMap<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> map, @NonNull Comparator<? super VALUETYPE> comparator) {
        return CollectionCommonsHelper.getSortedByValue(map, comparator);
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> @NonNull CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable ICommonsIterableIterator<? extends ELEMENTTYPE> iCommonsIterableIterator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(iCommonsIterableIterator));
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> @NonNull CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable ICommonsIterableIterator<? extends ELEMENTTYPE> iCommonsIterableIterator, @NonNull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(iCommonsIterableIterator), comparator);
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> @NonNull CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(iterator));
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Iterator<? extends ELEMENTTYPE> iterator, @NonNull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(iterator), comparator);
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> @NonNull CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(iterable));
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @NonNull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(iterable), comparator);
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> @NonNull CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(collection));
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable Collection<? extends ELEMENTTYPE> collection, @NonNull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(collection), comparator);
    }

    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> @NonNull CommonsArrayList<ELEMENTTYPE> getSorted(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(ELEMENTTYPEArray));
    }

    @ReturnsMutableCopy
    public static <ELEMENTTYPE> @NonNull CommonsArrayList<ELEMENTTYPE> getSorted(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @NonNull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionSort.getSortedInline(CollectionHelperExt.createList(ELEMENTTYPEArray), comparator);
    }
}

