/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class IdMappingUtil {
    @VisibleForTesting
    static final char NEW_LINE = '\n';
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n').omitEmptyStrings();

    private IdMappingUtil() {
    }

    static String generateSerializedIdMappings(Map<String, Map<String, String>> idGeneratorMaps) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<String, String>> replacements : idGeneratorMaps.entrySet()) {
            if (replacements.getValue().isEmpty()) continue;
            sb.append('[').append(replacements.getKey()).append(']').append('\n').append('\n');
            for (Map.Entry<String, String> replacement : replacements.getValue().entrySet()) {
                sb.append(replacement.getKey()).append(':').append(replacement.getValue()).append('\n');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static Map<String, BiMap<String, String>> parseSerializedIdMappings(String idMappings) {
        if (Strings.isNullOrEmpty((String)idMappings)) {
            return Collections.emptyMap();
        }
        HashMap<String, BiMap<String, String>> resultMap = new HashMap<String, BiMap<String, String>>();
        BiMap currentSectionMap = null;
        int lineIndex = 0;
        for (String line : LINE_SPLITTER.split((CharSequence)idMappings)) {
            ++lineIndex;
            if (line.isEmpty()) continue;
            if (line.charAt(0) == '[') {
                String currentSection = line.substring(1, line.length() - 1);
                currentSectionMap = (BiMap)resultMap.get(currentSection);
                if (currentSectionMap == null) {
                    currentSectionMap = HashBiMap.create();
                    resultMap.put(currentSection, (BiMap<String, String>)currentSectionMap);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Cannot parse id map: %s\n Line: $s, lineIndex: %s", idMappings, line, lineIndex));
            }
            int split = line.indexOf(58);
            if (split != -1) {
                String name = line.substring(0, split);
                String location = line.substring(split + 1, line.length());
                currentSectionMap.put((Object)name, (Object)location);
                continue;
            }
            throw new IllegalArgumentException(String.format("Cannot parse id map: %s\n Line: $s, lineIndex: %s", idMappings, line, lineIndex));
        }
        return resultMap;
    }
}

