/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class JSType {
    private static final int BOTTOM_MASK = 0;
    private static final int STRING_MASK = 1;
    private static final int NUMBER_MASK = 2;
    private static final int UNDEFINED_MASK = 4;
    private static final int TRUE_MASK = 8;
    private static final int FALSE_MASK = 16;
    private static final int NULL_MASK = 32;
    private static final int NON_SCALAR_MASK = 64;
    private static final int TYPEVAR_MASK = 128;
    private static final int END_MASK = 256;
    private static final int TRUTHY_MASK = 256;
    private static final int FALSY_MASK = 512;
    private static final int UNKNOWN_MASK = Integer.MAX_VALUE;
    private static final int TOP_MASK = -1;
    private static final int BOOLEAN_MASK = 24;
    private static final int TOP_SCALAR_MASK = 63;
    private final int mask;
    private final ImmutableSet<ObjectType> objs;
    private final String typeVar;
    private final String location;
    static final String GENERIC_LOCATION = "%";
    public static final JSType BOOLEAN = new JSType(24);
    public static final JSType BOTTOM = new JSType(0);
    public static final JSType FALSE_TYPE = new JSType(16);
    public static final JSType FALSY = new JSType(512);
    public static final JSType NULL = new JSType(32);
    public static final JSType NUMBER = new JSType(2);
    public static final JSType STRING = new JSType(1);
    public static final JSType TOP = new JSType(-1);
    public static final JSType TOP_SCALAR = new JSType(63);
    public static final JSType TRUE_TYPE = new JSType(8);
    public static final JSType TRUTHY = new JSType(256);
    public static final JSType UNDEFINED = new JSType(4);
    public static final JSType UNKNOWN = new JSType(Integer.MAX_VALUE);
    public static final JSType TOP_OBJECT = JSType.fromObjectType(ObjectType.TOP_OBJECT);
    public static final JSType TOP_STRUCT = JSType.fromObjectType(ObjectType.TOP_STRUCT);
    public static final JSType TOP_DICT = JSType.fromObjectType(ObjectType.TOP_DICT);
    private static JSType TOP_FUNCTION = null;
    public static final JSType NULL_OR_UNDEF = new JSType(36);
    public static final JSType NUM_OR_STR = new JSType(3);
    private static final JSType TOP_MINUS_NULL = new JSType(95, null, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)ObjectType.TOP_OBJECT), null);
    private static final JSType TOP_MINUS_UNDEF = new JSType(123, null, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)ObjectType.TOP_OBJECT), null);

    private JSType(int mask, String location, ImmutableSet<ObjectType> objs, String typeVar) {
        this.typeVar = typeVar;
        this.location = location;
        if (objs == null) {
            this.mask = mask;
            this.objs = null;
        } else if (objs.isEmpty()) {
            this.mask = mask & 0xFFFFFFBF;
            this.objs = null;
        } else {
            this.mask = mask | 0x40;
            this.objs = objs;
        }
        Preconditions.checkState((boolean)this.isValidType(), (String)"Cannot create type with bits <<<%X>>>, objs <<<%s>>>, and typeVar <<<%s>>>", (Object[])new Object[]{mask, objs, typeVar});
    }

    private JSType(int mask) {
        this(mask, null, null, null);
    }

    public static JSType fromFunctionType(FunctionType fn) {
        return new JSType(64, null, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)ObjectType.fromFunction(fn)), null);
    }

    public static JSType fromObjectType(ObjectType obj) {
        return new JSType(64, null, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)obj), null);
    }

    public static JSType fromTypeVar(String template) {
        return new JSType(128, null, null, template);
    }

    boolean isValidType() {
        if (this.isUnknown() || this.isTop()) {
            return true;
        }
        if ((this.mask & 0x40) != 0 && (this.objs == null || this.objs.isEmpty())) {
            return false;
        }
        if ((this.mask & 0x40) == 0 && this.objs != null) {
            return false;
        }
        return (this.mask & 0x80) != 0 == (this.typeVar != null);
    }

    public static JSType topFunction() {
        if (TOP_FUNCTION == null) {
            TOP_FUNCTION = JSType.fromFunctionType(FunctionType.TOP_FUNCTION);
        }
        return TOP_FUNCTION;
    }

    static JSType qmarkFunction() {
        return JSType.fromFunctionType(FunctionType.QMARK_FUNCTION);
    }

    public boolean isTop() {
        return -1 == this.mask;
    }

    public boolean isBottom() {
        return 0 == this.mask;
    }

    public boolean isUnknown() {
        return Integer.MAX_VALUE == this.mask;
    }

    public boolean isTruthy() {
        return 256 == this.mask || 8 == this.mask;
    }

    public boolean isFalsy() {
        return 512 == this.mask || 16 == this.mask;
    }

    public boolean isBoolean() {
        return (this.mask & 0xFFFFFFE7) == 0 && (this.mask & 0x18) != 0;
    }

    public boolean isNullOrUndef() {
        int nullUndefMask = 36;
        return this.mask != 0 && (this.mask | nullUndefMask) == nullUndefMask;
    }

    public boolean isFromNonLocalValue() {
        return this.location != null;
    }

    public boolean isScalar() {
        return this.mask == 2 || this.mask == 1 || this.mask == 32 || this.mask == 4 || this.isBoolean();
    }

    public boolean isInhabitable() {
        if (this.isBottom()) {
            return false;
        }
        if (this.objs == null) {
            return true;
        }
        for (ObjectType obj : this.objs) {
            if (obj.isInhabitable()) continue;
            return false;
        }
        return true;
    }

    public boolean hasNonScalar() {
        return this.objs != null;
    }

    public boolean isNullable() {
        return (this.mask & 0x20) != 0;
    }

    boolean isTypeVariable() {
        return (this.mask & 0xFFFFFF7F) == 0;
    }

    public boolean isRecordType() {
        return this.mask == 64 && this.objs.size() == 1 && ((ObjectType)Iterables.getOnlyElement(this.objs)).isRecordType();
    }

    public boolean isStruct() {
        if (this.objs == null) {
            return false;
        }
        for (ObjectType objType : this.objs) {
            if (!objType.isStruct()) continue;
            return true;
        }
        return false;
    }

    public boolean isLooseStruct() {
        if (this.objs == null) {
            return false;
        }
        boolean foundLooseStruct = false;
        boolean foundNonLooseStruct = false;
        for (ObjectType objType : this.objs) {
            if (objType.isLooseStruct()) {
                foundLooseStruct = true;
                continue;
            }
            if (!objType.isStruct()) continue;
            foundNonLooseStruct = true;
        }
        return foundLooseStruct && !foundNonLooseStruct;
    }

    public boolean isDict() {
        if (this.objs == null) {
            return false;
        }
        for (ObjectType objType : this.objs) {
            if (!objType.isDict()) continue;
            return true;
        }
        return false;
    }

    public static boolean areCompatibleScalarTypes(JSType lhs, JSType rhs) {
        Preconditions.checkArgument((lhs.isSubtypeOf(TOP_SCALAR) || rhs.isSubtypeOf(TOP_SCALAR) ? 1 : 0) != 0);
        return lhs.isBottom() || rhs.isBottom() || lhs.isUnknown() || rhs.isUnknown() || lhs.isBoolean() && rhs.isBoolean() || lhs.equals(rhs);
    }

    public static JSType join(JSType lhs, JSType rhs) {
        if (lhs.isTop() || rhs.isTop()) {
            return TOP;
        }
        if (lhs.isUnknown() || rhs.isUnknown()) {
            return UNKNOWN;
        }
        if (lhs.isBottom()) {
            return rhs;
        }
        if (rhs.isBottom()) {
            return lhs;
        }
        if (lhs.typeVar != null && rhs.typeVar != null && !lhs.typeVar.equals(rhs.typeVar)) {
            return UNKNOWN;
        }
        return new JSType(lhs.mask | rhs.mask, JSType.joinLocs(lhs.location, rhs.location), ObjectType.joinSets(lhs.objs, rhs.objs), lhs.typeVar != null ? lhs.typeVar : rhs.typeVar);
    }

    private static String joinLocs(String loc1, String loc2) {
        if (loc1 == null || loc2 == null) {
            return null;
        }
        return loc1.equals(loc2) ? loc1 : GENERIC_LOCATION;
    }

    public JSType substituteGenerics(Map<String, JSType> concreteTypes) {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        ImmutableSet newObjs = null;
        if (this.objs != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (ObjectType obj : this.objs) {
                builder.add((Object)obj.substituteGenerics(concreteTypes));
            }
            newObjs = builder.build();
        }
        JSType current = new JSType(this.mask & 0xFFFFFF7F, this.location, newObjs, null);
        if ((this.mask & 0x80) != 0) {
            current = JSType.join(current, concreteTypes.containsKey(this.typeVar) ? concreteTypes.get(this.typeVar) : JSType.fromTypeVar(this.typeVar));
        }
        return current;
    }

    private static void updateTypemap(Multimap<String, JSType> typeMultimap, String typeParam, JSType type) {
        HashSet typesToRemove = Sets.newHashSet();
        for (JSType other : typeMultimap.get((Object)typeParam)) {
            JSType unified = JSType.unifyUnknowns(type, other);
            if (unified == null) continue;
            typesToRemove.add(other);
            type = unified;
        }
        for (JSType typeToRemove : typesToRemove) {
            typeMultimap.remove((Object)typeParam, (Object)typeToRemove);
        }
        typeMultimap.put((Object)typeParam, (Object)type);
    }

    private static int promoteBoolean(int mask) {
        if ((mask & 0x18) != 0) {
            return mask | 8 | 0x10;
        }
        return mask;
    }

    static JSType unifyUnknowns(JSType t1, JSType t2) {
        int t2Mask;
        if (t1.isUnknown()) {
            return t2;
        }
        if (t2.isUnknown()) {
            return t1;
        }
        if (t1.isTop() && t2.isTop()) {
            return TOP;
        }
        if (t1.isTop() || t2.isTop()) {
            return null;
        }
        int t1Mask = JSType.promoteBoolean(t1.mask);
        if (t1Mask != (t2Mask = JSType.promoteBoolean(t2.mask)) || !Objects.equal((Object)t1.typeVar, (Object)t2.typeVar)) {
            return null;
        }
        if ((t1Mask & 0x40) == 0) {
            return t1;
        }
        if (t1.objs.size() != t2.objs.size()) {
            return null;
        }
        HashSet ununified = Sets.newHashSet(t2.objs);
        HashSet unifiedObjs = Sets.newHashSet();
        Iterator i$ = t1.objs.iterator();
        while (i$.hasNext()) {
            ObjectType objType1;
            ObjectType unified = objType1 = (ObjectType)i$.next();
            boolean hasUnified = false;
            for (ObjectType objType2 : t2.objs) {
                ObjectType tmp = ObjectType.unifyUnknowns(unified, objType2);
                if (tmp == null) continue;
                hasUnified = true;
                ununified.remove(objType2);
                unified = tmp;
            }
            if (!hasUnified) {
                return null;
            }
            unifiedObjs.add(unified);
        }
        if (!ununified.isEmpty()) {
            return null;
        }
        return new JSType(t1Mask, null, (ImmutableSet<ObjectType>)ImmutableSet.copyOf((Collection)unifiedObjs), t1.typeVar);
    }

    public boolean unifyWith(JSType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap) {
        int thisScalarBits;
        int otherScalarBits;
        if (this.isUnknown()) {
            return true;
        }
        if (this.isTop()) {
            return other.isTop();
        }
        if (this.mask == 128 && typeParameters.contains(this.typeVar)) {
            JSType.updateTypemap(typeMultimap, this.typeVar, new JSType(JSType.promoteBoolean(other.mask), null, other.objs, other.typeVar));
            return true;
        }
        if (other.isTop()) {
            return false;
        }
        if (other.isUnknown()) {
            return true;
        }
        Object ununified = ImmutableSet.of();
        if (other.objs != null) {
            ununified = Sets.newHashSet(other.objs);
        }
        if (this.objs != null) {
            if (other.objs == null) {
                return false;
            }
            for (ObjectType targetObj : this.objs) {
                boolean hasUnified = false;
                for (ObjectType sourceObj : other.objs) {
                    if (!targetObj.unifyWith(sourceObj, typeParameters, typeMultimap)) continue;
                    ununified.remove(sourceObj);
                    hasUnified = true;
                }
                if (hasUnified) continue;
                return false;
            }
        }
        String thisTypevar = this.typeVar;
        String otherTypevar = other.typeVar;
        if (thisTypevar == null) {
            return otherTypevar == null && this.mask == other.mask;
        }
        if (!typeParameters.contains(thisTypevar)) {
            return thisTypevar.equals(otherTypevar) && this.mask == other.mask;
        }
        int templateMask = 0;
        if (!ununified.isEmpty()) {
            templateMask |= 0x40;
        }
        if ((other.mask & 0x80) != 0) {
            templateMask |= 0x80;
        }
        if ((templateMask |= (otherScalarBits = other.mask & 0xFFFFFFBF & 0xFFFFFF7F) & ~(thisScalarBits = this.mask & 0xFFFFFFBF & 0xFFFFFF7F)) == 0) {
            return false;
        }
        JSType templateType = new JSType(JSType.promoteBoolean(templateMask), null, (ImmutableSet<ObjectType>)ImmutableSet.copyOf((Collection)ununified), otherTypevar);
        JSType.updateTypemap(typeMultimap, this.typeVar, templateType);
        return true;
    }

    public JSType specialize(JSType other) {
        String newTypevar;
        if (other.isTop() || other.isUnknown()) {
            return this;
        }
        if (other.isTruthy()) {
            return this.makeTruthy();
        }
        if (other.isFalsy()) {
            return this.makeFalsy();
        }
        if (this.isTop() || this.isUnknown()) {
            return other.withLocation(this.location);
        }
        int newMask = this.mask & other.mask;
        if (Objects.equal((Object)this.typeVar, (Object)other.typeVar)) {
            newTypevar = this.typeVar;
        } else {
            newTypevar = null;
            newMask &= 0xFFFFFF7F;
        }
        return new JSType(newMask, this.location, ObjectType.specializeSet(this.objs, other.objs), newTypevar);
    }

    private JSType makeTruthy() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        return new JSType(this.mask & 0xFFFFFFDF & 0xFFFFFFEF & 0xFFFFFFFB, this.location, this.objs, this.typeVar);
    }

    private JSType makeFalsy() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        return new JSType(this.mask & 0xFFFFFFF7 & 0xFFFFFFBF, this.location, null, this.typeVar);
    }

    public static JSType meet(JSType lhs, JSType rhs) {
        String newTypevar;
        if (lhs.isTop()) {
            return rhs;
        }
        if (rhs.isTop()) {
            return lhs;
        }
        if (lhs.isUnknown()) {
            return rhs;
        }
        if (rhs.isUnknown()) {
            return lhs;
        }
        int newMask = lhs.mask & rhs.mask;
        if (Objects.equal((Object)lhs.typeVar, (Object)rhs.typeVar)) {
            newTypevar = lhs.typeVar;
        } else {
            newTypevar = null;
            newMask &= 0xFFFFFF7F;
        }
        return new JSType(newMask, null, ObjectType.meetSets(lhs.objs, rhs.objs), newTypevar);
    }

    public static JSType plus(JSType lhs, JSType rhs) {
        int newtype = (lhs.mask | rhs.mask) & 1;
        if ((lhs.mask & 0xFFFFFFFE) != 0 && (rhs.mask & 0xFFFFFFFE) != 0) {
            newtype |= 2;
        }
        return new JSType(newtype);
    }

    public JSType negate() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        if (this.isTruthy()) {
            return FALSY;
        }
        if (this.isFalsy()) {
            return TRUTHY;
        }
        if (this.objs == null && this.typeVar == null) {
            return new JSType(0x3F & ~this.mask);
        }
        return UNKNOWN;
    }

    public JSType toBoolean() {
        if (this.isTruthy()) {
            return TRUE_TYPE;
        }
        if (this.isFalsy()) {
            return FALSE_TYPE;
        }
        return BOOLEAN;
    }

    public boolean isNonLooseSubtypeOf(JSType other) {
        return this.isSubtypeOfHelper(false, other);
    }

    public boolean isSubtypeOf(JSType other) {
        return this.isSubtypeOfHelper(true, other);
    }

    private boolean isSubtypeOfHelper(boolean keepLoosenessOfThis, JSType other) {
        if (this.isUnknown() || other.isUnknown() || other.isTop()) {
            return true;
        }
        if ((this.mask | other.mask) != other.mask) {
            return false;
        }
        if (!Objects.equal((Object)this.typeVar, (Object)other.typeVar)) {
            return false;
        }
        if (this.objs == null) {
            return true;
        }
        return ObjectType.isUnionSubtype(keepLoosenessOfThis, this.objs, other.objs);
    }

    public JSType removeType(JSType other) {
        if ((this.isTop() || this.isUnknown()) && other.equals(NULL)) {
            return TOP_MINUS_NULL;
        }
        if ((this.isTop() || this.isUnknown()) && other.equals(UNDEFINED)) {
            return TOP_MINUS_UNDEF;
        }
        if (other.equals(NULL) || other.equals(UNDEFINED)) {
            return new JSType(this.mask & ~other.mask, this.location, this.objs, this.typeVar);
        }
        if (this.objs == null) {
            return this;
        }
        Preconditions.checkState(((other.mask & 0xFFFFFFBF) == 0 && other.objs.size() == 1 ? 1 : 0) != 0);
        NominalType otherKlass = ((ObjectType)Iterables.getOnlyElement(other.objs)).getNominalType();
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : this.objs) {
            if (Objects.equal((Object)obj.getNominalType(), (Object)otherKlass)) continue;
            newObjs.add((Object)obj);
        }
        return new JSType(this.mask, this.location, (ImmutableSet<ObjectType>)newObjs.build(), this.typeVar);
    }

    public JSType withLocation(String location) {
        if (Objects.equal((Object)location, (Object)this.location)) {
            return this;
        }
        String newLocation = location == null ? null : GENERIC_LOCATION;
        return new JSType(this.mask, location, this.objs == null ? null : ObjectType.withLocation(this.objs, newLocation), this.typeVar);
    }

    public String getLocation() {
        return this.location;
    }

    public FunctionType getFunTypeIfSingletonObj() {
        if (this.mask != 64 || this.objs.size() > 1) {
            return null;
        }
        return ((ObjectType)Iterables.getOnlyElement(this.objs)).getFunType();
    }

    public FunctionType getFunType() {
        if (this.objs == null) {
            return null;
        }
        if (this.objs.size() == 1) {
            return ((ObjectType)Iterables.getOnlyElement(this.objs)).getFunType();
        }
        FunctionType result = FunctionType.TOP_FUNCTION;
        for (ObjectType obj : this.objs) {
            result = FunctionType.meet(result, obj.getFunType());
        }
        return result;
    }

    NominalType getNominalTypeIfUnique() {
        if (this.objs == null || this.objs.size() > 1) {
            return null;
        }
        return ((ObjectType)Iterables.getOnlyElement(this.objs)).getNominalType();
    }

    public boolean isInterfaceDefinition() {
        if (this.objs == null || this.objs.size() > 1) {
            return false;
        }
        FunctionType ft = ((ObjectType)Iterables.getOnlyElement(this.objs)).getFunType();
        return ft != null && ft.isInterfaceDefinition();
    }

    public JSType withLoose() {
        Preconditions.checkNotNull(this.objs);
        return new JSType(this.mask, this.location, ObjectType.withLooseObjects(this.objs), this.typeVar);
    }

    public JSType getProp(QualifiedName qname) {
        if (this.isBottom() || this.isUnknown()) {
            return UNKNOWN;
        }
        Preconditions.checkState((this.objs != null ? 1 : 0) != 0);
        JSType ptype = BOTTOM;
        for (ObjectType o : this.objs) {
            if (!o.mayHaveProp(qname)) continue;
            ptype = JSType.join(ptype, o.getProp(qname));
        }
        if (ptype.isBottom()) {
            return null;
        }
        return ptype;
    }

    public boolean mayHaveProp(QualifiedName qname) {
        if (this.objs == null) {
            return false;
        }
        for (ObjectType o : this.objs) {
            if (!o.mayHaveProp(qname)) continue;
            return true;
        }
        return false;
    }

    public boolean hasProp(QualifiedName qname) {
        if (this.objs == null) {
            return false;
        }
        for (ObjectType o : this.objs) {
            if (o.hasProp(qname)) continue;
            return false;
        }
        return true;
    }

    public boolean hasConstantProp(QualifiedName pname) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        if (this.objs == null) {
            return false;
        }
        for (ObjectType obj : this.objs) {
            if (!obj.hasConstantProp(pname)) continue;
            return true;
        }
        return false;
    }

    public JSType getDeclaredProp(QualifiedName qname) {
        if (this.isUnknown()) {
            return UNKNOWN;
        }
        Preconditions.checkState((this.objs != null ? 1 : 0) != 0, (String)"Cannot get declared prop %s of type %s", (Object[])new Object[]{qname, this});
        JSType ptype = BOTTOM;
        for (ObjectType o : this.objs) {
            JSType declType = o.getDeclaredProp(qname);
            if (declType == null) continue;
            ptype = JSType.join(ptype, declType);
        }
        return ptype.isBottom() ? null : ptype;
    }

    public JSType withoutProperty(QualifiedName qname) {
        return this.objs == null ? this : new JSType(this.mask, this.location, ObjectType.withoutProperty(this.objs, qname), this.typeVar);
    }

    public JSType withProperty(QualifiedName qname, JSType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        if (this.isUnknown()) {
            return this;
        }
        Preconditions.checkState((this.objs != null ? 1 : 0) != 0);
        return new JSType(this.mask, this.location, ObjectType.withProperty(this.objs, qname, type), this.typeVar);
    }

    public JSType withDeclaredProperty(QualifiedName qname, JSType type, boolean isConstant) {
        Preconditions.checkState((this.objs != null && this.location == null ? 1 : 0) != 0);
        if (type == null && isConstant) {
            type = UNKNOWN;
        }
        return new JSType(this.mask, null, ObjectType.withDeclaredProperty(this.objs, qname, type, isConstant), this.typeVar);
    }

    public JSType withPropertyRequired(String pname) {
        return this.isUnknown() || this.objs == null ? this : new JSType(this.mask, this.location, ObjectType.withPropertyRequired(this.objs, pname), this.typeVar);
    }

    static List<JSType> fixLengthOfTypeList(int desiredLength, List<JSType> typeList) {
        int length = typeList.size();
        if (length == desiredLength) {
            return typeList;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < desiredLength; ++i) {
            builder.add((Object)(i < length ? typeList.get(i) : UNKNOWN));
        }
        return builder.build();
    }

    public String toString() {
        return this.typeToString() + JSType.locationPostfix(this.location);
    }

    private String typeToString() {
        switch (this.mask) {
            case -1: 
            case 0: 
            case 0x7FFFFFFF: {
                return JSType.tagToString(this.mask, null, null);
            }
        }
        int tags = this.mask;
        TreeSet types = Sets.newTreeSet();
        for (int mask = 1; mask != 256; mask <<= 1) {
            if ((tags & mask) == 0) continue;
            types.add(JSType.tagToString(mask, this.objs, this.typeVar));
            tags &= ~mask;
        }
        if (tags == 0) {
            return Joiner.on((String)"|").join((Iterable)types);
        }
        if (tags == 256) {
            return "truthy";
        }
        if (tags == 512) {
            return "falsy";
        }
        return "Unrecognized type: " + tags;
    }

    private static String locationPostfix(String location) {
        if (location == null) {
            return "";
        }
        return "@" + location;
    }

    private static String tagToString(int tag, Set<ObjectType> objs, String T) {
        switch (tag) {
            case 8: 
            case 16: {
                return "boolean";
            }
            case 0: {
                return "bottom";
            }
            case 1: {
                return "string";
            }
            case 64: {
                HashSet strReps = Sets.newHashSet();
                for (ObjectType obj : objs) {
                    strReps.add(obj.toString());
                }
                return Joiner.on((String)"|").join((Iterable)strReps);
            }
            case 32: {
                return "null";
            }
            case 2: {
                return "number";
            }
            case -1: {
                return "top";
            }
            case 4: {
                return "undefined";
            }
            case 0x7FFFFFFF: {
                return "?";
            }
            case 128: {
                return T;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(o instanceof JSType));
        JSType t2 = (JSType)o;
        return this.mask == t2.mask && Objects.equal(this.objs, t2.objs);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mask, this.objs});
    }
}

