/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.StaticSourceFile;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class NodeUtil {
    static final long MAX_POSITIVE_INTEGER_NUMBER = (long)Math.pow(2.0, 53.0);
    static final String JSC_PROPERTY_NAME_FN = "JSCompiler_renameProperty";
    static final char LARGEST_BASIC_LATIN = '\u007f';
    private static final Set<String> CONSTRUCTORS_WITHOUT_SIDE_EFFECTS = new HashSet<String>(Arrays.asList("Array", "Date", "Error", "Object", "RegExp", "XMLHttpRequest"));
    private static final Set<String> BUILTIN_FUNCTIONS_WITHOUT_SIDEEFFECTS = ImmutableSet.of((Object)"Object", (Object)"Array", (Object)"String", (Object)"Number", (Object)"Boolean", (Object)"RegExp", (Object[])new String[]{"Error"});
    private static final Set<String> OBJECT_METHODS_WITHOUT_SIDEEFFECTS = ImmutableSet.of((Object)"toString", (Object)"valueOf");
    private static final Set<String> REGEXP_METHODS = ImmutableSet.of((Object)"test", (Object)"exec");
    private static final Set<String> STRING_REGEXP_METHODS = ImmutableSet.of((Object)"match", (Object)"replace", (Object)"search", (Object)"split");
    static final Predicate<Node> IMMUTABLE_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node n) {
            return NodeUtil.isImmutableValue(n);
        }
    };
    static final NumbericResultPredicate NUMBERIC_RESULT_PREDICATE = new NumbericResultPredicate();
    static final BooleanResultPredicate BOOLEAN_RESULT_PREDICATE = new BooleanResultPredicate();
    static final MayBeStringResultPredicate MAY_BE_STRING_PREDICATE = new MayBeStringResultPredicate();
    static final Predicate<Node> MATCH_NOT_FUNCTION = new MatchNotFunction();

    private NodeUtil() {
    }

    static TernaryValue getImpureBooleanValue(Node n) {
        switch (n.getType()) {
            case 85: 
            case 86: {
                return NodeUtil.getImpureBooleanValue(n.getLastChild());
            }
            case 26: {
                TernaryValue value = NodeUtil.getImpureBooleanValue(n.getLastChild());
                return value.not();
            }
            case 101: {
                TernaryValue lhs = NodeUtil.getImpureBooleanValue(n.getFirstChild());
                TernaryValue rhs = NodeUtil.getImpureBooleanValue(n.getLastChild());
                return lhs.and(rhs);
            }
            case 100: {
                TernaryValue lhs = NodeUtil.getImpureBooleanValue(n.getFirstChild());
                TernaryValue rhs = NodeUtil.getImpureBooleanValue(n.getLastChild());
                return lhs.or(rhs);
            }
            case 98: {
                TernaryValue trueValue = NodeUtil.getImpureBooleanValue(n.getFirstChild().getNext());
                TernaryValue falseValue = NodeUtil.getImpureBooleanValue(n.getLastChild());
                if (trueValue.equals((Object)falseValue)) {
                    return trueValue;
                }
                return TernaryValue.UNKNOWN;
            }
            case 63: 
            case 64: {
                return TernaryValue.TRUE;
            }
            case 122: {
                return TernaryValue.FALSE;
            }
        }
        return NodeUtil.getPureBooleanValue(n);
    }

    static TernaryValue getPureBooleanValue(Node n) {
        switch (n.getType()) {
            case 40: {
                return TernaryValue.forBoolean(n.getString().length() > 0);
            }
            case 39: {
                return TernaryValue.forBoolean(n.getDouble() != 0.0);
            }
            case 26: {
                return NodeUtil.getPureBooleanValue(n.getLastChild()).not();
            }
            case 41: 
            case 43: {
                return TernaryValue.FALSE;
            }
            case 122: {
                if (NodeUtil.mayHaveSideEffects(n.getFirstChild())) break;
                return TernaryValue.FALSE;
            }
            case 38: {
                String name = n.getString();
                if ("undefined".equals(name) || "NaN".equals(name)) {
                    return TernaryValue.FALSE;
                }
                if (!"Infinity".equals(name)) break;
                return TernaryValue.TRUE;
            }
            case 44: 
            case 47: {
                return TernaryValue.TRUE;
            }
            case 63: 
            case 64: {
                if (NodeUtil.mayHaveSideEffects(n)) break;
                return TernaryValue.TRUE;
            }
        }
        return TernaryValue.UNKNOWN;
    }

    static String getStringValue(Node n) {
        switch (n.getType()) {
            case 40: 
            case 154: {
                return n.getString();
            }
            case 38: {
                String name = n.getString();
                if (!"undefined".equals(name) && !"Infinity".equals(name) && !"NaN".equals(name)) break;
                return name;
            }
            case 39: {
                return NodeUtil.getStringValue(n.getDouble());
            }
            case 43: {
                return "false";
            }
            case 44: {
                return "true";
            }
            case 41: {
                return "null";
            }
            case 122: {
                return "undefined";
            }
            case 26: {
                TernaryValue child = NodeUtil.getPureBooleanValue(n.getFirstChild());
                if (child == TernaryValue.UNKNOWN) break;
                return child.toBoolean(true) ? "false" : "true";
            }
            case 63: {
                return NodeUtil.arrayToString(n);
            }
            case 64: {
                return "[object Object]";
            }
        }
        return null;
    }

    static String getStringValue(double value) {
        long longValue = (long)value;
        if ((double)longValue == value) {
            return Long.toString(longValue);
        }
        return Double.toString(value);
    }

    static String getArrayElementStringValue(Node n) {
        return NodeUtil.isNullOrUndefined(n) || n.isEmpty() ? "" : NodeUtil.getStringValue(n);
    }

    static String arrayToString(Node literal) {
        Node first = literal.getFirstChild();
        StringBuilder result = new StringBuilder();
        for (Node n = first; n != null; n = n.getNext()) {
            String childValue = NodeUtil.getArrayElementStringValue(n);
            if (childValue == null) {
                return null;
            }
            if (n != first) {
                result.append(',');
            }
            result.append(childValue);
        }
        return result.toString();
    }

    static Double getNumberValue(Node n) {
        switch (n.getType()) {
            case 44: {
                return 1.0;
            }
            case 41: 
            case 43: {
                return 0.0;
            }
            case 39: {
                return n.getDouble();
            }
            case 122: {
                if (NodeUtil.mayHaveSideEffects(n.getFirstChild())) {
                    return null;
                }
                return Double.NaN;
            }
            case 38: {
                String name = n.getString();
                if (name.equals("undefined")) {
                    return Double.NaN;
                }
                if (name.equals("NaN")) {
                    return Double.NaN;
                }
                if (name.equals("Infinity")) {
                    return Double.POSITIVE_INFINITY;
                }
                return null;
            }
            case 29: {
                if (n.getChildCount() == 1 && n.getFirstChild().isName() && n.getFirstChild().getString().equals("Infinity")) {
                    return Double.NEGATIVE_INFINITY;
                }
                return null;
            }
            case 26: {
                TernaryValue child = NodeUtil.getPureBooleanValue(n.getFirstChild());
                if (child == TernaryValue.UNKNOWN) break;
                return child.toBoolean(true) ? 0.0 : 1.0;
            }
            case 40: {
                return NodeUtil.getStringNumberValue(n.getString());
            }
            case 63: 
            case 64: {
                String value = NodeUtil.getStringValue(n);
                return value != null ? NodeUtil.getStringNumberValue(value) : null;
            }
        }
        return null;
    }

    static Double getStringNumberValue(String rawJsString) {
        if (rawJsString.contains("\u000b")) {
            return null;
        }
        String s = NodeUtil.trimJsWhiteSpace(rawJsString);
        if (s.length() == 0) {
            return 0.0;
        }
        if (s.length() > 2 && s.charAt(0) == '0' && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
            try {
                return Integer.parseInt(s.substring(2), 16);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        if (!(s.length() <= 3 || s.charAt(0) != '-' && s.charAt(0) != '+' || s.charAt(1) != '0' || s.charAt(2) != 'x' && s.charAt(2) != 'X')) {
            return null;
        }
        if (s.equals("infinity") || s.equals("-infinity") || s.equals("+infinity")) {
            return null;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    static String trimJsWhiteSpace(String s) {
        int end;
        int start = 0;
        for (end = s.length(); end > 0 && NodeUtil.isStrWhiteSpaceChar(s.charAt(end - 1)) == TernaryValue.TRUE; --end) {
        }
        while (start < end && NodeUtil.isStrWhiteSpaceChar(s.charAt(start)) == TernaryValue.TRUE) {
            ++start;
        }
        return s.substring(start, end);
    }

    public static TernaryValue isStrWhiteSpaceChar(int c) {
        switch (c) {
            case 11: {
                return TernaryValue.UNKNOWN;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: 
            case 160: 
            case 8232: 
            case 8233: 
            case 65279: {
                return TernaryValue.TRUE;
            }
        }
        return Character.getType(c) == 12 ? TernaryValue.TRUE : TernaryValue.FALSE;
    }

    static String getFunctionName(Node n) {
        Preconditions.checkState((boolean)n.isFunction());
        Node parent = n.getParent();
        switch (parent.getType()) {
            case 38: {
                return parent.getQualifiedName();
            }
            case 86: {
                return parent.getFirstChild().getQualifiedName();
            }
        }
        String name = n.getFirstChild().getQualifiedName();
        return name;
    }

    public static String getNearestFunctionName(Node n) {
        if (!n.isFunction()) {
            return null;
        }
        String name = NodeUtil.getFunctionName(n);
        if (name != null) {
            return name;
        }
        Node parent = n.getParent();
        switch (parent.getType()) {
            case 147: 
            case 148: 
            case 154: {
                return parent.getString();
            }
            case 39: {
                return NodeUtil.getStringValue(parent);
            }
        }
        return null;
    }

    static boolean isImmutableValue(Node n) {
        switch (n.getType()) {
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                return true;
            }
            case 26: 
            case 155: {
                return NodeUtil.isImmutableValue(n.getFirstChild());
            }
            case 29: 
            case 122: {
                return NodeUtil.isImmutableValue(n.getFirstChild());
            }
            case 38: {
                String name = n.getString();
                return "undefined".equals(name) || "Infinity".equals(name) || "NaN".equals(name);
            }
        }
        return false;
    }

    static boolean isSymmetricOperation(Node n) {
        switch (n.getType()) {
            case 12: 
            case 13: 
            case 23: 
            case 45: 
            case 46: {
                return true;
            }
        }
        return false;
    }

    static boolean isRelationalOperation(Node n) {
        switch (n.getType()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    static int getInverseOperator(int type) {
        switch (type) {
            case 16: {
                return 14;
            }
            case 14: {
                return 16;
            }
            case 17: {
                return 15;
            }
            case 15: {
                return 17;
            }
        }
        return -1;
    }

    static boolean isLiteralValue(Node n, boolean includeFunctions) {
        switch (n.getType()) {
            case 155: {
                return NodeUtil.isLiteralValue(n.getFirstChild(), includeFunctions);
            }
            case 63: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (child.isEmpty() || NodeUtil.isLiteralValue(child, includeFunctions)) continue;
                    return false;
                }
                return true;
            }
            case 47: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (NodeUtil.isLiteralValue(child, includeFunctions)) continue;
                    return false;
                }
                return true;
            }
            case 64: {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (NodeUtil.isLiteralValue(child.getFirstChild(), includeFunctions)) continue;
                    return false;
                }
                return true;
            }
            case 105: {
                return includeFunctions && !NodeUtil.isFunctionDeclaration(n);
            }
        }
        return NodeUtil.isImmutableValue(n);
    }

    static boolean isValidDefineValue(Node val, Set<String> defines) {
        switch (val.getType()) {
            case 39: 
            case 40: 
            case 43: 
            case 44: {
                return true;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 45: 
            case 46: {
                return NodeUtil.isValidDefineValue(val.getFirstChild(), defines) && NodeUtil.isValidDefineValue(val.getLastChild(), defines);
            }
            case 26: 
            case 28: 
            case 29: {
                return NodeUtil.isValidDefineValue(val.getFirstChild(), defines);
            }
            case 33: 
            case 38: {
                if (!val.isQualifiedName()) break;
                return defines.contains(val.getQualifiedName());
            }
        }
        return false;
    }

    static boolean isEmptyBlock(Node block) {
        if (!block.isBlock()) {
            return false;
        }
        for (Node n = block.getFirstChild(); n != null; n = n.getNext()) {
            if (n.isEmpty()) continue;
            return false;
        }
        return true;
    }

    static boolean isSimpleOperator(Node n) {
        return NodeUtil.isSimpleOperatorType(n.getType());
    }

    static boolean isSimpleOperatorType(int type) {
        switch (type) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 45: 
            case 46: 
            case 52: 
            case 85: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    static Node newExpr(Node child) {
        return IR.exprResult(child).srcref(child);
    }

    static boolean mayEffectMutableState(Node n) {
        return NodeUtil.mayEffectMutableState(n, null);
    }

    static boolean mayEffectMutableState(Node n, AbstractCompiler compiler) {
        return NodeUtil.checkForStateChangeHelper(n, true, compiler);
    }

    static boolean mayHaveSideEffects(Node n) {
        return NodeUtil.mayHaveSideEffects(n, null);
    }

    static boolean mayHaveSideEffects(Node n, AbstractCompiler compiler) {
        return NodeUtil.checkForStateChangeHelper(n, false, compiler);
    }

    private static boolean checkForStateChangeHelper(Node n, boolean checkForNewObjects, AbstractCompiler compiler) {
        switch (n.getType()) {
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 51: 
            case 77: 
            case 83: 
            case 98: 
            case 100: 
            case 101: 
            case 108: 
            case 110: 
            case 124: 
            case 125: 
            case 130: 
            case 154: 
            case 155: {
                break;
            }
            case 49: {
                return true;
            }
            case 64: {
                if (checkForNewObjects) {
                    return true;
                }
                for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                    if (!NodeUtil.checkForStateChangeHelper(c.getFirstChild(), checkForNewObjects, compiler)) continue;
                    return true;
                }
                return false;
            }
            case 47: 
            case 63: {
                if (!checkForNewObjects) break;
                return true;
            }
            case 38: 
            case 118: {
                if (n.getFirstChild() == null) break;
                return true;
            }
            case 105: {
                return checkForNewObjects || !NodeUtil.isFunctionExpression(n);
            }
            case 30: {
                if (checkForNewObjects) {
                    return true;
                }
                if (!NodeUtil.constructorCallHasSideEffects(n)) break;
                return true;
            }
            case 37: {
                if (!NodeUtil.functionCallHasSideEffects(n, compiler)) break;
                return true;
            }
            default: {
                if (NodeUtil.isSimpleOperator(n)) break;
                if (NodeUtil.isAssignmentOp(n)) {
                    Node assignTarget = n.getFirstChild();
                    if (assignTarget.isName()) {
                        return true;
                    }
                    if (NodeUtil.checkForStateChangeHelper(n.getFirstChild(), checkForNewObjects, compiler) || NodeUtil.checkForStateChangeHelper(n.getLastChild(), checkForNewObjects, compiler)) {
                        return true;
                    }
                    if (NodeUtil.isGet(assignTarget)) {
                        Node current = assignTarget.getFirstChild();
                        if (NodeUtil.evaluatesToLocalValue(current)) {
                            return false;
                        }
                        while (NodeUtil.isGet(current)) {
                            current = current.getFirstChild();
                        }
                        return !NodeUtil.isLiteralValue(current, true);
                    }
                    return !NodeUtil.isLiteralValue(assignTarget, true);
                }
                return true;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.checkForStateChangeHelper(c, checkForNewObjects, compiler)) continue;
            return true;
        }
        return false;
    }

    static boolean constructorCallHasSideEffects(Node callNode) {
        return NodeUtil.constructorCallHasSideEffects(callNode, null);
    }

    static boolean constructorCallHasSideEffects(Node callNode, AbstractCompiler compiler) {
        if (!callNode.isNew()) {
            throw new IllegalStateException("Expected NEW node, got " + Token.name(callNode.getType()));
        }
        if (callNode.isNoSideEffectsCall()) {
            return false;
        }
        Node nameNode = callNode.getFirstChild();
        return !nameNode.isName() || !CONSTRUCTORS_WITHOUT_SIDE_EFFECTS.contains(nameNode.getString());
    }

    static boolean functionCallHasSideEffects(Node callNode) {
        return NodeUtil.functionCallHasSideEffects(callNode, null);
    }

    static boolean functionCallHasSideEffects(Node callNode, @Nullable AbstractCompiler compiler) {
        if (!callNode.isCall()) {
            throw new IllegalStateException("Expected CALL node, got " + Token.name(callNode.getType()));
        }
        if (callNode.isNoSideEffectsCall()) {
            return false;
        }
        Node nameNode = callNode.getFirstChild();
        if (nameNode.isName()) {
            String name = nameNode.getString();
            if (BUILTIN_FUNCTIONS_WITHOUT_SIDEEFFECTS.contains(name)) {
                return false;
            }
        } else if (nameNode.isGetProp()) {
            if (callNode.hasOneChild() && OBJECT_METHODS_WITHOUT_SIDEEFFECTS.contains(nameNode.getLastChild().getString())) {
                return false;
            }
            if (callNode.isOnlyModifiesThisCall() && NodeUtil.evaluatesToLocalValue(nameNode.getFirstChild())) {
                return false;
            }
            if (nameNode.getFirstChild().isName() && "Math.floor".equals(nameNode.getQualifiedName())) {
                return false;
            }
            if (compiler != null && !compiler.hasRegExpGlobalReferences()) {
                Node param;
                if (nameNode.getFirstChild().isRegExp() && REGEXP_METHODS.contains(nameNode.getLastChild().getString())) {
                    return false;
                }
                if (nameNode.getFirstChild().isString() && STRING_REGEXP_METHODS.contains(nameNode.getLastChild().getString()) && (param = nameNode.getNext()) != null && (param.isString() || param.isRegExp())) {
                    return false;
                }
            }
        }
        return true;
    }

    static boolean callHasLocalResult(Node n) {
        Preconditions.checkState((boolean)n.isCall());
        return (n.getSideEffectFlags() & 0x10) > 0;
    }

    static boolean newHasLocalResult(Node n) {
        Preconditions.checkState((boolean)n.isNew());
        return n.isOnlyModifiesThisCall();
    }

    static boolean nodeTypeMayHaveSideEffects(Node n) {
        return NodeUtil.nodeTypeMayHaveSideEffects(n, null);
    }

    static boolean nodeTypeMayHaveSideEffects(Node n, AbstractCompiler compiler) {
        if (NodeUtil.isAssignmentOp(n)) {
            return true;
        }
        switch (n.getType()) {
            case 31: 
            case 49: 
            case 102: 
            case 103: {
                return true;
            }
            case 37: {
                return NodeUtil.functionCallHasSideEffects(n, compiler);
            }
            case 30: {
                return NodeUtil.constructorCallHasSideEffects(n, compiler);
            }
            case 38: {
                return n.hasChildren();
            }
        }
        return false;
    }

    static boolean canBeSideEffected(Node n) {
        Set<String> emptySet = Collections.emptySet();
        return NodeUtil.canBeSideEffected(n, emptySet);
    }

    static boolean canBeSideEffected(Node n, Set<String> knownConstants) {
        switch (n.getType()) {
            case 30: 
            case 37: {
                return true;
            }
            case 38: {
                return !NodeUtil.isConstantName(n) && !knownConstants.contains(n.getString());
            }
            case 33: 
            case 35: {
                return true;
            }
            case 105: {
                Preconditions.checkState((boolean)NodeUtil.isFunctionExpression(n));
                return false;
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.canBeSideEffected(c, knownConstants)) continue;
            return true;
        }
        return false;
    }

    static int precedence(int type) {
        int precedence = NodeUtil.precedenceWithDefault(type);
        if (precedence != -1) {
            return precedence;
        }
        throw new Error("Unknown precedence for " + Token.name(type) + " (type " + type + ")");
    }

    static int precedenceWithDefault(int type) {
        switch (type) {
            case 85: {
                return 0;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return 1;
            }
            case 98: {
                return 2;
            }
            case 100: {
                return 3;
            }
            case 101: {
                return 4;
            }
            case 9: {
                return 5;
            }
            case 10: {
                return 6;
            }
            case 11: {
                return 7;
            }
            case 12: 
            case 13: 
            case 45: 
            case 46: {
                return 8;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 51: 
            case 52: {
                return 9;
            }
            case 18: 
            case 19: 
            case 20: {
                return 10;
            }
            case 21: 
            case 22: {
                return 11;
            }
            case 23: 
            case 24: 
            case 25: {
                return 12;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 102: 
            case 103: 
            case 122: {
                return 13;
            }
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 63: 
            case 64: 
            case 105: 
            case 124: 
            case 154: {
                return 15;
            }
            case 155: {
                return 16;
            }
        }
        return -1;
    }

    static boolean isUndefined(Node n) {
        switch (n.getType()) {
            case 122: {
                return true;
            }
            case 38: {
                return n.getString().equals("undefined");
            }
        }
        return false;
    }

    static boolean isNullOrUndefined(Node n) {
        return n.isNull() || NodeUtil.isUndefined(n);
    }

    static boolean isImmutableResult(Node n) {
        return NodeUtil.allResultsMatch(n, IMMUTABLE_PREDICATE);
    }

    static boolean allResultsMatch(Node n, Predicate<Node> p) {
        switch (n.getType()) {
            case 155: {
                return NodeUtil.allResultsMatch(n.getFirstChild(), p);
            }
            case 85: 
            case 86: {
                return NodeUtil.allResultsMatch(n.getLastChild(), p);
            }
            case 100: 
            case 101: {
                return NodeUtil.allResultsMatch(n.getFirstChild(), p) && NodeUtil.allResultsMatch(n.getLastChild(), p);
            }
            case 98: {
                return NodeUtil.allResultsMatch(n.getFirstChild().getNext(), p) && NodeUtil.allResultsMatch(n.getLastChild(), p);
            }
        }
        return p.apply((Object)n);
    }

    static boolean anyResultsMatch(Node n, Predicate<Node> p) {
        switch (n.getType()) {
            case 155: {
                return NodeUtil.anyResultsMatch(n.getFirstChild(), p);
            }
            case 85: 
            case 86: {
                return NodeUtil.anyResultsMatch(n.getLastChild(), p);
            }
            case 100: 
            case 101: {
                return NodeUtil.anyResultsMatch(n.getFirstChild(), p) || NodeUtil.anyResultsMatch(n.getLastChild(), p);
            }
            case 98: {
                return NodeUtil.anyResultsMatch(n.getFirstChild().getNext(), p) || NodeUtil.anyResultsMatch(n.getLastChild(), p);
            }
        }
        return p.apply((Object)n);
    }

    static boolean isNumericResult(Node n) {
        return NodeUtil.allResultsMatch(n, NUMBERIC_RESULT_PREDICATE);
    }

    static boolean isNumericResultHelper(Node n) {
        switch (n.getType()) {
            case 21: {
                return !NodeUtil.mayBeString(n.getFirstChild()) && !NodeUtil.mayBeString(n.getLastChild());
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 39: 
            case 102: 
            case 103: {
                return true;
            }
            case 38: {
                String name = n.getString();
                if (name.equals("NaN")) {
                    return true;
                }
                return name.equals("Infinity");
            }
        }
        return false;
    }

    static boolean isBooleanResult(Node n) {
        return NodeUtil.allResultsMatch(n, BOOLEAN_RESULT_PREDICATE);
    }

    static boolean isBooleanResultHelper(Node n) {
        switch (n.getType()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 31: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    static boolean mayBeString(Node n) {
        return NodeUtil.mayBeString(n, true);
    }

    static boolean mayBeString(Node n, boolean recurse) {
        if (recurse) {
            return NodeUtil.anyResultsMatch(n, MAY_BE_STRING_PREDICATE);
        }
        return NodeUtil.mayBeStringHelper(n);
    }

    static boolean mayBeStringHelper(Node n) {
        return !NodeUtil.isNumericResult(n) && !NodeUtil.isBooleanResult(n) && !NodeUtil.isUndefined(n) && !n.isNull();
    }

    static boolean isAssociative(int type) {
        switch (type) {
            case 9: 
            case 10: 
            case 11: 
            case 23: 
            case 100: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    static boolean isCommutative(int type) {
        switch (type) {
            case 9: 
            case 10: 
            case 11: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    static boolean isAssignmentOp(Node n) {
        switch (n.getType()) {
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return true;
            }
        }
        return false;
    }

    static int getOpFromAssignmentOp(Node n) {
        switch (n.getType()) {
            case 87: {
                return 9;
            }
            case 88: {
                return 10;
            }
            case 89: {
                return 11;
            }
            case 90: {
                return 18;
            }
            case 91: {
                return 19;
            }
            case 92: {
                return 20;
            }
            case 93: {
                return 21;
            }
            case 94: {
                return 22;
            }
            case 95: {
                return 23;
            }
            case 96: {
                return 24;
            }
            case 97: {
                return 25;
            }
        }
        throw new IllegalArgumentException("Not an assignment op:" + n);
    }

    static boolean containsFunction(Node n) {
        return NodeUtil.containsType(n, 105);
    }

    static boolean referencesThis(Node n) {
        Node start = n.isFunction() ? n.getLastChild() : n;
        return NodeUtil.containsType(start, 42, MATCH_NOT_FUNCTION);
    }

    static boolean isGet(Node n) {
        return n.isGetProp() || n.isGetElem();
    }

    static boolean isVarDeclaration(Node n) {
        return n.isName() && n.getParent().isVar();
    }

    static Node getAssignedValue(Node n) {
        Preconditions.checkState((boolean)n.isName());
        Node parent = n.getParent();
        if (parent.isVar()) {
            return n.getFirstChild();
        }
        if (parent.isAssign() && parent.getFirstChild() == n) {
            return n.getNext();
        }
        return null;
    }

    static boolean isExprAssign(Node n) {
        return n.isExprResult() && n.getFirstChild().isAssign();
    }

    static boolean isExprCall(Node n) {
        return n.isExprResult() && n.getFirstChild().isCall();
    }

    static boolean isForIn(Node n) {
        return n.isFor() && n.getChildCount() == 3;
    }

    static boolean isLoopStructure(Node n) {
        switch (n.getType()) {
            case 113: 
            case 114: 
            case 115: {
                return true;
            }
        }
        return false;
    }

    static Node getLoopCodeBlock(Node n) {
        switch (n.getType()) {
            case 113: 
            case 115: {
                return n.getLastChild();
            }
            case 114: {
                return n.getFirstChild();
            }
        }
        return null;
    }

    static boolean isWithinLoop(Node n) {
        for (Node parent : n.getAncestors()) {
            if (NodeUtil.isLoopStructure(parent)) {
                return true;
            }
            if (!parent.isFunction()) continue;
            break;
        }
        return false;
    }

    static boolean isControlStructure(Node n) {
        switch (n.getType()) {
            case 77: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 119: 
            case 120: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    static boolean isControlStructureCodeBlock(Node parent, Node n) {
        switch (parent.getType()) {
            case 113: 
            case 115: 
            case 119: 
            case 126: {
                return parent.getLastChild() == n;
            }
            case 114: {
                return parent.getFirstChild() == n;
            }
            case 108: {
                return parent.getFirstChild() != n;
            }
            case 77: {
                return parent.getFirstChild() == n || parent.getLastChild() == n;
            }
            case 120: {
                return parent.getLastChild() == n;
            }
            case 110: 
            case 111: {
                return parent.getFirstChild() != n;
            }
            case 112: {
                return true;
            }
        }
        Preconditions.checkState((boolean)NodeUtil.isControlStructure(parent));
        return false;
    }

    static Node getConditionExpression(Node n) {
        switch (n.getType()) {
            case 108: 
            case 113: {
                return n.getFirstChild();
            }
            case 114: {
                return n.getLastChild();
            }
            case 115: {
                switch (n.getChildCount()) {
                    case 3: {
                        return null;
                    }
                    case 4: {
                        return n.getFirstChild().getNext();
                    }
                }
                throw new IllegalArgumentException("malformed 'for' statement " + n);
            }
            case 111: {
                return null;
            }
        }
        throw new IllegalArgumentException(n + " does not have a condition.");
    }

    static boolean isStatementBlock(Node n) {
        return n.isScript() || n.isBlock();
    }

    static boolean isStatement(Node n) {
        return NodeUtil.isStatementParent(n.getParent());
    }

    static boolean isStatementParent(Node parent) {
        Preconditions.checkState((parent != null ? 1 : 0) != 0);
        switch (parent.getType()) {
            case 125: 
            case 126: 
            case 132: {
                return true;
            }
        }
        return false;
    }

    static boolean isSwitchCase(Node n) {
        return n.isCase() || n.isDefaultCase();
    }

    static boolean isReferenceName(Node n) {
        return n.isName() && !n.getString().isEmpty();
    }

    static boolean isTryFinallyNode(Node parent, Node child) {
        return parent.isTry() && parent.getChildCount() == 3 && child == parent.getLastChild();
    }

    static boolean isTryCatchNodeContainer(Node n) {
        Node parent = n.getParent();
        return parent.isTry() && parent.getFirstChild().getNext() == n;
    }

    static void removeChild(Node parent, Node node) {
        if (NodeUtil.isTryFinallyNode(parent, node)) {
            if (NodeUtil.hasCatchHandler(NodeUtil.getCatchBlock(parent))) {
                parent.removeChild(node);
            } else {
                node.detachChildren();
            }
        } else if (node.isCatch()) {
            Node tryNode = node.getParent().getParent();
            Preconditions.checkState((boolean)NodeUtil.hasFinally(tryNode));
            node.detachFromParent();
        } else if (NodeUtil.isTryCatchNodeContainer(node)) {
            Node tryNode = node.getParent();
            Preconditions.checkState((boolean)NodeUtil.hasFinally(tryNode));
            node.detachChildren();
        } else if (node.isBlock()) {
            node.detachChildren();
        } else if (NodeUtil.isStatementBlock(parent) || NodeUtil.isSwitchCase(node)) {
            parent.removeChild(node);
        } else if (parent.isVar()) {
            if (parent.hasMoreThanOneChild()) {
                parent.removeChild(node);
            } else {
                parent.removeChild(node);
                NodeUtil.removeChild(parent.getParent(), parent);
            }
        } else if (parent.isLabel() && node == parent.getLastChild()) {
            parent.removeChild(node);
            NodeUtil.removeChild(parent.getParent(), parent);
        } else if (parent.isFor() && parent.getChildCount() == 4) {
            parent.replaceChild(node, IR.empty());
        } else {
            throw new IllegalStateException("Invalid attempt to remove node: " + node.toString() + " of " + parent.toString());
        }
    }

    static void maybeAddFinally(Node tryNode) {
        Preconditions.checkState((boolean)tryNode.isTry());
        if (!NodeUtil.hasFinally(tryNode)) {
            tryNode.addChildrenToBack(IR.block().srcref(tryNode));
        }
    }

    static boolean tryMergeBlock(Node block) {
        Preconditions.checkState((boolean)block.isBlock());
        Node parent = block.getParent();
        if (NodeUtil.isStatementBlock(parent)) {
            Node previous = block;
            while (block.hasChildren()) {
                Node child = block.removeFirstChild();
                parent.addChildAfter(child, previous);
                previous = child;
            }
            parent.removeChild(block);
            return true;
        }
        return false;
    }

    static boolean isCallOrNew(Node node) {
        return node.isCall() || node.isNew();
    }

    static Node getFunctionBody(Node fn) {
        Preconditions.checkArgument((boolean)fn.isFunction());
        return fn.getLastChild();
    }

    static boolean isFunctionDeclaration(Node n) {
        return n.isFunction() && NodeUtil.isStatement(n);
    }

    static boolean isHoistedFunctionDeclaration(Node n) {
        return NodeUtil.isFunctionDeclaration(n) && (n.getParent().isScript() || n.getParent().getParent().isFunction());
    }

    static boolean isFunctionExpression(Node n) {
        return n.isFunction() && !NodeUtil.isStatement(n);
    }

    static boolean isBleedingFunctionName(Node n) {
        return n.isName() && !n.getString().isEmpty() && NodeUtil.isFunctionExpression(n.getParent());
    }

    static boolean isEmptyFunctionExpression(Node node) {
        return NodeUtil.isFunctionExpression(node) && NodeUtil.isEmptyBlock(node.getLastChild());
    }

    static boolean isVarArgsFunction(Node function) {
        Preconditions.checkArgument((boolean)function.isFunction());
        return NodeUtil.isNameReferenced(function.getLastChild(), "arguments", MATCH_NOT_FUNCTION);
    }

    static boolean isObjectCallMethod(Node callNode, String methodName) {
        Node last;
        Node functionIndentifyingExpression;
        if (callNode.isCall() && NodeUtil.isGet(functionIndentifyingExpression = callNode.getFirstChild()) && (last = functionIndentifyingExpression.getLastChild()) != null && last.isString()) {
            String propName = last.getString();
            return propName.equals(methodName);
        }
        return false;
    }

    static boolean isFunctionObjectCall(Node callNode) {
        return NodeUtil.isObjectCallMethod(callNode, "call");
    }

    static boolean isFunctionObjectApply(Node callNode) {
        return NodeUtil.isObjectCallMethod(callNode, "apply");
    }

    static boolean isVarOrSimpleAssignLhs(Node n, Node parent) {
        return parent.isAssign() && parent.getFirstChild() == n || parent.isVar();
    }

    public static boolean isLValue(Node n) {
        Preconditions.checkArgument((n.isName() || n.isGetProp() || n.isGetElem() ? 1 : 0) != 0);
        Node parent = n.getParent();
        if (parent == null) {
            return false;
        }
        return NodeUtil.isAssignmentOp(parent) && parent.getFirstChild() == n || NodeUtil.isForIn(parent) && parent.getFirstChild() == n || parent.isVar() || parent.isFunction() && parent.getFirstChild() == n || parent.isDec() || parent.isInc() || parent.isParamList() || parent.isCatch();
    }

    static boolean isObjectLitKey(Node node) {
        switch (node.getType()) {
            case 147: 
            case 148: 
            case 154: {
                return true;
            }
        }
        return false;
    }

    static String getObjectLitKeyName(Node key) {
        switch (key.getType()) {
            case 147: 
            case 148: 
            case 154: {
                return key.getString();
            }
        }
        throw new IllegalStateException("Unexpected node type: " + key);
    }

    static JSType getObjectLitKeyTypeFromValueType(Node key, JSType valueType) {
        if (valueType != null) {
            switch (key.getType()) {
                case 147: {
                    if (valueType.isFunctionType()) {
                        FunctionType fntype = valueType.toMaybeFunctionType();
                        valueType = fntype.getReturnType();
                        break;
                    }
                    return null;
                }
                case 148: {
                    if (valueType.isFunctionType()) {
                        FunctionType fntype = valueType.toMaybeFunctionType();
                        Node param = fntype.getParametersNode().getFirstChild();
                        valueType = param.getJSType();
                        break;
                    }
                    return null;
                }
            }
        }
        return valueType;
    }

    static boolean isGetOrSetKey(Node node) {
        switch (node.getType()) {
            case 147: 
            case 148: {
                return true;
            }
        }
        return false;
    }

    static String opToStr(int operator) {
        switch (operator) {
            case 9: {
                return "|";
            }
            case 100: {
                return "||";
            }
            case 10: {
                return "^";
            }
            case 101: {
                return "&&";
            }
            case 11: {
                return "&";
            }
            case 45: {
                return "===";
            }
            case 12: {
                return "==";
            }
            case 26: {
                return "!";
            }
            case 13: {
                return "!=";
            }
            case 46: {
                return "!==";
            }
            case 18: {
                return "<<";
            }
            case 51: {
                return "in";
            }
            case 15: {
                return "<=";
            }
            case 14: {
                return "<";
            }
            case 20: {
                return ">>>";
            }
            case 19: {
                return ">>";
            }
            case 17: {
                return ">=";
            }
            case 16: {
                return ">";
            }
            case 23: {
                return "*";
            }
            case 24: {
                return "/";
            }
            case 25: {
                return "%";
            }
            case 27: {
                return "~";
            }
            case 21: {
                return "+";
            }
            case 22: {
                return "-";
            }
            case 28: {
                return "+";
            }
            case 29: {
                return "-";
            }
            case 86: {
                return "=";
            }
            case 87: {
                return "|=";
            }
            case 88: {
                return "^=";
            }
            case 89: {
                return "&=";
            }
            case 90: {
                return "<<=";
            }
            case 91: {
                return ">>=";
            }
            case 92: {
                return ">>>=";
            }
            case 93: {
                return "+=";
            }
            case 94: {
                return "-=";
            }
            case 95: {
                return "*=";
            }
            case 96: {
                return "/=";
            }
            case 97: {
                return "%=";
            }
            case 122: {
                return "void";
            }
            case 32: {
                return "typeof";
            }
            case 52: {
                return "instanceof";
            }
        }
        return null;
    }

    static String opToStrNoFail(int operator) {
        String res = NodeUtil.opToStr(operator);
        if (res == null) {
            throw new Error("Unknown op " + operator + ": " + Token.name(operator));
        }
        return res;
    }

    static boolean containsType(Node node, int type, Predicate<Node> traverseChildrenPred) {
        return NodeUtil.has(node, new MatchNodeType(type), traverseChildrenPred);
    }

    static boolean containsType(Node node, int type) {
        return NodeUtil.containsType(node, type, (Predicate<Node>)Predicates.alwaysTrue());
    }

    static void redeclareVarsInsideBranch(Node branch) {
        Collection<Node> vars = NodeUtil.getVarsDeclaredInBranch(branch);
        if (vars.isEmpty()) {
            return;
        }
        Node parent = NodeUtil.getAddingRoot(branch);
        for (Node nameNode : vars) {
            Node var = IR.var(IR.name(nameNode.getString()).srcref(nameNode)).srcref(nameNode);
            NodeUtil.copyNameAnnotations(nameNode, var.getFirstChild());
            parent.addChildToFront(var);
        }
    }

    static void copyNameAnnotations(Node source, Node destination) {
        if (source.getBooleanProp(43)) {
            destination.putBooleanProp(43, true);
        }
    }

    private static Node getAddingRoot(Node n) {
        Node addingRoot = null;
        Node ancestor = n;
        while (null != (ancestor = ancestor.getParent())) {
            int type = ancestor.getType();
            if (type == 132) {
                addingRoot = ancestor;
                break;
            }
            if (type != 105) continue;
            addingRoot = ancestor.getLastChild();
            break;
        }
        Preconditions.checkState((addingRoot.isBlock() || addingRoot.isScript() ? 1 : 0) != 0);
        Preconditions.checkState((addingRoot.getFirstChild() == null || !addingRoot.getFirstChild().isScript() ? 1 : 0) != 0);
        return addingRoot;
    }

    public static Node newQualifiedNameNode(CodingConvention convention, String name) {
        int endPos = name.indexOf(46);
        if (endPos == -1) {
            return NodeUtil.newName(convention, name);
        }
        String nodeName = name.substring(0, endPos);
        Node node = "this".equals(nodeName) ? IR.thisNode() : NodeUtil.newName(convention, nodeName);
        do {
            int startPos;
            String part = (endPos = name.indexOf(46, startPos = endPos + 1)) == -1 ? name.substring(startPos) : name.substring(startPos, endPos);
            Node propNode = IR.string(part);
            if (convention.isConstantKey(part)) {
                propNode.putBooleanProp(43, true);
            }
            node = IR.getprop(node, propNode);
        } while (endPos != -1);
        return node;
    }

    public static Node newQualifiedNameNodeDeclaration(CodingConvention convention, String name, Node value, JSDocInfo info) {
        Node result;
        Node nameNode = NodeUtil.newQualifiedNameNode(convention, name);
        if (nameNode.isName()) {
            result = IR.var(nameNode, value);
            result.setJSDocInfo(info);
        } else {
            result = IR.exprResult(IR.assign(nameNode, value));
            result.getFirstChild().setJSDocInfo(info);
        }
        return result;
    }

    static Node newQualifiedNameNode(CodingConvention convention, String name, Node basisNode, String originalName) {
        Node node = NodeUtil.newQualifiedNameNode(convention, name);
        NodeUtil.setDebugInformation(node, basisNode, originalName);
        return node;
    }

    static Node getRootOfQualifiedName(Node qName) {
        Node current = qName;
        while (!current.isName() && !current.isThis()) {
            Preconditions.checkState((boolean)current.isGetProp());
            current = current.getFirstChild();
        }
        return current;
    }

    static void setDebugInformation(Node node, Node basisNode, String originalName) {
        node.copyInformationFromForTree(basisNode);
        node.putProp(40, originalName);
    }

    private static Node newName(CodingConvention convention, String name) {
        Node nameNode = IR.name(name);
        if (convention.isConstant(name)) {
            nameNode.putBooleanProp(43, true);
        }
        return nameNode;
    }

    static Node newName(CodingConvention convention, String name, Node srcref) {
        return NodeUtil.newName(convention, name).srcref(srcref);
    }

    static Node newName(CodingConvention convention, String name, Node basisNode, String originalName) {
        Node nameNode = NodeUtil.newName(convention, name, basisNode);
        nameNode.putProp(40, originalName);
        return nameNode;
    }

    static boolean isLatin(String s) {
        int len = s.length();
        for (int index = 0; index < len; ++index) {
            char c = s.charAt(index);
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    static boolean isValidSimpleName(String name) {
        return TokenStream.isJSIdentifier(name) && !TokenStream.isKeyword(name) && NodeUtil.isLatin(name);
    }

    public static boolean isValidQualifiedName(String name) {
        String[] parts;
        if (name.endsWith(".") || name.startsWith(".")) {
            return false;
        }
        for (String part : parts = name.split("\\.")) {
            if (NodeUtil.isValidSimpleName(part)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidPropertyName(String name) {
        return NodeUtil.isValidSimpleName(name);
    }

    static Collection<Node> getVarsDeclaredInBranch(Node root) {
        VarCollector collector = new VarCollector();
        NodeUtil.visitPreOrder(root, collector, MATCH_NOT_FUNCTION);
        return collector.vars.values();
    }

    static boolean isPrototypePropertyDeclaration(Node n) {
        return NodeUtil.isExprAssign(n) && NodeUtil.isPrototypeProperty(n.getFirstChild().getFirstChild());
    }

    static boolean isPrototypeProperty(Node n) {
        String lhsString = n.getQualifiedName();
        return lhsString != null && lhsString.contains(".prototype.");
    }

    static Node getPrototypeClassName(Node qName) {
        Node cur = qName;
        while (cur.isGetProp()) {
            if (cur.getLastChild().getString().equals("prototype")) {
                return cur.getFirstChild();
            }
            cur = cur.getFirstChild();
        }
        return null;
    }

    static String getPrototypePropertyName(Node qName) {
        String qNameStr = qName.getQualifiedName();
        int prototypeIdx = qNameStr.lastIndexOf(".prototype.");
        int memberIndex = prototypeIdx + ".prototype".length() + 1;
        return qNameStr.substring(memberIndex);
    }

    static Node newUndefinedNode(Node srcReferenceNode) {
        Node node = IR.voidNode(IR.number(0.0));
        if (srcReferenceNode != null) {
            node.copyInformationFromForTree(srcReferenceNode);
        }
        return node;
    }

    static Node newVarNode(String name, Node value) {
        Node nodeName = IR.name(name);
        if (value != null) {
            Preconditions.checkState((value.getNext() == null ? 1 : 0) != 0);
            nodeName.addChildToBack(value);
            nodeName.srcref(value);
        }
        Node var = IR.var(nodeName).srcref(nodeName);
        return var;
    }

    static int getNodeTypeReferenceCount(Node node, int type, Predicate<Node> traverseChildrenPred) {
        return NodeUtil.getCount(node, new MatchNodeType(type), traverseChildrenPred);
    }

    static boolean isNameReferenced(Node node, String name, Predicate<Node> traverseChildrenPred) {
        return NodeUtil.has(node, new MatchNameNode(name), traverseChildrenPred);
    }

    static boolean isNameReferenced(Node node, String name) {
        return NodeUtil.isNameReferenced(node, name, (Predicate<Node>)Predicates.alwaysTrue());
    }

    static int getNameReferenceCount(Node node, String name) {
        return NodeUtil.getCount(node, new MatchNameNode(name), (Predicate<Node>)Predicates.alwaysTrue());
    }

    static boolean has(Node node, Predicate<Node> pred, Predicate<Node> traverseChildrenPred) {
        if (pred.apply((Object)node)) {
            return true;
        }
        if (!traverseChildrenPred.apply((Object)node)) {
            return false;
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            if (!NodeUtil.has(c, pred, traverseChildrenPred)) continue;
            return true;
        }
        return false;
    }

    static int getCount(Node n, Predicate<Node> pred, Predicate<Node> traverseChildrenPred) {
        int total = 0;
        if (pred.apply((Object)n)) {
            ++total;
        }
        if (traverseChildrenPred.apply((Object)n)) {
            for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
                total += NodeUtil.getCount(c, pred, traverseChildrenPred);
            }
        }
        return total;
    }

    static void visitPreOrder(Node node, Visitor visitor, Predicate<Node> traverseChildrenPred) {
        visitor.visit(node);
        if (traverseChildrenPred.apply((Object)node)) {
            for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
                NodeUtil.visitPreOrder(c, visitor, traverseChildrenPred);
            }
        }
    }

    static void visitPostOrder(Node node, Visitor visitor, Predicate<Node> traverseChildrenPred) {
        if (traverseChildrenPred.apply((Object)node)) {
            for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
                NodeUtil.visitPostOrder(c, visitor, traverseChildrenPred);
            }
        }
        visitor.visit(node);
    }

    static boolean hasFinally(Node n) {
        Preconditions.checkArgument((boolean)n.isTry());
        return n.getChildCount() == 3;
    }

    static Node getCatchBlock(Node n) {
        Preconditions.checkArgument((boolean)n.isTry());
        return n.getFirstChild().getNext();
    }

    static boolean hasCatchHandler(Node n) {
        Preconditions.checkArgument((boolean)n.isBlock());
        return n.hasChildren() && n.getFirstChild().isCatch();
    }

    public static Node getFunctionParameters(Node fnNode) {
        Preconditions.checkArgument((boolean)fnNode.isFunction());
        return fnNode.getFirstChild().getNext();
    }

    static boolean isConstantName(Node node) {
        return node.getBooleanProp(43);
    }

    static boolean isConstantByConvention(CodingConvention convention, Node node, Node parent) {
        if (parent.isGetProp() && node == parent.getLastChild()) {
            return convention.isConstantKey(node.getString());
        }
        if (NodeUtil.isObjectLitKey(node)) {
            return convention.isConstantKey(node.getString());
        }
        if (node.isName()) {
            return convention.isConstant(node.getString());
        }
        return false;
    }

    public static JSDocInfo getFunctionJSDocInfo(Node n) {
        Preconditions.checkState((boolean)n.isFunction());
        JSDocInfo fnInfo = n.getJSDocInfo();
        if (fnInfo == null && NodeUtil.isFunctionExpression(n)) {
            Node parent = n.getParent();
            if (parent.isAssign()) {
                fnInfo = parent.getJSDocInfo();
            } else if (parent.isName()) {
                fnInfo = parent.getParent().getJSDocInfo();
            }
        }
        return fnInfo;
    }

    public static String getSourceName(Node n) {
        String sourceName = null;
        while (sourceName == null && n != null) {
            sourceName = n.getSourceFileName();
            n = n.getParent();
        }
        return sourceName;
    }

    public static StaticSourceFile getSourceFile(Node n) {
        StaticSourceFile sourceName = null;
        while (sourceName == null && n != null) {
            sourceName = n.getStaticSourceFile();
            n = n.getParent();
        }
        return sourceName;
    }

    public static InputId getInputId(Node n) {
        while (n != null && !n.isScript()) {
            n = n.getParent();
        }
        return n != null && n.isScript() ? n.getInputId() : null;
    }

    static Node newCallNode(Node callTarget, Node ... parameters) {
        boolean isFreeCall = !NodeUtil.isGet(callTarget);
        Node call = IR.call(callTarget, new Node[0]);
        call.putBooleanProp(50, isFreeCall);
        for (Node parameter : parameters) {
            call.addChildToBack(parameter);
        }
        return call;
    }

    static boolean evaluatesToLocalValue(Node value) {
        return NodeUtil.evaluatesToLocalValue(value, (Predicate<Node>)Predicates.alwaysFalse());
    }

    static boolean evaluatesToLocalValue(Node value, Predicate<Node> locals) {
        switch (value.getType()) {
            case 155: {
                return NodeUtil.evaluatesToLocalValue(value.getFirstChild(), locals);
            }
            case 86: {
                return NodeUtil.isImmutableValue(value.getLastChild()) || locals.apply((Object)value) && NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case 85: {
                return NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case 100: 
            case 101: {
                return NodeUtil.evaluatesToLocalValue(value.getFirstChild(), locals) && NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case 98: {
                return NodeUtil.evaluatesToLocalValue(value.getFirstChild().getNext(), locals) && NodeUtil.evaluatesToLocalValue(value.getLastChild(), locals);
            }
            case 102: 
            case 103: {
                if (value.getBooleanProp(32)) {
                    return NodeUtil.evaluatesToLocalValue(value.getFirstChild(), locals);
                }
                return true;
            }
            case 42: {
                return locals.apply((Object)value);
            }
            case 38: {
                return NodeUtil.isImmutableValue(value) || locals.apply((Object)value);
            }
            case 33: 
            case 35: {
                return locals.apply((Object)value);
            }
            case 37: {
                return NodeUtil.callHasLocalResult(value) || NodeUtil.isToStringMethodCall(value) || locals.apply((Object)value);
            }
            case 30: {
                return NodeUtil.newHasLocalResult(value) || locals.apply((Object)value);
            }
            case 47: 
            case 63: 
            case 64: 
            case 105: {
                return true;
            }
            case 31: 
            case 51: {
                return true;
            }
        }
        if (NodeUtil.isAssignmentOp(value) || NodeUtil.isSimpleOperator(value) || NodeUtil.isImmutableValue(value)) {
            return true;
        }
        throw new IllegalStateException("Unexpected expression node" + value + "\n parent:" + value.getParent());
    }

    private static Node getNthSibling(Node first, int index) {
        Node sibling;
        for (sibling = first; index != 0 && sibling != null; sibling = sibling.getNext(), --index) {
        }
        return sibling;
    }

    static Node getArgumentForFunction(Node function, int index) {
        Preconditions.checkState((boolean)function.isFunction());
        return NodeUtil.getNthSibling(function.getFirstChild().getNext().getFirstChild(), index);
    }

    static Node getArgumentForCallOrNew(Node call, int index) {
        Preconditions.checkState((boolean)NodeUtil.isCallOrNew(call));
        return NodeUtil.getNthSibling(call.getFirstChild().getNext(), index);
    }

    static boolean isCallOrNewTarget(Node target) {
        Node parent = target.getParent();
        return parent != null && NodeUtil.isCallOrNew(parent) && parent.getFirstChild() == target;
    }

    private static boolean isToStringMethodCall(Node call) {
        Node getNode = call.getFirstChild();
        if (NodeUtil.isGet(getNode)) {
            Node propNode = getNode.getLastChild();
            return propNode.isString() && "toString".equals(propNode.getString());
        }
        return false;
    }

    static JSDocInfo getBestJSDocInfo(Node n) {
        JSDocInfo info = n.getJSDocInfo();
        if (info == null) {
            Node parent = n.getParent();
            if (parent == null) {
                return null;
            }
            if (parent.isName()) {
                return NodeUtil.getBestJSDocInfo(parent);
            }
            if (parent.isAssign()) {
                return NodeUtil.getBestJSDocInfo(parent);
            }
            if (NodeUtil.isObjectLitKey(parent)) {
                return parent.getJSDocInfo();
            }
            if (parent.isFunction()) {
                return parent.getJSDocInfo();
            }
            if (parent.isVar() && parent.hasOneChild()) {
                return parent.getJSDocInfo();
            }
            if (parent.isHook() && parent.getFirstChild() != n || parent.isOr() || parent.isAnd() || parent.isComma() && parent.getFirstChild() != n) {
                return NodeUtil.getBestJSDocInfo(parent);
            }
            if (parent.isCast()) {
                return parent.getJSDocInfo();
            }
        }
        return info;
    }

    static Node getBestLValue(Node n) {
        Node parent = n.getParent();
        boolean isFunctionDeclaration = NodeUtil.isFunctionDeclaration(n);
        if (isFunctionDeclaration) {
            return n.getFirstChild();
        }
        if (parent.isName()) {
            return parent;
        }
        if (parent.isAssign()) {
            return parent.getFirstChild();
        }
        if (NodeUtil.isObjectLitKey(parent)) {
            return parent;
        }
        if (parent.isHook() && parent.getFirstChild() != n || parent.isOr() || parent.isAnd() || parent.isComma() && parent.getFirstChild() != n) {
            return NodeUtil.getBestLValue(parent);
        }
        if (parent.isCast()) {
            return NodeUtil.getBestLValue(parent);
        }
        return null;
    }

    static Node getRValueOfLValue(Node n) {
        Node parent = n.getParent();
        switch (parent.getType()) {
            case 86: {
                return n.getNext();
            }
            case 118: {
                return n.getFirstChild();
            }
            case 105: {
                return parent;
            }
        }
        return null;
    }

    static Node getBestLValueOwner(@Nullable Node lValue) {
        if (lValue == null || lValue.getParent() == null) {
            return null;
        }
        if (NodeUtil.isObjectLitKey(lValue)) {
            return NodeUtil.getBestLValue(lValue.getParent());
        }
        if (NodeUtil.isGet(lValue)) {
            return lValue.getFirstChild();
        }
        return null;
    }

    static String getBestLValueName(@Nullable Node lValue) {
        if (lValue == null || lValue.getParent() == null) {
            return null;
        }
        if (NodeUtil.isObjectLitKey(lValue)) {
            String ownerName;
            Node owner = NodeUtil.getBestLValue(lValue.getParent());
            if (owner != null && (ownerName = NodeUtil.getBestLValueName(owner)) != null) {
                return ownerName + "." + NodeUtil.getObjectLitKeyName(lValue);
            }
            return null;
        }
        return lValue.getQualifiedName();
    }

    static boolean isExpressionResultUsed(Node expr) {
        Node parent = expr.getParent();
        switch (parent.getType()) {
            case 125: 
            case 130: {
                return false;
            }
            case 155: {
                return NodeUtil.isExpressionResultUsed(parent);
            }
            case 98: 
            case 100: 
            case 101: {
                return expr == parent.getFirstChild() ? true : NodeUtil.isExpressionResultUsed(parent);
            }
            case 85: {
                Node gramps = parent.getParent();
                if (gramps.isCall() && parent == gramps.getFirstChild() && expr == parent.getFirstChild() && parent.getChildCount() == 2 && expr.getNext().isName() && "eval".equals(expr.getNext().getString())) {
                    return true;
                }
                return expr == parent.getFirstChild() ? false : NodeUtil.isExpressionResultUsed(parent);
            }
            case 115: {
                if (NodeUtil.isForIn(parent)) break;
                return parent.getChildAtIndex(1) == expr;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean isExecutedExactlyOnce(Node n) {
        do {
            Node parent = n.getParent();
            switch (parent.getType()) {
                case 98: 
                case 100: 
                case 101: 
                case 108: {
                    if (parent.getFirstChild() == n) break;
                    return false;
                }
                case 115: {
                    if (!(NodeUtil.isForIn(parent) ? parent.getChildAtIndex(1) != n : parent.getFirstChild() != n)) break;
                    return false;
                }
                case 113: 
                case 114: {
                    return false;
                }
                case 77: {
                    if (!NodeUtil.hasFinally(parent)) return false;
                    if (parent.getLastChild() == n) break;
                    return false;
                }
                case 111: 
                case 112: {
                    return false;
                }
                case 105: 
                case 132: {
                    return true;
                }
            }
        } while ((n = n.getParent()) != null);
        return true;
    }

    static Node booleanNode(boolean value) {
        return value ? IR.trueNode() : IR.falseNode();
    }

    static Node numberNode(double value, Node srcref) {
        Node result = Double.isNaN(value) ? IR.name("NaN") : (value == Double.POSITIVE_INFINITY ? IR.name("Infinity") : (value == Double.NEGATIVE_INFINITY ? IR.neg(IR.name("Infinity")) : IR.number(value)));
        if (srcref != null) {
            result.srcrefTree(srcref);
        }
        return result;
    }

    static boolean isNaN(Node n) {
        return n.isName() && n.getString().equals("NaN") || n.getType() == 24 && n.getFirstChild().isNumber() && n.getFirstChild().getDouble() == 0.0 && n.getLastChild().isNumber() && n.getLastChild().getDouble() == 0.0;
    }

    public static Map<Node, Node> mapMainToClone(Node main, Node clone) {
        Preconditions.checkState((boolean)main.isEquivalentTo(clone));
        HashMap<Node, Node> mtoc = new HashMap<Node, Node>();
        mtoc.put(main, clone);
        NodeUtil.mtocHelper(mtoc, main, clone);
        return mtoc;
    }

    private static void mtocHelper(Map<Node, Node> map, Node main, Node clone) {
        if (main.isFunction()) {
            map.put(main, clone);
        }
        Node mchild = main.getFirstChild();
        Node cchild = clone.getFirstChild();
        while (mchild != null) {
            NodeUtil.mtocHelper(map, mchild, cchild);
            mchild = mchild.getNext();
            cchild = cchild.getNext();
        }
    }

    public static void verifyScopeChanges(Map<Node, Node> map, Node main, boolean verifyUnchangedNodes, AbstractCompiler compiler) {
        final Map<Node, Node> mtoc = map;
        final boolean checkUnchanged = verifyUnchangedNodes;
        Node clone = mtoc.get(main);
        if (main.getChangeTime() > clone.getChangeTime()) {
            Preconditions.checkState((!main.isEquivalentToShallow(clone) ? 1 : 0) != 0);
        } else if (checkUnchanged) {
            Preconditions.checkState((boolean)main.isEquivalentToShallow(clone));
        }
        NodeUtil.visitPreOrder(main, new Visitor(){

            @Override
            public void visit(Node n) {
                if (n.isFunction() && mtoc.containsKey(n)) {
                    Node clone = (Node)mtoc.get(n);
                    if (n.getChangeTime() > clone.getChangeTime()) {
                        Preconditions.checkState((!n.isEquivalentToShallow(clone) ? 1 : 0) != 0);
                    } else if (checkUnchanged) {
                        Preconditions.checkState((boolean)n.isEquivalentToShallow(clone));
                    }
                }
            }
        }, (Predicate<Node>)Predicates.alwaysTrue());
    }

    static interface Visitor {
        public void visit(Node var1);
    }

    static class MatchShallowStatement
    implements Predicate<Node> {
        MatchShallowStatement() {
        }

        public boolean apply(Node n) {
            Node parent = n.getParent();
            return n.isBlock() || !n.isFunction() && (parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent));
        }
    }

    private static class MatchNotFunction
    implements Predicate<Node> {
        private MatchNotFunction() {
        }

        public boolean apply(Node n) {
            return !n.isFunction();
        }
    }

    static class MatchDeclaration
    implements Predicate<Node> {
        MatchDeclaration() {
        }

        public boolean apply(Node n) {
            return NodeUtil.isFunctionDeclaration(n) || n.isVar();
        }
    }

    static class MatchNodeType
    implements Predicate<Node> {
        final int type;

        MatchNodeType(int type) {
            this.type = type;
        }

        public boolean apply(Node n) {
            return n.getType() == this.type;
        }
    }

    private static class MatchNameNode
    implements Predicate<Node> {
        final String name;

        MatchNameNode(String name) {
            this.name = name;
        }

        public boolean apply(Node n) {
            return n.isName() && n.getString().equals(this.name);
        }
    }

    private static class VarCollector
    implements Visitor {
        final Map<String, Node> vars = Maps.newLinkedHashMap();

        private VarCollector() {
        }

        @Override
        public void visit(Node n) {
            String name;
            Node parent;
            if (n.isName() && (parent = n.getParent()) != null && parent.isVar() && !this.vars.containsKey(name = n.getString())) {
                this.vars.put(name, n);
            }
        }
    }

    static class MayBeStringResultPredicate
    implements Predicate<Node> {
        MayBeStringResultPredicate() {
        }

        public boolean apply(Node n) {
            return NodeUtil.mayBeStringHelper(n);
        }
    }

    static class BooleanResultPredicate
    implements Predicate<Node> {
        BooleanResultPredicate() {
        }

        public boolean apply(Node n) {
            return NodeUtil.isBooleanResultHelper(n);
        }
    }

    static class NumbericResultPredicate
    implements Predicate<Node> {
        NumbericResultPredicate() {
        }

        public boolean apply(Node n) {
            return NodeUtil.isNumericResultHelper(n);
        }
    }
}

