/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Map;

class CodeGenerator {
    private static final String LT_ESCAPED = "\\x3c";
    private static final String GT_ESCAPED = "\\x3e";
    private final Map<String, String> escapedJsStrings = Maps.newHashMap();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final CodeConsumer cc;
    private final CharsetEncoder outputCharsetEncoder;
    private final boolean preferSingleQuotes;
    private final boolean trustedStrings;

    private CodeGenerator(CodeConsumer consumer) {
        this.cc = consumer;
        this.outputCharsetEncoder = null;
        this.preferSingleQuotes = false;
        this.trustedStrings = true;
    }

    static CodeGenerator forCostEstimation(CodeConsumer consumer) {
        return new CodeGenerator(consumer);
    }

    CodeGenerator(CodeConsumer consumer, CompilerOptions options) {
        this.cc = consumer;
        Charset outputCharset = options.getOutputCharset();
        this.outputCharsetEncoder = outputCharset == null || outputCharset == Charsets.US_ASCII ? null : outputCharset.newEncoder();
        this.preferSingleQuotes = options.preferSingleQuotes;
        this.trustedStrings = options.trustedStrings;
    }

    public void tagAsStrict() {
        this.add("'use strict';");
    }

    void add(String str) {
        this.cc.add(str);
    }

    private void addIdentifier(String identifier) {
        this.cc.addIdentifier(CodeGenerator.identifierEscape(identifier));
    }

    void add(Node n) {
        this.add(n, Context.OTHER);
    }

    void add(Node n, Context context) {
        if (!this.cc.continueProcessing()) {
            return;
        }
        int type = n.getType();
        String opstr = NodeUtil.opToStr(type);
        int childCount = n.getChildCount();
        Node first = n.getFirstChild();
        Node last = n.getLastChild();
        if (opstr != null && first != last) {
            Preconditions.checkState((childCount == 2 ? 1 : 0) != 0, (String)"Bad binary operator \"%s\": expected 2 arguments but got %s", (Object[])new Object[]{opstr, childCount});
            int p = NodeUtil.precedence(type);
            Context rhsContext = this.getContextForNoInOperator(context);
            if (last.getType() == type && NodeUtil.isAssociative(type)) {
                this.addExpr(first, p, context);
                this.cc.addOp(opstr, true);
                this.addExpr(last, p, rhsContext);
            } else if (NodeUtil.isAssignmentOp(n) && NodeUtil.isAssignmentOp(last)) {
                this.addExpr(first, p, context);
                this.cc.addOp(opstr, true);
                this.addExpr(last, p, rhsContext);
            } else {
                this.unrollBinaryOperator(n, type, opstr, context, rhsContext, p, p + 1);
            }
            return;
        }
        this.cc.startSourceMapping(n);
        switch (type) {
            case 77: {
                Preconditions.checkState((first.getNext().isBlock() && !first.getNext().hasMoreThanOneChild() ? 1 : 0) != 0);
                Preconditions.checkState((childCount >= 2 && childCount <= 3 ? 1 : 0) != 0);
                this.add("try");
                this.add(first, Context.PRESERVE_BLOCK);
                Node catchblock = first.getNext().getFirstChild();
                if (catchblock != null) {
                    this.add(catchblock);
                }
                if (childCount != 3) break;
                this.add("finally");
                this.add(last, Context.PRESERVE_BLOCK);
                break;
            }
            case 120: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                this.add("catch(");
                this.add(first);
                this.add(")");
                this.add(last, Context.PRESERVE_BLOCK);
                break;
            }
            case 49: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.add("throw");
                this.add(first);
                this.cc.endStatement(true);
                break;
            }
            case 4: {
                this.add("return");
                if (childCount == 1) {
                    this.add(first);
                } else {
                    Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                }
                this.cc.endStatement();
                break;
            }
            case 118: {
                if (first == null) break;
                this.add("var ");
                this.addList(first, false, this.getContextForNoInOperator(context));
                break;
            }
            case 153: {
                Preconditions.checkState((!n.getString().isEmpty() ? 1 : 0) != 0);
                this.addIdentifier(n.getString());
                break;
            }
            case 38: {
                if (first == null || first.isEmpty()) {
                    this.addIdentifier(n.getString());
                    break;
                }
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.addIdentifier(n.getString());
                this.cc.addOp("=", true);
                if (first.isComma()) {
                    this.addExpr(first, NodeUtil.precedence(86), Context.OTHER);
                    break;
                }
                this.addExpr(first, 0, this.getContextForNoInOperator(context));
                break;
            }
            case 63: {
                this.add("[");
                this.addArrayList(first);
                this.add("]");
                break;
            }
            case 83: {
                this.add("(");
                this.addList(first);
                this.add(")");
                break;
            }
            case 85: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                this.unrollBinaryOperator(n, 85, ",", context, this.getContextForNoInOperator(context), 0, 0);
                break;
            }
            case 39: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.cc.addNumber(n.getDouble());
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 122: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.cc.addOp(NodeUtil.opToStrNoFail(type), false);
                this.addExpr(first, NodeUtil.precedence(type), Context.OTHER);
                break;
            }
            case 29: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                if (n.getFirstChild().isNumber()) {
                    this.cc.addNumber(-n.getFirstChild().getDouble());
                    break;
                }
                this.cc.addOp(NodeUtil.opToStrNoFail(type), false);
                this.addExpr(first, NodeUtil.precedence(type), Context.OTHER);
                break;
            }
            case 98: {
                Preconditions.checkState((childCount == 3 ? 1 : 0) != 0);
                int p = NodeUtil.precedence(type);
                this.addExpr(first, p + 1, context);
                this.cc.addOp("?", true);
                this.addExpr(first.getNext(), 1, Context.OTHER);
                this.cc.addOp(":", true);
                this.addExpr(last, 1, Context.OTHER);
                break;
            }
            case 47: {
                if (!first.isString() || !last.isString()) {
                    throw new Error("Expected children to be strings");
                }
                String regexp = this.regexpEscape(first.getString(), this.outputCharsetEncoder);
                if (childCount == 2) {
                    this.add(regexp + last.getString());
                    break;
                }
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.add(regexp);
                break;
            }
            case 105: {
                boolean funcNeedsParens;
                if (n.getClass() != Node.class) {
                    throw new Error("Unexpected Node subclass.");
                }
                Preconditions.checkState((childCount == 3 ? 1 : 0) != 0);
                boolean bl = funcNeedsParens = context == Context.START_OF_EXPR;
                if (funcNeedsParens) {
                    this.add("(");
                }
                this.add("function");
                this.add(first);
                this.add(first.getNext());
                this.add(last, Context.PRESERVE_BLOCK);
                this.cc.endFunction(context == Context.STATEMENT);
                if (!funcNeedsParens) break;
                this.add(")");
                break;
            }
            case 147: 
            case 148: {
                Preconditions.checkState((boolean)n.getParent().isObjectLit());
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                Preconditions.checkState((boolean)first.isFunction());
                Preconditions.checkState((boolean)first.getFirstChild().getString().isEmpty());
                if (type == 147) {
                    Preconditions.checkState((!first.getChildAtIndex(1).hasChildren() ? 1 : 0) != 0);
                    this.add("get ");
                } else {
                    Preconditions.checkState((boolean)first.getChildAtIndex(1).hasOneChild());
                    this.add("set ");
                }
                String name = n.getString();
                Node fn = first;
                Node parameters = fn.getChildAtIndex(1);
                Node body = fn.getLastChild();
                if (!n.isQuotedString() && TokenStream.isJSIdentifier(name) && NodeUtil.isLatin(name)) {
                    this.add(name);
                } else {
                    double d = CodeGenerator.getSimpleNumber(name);
                    if (!Double.isNaN(d)) {
                        this.cc.addNumber(d);
                    } else {
                        this.addJsString(n);
                    }
                }
                this.add(parameters);
                this.add(body, Context.PRESERVE_BLOCK);
                break;
            }
            case 125: 
            case 132: {
                boolean preserveBlock;
                if (n.getClass() != Node.class) {
                    throw new Error("Unexpected Node subclass.");
                }
                boolean bl = preserveBlock = context == Context.PRESERVE_BLOCK;
                if (preserveBlock) {
                    this.cc.beginBlock();
                }
                boolean preferLineBreaks = type == 132 || type == 125 && !preserveBlock && n.getParent() != null && n.getParent().isScript();
                for (Node c = first; c != null; c = c.getNext()) {
                    this.add(c, Context.STATEMENT);
                    if (c.isVar()) {
                        this.cc.endStatement();
                    }
                    if (c.isFunction()) {
                        this.cc.maybeLineBreak();
                    }
                    if (!preferLineBreaks) continue;
                    this.cc.notePreferredLineBreak();
                }
                if (!preserveBlock) break;
                this.cc.endBlock(this.cc.breakAfterBlockFor(n, context == Context.STATEMENT));
                break;
            }
            case 115: {
                if (childCount == 4) {
                    this.add("for(");
                    if (first.isVar()) {
                        this.add(first, Context.IN_FOR_INIT_CLAUSE);
                    } else {
                        this.addExpr(first, 0, Context.IN_FOR_INIT_CLAUSE);
                    }
                    this.add(";");
                    this.add(first.getNext());
                    this.add(";");
                    this.add(first.getNext().getNext());
                    this.add(")");
                    this.addNonEmptyStatement(last, this.getContextForNonEmptyExpression(context), false);
                    break;
                }
                Preconditions.checkState((childCount == 3 ? 1 : 0) != 0);
                this.add("for(");
                this.add(first);
                this.add("in");
                this.add(first.getNext());
                this.add(")");
                this.addNonEmptyStatement(last, this.getContextForNonEmptyExpression(context), false);
                break;
            }
            case 114: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                this.add("do");
                this.addNonEmptyStatement(first, Context.OTHER, false);
                this.add("while(");
                this.add(last);
                this.add(")");
                this.cc.endStatement();
                break;
            }
            case 113: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                this.add("while(");
                this.add(first);
                this.add(")");
                this.addNonEmptyStatement(last, this.getContextForNonEmptyExpression(context), false);
                break;
            }
            case 124: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                break;
            }
            case 33: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0, (String)"Bad GETPROP: expected 2 children, but got %s", (Object[])new Object[]{childCount});
                Preconditions.checkState((boolean)last.isString(), (Object)"Bad GETPROP: RHS should be STRING");
                boolean needsParens = first.isNumber();
                if (needsParens) {
                    this.add("(");
                }
                this.addExpr(first, NodeUtil.precedence(type), context);
                if (needsParens) {
                    this.add(")");
                }
                this.add(".");
                this.addIdentifier(last.getString());
                break;
            }
            case 35: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0, (String)"Bad GETELEM: expected 2 children but got %s", (Object[])new Object[]{childCount});
                this.addExpr(first, NodeUtil.precedence(type), context);
                this.add("[");
                this.add(first.getNext());
                this.add("]");
                break;
            }
            case 119: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                this.add("with(");
                this.add(first);
                this.add(")");
                this.addNonEmptyStatement(last, this.getContextForNonEmptyExpression(context), false);
                break;
            }
            case 102: 
            case 103: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                String o = type == 102 ? "++" : "--";
                int postProp = n.getIntProp(32);
                if (postProp != 0) {
                    this.addExpr(first, NodeUtil.precedence(type), context);
                    this.cc.addOp(o, false);
                    break;
                }
                this.cc.addOp(o, false);
                this.add(first);
                break;
            }
            case 37: {
                if (this.isIndirectEval(first) || n.getBooleanProp(50) && NodeUtil.isGet(first)) {
                    this.add("(0,");
                    this.addExpr(first, NodeUtil.precedence(85), Context.OTHER);
                    this.add(")");
                } else {
                    this.addExpr(first, NodeUtil.precedence(type), context);
                }
                this.add("(");
                this.addList(first.getNext());
                this.add(")");
                break;
            }
            case 108: {
                boolean ambiguousElseClause;
                boolean hasElse = childCount == 3;
                boolean bl = ambiguousElseClause = context == Context.BEFORE_DANGLING_ELSE && !hasElse;
                if (ambiguousElseClause) {
                    this.cc.beginBlock();
                }
                this.add("if(");
                this.add(first);
                this.add(")");
                if (hasElse) {
                    this.addNonEmptyStatement(first.getNext(), Context.BEFORE_DANGLING_ELSE, false);
                    this.add("else");
                    this.addNonEmptyStatement(last, this.getContextForNonEmptyExpression(context), false);
                } else {
                    this.addNonEmptyStatement(first.getNext(), Context.OTHER, false);
                    Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                }
                if (!ambiguousElseClause) break;
                this.cc.endBlock();
                break;
            }
            case 41: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.cc.addConstant("null");
                break;
            }
            case 42: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.add("this");
                break;
            }
            case 43: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.cc.addConstant("false");
                break;
            }
            case 44: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.cc.addConstant("true");
                break;
            }
            case 117: {
                Preconditions.checkState((childCount <= 1 ? 1 : 0) != 0);
                this.add("continue");
                if (childCount == 1) {
                    if (!first.isLabelName()) {
                        throw new Error("Unexpected token type. Should be LABEL_NAME.");
                    }
                    this.add(" ");
                    this.add(first);
                }
                this.cc.endStatement();
                break;
            }
            case 152: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0);
                this.add("debugger");
                this.cc.endStatement();
                break;
            }
            case 116: {
                Preconditions.checkState((childCount <= 1 ? 1 : 0) != 0);
                this.add("break");
                if (childCount == 1) {
                    if (!first.isLabelName()) {
                        throw new Error("Unexpected token type. Should be LABEL_NAME.");
                    }
                    this.add(" ");
                    this.add(first);
                }
                this.cc.endStatement();
                break;
            }
            case 130: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.add(first, Context.START_OF_EXPR);
                this.cc.endStatement();
                break;
            }
            case 30: {
                this.add("new ");
                int precedence = NodeUtil.precedence(type);
                if (NodeUtil.containsType(first, 37, NodeUtil.MATCH_NOT_FUNCTION)) {
                    precedence = NodeUtil.precedence(first.getType()) + 1;
                }
                this.addExpr(first, precedence, Context.OTHER);
                Node next = first.getNext();
                if (next == null) break;
                this.add("(");
                this.addList(next);
                this.add(")");
                break;
            }
            case 154: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0, (Object)"Object lit key must have 1 child");
                this.addJsString(n);
                break;
            }
            case 40: {
                Preconditions.checkState((childCount == 0 ? 1 : 0) != 0, (Object)"A string may not have children");
                this.addJsString(n);
                break;
            }
            case 31: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.add("delete ");
                this.add(first);
                break;
            }
            case 64: {
                boolean needsParens;
                boolean bl = needsParens = context == Context.START_OF_EXPR;
                if (needsParens) {
                    this.add("(");
                }
                this.add("{");
                for (Node c = first; c != null; c = c.getNext()) {
                    if (c != first) {
                        this.cc.listSeparator();
                    }
                    if (c.isGetterDef() || c.isSetterDef()) {
                        this.add(c);
                        continue;
                    }
                    Preconditions.checkState((boolean)c.isStringKey());
                    String key = c.getString();
                    if (!c.isQuotedString() && !TokenStream.isKeyword(key) && TokenStream.isJSIdentifier(key) && NodeUtil.isLatin(key)) {
                        this.add(key);
                    } else {
                        double d = CodeGenerator.getSimpleNumber(key);
                        if (!Double.isNaN(d)) {
                            this.cc.addNumber(d);
                        } else {
                            this.addExpr(c, 1, Context.OTHER);
                        }
                    }
                    this.add(":");
                    this.addExpr(c.getFirstChild(), 1, Context.OTHER);
                }
                this.add("}");
                if (!needsParens) break;
                this.add(")");
                break;
            }
            case 110: {
                this.add("switch(");
                this.add(first);
                this.add(")");
                this.cc.beginBlock();
                this.addAllSiblings(first.getNext());
                this.cc.endBlock(context == Context.STATEMENT);
                break;
            }
            case 111: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                this.add("case ");
                this.add(first);
                this.addCaseBody(last);
                break;
            }
            case 112: {
                Preconditions.checkState((childCount == 1 ? 1 : 0) != 0);
                this.add("default");
                this.addCaseBody(first);
                break;
            }
            case 126: {
                Preconditions.checkState((childCount == 2 ? 1 : 0) != 0);
                if (!first.isLabelName()) {
                    throw new Error("Unexpected token type. Should be LABEL_NAME.");
                }
                this.add(first);
                this.add(":");
                this.addNonEmptyStatement(last, this.getContextForNonEmptyExpression(context), true);
                break;
            }
            case 155: {
                this.add("(");
                this.add(first);
                this.add(")");
                break;
            }
            default: {
                throw new Error("Unknown type " + type + "\n" + n.toStringTree());
            }
        }
        this.cc.endSourceMapping(n);
    }

    private void unrollBinaryOperator(Node n, int op, String opStr, Context context, Context rhsContext, int leftPrecedence, int rightPrecedence) {
        Node firstNonOperator = n.getFirstChild();
        while (firstNonOperator.getType() == op) {
            firstNonOperator = firstNonOperator.getFirstChild();
        }
        this.addExpr(firstNonOperator, leftPrecedence, context);
        Node current = firstNonOperator;
        do {
            current = current.getParent();
            this.cc.addOp(opStr, true);
            this.addExpr(current.getFirstChild().getNext(), rightPrecedence, rhsContext);
        } while (current != n);
    }

    static boolean isSimpleNumber(String s) {
        int len = s.length();
        if (len == 0) {
            return false;
        }
        for (int index = 0; index < len; ++index) {
            char c = s.charAt(index);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return len == 1 || s.charAt(0) != '0';
    }

    static double getSimpleNumber(String s) {
        if (CodeGenerator.isSimpleNumber(s)) {
            try {
                long l = Long.parseLong(s);
                if (l < NodeUtil.MAX_POSITIVE_INTEGER_NUMBER) {
                    return l;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    private boolean isIndirectEval(Node n) {
        return n.isName() && "eval".equals(n.getString()) && !n.getBooleanProp(49);
    }

    private void addNonEmptyStatement(Node n, Context context, boolean allowNonBlockChild) {
        Node nodeToProcess = n;
        if (!allowNonBlockChild && !n.isBlock()) {
            throw new Error("Missing BLOCK child.");
        }
        if (n.isBlock()) {
            int count = CodeGenerator.getNonEmptyChildCount(n, 2);
            if (count == 0) {
                if (this.cc.shouldPreserveExtraBlocks()) {
                    this.cc.beginBlock();
                    this.cc.endBlock(this.cc.breakAfterBlockFor(n, context == Context.STATEMENT));
                } else {
                    this.cc.endStatement(true);
                }
                return;
            }
            if (count == 1) {
                Node firstAndOnlyChild = CodeGenerator.getFirstNonEmptyChild(n);
                boolean alwaysWrapInBlock = this.cc.shouldPreserveExtraBlocks();
                if (alwaysWrapInBlock || this.isOneExactlyFunctionOrDo(firstAndOnlyChild)) {
                    this.cc.beginBlock();
                    this.add(firstAndOnlyChild, Context.STATEMENT);
                    this.cc.maybeLineBreak();
                    this.cc.endBlock(this.cc.breakAfterBlockFor(n, context == Context.STATEMENT));
                    return;
                }
                nodeToProcess = firstAndOnlyChild;
            }
            if (count > 1) {
                context = Context.PRESERVE_BLOCK;
            }
        }
        if (nodeToProcess.isEmpty()) {
            this.cc.endStatement(true);
        } else {
            this.add(nodeToProcess, context);
            if (nodeToProcess.isVar()) {
                this.cc.endStatement();
            }
        }
    }

    private boolean isOneExactlyFunctionOrDo(Node n) {
        if (n.isLabel()) {
            Node labeledStatement = n.getLastChild();
            if (!labeledStatement.isBlock()) {
                return this.isOneExactlyFunctionOrDo(labeledStatement);
            }
            if (CodeGenerator.getNonEmptyChildCount(n, 2) == 1) {
                return this.isOneExactlyFunctionOrDo(CodeGenerator.getFirstNonEmptyChild(n));
            }
            return false;
        }
        return n.isFunction() || n.isDo();
    }

    private void addExpr(Node n, int minPrecedence, Context context) {
        if (NodeUtil.precedence(n.getType()) < minPrecedence || context == Context.IN_FOR_INIT_CLAUSE && n.isIn()) {
            this.add("(");
            this.add(n, Context.OTHER);
            this.add(")");
        } else {
            this.add(n, context);
        }
    }

    void addList(Node firstInList) {
        this.addList(firstInList, true, Context.OTHER);
    }

    void addList(Node firstInList, boolean isArrayOrFunctionArgument) {
        this.addList(firstInList, isArrayOrFunctionArgument, Context.OTHER);
    }

    void addList(Node firstInList, boolean isArrayOrFunctionArgument, Context lhsContext) {
        for (Node n = firstInList; n != null; n = n.getNext()) {
            boolean isFirst;
            boolean bl = isFirst = n == firstInList;
            if (isFirst) {
                this.addExpr(n, isArrayOrFunctionArgument ? 1 : 0, lhsContext);
                continue;
            }
            this.cc.listSeparator();
            this.addExpr(n, isArrayOrFunctionArgument ? 1 : 0, this.getContextForNoInOperator(lhsContext));
        }
    }

    void addArrayList(Node firstInList) {
        boolean lastWasEmpty = false;
        for (Node n = firstInList; n != null; n = n.getNext()) {
            if (n != firstInList) {
                this.cc.listSeparator();
            }
            this.addExpr(n, 1, Context.OTHER);
            lastWasEmpty = n.isEmpty();
        }
        if (lastWasEmpty) {
            this.cc.listSeparator();
        }
    }

    void addCaseBody(Node caseBody) {
        this.cc.beginCaseBody();
        this.add(caseBody);
        this.cc.endCaseBody();
    }

    void addAllSiblings(Node n) {
        for (Node c = n; c != null; c = c.getNext()) {
            this.add(c);
        }
    }

    private void addJsString(Node n) {
        String s = n.getString();
        boolean useSlashV = n.getBooleanProp(54);
        if (useSlashV) {
            this.add(this.jsString(n.getString(), useSlashV));
        } else {
            String cached = this.escapedJsStrings.get(s);
            if (cached == null) {
                cached = this.jsString(n.getString(), useSlashV);
                this.escapedJsStrings.put(s, cached);
            }
            this.add(cached);
        }
    }

    private String jsString(String s, boolean useSlashV) {
        String singlequote;
        String doublequote;
        char quote;
        int singleq = 0;
        int doubleq = 0;
        block4: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\"': {
                    ++doubleq;
                    continue block4;
                }
                case '\'': {
                    ++singleq;
                }
            }
        }
        if (this.preferSingleQuotes ? singleq <= doubleq : singleq < doubleq) {
            quote = '\'';
            doublequote = "\"";
            singlequote = "\\'";
        } else {
            quote = '\"';
            doublequote = "\\\"";
            singlequote = "'";
        }
        return this.strEscape(s, quote, doublequote, singlequote, "\\\\", this.outputCharsetEncoder, useSlashV, false);
    }

    String regexpEscape(String s, CharsetEncoder outputCharsetEncoder) {
        return this.strEscape(s, '/', "\"", "'", "\\", outputCharsetEncoder, false, true);
    }

    String escapeToDoubleQuotedJsString(String s) {
        return this.strEscape(s, '\"', "\\\"", "'", "\\\\", null, false, false);
    }

    String regexpEscape(String s) {
        return this.regexpEscape(s, null);
    }

    private String strEscape(String s, char quote, String doublequoteEscape, String singlequoteEscape, String backslashEscape, CharsetEncoder outputCharsetEncoder, boolean useSlashV, boolean isRegexp) {
        StringBuilder sb = new StringBuilder(s.length() + 2);
        sb.append(quote);
        block18: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': {
                    sb.append("\\x00");
                    continue block18;
                }
                case '\u000b': {
                    if (useSlashV) {
                        sb.append("\\v");
                        continue block18;
                    }
                    sb.append("\\x0B");
                    continue block18;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block18;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block18;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block18;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block18;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block18;
                }
                case '\\': {
                    sb.append(backslashEscape);
                    continue block18;
                }
                case '\"': {
                    sb.append(doublequoteEscape);
                    continue block18;
                }
                case '\'': {
                    sb.append(singlequoteEscape);
                    continue block18;
                }
                case '\u2028': {
                    sb.append("\\u2028");
                    continue block18;
                }
                case '\u2029': {
                    sb.append("\\u2029");
                    continue block18;
                }
                case '=': {
                    if (this.trustedStrings || isRegexp) {
                        sb.append(c);
                        continue block18;
                    }
                    sb.append("\\x3d");
                    continue block18;
                }
                case '&': {
                    if (this.trustedStrings || isRegexp) {
                        sb.append(c);
                        continue block18;
                    }
                    sb.append("\\x26");
                    continue block18;
                }
                case '>': {
                    if (!this.trustedStrings && !isRegexp) {
                        sb.append(GT_ESCAPED);
                        continue block18;
                    }
                    if (i >= 2 && (s.charAt(i - 1) == '-' && s.charAt(i - 2) == '-' || s.charAt(i - 1) == ']' && s.charAt(i - 2) == ']')) {
                        sb.append(GT_ESCAPED);
                        continue block18;
                    }
                    sb.append(c);
                    continue block18;
                }
                case '<': {
                    if (!this.trustedStrings && !isRegexp) {
                        sb.append(LT_ESCAPED);
                        continue block18;
                    }
                    String endScript = "/script";
                    String startComment = "!--";
                    if (s.regionMatches(true, i + 1, "/script", 0, "/script".length())) {
                        sb.append(LT_ESCAPED);
                        continue block18;
                    }
                    if (s.regionMatches(false, i + 1, "!--", 0, "!--".length())) {
                        sb.append(LT_ESCAPED);
                        continue block18;
                    }
                    sb.append(c);
                    continue block18;
                }
                default: {
                    if (outputCharsetEncoder != null) {
                        if (outputCharsetEncoder.canEncode(c)) {
                            sb.append(c);
                            continue block18;
                        }
                        CodeGenerator.appendHexJavaScriptRepresentation(sb, c);
                        continue block18;
                    }
                    if (c > '\u001f' && c < '\u007f') {
                        sb.append(c);
                        continue block18;
                    }
                    CodeGenerator.appendHexJavaScriptRepresentation(sb, c);
                }
            }
        }
        sb.append(quote);
        return sb.toString();
    }

    static String identifierEscape(String s) {
        if (NodeUtil.isLatin(s)) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u001f' && c < '\u007f') {
                sb.append(c);
                continue;
            }
            CodeGenerator.appendHexJavaScriptRepresentation(sb, c);
        }
        return sb.toString();
    }

    private static int getNonEmptyChildCount(Node n, int maxCount) {
        int i = 0;
        for (Node c = n.getFirstChild(); c != null && i < maxCount; c = c.getNext()) {
            if (c.isBlock()) {
                i += CodeGenerator.getNonEmptyChildCount(c, maxCount - i);
                continue;
            }
            if (c.isEmpty()) continue;
            ++i;
        }
        return i;
    }

    private static Node getFirstNonEmptyChild(Node n) {
        for (Node c = n.getFirstChild(); c != null; c = c.getNext()) {
            if (c.isBlock()) {
                Node result = CodeGenerator.getFirstNonEmptyChild(c);
                if (result == null) continue;
                return result;
            }
            if (c.isEmpty()) continue;
            return c;
        }
        return null;
    }

    private Context getContextForNonEmptyExpression(Context currentContext) {
        return currentContext == Context.BEFORE_DANGLING_ELSE ? Context.BEFORE_DANGLING_ELSE : Context.OTHER;
    }

    private Context getContextForNoInOperator(Context context) {
        return context == Context.IN_FOR_INIT_CLAUSE ? Context.IN_FOR_INIT_CLAUSE : Context.OTHER;
    }

    private static void appendHexJavaScriptRepresentation(StringBuilder sb, char c) {
        try {
            CodeGenerator.appendHexJavaScriptRepresentation(c, sb);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void appendHexJavaScriptRepresentation(int codePoint, Appendable out) throws IOException {
        if (Character.isSupplementaryCodePoint(codePoint)) {
            char[] surrogates = Character.toChars(codePoint);
            CodeGenerator.appendHexJavaScriptRepresentation(surrogates[0], out);
            CodeGenerator.appendHexJavaScriptRepresentation(surrogates[1], out);
            return;
        }
        out.append("\\u").append(HEX_CHARS[codePoint >>> 12 & 0xF]).append(HEX_CHARS[codePoint >>> 8 & 0xF]).append(HEX_CHARS[codePoint >>> 4 & 0xF]).append(HEX_CHARS[codePoint & 0xF]);
    }

    static enum Context {
        STATEMENT,
        BEFORE_DANGLING_ELSE,
        START_OF_EXPR,
        PRESERVE_BLOCK,
        IN_FOR_INIT_CLAUSE,
        OTHER;

    }
}

