/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;

public final class InstanceObjectType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private final FunctionType constructor;

    InstanceObjectType(JSTypeRegistry jSTypeRegistry, FunctionType functionType) {
        this(jSTypeRegistry, functionType, false);
    }

    InstanceObjectType(JSTypeRegistry jSTypeRegistry, FunctionType functionType, boolean bl) {
        super(jSTypeRegistry, null, null, bl);
        Preconditions.checkNotNull((Object)functionType);
        this.constructor = functionType;
    }

    @Override
    public String getReferenceName() {
        return this.getConstructor().getReferenceName();
    }

    @Override
    public boolean hasReferenceName() {
        return this.getConstructor().hasReferenceName();
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.getConstructor().getPrototype();
    }

    @Override
    public FunctionType getConstructor() {
        return this.constructor;
    }

    @Override
    boolean defineProperty(String string, JSType jSType, boolean bl, boolean bl2, Node node) {
        ObjectType objectType = this.getImplicitPrototype();
        if (objectType != null && objectType.hasOwnDeclaredProperty(string)) {
            return false;
        }
        return super.defineProperty(string, jSType, bl, bl2, node);
    }

    @Override
    public String toString() {
        if (this.constructor.hasReferenceName()) {
            return this.constructor.getReferenceName();
        }
        return super.toString();
    }

    @Override
    boolean isTheObjectType() {
        return this.getConstructor().isNative() && "Object".equals(this.getReferenceName());
    }

    @Override
    public boolean isInstanceType() {
        return true;
    }

    @Override
    public boolean isArrayType() {
        return this.getConstructor().isNative() && "Array".equals(this.getReferenceName());
    }

    @Override
    public boolean isStringObjectType() {
        return this.getConstructor().isNative() && "String".equals(this.getReferenceName());
    }

    @Override
    public boolean isBooleanObjectType() {
        return this.getConstructor().isNative() && "Boolean".equals(this.getReferenceName());
    }

    @Override
    public boolean isNumberObjectType() {
        return this.getConstructor().isNative() && "Number".equals(this.getReferenceName());
    }

    @Override
    public boolean isDateType() {
        return this.getConstructor().isNative() && "Date".equals(this.getReferenceName());
    }

    @Override
    public boolean isRegexpType() {
        return this.getConstructor().isNative() && "RegExp".equals(this.getReferenceName());
    }

    @Override
    public boolean isNominalType() {
        return this.hasReferenceName();
    }

    @Override
    public boolean isEquivalentTo(JSType jSType) {
        ObjectType objectType;
        if (this == jSType) {
            return true;
        }
        if (this.isNominalType() && (objectType = ObjectType.cast(jSType)) != null && objectType.isNominalType()) {
            return this.getReferenceName().equals(objectType.getReferenceName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hasReferenceName()) {
            return this.getReferenceName().hashCode();
        }
        return super.hashCode();
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return this.getConstructor().getImplementedInterfaces();
    }
}

