/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.Kit;
import com.google.javascript.rhino.UniqueTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ObjToIntMap
implements Serializable {
    static final long serialVersionUID = -1542220580748809402L;
    private static final int A = -1640531527;
    private static final Object DELETED = new Object();
    private transient Object[] keys;
    private transient int[] values;
    private int power;
    private int keyCount;
    private transient int occupiedCount;
    private static final boolean check = false;

    public ObjToIntMap() {
        this(4);
    }

    public ObjToIntMap(int n) {
        if (n < 0) {
            Kit.codeBug();
        }
        int n2 = n * 4 / 3;
        int n3 = 2;
        while (1 << n3 < n2) {
            ++n3;
        }
        this.power = n3;
    }

    public boolean isEmpty() {
        return this.keyCount == 0;
    }

    public int size() {
        return this.keyCount;
    }

    public boolean has(Object object) {
        if (object == null) {
            object = UniqueTag.NULL_VALUE;
        }
        return 0 <= this.findIndex(object);
    }

    public int get(Object object, int n) {
        int n2;
        if (object == null) {
            object = UniqueTag.NULL_VALUE;
        }
        if (0 <= (n2 = this.findIndex(object))) {
            return this.values[n2];
        }
        return n;
    }

    public int getExisting(Object object) {
        int n;
        if (object == null) {
            object = UniqueTag.NULL_VALUE;
        }
        if (0 <= (n = this.findIndex(object))) {
            return this.values[n];
        }
        Kit.codeBug();
        return 0;
    }

    public void put(Object object, int n) {
        if (object == null) {
            object = UniqueTag.NULL_VALUE;
        }
        int n2 = this.ensureIndex(object);
        this.values[n2] = n;
    }

    public Object intern(Object object) {
        boolean bl = false;
        if (object == null) {
            bl = true;
            object = UniqueTag.NULL_VALUE;
        }
        int n = this.ensureIndex(object);
        this.values[n] = 0;
        return bl ? null : this.keys[n];
    }

    public void remove(Object object) {
        int n;
        if (object == null) {
            object = UniqueTag.NULL_VALUE;
        }
        if (0 <= (n = this.findIndex(object))) {
            this.keys[n] = DELETED;
            --this.keyCount;
        }
    }

    public void clear() {
        int n = this.keys.length;
        while (n != 0) {
            this.keys[--n] = null;
        }
        this.keyCount = 0;
        this.occupiedCount = 0;
    }

    public Iterator newIterator() {
        return new Iterator(this);
    }

    final void initIterator(Iterator iterator) {
        iterator.init(this.keys, this.values, this.keyCount);
    }

    public Object[] getKeys() {
        Object[] objectArray = new Object[this.keyCount];
        this.getKeys(objectArray, 0);
        return objectArray;
    }

    public void getKeys(Object[] objectArray, int n) {
        int n2 = this.keyCount;
        int n3 = 0;
        while (n2 != 0) {
            Object object = this.keys[n3];
            if (object != null && object != DELETED) {
                if (object == UniqueTag.NULL_VALUE) {
                    object = null;
                }
                objectArray[n] = object;
                ++n;
                --n2;
            }
            ++n3;
        }
    }

    private static int tableLookupStep(int n, int n2, int n3) {
        int n4 = 32 - 2 * n3;
        if (n4 >= 0) {
            return n >>> n4 & n2 | 1;
        }
        return n & n2 >>> -n4 | 1;
    }

    private int findIndex(Object object) {
        int n;
        int n2;
        int n3;
        Object object2;
        if (this.keys != null && (object2 = this.keys[n3 = (n2 = (n = object.hashCode()) * -1640531527) >>> 32 - this.power]) != null) {
            int n4 = 1 << this.power;
            if (object2 == object || this.values[n4 + n3] == n && object2.equals(object)) {
                return n3;
            }
            int n5 = n4 - 1;
            int n6 = ObjToIntMap.tableLookupStep(n2, n5, this.power);
            boolean bl = false;
            while ((object2 = this.keys[n3 = n3 + n6 & n5]) != null) {
                if (object2 != object && (this.values[n4 + n3] != n || !object2.equals(object))) continue;
                return n3;
            }
        }
        return -1;
    }

    private int insertNewKey(Object object, int n) {
        int n2 = n * -1640531527;
        int n3 = n2 >>> 32 - this.power;
        int n4 = 1 << this.power;
        if (this.keys[n3] != null) {
            int n5 = n4 - 1;
            int n6 = ObjToIntMap.tableLookupStep(n2, n5, this.power);
            int n7 = n3;
            while (this.keys[n3 = n3 + n6 & n5] != null) {
            }
        }
        this.keys[n3] = object;
        this.values[n4 + n3] = n;
        ++this.occupiedCount;
        ++this.keyCount;
        return n3;
    }

    private void rehashTable() {
        if (this.keys == null) {
            int n = 1 << this.power;
            this.keys = new Object[n];
            this.values = new int[2 * n];
        } else {
            if (this.keyCount * 2 >= this.occupiedCount) {
                ++this.power;
            }
            int n = 1 << this.power;
            Object[] objectArray = this.keys;
            int[] nArray = this.values;
            int n2 = objectArray.length;
            this.keys = new Object[n];
            this.values = new int[2 * n];
            int n3 = this.keyCount;
            this.keyCount = 0;
            this.occupiedCount = 0;
            int n4 = 0;
            while (n3 != 0) {
                Object object = objectArray[n4];
                if (object != null && object != DELETED) {
                    int n5 = nArray[n2 + n4];
                    int n6 = this.insertNewKey(object, n5);
                    this.values[n6] = nArray[n4];
                    --n3;
                }
                ++n4;
            }
        }
    }

    private int ensureIndex(Object object) {
        int n;
        Object object2;
        int n2 = object.hashCode();
        int n3 = -1;
        int n4 = -1;
        if (this.keys != null && (object2 = this.keys[n3 = (n = n2 * -1640531527) >>> 32 - this.power]) != null) {
            int n5 = 1 << this.power;
            if (object2 == object || this.values[n5 + n3] == n2 && object2.equals(object)) {
                return n3;
            }
            if (object2 == DELETED) {
                n4 = n3;
            }
            int n6 = n5 - 1;
            int n7 = ObjToIntMap.tableLookupStep(n, n6, this.power);
            boolean bl = false;
            while ((object2 = this.keys[n3 = n3 + n7 & n6]) != null) {
                if (object2 == object || this.values[n5 + n3] == n2 && object2.equals(object)) {
                    return n3;
                }
                if (object2 != DELETED || n4 >= 0) continue;
                n4 = n3;
            }
        }
        if (n4 >= 0) {
            n3 = n4;
        } else {
            if (this.keys == null || this.occupiedCount * 4 >= (1 << this.power) * 3) {
                this.rehashTable();
                return this.insertNewKey(object, n2);
            }
            ++this.occupiedCount;
        }
        this.keys[n3] = object;
        this.values[(1 << this.power) + n3] = n2;
        ++this.keyCount;
        return n3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.keyCount;
        int n2 = 0;
        while (n != 0) {
            Object object = this.keys[n2];
            if (object != null && object != DELETED) {
                --n;
                objectOutputStream.writeObject(object);
                objectOutputStream.writeInt(this.values[n2]);
            }
            ++n2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.keyCount;
        if (n != 0) {
            this.keyCount = 0;
            int n2 = 1 << this.power;
            this.keys = new Object[n2];
            this.values = new int[2 * n2];
            for (int i = 0; i != n; ++i) {
                Object object = objectInputStream.readObject();
                int n3 = object.hashCode();
                int n4 = this.insertNewKey(object, n3);
                this.values[n4] = objectInputStream.readInt();
            }
        }
    }

    public static class Iterator {
        ObjToIntMap master;
        private int cursor;
        private int remaining;
        private Object[] keys;
        private int[] values;

        Iterator(ObjToIntMap objToIntMap) {
            this.master = objToIntMap;
        }

        final void init(Object[] objectArray, int[] nArray, int n) {
            this.keys = objectArray;
            this.values = nArray;
            this.cursor = -1;
            this.remaining = n;
        }

        public void start() {
            this.master.initIterator(this);
            this.next();
        }

        public boolean done() {
            return this.remaining < 0;
        }

        public void next() {
            if (this.remaining == -1) {
                Kit.codeBug();
            }
            if (this.remaining == 0) {
                this.remaining = -1;
                this.cursor = -1;
            } else {
                ++this.cursor;
                while (true) {
                    Object object;
                    if ((object = this.keys[this.cursor]) != null && object != DELETED) {
                        --this.remaining;
                        break;
                    }
                    ++this.cursor;
                }
            }
        }

        public Object getKey() {
            Object object = this.keys[this.cursor];
            if (object == UniqueTag.NULL_VALUE) {
                object = null;
            }
            return object;
        }

        public int getValue() {
            return this.values[this.cursor];
        }

        public void setValue(int n) {
            this.values[this.cursor] = n;
        }
    }
}

