/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.deps.JsFileLineParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsFunctionParser
extends JsFileLineParser {
    private static Logger logger = Logger.getLogger(JsFunctionParser.class.getName());
    private Pattern pattern;
    private Matcher matcher;
    private Collection<SymbolInfo> symbols;
    private Collection<String> functionsToParse;

    public JsFunctionParser(Collection<String> collection, ErrorManager errorManager) {
        super(errorManager);
        this.functionsToParse = collection;
        this.pattern = this.getPattern(collection);
        this.matcher = this.pattern.matcher("");
    }

    private Pattern getPattern(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder("(?:^|;)\\s*(");
        for (String string : collection) {
            stringBuilder.append(Pattern.quote(string) + "|");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(")\\s*\\((.*?)\\)");
        return Pattern.compile(stringBuilder.toString());
    }

    public Collection<SymbolInfo> parseFile(String string, String string2) {
        return this.parseReader(string, new StringReader(string2));
    }

    private Collection<SymbolInfo> parseReader(String string, Reader reader) {
        this.symbols = Lists.newArrayList();
        logger.fine("Parsing Source: " + string);
        this.doParse(string, reader);
        return this.symbols;
    }

    @Override
    protected boolean parseLine(String string) throws JsFileLineParser.ParseException {
        boolean bl = false;
        boolean bl2 = false;
        for (String string2 : this.functionsToParse) {
            if (string.indexOf(string2) == -1) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            this.matcher.reset(string);
            while (this.matcher.find()) {
                String string2;
                bl = true;
                String string3 = this.matcher.group(1);
                string2 = this.parseJsString(this.matcher.group(2));
                this.symbols.add(new SymbolInfo(string3, string2));
            }
        }
        return !this.shortcutMode || bl || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)string);
    }

    public static class SymbolInfo {
        public final String functionName;
        public final String symbol;

        private SymbolInfo(String string, String string2) {
            this.functionName = string;
            this.symbol = string2;
        }
    }
}

