/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileLineParser;
import com.google.javascript.jscomp.deps.SimpleDependencyInfo;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DepsFileParser
extends JsFileLineParser {
    private static Logger logger = Logger.getLogger(DepsFileParser.class.getName());
    private final Matcher depMatcher = Pattern.compile("\\s*goog.addDependency\\((.*)\\);?\\s*").matcher("");
    private final Matcher depArgsMatch = Pattern.compile("\\s*([^,]*), (\\[[^\\]]*\\]), (\\[[^\\]]*\\])\\s*").matcher("");
    private List<DependencyInfo> depInfos;

    public DepsFileParser(ErrorManager errorManager) {
        super(errorManager);
    }

    public List<DependencyInfo> parseFile(String string) throws IOException {
        return this.parseFileReader(string, new FileReader(string));
    }

    public List<DependencyInfo> parseFile(String string, String string2) {
        return this.parseFileReader(string, new StringReader(string2));
    }

    public List<DependencyInfo> parseFileReader(String string, Reader reader) {
        this.depInfos = Lists.newArrayList();
        logger.info("Parsing Dep: " + string);
        this.doParse(string, reader);
        return this.depInfos;
    }

    @Override
    protected boolean parseLine(String string) throws JsFileLineParser.ParseException {
        boolean bl = false;
        if (string.indexOf("addDependency") != -1) {
            this.depMatcher.reset(string);
            if (this.depMatcher.matches()) {
                bl = true;
                String string2 = this.depMatcher.group(1);
                this.depArgsMatch.reset(string2);
                if (!this.depArgsMatch.matches()) {
                    throw new JsFileLineParser.ParseException("Invalid arguments to goog.addDependency(). Found: " + string2, true);
                }
                String string3 = this.parseJsString(this.depArgsMatch.group(1));
                SimpleDependencyInfo simpleDependencyInfo = new SimpleDependencyInfo(string3, this.filePath, this.parseJsStringArray(this.depArgsMatch.group(2)), this.parseJsStringArray(this.depArgsMatch.group(3)));
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Found dep: " + simpleDependencyInfo);
                }
                this.depInfos.add(simpleDependencyInfo);
            }
        }
        return !this.shortcutMode || bl || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)string);
    }
}

