/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Map;

class VariableVisibilityAnalysis
implements CompilerPass {
    private AbstractCompiler compiler;
    private Map<Node, VariableVisibility> visibilityByDeclaringNameNode;

    public VariableVisibilityAnalysis(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.visibilityByDeclaringNameNode = Maps.newHashMap();
    }

    public VariableVisibility getVariableVisibility(Node node) {
        Node node2 = node.getParent();
        Preconditions.checkArgument((NodeUtil.isVar(node2) || NodeUtil.isFunction(node2) || node2.getType() == 83 ? 1 : 0) != 0);
        return this.visibilityByDeclaringNameNode.get(node);
    }

    @Override
    public void process(Node node, Node node2) {
        ReferenceCollectingCallback referenceCollectingCallback = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR);
        NodeTraversal.traverse(this.compiler, node2, referenceCollectingCallback);
        for (Scope.Var var : referenceCollectingCallback.getReferencedVariables()) {
            VariableVisibility variableVisibility;
            ReferenceCollectingCallback.ReferenceCollection referenceCollection = referenceCollectingCallback.getReferenceCollection(var);
            if (VariableVisibilityAnalysis.variableIsParameter(var)) {
                variableVisibility = VariableVisibility.PARAMETER;
            } else if (var.isLocal()) {
                variableVisibility = referenceCollection.isEscaped() ? VariableVisibility.CAPTURED_LOCAL : VariableVisibility.LOCAL;
            } else if (var.isGlobal()) {
                variableVisibility = VariableVisibility.GLOBAL;
            } else {
                throw new IllegalStateException("Un-handled variable visibility for " + var);
            }
            this.visibilityByDeclaringNameNode.put(var.getNameNode(), variableVisibility);
        }
    }

    private static boolean variableIsParameter(Scope.Var var) {
        Node node = var.getParentNode();
        return node != null && node.getType() == 83;
    }

    static enum VariableVisibility {
        LOCAL,
        CAPTURED_LOCAL,
        PARAMETER,
        GLOBAL;

    }
}

