/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class VariableReferenceCheck
implements CompilerPass {
    static final DiagnosticType UNDECLARED_REFERENCE = DiagnosticType.warning("JSC_REFERENCE_BEFORE_DECLARE", "Variable referenced before declaration: {0}");
    static final DiagnosticType REDECLARED_VARIABLE = DiagnosticType.warning("JSC_REDECLARED_VARIABLE", "Redeclared variable: {0}");
    static final DiagnosticType AMBIGUOUS_FUNCTION_DECL = DiagnosticType.disabled("AMBIGUOUS_FUNCTION_DECL", "Ambiguous use of a named function: {0}.");
    private AbstractCompiler compiler;
    private CheckLevel checkLevel;
    private Set<ReferenceCollectingCallback.BasicBlock> blocksWithDeclarations = Sets.newHashSet();

    public VariableReferenceCheck(AbstractCompiler abstractCompiler, CheckLevel checkLevel) {
        this.compiler = abstractCompiler;
        this.checkLevel = checkLevel;
    }

    @Override
    public void process(Node node, Node node2) {
        ReferenceCollectingCallback referenceCollectingCallback = new ReferenceCollectingCallback(this.compiler, new ReferenceCheckingBehavior());
        referenceCollectingCallback.process(node, node2);
    }

    private class ReferenceCheckingBehavior
    implements ReferenceCollectingCallback.Behavior {
        private ReferenceCheckingBehavior() {
        }

        @Override
        public void afterExitScope(NodeTraversal nodeTraversal, Map<Scope.Var, ReferenceCollectingCallback.ReferenceCollection> map) {
            Iterator<Scope.Var> iterator = nodeTraversal.getScope().getVars();
            while (iterator.hasNext()) {
                Scope.Var var = iterator.next();
                this.checkVar(nodeTraversal, var, map.get((Object)var).references);
            }
        }

        private void checkVar(NodeTraversal nodeTraversal, Scope.Var var, List<ReferenceCollectingCallback.Reference> list) {
            VariableReferenceCheck.this.blocksWithDeclarations.clear();
            boolean bl = false;
            boolean bl2 = false;
            ReferenceCollectingCallback.Reference reference = null;
            for (ReferenceCollectingCallback.Reference reference2 : list) {
                if (reference2.isHoistedFunction()) {
                    VariableReferenceCheck.this.blocksWithDeclarations.add(reference2.getBasicBlock());
                    bl = true;
                    reference = reference2;
                    break;
                }
                if (!NodeUtil.isFunctionDeclaration(reference2.getNameNode().getParent())) continue;
                bl2 = true;
            }
            for (ReferenceCollectingCallback.Reference reference2 : list) {
                if (reference2 == reference) continue;
                ReferenceCollectingCallback.BasicBlock basicBlock = reference2.getBasicBlock();
                boolean bl3 = reference2.isDeclaration();
                if (bl3) {
                    for (ReferenceCollectingCallback.BasicBlock basicBlock2 : VariableReferenceCheck.this.blocksWithDeclarations) {
                        if (!basicBlock2.provablyExecutesBefore(basicBlock)) continue;
                        VariableReferenceCheck.this.compiler.report(JSError.make(reference2.getSourceName(), reference2.getNameNode(), VariableReferenceCheck.this.checkLevel, REDECLARED_VARIABLE, var.name));
                        break;
                    }
                }
                if (bl2 && !bl3 && bl) {
                    for (ReferenceCollectingCallback.BasicBlock basicBlock2 : VariableReferenceCheck.this.blocksWithDeclarations) {
                        if (basicBlock2.provablyExecutesBefore(basicBlock)) continue;
                        VariableReferenceCheck.this.compiler.report(JSError.make(reference2.getSourceName(), reference2.getNameNode(), AMBIGUOUS_FUNCTION_DECL, var.name));
                        break;
                    }
                }
                if (!bl3 && !bl) {
                    Node node = reference2.getGrandparent();
                    if (node.getType() == 38 && node.getString() == var.name) continue;
                    if (reference2.getScope() == var.scope) {
                        VariableReferenceCheck.this.compiler.report(JSError.make(reference2.getSourceName(), reference2.getNameNode(), VariableReferenceCheck.this.checkLevel, UNDECLARED_REFERENCE, var.name));
                    }
                }
                if (!bl3) continue;
                VariableReferenceCheck.this.blocksWithDeclarations.add(basicBlock);
                bl = true;
            }
        }
    }
}

