/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;

class StrictModeCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType UNKNOWN_VARIABLE = DiagnosticType.error("JSC_UNKNOWN_VARIABLE", "unknown variable {0}");
    static final DiagnosticType WITH_DISALLOWED = DiagnosticType.error("JSC_WITH_DISALLOWED", "\"with\" cannot be used in ES5 strict mode");
    static final DiagnosticType EVAL_USE = DiagnosticType.error("JSC_EVAL_USE", "\"eval\" cannot be used in Caja");
    static final DiagnosticType EVAL_DECLARATION = DiagnosticType.error("JSC_EVAL_DECLARATION", "\"eval\" cannot be redeclared in ES5 strict mode");
    static final DiagnosticType EVAL_ASSIGNMENT = DiagnosticType.error("JSC_EVAL_ASSIGNMENT", "the \"eval\" object cannot be reassigned in ES5 strict mode");
    static final DiagnosticType ARGUMENTS_DECLARATION = DiagnosticType.error("JSC_ARGUMENTS_DECLARATION", "\"arguments\" cannot be redeclared in ES5 strict mode");
    static final DiagnosticType ARGUMENTS_ASSIGNMENT = DiagnosticType.error("JSC_ARGUMENTS_ASSIGNMENT", "the \"arguments\" object cannot be reassigned in ES5 strict mode");
    static final DiagnosticType DELETE_VARIABLE = DiagnosticType.error("JSC_DELETE_VARIABLE", "variables, functions, and arguments cannot be deleted in ES5 strict mode");
    static final DiagnosticType ILLEGAL_NAME = DiagnosticType.error("JSC_ILLEGAL_NAME", "identifiers ending in '__' cannot be used in Caja");
    private final AbstractCompiler compiler;
    private final boolean noVarCheck;
    private final boolean noCajaChecks;

    StrictModeCheck(AbstractCompiler abstractCompiler) {
        this(abstractCompiler, false, false);
    }

    StrictModeCheck(AbstractCompiler abstractCompiler, boolean bl, boolean bl2) {
        this.compiler = abstractCompiler;
        this.noVarCheck = bl;
        this.noCajaChecks = bl2;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList((Object[])new Node[]{node, node2}), this);
        NodeTraversal.traverse(this.compiler, node2, new NonExternChecks());
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (node.getType() == 119) {
            nodeTraversal.report(node, WITH_DISALLOWED, new String[0]);
        } else if (node.getType() == 38) {
            if (!StrictModeCheck.isDeclaration(node)) {
                this.checkNameUse(nodeTraversal, node);
            }
        } else if (node.getType() == 86) {
            this.checkAssignment(nodeTraversal, node);
        } else if (node.getType() == 31) {
            this.checkDelete(nodeTraversal, node);
        } else if (node.getType() == 64) {
            this.checkObjectLiteral(nodeTraversal, node);
        } else if (node.getType() == 126) {
            this.checkLabel(nodeTraversal, node);
        }
    }

    private static boolean isDeclaration(Node node) {
        switch (node.getParent().getType()) {
            case 105: 
            case 118: 
            case 120: {
                return true;
            }
            case 83: {
                return node.getParent().getParent().getType() == 105;
            }
        }
        return false;
    }

    private void checkNameUse(NodeTraversal nodeTraversal, Node node) {
        Scope.Var var = nodeTraversal.getScope().getVar(node.getString());
        if (var == null && !this.noVarCheck) {
            nodeTraversal.report(node, UNKNOWN_VARIABLE, node.getString());
        }
        if (!this.noCajaChecks) {
            if ("eval".equals(node.getString())) {
                nodeTraversal.report(node, EVAL_USE, new String[0]);
            } else if (node.getString().endsWith("__")) {
                nodeTraversal.report(node, ILLEGAL_NAME, new String[0]);
            }
        }
    }

    private void checkAssignment(NodeTraversal nodeTraversal, Node node) {
        if (node.getFirstChild().getType() == 38) {
            if ("arguments".equals(node.getFirstChild().getString())) {
                nodeTraversal.report(node, ARGUMENTS_ASSIGNMENT, new String[0]);
            } else if ("eval".equals(node.getFirstChild().getString()) && this.noCajaChecks) {
                nodeTraversal.report(node, EVAL_ASSIGNMENT, new String[0]);
            }
        }
    }

    private void checkDelete(NodeTraversal nodeTraversal, Node node) {
        Scope.Var var;
        if (node.getFirstChild().getType() == 38 && (var = nodeTraversal.getScope().getVar(node.getFirstChild().getString())) != null) {
            nodeTraversal.report(node, DELETE_VARIABLE, new String[0]);
        }
    }

    private void checkObjectLiteral(NodeTraversal nodeTraversal, Node node) {
        if (!this.noCajaChecks) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                if (node2.getType() == 39 || !node2.getString().endsWith("__")) continue;
                nodeTraversal.report(node2, ILLEGAL_NAME, new String[0]);
            }
        }
    }

    private void checkLabel(NodeTraversal nodeTraversal, Node node) {
        if (node.getFirstChild().getString().endsWith("__") && !this.noCajaChecks) {
            nodeTraversal.report(node.getFirstChild(), ILLEGAL_NAME, new String[0]);
        }
    }

    private class NonExternChecks
    extends NodeTraversal.AbstractPostOrderCallback {
        private NonExternChecks() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 38 && StrictModeCheck.isDeclaration(node)) {
                this.checkDeclaration(nodeTraversal, node);
            } else if (node.getType() == 33) {
                this.checkProperty(nodeTraversal, node);
            }
        }

        private void checkDeclaration(NodeTraversal nodeTraversal, Node node) {
            if ("eval".equals(node.getString())) {
                nodeTraversal.report(node, EVAL_DECLARATION, new String[0]);
            } else if ("arguments".equals(node.getString())) {
                nodeTraversal.report(node, ARGUMENTS_DECLARATION, new String[0]);
            } else if (node.getString().endsWith("__") && !StrictModeCheck.this.noCajaChecks) {
                nodeTraversal.report(node, ILLEGAL_NAME, new String[0]);
            }
        }

        private void checkProperty(NodeTraversal nodeTraversal, Node node) {
            if (node.getLastChild().getString().endsWith("__") && !StrictModeCheck.this.noCajaChecks) {
                nodeTraversal.report(node.getLastChild(), ILLEGAL_NAME, new String[0]);
            }
        }
    }
}

