/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.SimpleFunctionAliasAnalysis;
import com.google.javascript.jscomp.SpecializationAwareCompilerPass;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

class SpecializeModule
implements CompilerPass {
    private AbstractCompiler compiler;
    private Map<Node, Node> specializedInputRootsByOriginal;
    private Map<Node, OriginalFunctionInformation> functionInfoBySpecializedFunctionNode;
    private SpecializationState specializationState;
    private final PassFactory[] specializationPassFactories;

    public SpecializeModule(AbstractCompiler abstractCompiler, PassFactory ... passFactoryArray) {
        this.compiler = abstractCompiler;
        this.specializationPassFactories = passFactoryArray;
    }

    @Override
    public void process(Node node, Node node2) {
        JSModuleGraph jSModuleGraph = this.compiler.getModuleGraph();
        if (jSModuleGraph == null) {
            return;
        }
        JSModule jSModule = jSModuleGraph.getRootModule();
        Node node3 = this.copyModuleInputs(jSModule);
        SimpleDefinitionFinder simpleDefinitionFinder = new SimpleDefinitionFinder(this.compiler);
        simpleDefinitionFinder.process(node, node3);
        SimpleFunctionAliasAnalysis simpleFunctionAliasAnalysis = new SimpleFunctionAliasAnalysis();
        simpleFunctionAliasAnalysis.analyze(simpleDefinitionFinder);
        this.specializationState = new SpecializationState(simpleFunctionAliasAnalysis);
        do {
            this.specializationState.resetHasChanged();
            for (SpecializationAwareCompilerPass specializationAwareCompilerPass : this.createSpecializingPasses()) {
                specializationAwareCompilerPass.enableSpecialization(this.specializationState);
                specializationAwareCompilerPass.process(node, node3);
            }
        } while (this.specializationState.hasChanged());
        this.addDummyVarDeclarationsToInitialModule(jSModule);
        this.replaceOriginalModuleInputsWithSpecialized();
        this.addOriginalFunctionVersionsToDependentModules(jSModule);
    }

    private Collection<SpecializationAwareCompilerPass> createSpecializingPasses() {
        LinkedList linkedList = Lists.newLinkedList();
        for (PassFactory passFactory : this.specializationPassFactories) {
            CompilerPass compilerPass = passFactory.createInternal(this.compiler);
            Preconditions.checkState((boolean)(compilerPass instanceof SpecializationAwareCompilerPass));
            linkedList.add((SpecializationAwareCompilerPass)compilerPass);
        }
        return linkedList;
    }

    private Node copyModuleInputs(JSModule jSModule) {
        this.specializedInputRootsByOriginal = Maps.newLinkedHashMap();
        this.functionInfoBySpecializedFunctionNode = Maps.newLinkedHashMap();
        Node node = new Node(125);
        node.setIsSyntheticBlock(true);
        for (CompilerInput compilerInput : jSModule.getInputs()) {
            Node node2 = compilerInput.getAstRoot(this.compiler);
            Node node3 = node2.cloneTree();
            node3.copyInformationFromForTree(node2);
            this.specializedInputRootsByOriginal.put(node2, node3);
            this.matchTopLevelFunctions(node2, node3);
            node.addChildToBack(node3);
        }
        Node node4 = new Node(125);
        node4.addChildToBack(node);
        return node;
    }

    private void matchTopLevelFunctions(Node node, Node node2) {
        new NodeMatcher(){

            @Override
            public void reportMatch(Node node, Node node2) {
                if (NodeUtil.isFunction(node)) {
                    OriginalFunctionInformation originalFunctionInformation = new OriginalFunctionInformation(node);
                    SpecializeModule.this.functionInfoBySpecializedFunctionNode.put(node2, originalFunctionInformation);
                }
            }

            @Override
            public boolean shouldTraverse(Node node, Node node2) {
                return !NodeUtil.isFunction(node);
            }
        }.match(node, node2);
    }

    private void replaceOriginalModuleInputsWithSpecialized() {
        for (Node node : this.specializedInputRootsByOriginal.keySet()) {
            Node node2 = this.specializedInputRootsByOriginal.get(node);
            node.removeChildren();
            LinkedList linkedList = Lists.newLinkedList();
            while (node2.getFirstChild() != null) {
                node.addChildToBack(node2.removeFirstChild());
            }
        }
    }

    private void addDummyVarDeclarationsToInitialModule(JSModule jSModule) {
        for (Node node : this.functionInfoBySpecializedFunctionNode.keySet()) {
            Node node2;
            OriginalFunctionInformation originalFunctionInformation;
            if (!this.specializationState.getRemovedFunctions().contains(node) || (originalFunctionInformation = this.functionInfoBySpecializedFunctionNode.get(node)).name == null || !originalFunctionInformation.originalWasDeclaration() || (node2 = (Node)this.specializationState.removedFunctionToBlock.get(node)) == null) continue;
            Node node3 = this.specializedInputRootsByOriginal.get(node2);
            node2.addChildrenToBack(originalFunctionInformation.generateDummyDeclaration());
        }
    }

    private void addOriginalFunctionVersionsToDependentModules(JSModule jSModule) {
        for (JSModule jSModule2 : this.getDirectDependents(jSModule)) {
            CompilerInput compilerInput = jSModule2.getInputs().get(0);
            Node node = compilerInput.getAstRoot(this.compiler);
            ArrayList arrayList = Lists.newArrayList(this.functionInfoBySpecializedFunctionNode.keySet());
            Collections.reverse(arrayList);
            for (Node node2 : arrayList) {
                OriginalFunctionInformation originalFunctionInformation;
                boolean bl = this.specializationState.getSpecializedFunctions().contains(node2);
                boolean bl2 = this.specializationState.getRemovedFunctions().contains(node2);
                if (!bl && !bl2 || (originalFunctionInformation = this.functionInfoBySpecializedFunctionNode.get(node2)).name == null) continue;
                Node node3 = originalFunctionInformation.generateFixupDefinition();
                node.addChildrenToFront(node3);
            }
        }
    }

    public Collection<JSModule> getDirectDependents(JSModule jSModule) {
        HashSet hashSet = Sets.newHashSet();
        for (JSModule jSModule2 : this.compiler.getModuleGraph().getAllModules()) {
            if (!jSModule2.getDependencies().contains(jSModule)) continue;
            hashSet.add(jSModule2);
        }
        return hashSet;
    }

    public static class SpecializationState {
        private Set<Node> specializedFunctions;
        private Set<Node> removedFunctions;
        private Map<Node, Node> removedFunctionToBlock;
        private SimpleFunctionAliasAnalysis initialModuleAliasAnalysis;
        private boolean hasChanged = false;

        public SpecializationState(SimpleFunctionAliasAnalysis simpleFunctionAliasAnalysis) {
            this.initialModuleAliasAnalysis = simpleFunctionAliasAnalysis;
            this.specializedFunctions = Sets.newLinkedHashSet();
            this.removedFunctions = Sets.newLinkedHashSet();
            this.removedFunctionToBlock = Maps.newLinkedHashMap();
        }

        private boolean hasChanged() {
            return this.hasChanged;
        }

        private void resetHasChanged() {
            this.hasChanged = false;
        }

        public Set<Node> getSpecializedFunctions() {
            return this.specializedFunctions;
        }

        public void reportSpecializedFunction(Node node) {
            if (this.specializedFunctions.add(node)) {
                this.hasChanged = true;
            }
        }

        public void reportSpecializedFunctionContainingNode(Node node) {
            Node node2 = this.containingFunction(node);
            if (node2 != null) {
                this.reportSpecializedFunction(node2);
            }
        }

        public Set<Node> getRemovedFunctions() {
            return this.removedFunctions;
        }

        public void reportRemovedFunction(Node node, Node node2) {
            if (this.removedFunctions.add(node)) {
                this.hasChanged = true;
                this.removedFunctionToBlock.put(node, node2);
            }
        }

        public boolean canFixupFunction(Node node) {
            Preconditions.checkArgument((boolean)NodeUtil.isFunction(node));
            if (!this.nodeIsInGlobalScope(node) || this.initialModuleAliasAnalysis.isAliased(node)) {
                return false;
            }
            if (NodeUtil.isStatement(node)) {
                return true;
            }
            Node node2 = node.getParent();
            Node node3 = node2.getParent();
            if (NodeUtil.isName(node2) && NodeUtil.isVar(node3)) {
                return true;
            }
            return NodeUtil.isExprAssign(node3) && node2.getChildAtIndex(1) == node;
        }

        public boolean canFixupSpecializedFunctionContainingNode(Node node) {
            Node node2 = this.containingFunction(node);
            if (node2 != null) {
                return this.canFixupFunction(node2);
            }
            return true;
        }

        private boolean nodeIsInGlobalScope(Node node) {
            return this.containingFunction(node) == null;
        }

        private Node containingFunction(Node node) {
            for (Node node2 : node.getAncestors()) {
                if (!NodeUtil.isFunction(node2)) continue;
                return node2;
            }
            return null;
        }
    }

    private class OriginalFunctionInformation {
        private String name;
        private boolean isAssignFunction;
        private boolean assignHasVar;
        private Node originalFunctionCopy;

        public OriginalFunctionInformation(Node node) {
            this.name = NodeUtil.getFunctionName(node);
            this.originalFunctionCopy = node.cloneTree();
            this.originalFunctionCopy.copyInformationFromForTree(node);
            Node node2 = node.getParent();
            this.isAssignFunction = NodeUtil.isAssign(node2) || NodeUtil.isName(node2);
            this.assignHasVar = this.isAssignFunction && NodeUtil.isVar(node2.getParent());
        }

        private Node copiedOriginalFunction() {
            Node node = this.originalFunctionCopy.cloneTree();
            node.copyInformationFromForTree(this.originalFunctionCopy);
            return node;
        }

        private boolean originalWasDeclaration() {
            return !this.isAssignFunction || this.assignHasVar;
        }

        private Node generateFixupDefinition() {
            Node node;
            Node node2 = this.copiedOriginalFunction();
            if (this.isAssignFunction) {
                node = NodeUtil.newQualifiedNameNode(SpecializeModule.this.compiler.getCodingConvention(), this.name, node2, this.name);
            } else {
                node = node2.getFirstChild();
                node2.replaceChild(node, NodeUtil.newName(SpecializeModule.this.compiler.getCodingConvention(), "", node));
            }
            Node node3 = new Node(86, node, node2);
            node3.copyInformationFrom(node2);
            return NodeUtil.newExpr(node3);
        }

        private Node generateDummyDeclaration() {
            Node node = NodeUtil.newVarNode(this.name, null);
            node.copyInformationFromForTree(this.originalFunctionCopy);
            return node;
        }
    }

    private static abstract class NodeMatcher {
        private NodeMatcher() {
        }

        public void match(Node node, Node node2) {
            this.reportMatch(node, node2);
            if (this.shouldTraverse(node, node2)) {
                Node node3 = node.getFirstChild();
                Node node4 = node2.getFirstChild();
                while (node3 != null) {
                    this.match(node3, node4);
                    node3 = node3.getNext();
                    node4 = node4.getNext();
                }
            }
        }

        public abstract void reportMatch(Node var1, Node var2);

        public boolean shouldTraverse(Node node, Node node2) {
            return true;
        }
    }
}

