/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnalyzePrototypeProperties;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SpecializationAwareCompilerPass;
import com.google.javascript.jscomp.SpecializeModule;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.logging.Logger;

class RemoveUnusedPrototypeProperties
implements SpecializationAwareCompilerPass {
    private static final Logger logger = Logger.getLogger(RemoveUnusedPrototypeProperties.class.getName());
    private final AbstractCompiler compiler;
    private final boolean canModifyExterns;
    private final boolean anchorUnusedVars;
    private SpecializeModule.SpecializationState specializationState;

    RemoveUnusedPrototypeProperties(AbstractCompiler abstractCompiler, boolean bl, boolean bl2) {
        this.compiler = abstractCompiler;
        this.canModifyExterns = bl;
        this.anchorUnusedVars = bl2;
    }

    @Override
    public void enableSpecialization(SpecializeModule.SpecializationState specializationState) {
        this.specializationState = specializationState;
    }

    @Override
    public void process(Node node, Node node2) {
        AnalyzePrototypeProperties analyzePrototypeProperties = new AnalyzePrototypeProperties(this.compiler, null, this.canModifyExterns, this.anchorUnusedVars);
        analyzePrototypeProperties.process(node, node2);
        this.removeUnusedSymbols(analyzePrototypeProperties.getAllNameInfo());
    }

    private void removeUnusedSymbols(Collection<AnalyzePrototypeProperties.NameInfo> collection) {
        boolean bl = false;
        for (AnalyzePrototypeProperties.NameInfo nameInfo : collection) {
            if (nameInfo.isReferenced()) continue;
            for (AnalyzePrototypeProperties.Symbol symbol : nameInfo.getDeclarations()) {
                boolean bl2 = false;
                if (this.specializationState == null) {
                    bl2 = true;
                } else {
                    Node node = this.getSpecializableFunctionFromSymbol(symbol);
                    if (node != null) {
                        this.specializationState.reportRemovedFunction(node, null);
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                symbol.remove();
                bl = true;
            }
            logger.fine("Removed unused prototype property: " + nameInfo.name);
        }
        if (bl) {
            this.compiler.reportCodeChange();
        }
    }

    private Node getSpecializableFunctionFromSymbol(AnalyzePrototypeProperties.Symbol symbol) {
        Preconditions.checkNotNull((Object)this.specializationState);
        Node node = null;
        if (symbol instanceof AnalyzePrototypeProperties.GlobalFunction) {
            node = ((AnalyzePrototypeProperties.GlobalFunction)symbol).getFunctionNode();
        } else if (symbol instanceof AnalyzePrototypeProperties.AssignmentProperty) {
            Node node2 = ((AnalyzePrototypeProperties.AssignmentProperty)symbol).getValue();
            if (NodeUtil.isFunction(node2)) {
                node = node2;
            }
        } else {
            if (symbol instanceof AnalyzePrototypeProperties.LiteralProperty) {
                return null;
            }
            Preconditions.checkState((boolean)false, (Object)"Should be unreachable.");
        }
        if (node != null && this.specializationState.canFixupFunction(node)) {
            return node;
        }
        return null;
    }
}

