/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;

class NodeNameExtractor {
    private final char delimiter;
    private int nextUniqueInt = 0;

    NodeNameExtractor(char c) {
        this.delimiter = c;
    }

    String getName(Node node) {
        switch (node.getType()) {
            case 105: {
                Node node2 = node.getFirstChild();
                return node2.getString();
            }
            case 33: {
                Node node3 = node.getFirstChild();
                Node node4 = node3.getNext();
                String string = this.getName(node3);
                String string2 = this.getName(node4);
                if ("prototype".equals(string2)) {
                    return string + this.delimiter;
                }
                return string + this.delimiter + string2;
            }
            case 35: {
                Node node5 = node.getFirstChild();
                Node node6 = node5.getNext();
                String string = this.getName(node5);
                String string3 = this.getName(node6);
                if ("prototype".equals(string3)) {
                    return string + this.delimiter;
                }
                return string + this.delimiter + string3;
            }
            case 38: {
                return node.getString();
            }
            case 40: {
                return TokenStream.isJSIdentifier(node.getString()) ? node.getString() : "__" + this.nextUniqueInt++;
            }
            case 39: {
                return NodeUtil.getStringValue(node);
            }
            case 42: {
                return "this";
            }
            case 37: {
                return this.getName(node.getFirstChild());
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node7 = node.getFirstChild(); node7 != null; node7 = node7.getNext()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(this.delimiter);
            }
            stringBuilder.append(this.getName(node7));
        }
        return stringBuilder.toString();
    }
}

