/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.common.primitives.Chars;
import com.google.javascript.rhino.TokenStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;

final class NameGenerator {
    static final char[] FIRST_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$".toCharArray();
    static final char[] NONFIRST_CHAR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789$".toCharArray();
    private final Set<String> reservedNames;
    private final String prefix;
    private int nameCount;
    private final char[] firstChars;
    private final char[] nonFirstChars;

    NameGenerator(Set<String> set, String string, @Nullable char[] cArray) {
        this.reservedNames = set;
        this.prefix = string;
        this.firstChars = NameGenerator.reserveCharacters(FIRST_CHAR, cArray);
        this.nonFirstChars = NameGenerator.reserveCharacters(NONFIRST_CHAR, cArray);
        this.checkPrefix(string);
    }

    static char[] reserveCharacters(char[] cArray, char[] cArray2) {
        if (cArray2 == null || cArray2.length == 0) {
            return cArray;
        }
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet((Iterable)Chars.asList((char[])cArray));
        for (char c : cArray2) {
            linkedHashSet.remove(Character.valueOf(c));
        }
        return Chars.toArray((Collection)linkedHashSet);
    }

    private void checkPrefix(String string) {
        if (string.length() > 0) {
            if (!this.contains(this.firstChars, string.charAt(0))) {
                throw new IllegalArgumentException("prefix must start with one of: " + Arrays.toString(this.firstChars));
            }
            for (int i = 1; i < string.length(); ++i) {
                if (this.contains(this.nonFirstChars, string.charAt(i))) continue;
                throw new IllegalArgumentException("prefix has invalid characters, must be one of: " + Arrays.toString(this.nonFirstChars));
            }
        }
    }

    private boolean contains(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            return true;
        }
        return false;
    }

    String generateNextName() {
        String string;
        do {
            int n;
            string = this.prefix;
            int n2 = this.nameCount;
            if (string.isEmpty()) {
                n = n2 % this.firstChars.length;
                string = string + this.firstChars[n];
                n2 /= this.firstChars.length;
            }
            while (n2 > 0) {
                n = --n2 % this.nonFirstChars.length;
                string = string + this.nonFirstChars[n];
                n2 /= this.nonFirstChars.length;
            }
            ++this.nameCount;
        } while (TokenStream.isKeyword(string) || this.reservedNames.contains(string));
        return string;
    }
}

