/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstChangeProxy;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.GatherSideEffectSubexpressionsCallback;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class NameAnalyzer
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Map<String, JsName> allNames = Maps.newTreeMap();
    private DiGraph<JsName, RefType> referenceGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private final Map<Node, NameInformation> scopes = Maps.newHashMap();
    private static final String PROTOTYPE_SUBSTRING = ".prototype.";
    private static final int PROTOTYPE_SUBSTRING_LEN = ".prototype.".length();
    private static final int PROTOTYPE_SUFFIX_LEN = ".prototype".length();
    private static final String WINDOW = "window";
    private static final String FUNCTION = "Function";
    static final Set<String> DEFAULT_GLOBAL_NAMES = ImmutableSet.of((Object)"window", (Object)"goog.global");
    private final boolean removeUnreferenced;
    private final Set<String> globalNames;
    private final AstChangeProxy changeProxy;
    private final Set<String> externalNames = Sets.newHashSet();
    private final List<RefNode> refNodes = Lists.newArrayList();
    private final Map<String, AliasSet> aliases = Maps.newHashMap();

    NameAnalyzer(AbstractCompiler abstractCompiler, boolean bl) {
        this.compiler = abstractCompiler;
        this.removeUnreferenced = bl;
        this.globalNames = DEFAULT_GLOBAL_NAMES;
        this.changeProxy = new AstChangeProxy();
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node, new ProcessExternals());
        NodeTraversal.traverse(this.compiler, node2, new FindDependencyScopes());
        NodeTraversal.traverse(this.compiler, node2, new HoistVariableAndFunctionDeclarations());
        NodeTraversal.traverse(this.compiler, node2, new FindDeclarationsAndSetters());
        NodeTraversal.traverse(this.compiler, node2, new FindReferences());
        this.referenceParentNames();
        this.referenceAliases();
        this.calculateReferences();
        if (this.removeUnreferenced) {
            this.removeUnreferenced();
        }
    }

    private void recordAlias(String string, String string2) {
        this.recordReference(string, string2, RefType.REGULAR);
        AliasSet aliasSet = this.aliases.get(string2);
        AliasSet aliasSet2 = this.aliases.get(string);
        AliasSet aliasSet3 = null;
        if (aliasSet == null && aliasSet2 == null) {
            aliasSet3 = new AliasSet(string2, string);
        } else if (aliasSet != null && aliasSet2 != null) {
            aliasSet3 = aliasSet;
            aliasSet3.names.addAll(aliasSet2.names);
            for (String string3 : aliasSet2.names) {
                this.aliases.put(string3, aliasSet3);
            }
        } else if (aliasSet != null) {
            aliasSet3 = aliasSet;
            aliasSet3.names.add(string);
        } else {
            aliasSet3 = aliasSet2;
            aliasSet3.names.add(string2);
        }
        this.aliases.put(string, aliasSet3);
        this.aliases.put(string2, aliasSet3);
    }

    private void recordReference(String string, String string2, RefType refType) {
        if (string.equals(string2)) {
            return;
        }
        JsName jsName = this.getName(string, true);
        JsName jsName2 = this.getName(string2, true);
        this.referenceGraph.createNode(jsName);
        this.referenceGraph.createNode(jsName2);
        if (!this.referenceGraph.isConnectedInDirection(jsName, refType, jsName2)) {
            this.referenceGraph.connect(jsName, refType, jsName2);
        }
    }

    void removeUnreferenced() {
        RemoveListener removeListener = new RemoveListener();
        this.changeProxy.registerListener(removeListener);
        for (RefNode refNode : this.refNodes) {
            JsName jsName = refNode.name();
            if (jsName.referenced || jsName.externallyDefined) continue;
            refNode.remove();
        }
        this.changeProxy.unregisterListener(removeListener);
    }

    String getHtmlReport() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body><style type=\"text/css\">body, td, p {font-family: Arial; font-size: 83%} ul {margin-top:2px; margin-left:0px; padding-left:1em;} li {margin-top:3px; margin-left:24px; padding-left:0px;padding-bottom: 4px}</style>");
        stringBuilder.append("OVERALL STATS<ul>");
        this.appendListItem(stringBuilder, "Total Names: " + this.countOf(TriState.BOTH, TriState.BOTH));
        this.appendListItem(stringBuilder, "Total Classes: " + this.countOf(TriState.TRUE, TriState.BOTH));
        this.appendListItem(stringBuilder, "Total Static Functions: " + this.countOf(TriState.FALSE, TriState.BOTH));
        this.appendListItem(stringBuilder, "Referenced Names: " + this.countOf(TriState.BOTH, TriState.TRUE));
        this.appendListItem(stringBuilder, "Referenced Classes: " + this.countOf(TriState.TRUE, TriState.TRUE));
        this.appendListItem(stringBuilder, "Referenced Functions: " + this.countOf(TriState.FALSE, TriState.TRUE));
        stringBuilder.append("</ul>");
        stringBuilder.append("ALL NAMES<ul>\n");
        for (JsName jsName : this.allNames.values()) {
            List<DiGraph.DiGraphEdge<JsName, RefType>> list;
            stringBuilder.append("<li>" + this.nameAnchor(jsName.name) + "<ul>");
            if (jsName.prototypeNames.size() > 0) {
                stringBuilder.append("<li>PROTOTYPES: ");
                list = jsName.prototypeNames.iterator();
                while (list.hasNext()) {
                    stringBuilder.append((String)list.next());
                    if (!list.hasNext()) continue;
                    stringBuilder.append(", ");
                }
            }
            if (this.referenceGraph.hasNode(jsName)) {
                Object object;
                list = this.referenceGraph.getOutEdges(jsName);
                if (list.size() > 0) {
                    stringBuilder.append("<li>REFERS TO: ");
                    object = list.iterator();
                    while (object.hasNext()) {
                        stringBuilder.append(this.nameLink(((JsName)((DiGraph.DiGraphEdge)object.next()).getDestination().getValue()).name));
                        if (!object.hasNext()) continue;
                        stringBuilder.append(", ");
                    }
                }
                if ((object = this.referenceGraph.getInEdges(jsName)).size() > 0) {
                    stringBuilder.append("<li>REFERENCED BY: ");
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        stringBuilder.append(this.nameLink(((JsName)((DiGraph.DiGraphEdge)iterator.next()).getDestination().getValue()).name));
                        if (!iterator.hasNext()) continue;
                        stringBuilder.append(", ");
                    }
                }
            }
            stringBuilder.append("</li>");
            stringBuilder.append("</ul></li>");
        }
        stringBuilder.append("</ul>");
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    private void appendListItem(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<li>" + string + "</li>\n");
    }

    private String nameLink(String string) {
        return "<a href=\"#" + string + "\">" + string + "</a>";
    }

    private String nameAnchor(String string) {
        return "<a name=\"" + string + "\">" + string + "</a>";
    }

    private JsName getName(String string, boolean bl) {
        if (bl) {
            this.createName(string);
        }
        return this.allNames.get(string);
    }

    private void createName(String string) {
        JsName jsName = this.allNames.get(string);
        if (jsName == null) {
            jsName = new JsName();
            jsName.name = string;
            this.allNames.put(string, jsName);
        }
    }

    private void referenceAliases() {
        for (Map.Entry<String, AliasSet> entry : this.aliases.entrySet()) {
            JsName jsName = this.getName(entry.getKey(), false);
            if (!jsName.hasWrittenDescendants) continue;
            for (String string : entry.getValue().names) {
                this.recordReference(string, entry.getKey(), RefType.REGULAR);
            }
        }
    }

    private void referenceParentNames() {
        HashSet hashSet = Sets.newHashSet(this.allNames.values());
        for (JsName jsName : hashSet) {
            String string = jsName.name;
            JsName jsName2 = jsName;
            while (string.indexOf(46) != -1) {
                String string2 = string.substring(0, string.lastIndexOf(46));
                if (!this.globalNames.contains(string2)) {
                    JsName jsName3 = this.getName(string2, true);
                    this.recordReference(jsName2.name, jsName3.name, RefType.REGULAR);
                    this.recordReference(jsName3.name, jsName2.name, RefType.REGULAR);
                    jsName2 = jsName3;
                }
                string = string2;
            }
        }
    }

    private NameInformation createNameInformation(NodeTraversal nodeTraversal, Node node, Node node2) {
        Object object;
        String string = "";
        Node node3 = node;
        boolean bl = false;
        while (NodeUtil.isGet(node3)) {
            object = node3.getLastChild();
            if (node3.getType() == 33) {
                string = "." + ((Node)object).getString() + string;
            } else {
                bl = true;
                string = "";
            }
            node3 = node3.getFirstChild();
        }
        if (NodeUtil.isCall(node2) && nodeTraversal.inGlobalScope()) {
            object = this.compiler.getCodingConvention();
            CodingConvention.SubclassRelationship subclassRelationship = object.getClassesDefinedByCall(node2);
            if (subclassRelationship != null) {
                NameInformation nameInformation = new NameInformation();
                nameInformation.name = subclassRelationship.subclassName;
                nameInformation.onlyAffectsClassDef = true;
                nameInformation.superclass = subclassRelationship.superclassName;
                return nameInformation;
            }
            String string2 = object.getSingletonGetterClassName(node2);
            if (string2 != null) {
                NameInformation nameInformation = new NameInformation();
                nameInformation.name = string2;
                nameInformation.onlyAffectsClassDef = true;
                return nameInformation;
            }
        }
        switch (node3.getType()) {
            case 38: {
                if (!bl && node.getType() == 33 && node2.getType() == 86 && "prototype".equals(node.getLastChild().getString())) {
                    if (this.createNameInformation(nodeTraversal, node.getFirstChild(), node) != null) {
                        string = node3.getString() + string;
                        string = string.substring(0, string.length() - PROTOTYPE_SUFFIX_LEN);
                        object = new NameInformation();
                        ((NameInformation)object).name = string;
                        return object;
                    }
                    return null;
                }
                return this.createNameInformation(node3.getString() + string, nodeTraversal.getScope(), node3);
            }
            case 42: {
                if (nodeTraversal.inGlobalScope()) {
                    object = new NameInformation();
                    ((NameInformation)object).name = string.indexOf(46) == 0 ? string.substring(1) : string;
                    ((NameInformation)object).isExternallyReferenceable = true;
                    return object;
                }
                return null;
            }
        }
        return null;
    }

    private NameInformation createNameInformation(String string, Scope scope, Node node) {
        boolean bl;
        String string2 = node.getString();
        Scope.Var var = scope.getVar(string2);
        boolean bl2 = var == null && this.externalNames.contains(string2);
        boolean bl3 = bl = var != null && var.isGlobal() || bl2 || string2.equals(WINDOW);
        if (!bl) {
            return null;
        }
        NameInformation nameInformation = new NameInformation();
        int n = string.indexOf(PROTOTYPE_SUBSTRING);
        if (n != -1) {
            nameInformation.isPrototype = true;
            nameInformation.prototypeClass = string.substring(0, n);
            nameInformation.prototypeProperty = string.substring(n + PROTOTYPE_SUBSTRING_LEN);
        }
        nameInformation.name = string;
        nameInformation.isExternallyReferenceable = bl2 || this.isExternallyReferenceable(scope, string);
        return nameInformation;
    }

    private boolean isExternallyReferenceable(Scope scope, String string) {
        if (this.compiler.getCodingConvention().isExported(string)) {
            return true;
        }
        if (scope.isLocal()) {
            return false;
        }
        for (String string2 : this.globalNames) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private NameInformation getDependencyScope(Node node) {
        for (Node node2 : node.getAncestors()) {
            NameInformation nameInformation = this.scopes.get(node2);
            if (nameInformation == null) continue;
            return nameInformation;
        }
        return null;
    }

    private NameInformation getEnclosingFunctionDependencyScope(NodeTraversal nodeTraversal) {
        Node node = nodeTraversal.getEnclosingFunction();
        if (node == null) {
            return null;
        }
        NameInformation nameInformation = this.scopes.get(node);
        if (nameInformation != null) {
            return nameInformation;
        }
        Node node2 = node.getParent();
        if (node2 != null) {
            Node node3;
            while (node2.getType() == 98) {
                node2 = node2.getParent();
            }
            if (node2.getType() == 38) {
                return this.scopes.get(node2);
            }
            if (node2.getType() == 86 && (node3 = node2.getParent()) != null && node3.getType() == 130) {
                return this.scopes.get(node3);
            }
        }
        return null;
    }

    private void calculateReferences() {
        JsName jsName = this.getName(WINDOW, true);
        jsName.referenced = true;
        JsName jsName2 = this.getName(FUNCTION, true);
        jsName2.referenced = true;
        FixedPointGraphTraversal.newTraversal(new ReferencePropagationCallback()).computeFixedPoint(this.referenceGraph);
    }

    private int countOf(TriState triState, TriState triState2) {
        int n = 0;
        for (JsName jsName : this.allNames.values()) {
            boolean bl;
            boolean bl2 = jsName.prototypeNames.size() > 0;
            boolean bl3 = triState == TriState.BOTH || bl2 && triState == TriState.TRUE || !bl2 && triState == TriState.FALSE;
            boolean bl4 = bl = triState2 == TriState.BOTH || jsName.referenced && triState2 == TriState.TRUE || !jsName.referenced && triState2 == TriState.FALSE;
            if (!bl3 || !bl || jsName.externallyDefined) continue;
            ++n;
        }
        return n;
    }

    private List<Node> getSideEffectNodes(Node node) {
        ArrayList arrayList = Lists.newArrayList();
        NodeTraversal.traverse(this.compiler, node, new GatherSideEffectSubexpressionsCallback(this.compiler, new GatherSideEffectSubexpressionsCallback.CopySideEffectSubexpressions(this.compiler, arrayList)));
        ArrayList arrayList2 = Lists.newArrayListWithExpectedSize((int)arrayList.size());
        for (Node node2 : arrayList) {
            arrayList2.add(NodeUtil.newExpr(node2));
        }
        return arrayList2;
    }

    private void replaceWithRhs(Node node, Node node2) {
        if (this.valueConsumedByParent(node2, node)) {
            List<Node> list = this.getRhsSubexpressions(node2);
            ArrayList arrayList = Lists.newArrayList();
            for (int i = 0; i < list.size() - 1; ++i) {
                arrayList.addAll(this.getSideEffectNodes(list.get(i)));
            }
            Node node3 = list.get(list.size() - 1);
            node3.detachFromParent();
            arrayList.add(node3);
            this.changeProxy.replaceWith(node, node2, this.collapseReplacements(arrayList));
        } else if (node2.getType() == 86 && node.getType() != 115) {
            Node node4 = node2.getLastChild();
            node4.detachFromParent();
            this.changeProxy.replaceWith(node, node2, node4);
        } else {
            this.replaceTopLevelExpressionWithRhs(node, node2);
        }
    }

    private void replaceTopLevelExpressionWithRhs(Node node, Node node2) {
        switch (node.getType()) {
            case 115: 
            case 125: 
            case 126: 
            case 132: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported parent node type in replaceWithRhs " + Token.name(node.getType()));
            }
        }
        switch (node2.getType()) {
            case 105: 
            case 118: 
            case 130: {
                break;
            }
            case 86: {
                Preconditions.checkArgument((node.getType() == 115 ? 1 : 0) != 0, (Object)("Unsupported assignment in replaceWithRhs. parent: " + Token.name(node.getType())));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type in replaceWithRhs " + Token.name(node2.getType()));
            }
        }
        ArrayList arrayList = Lists.newArrayList();
        for (Node node3 : this.getRhsSubexpressions(node2)) {
            arrayList.addAll(this.getSideEffectNodes(node3));
        }
        if (node.getType() == 115) {
            if (arrayList.isEmpty()) {
                arrayList.add(new Node(124));
            } else {
                Node node4 = this.collapseReplacements(arrayList);
                arrayList.clear();
                arrayList.add(node4);
            }
        }
        this.changeProxy.replaceWith(node, node2, arrayList);
    }

    private boolean valueConsumedByParent(Node node, Node node2) {
        if (NodeUtil.isAssignmentOp(node2)) {
            return node2.getLastChild() == node;
        }
        switch (node2.getType()) {
            case 4: 
            case 38: {
                return true;
            }
            case 98: 
            case 100: 
            case 101: {
                return node2.getFirstChild() == node;
            }
            case 115: {
                return node2.getFirstChild().getNext() == node;
            }
            case 108: 
            case 113: {
                return node2.getFirstChild() == node;
            }
            case 114: {
                return node2.getLastChild() == node;
            }
        }
        return false;
    }

    private Node collapseReplacements(List<Node> list) {
        Node node = null;
        for (Node node2 : list) {
            if (node2.getType() == 130) {
                node2 = node2.getFirstChild();
                node2.detachFromParent();
            }
            if (node == null) {
                node = node2;
                continue;
            }
            node = new Node(85, node, node2);
        }
        return node;
    }

    private List<Node> getRhsSubexpressions(Node node) {
        switch (node.getType()) {
            case 130: {
                return this.getRhsSubexpressions(node.getFirstChild());
            }
            case 105: {
                return Collections.emptyList();
            }
            case 38: {
                Node node2 = node.getFirstChild();
                if (node2 != null) {
                    return Lists.newArrayList((Object[])new Node[]{node2});
                }
                return Collections.emptyList();
            }
            case 86: {
                Node node3 = node.getFirstChild();
                Node node4 = node3.getNext();
                return Lists.newArrayList((Object[])new Node[]{node3, node4});
            }
            case 118: {
                ArrayList arrayList = Lists.newArrayList();
                for (Node node5 : node.children()) {
                    arrayList.addAll(this.getRhsSubexpressions(node5));
                }
                return arrayList;
            }
        }
        throw new IllegalArgumentException("AstChangeProxy::getRhs " + node);
    }

    private static enum TriState {
        TRUE,
        FALSE,
        BOTH;

    }

    private class RemoveListener
    implements AstChangeProxy.ChangeListener {
        private RemoveListener() {
        }

        @Override
        public void nodeRemoved(Node node) {
            NameAnalyzer.this.compiler.reportCodeChange();
        }
    }

    private class FindReferences
    implements NodeTraversal.Callback {
        Set<Node> nodesToKeep = Sets.newHashSet();

        FindReferences() {
        }

        private void addAllChildren(Node node) {
            this.nodesToKeep.add(node);
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                this.addAllChildren(node2);
            }
        }

        private void addSimplifiedChildren(Node node) {
            NodeTraversal.traverse(NameAnalyzer.this.compiler, node, new GatherSideEffectSubexpressionsCallback(NameAnalyzer.this.compiler, new NodeAccumulator()));
        }

        private void addSimplifiedExpression(Node node, Node node2) {
            if (node2.getType() == 118) {
                Node node3 = node.getFirstChild();
                if (node3 != null) {
                    this.addSimplifiedChildren(node3);
                }
            } else if (node.getType() == 86 && (node2.getType() == 130 || node2.getType() == 115 || node2.getType() == 4)) {
                for (Node node4 : node.children()) {
                    this.addSimplifiedChildren(node4);
                }
            } else if (node.getType() == 37 && node2.getType() == 130) {
                this.addSimplifiedChildren(node);
            } else {
                this.addAllChildren(node);
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node2 == null) {
                return true;
            }
            if (node.getType() == 115) {
                if (!NodeUtil.isForIn(node)) {
                    Node node3 = node.getFirstChild();
                    Node node4 = node3.getNext();
                    Node node5 = node4.getNext();
                    this.addSimplifiedExpression(node3, node);
                    this.addSimplifiedExpression(node4, node);
                    this.addSimplifiedExpression(node5, node);
                } else {
                    Node node6 = node.getFirstChild();
                    Node node7 = node6.getNext();
                    this.addAllChildren(node6);
                    this.addAllChildren(node7);
                }
            }
            if (node2.getType() == 118 || node2.getType() == 130 || node2.getType() == 4) {
                this.addSimplifiedExpression(node, node2);
            }
            if ((node2.getType() == 108 || node2.getType() == 113 || node2.getType() == 119 || node2.getType() == 110 || node2.getType() == 111) && node2.getFirstChild() == node) {
                this.addAllChildren(node);
            }
            if (node2.getType() == 114 && node2.getLastChild() == node) {
                this.addAllChildren(node);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (!(NodeUtil.isName(node) || NodeUtil.isGet(node) && !NodeUtil.isGetProp(node2))) {
                return;
            }
            NameInformation nameInformation = NameAnalyzer.this.createNameInformation(nodeTraversal, node, node2);
            if (nameInformation == null) {
                return;
            }
            if (nameInformation.onlyAffectsClassDef) {
                String string;
                if (nameInformation.superclass != null) {
                    NameAnalyzer.this.recordReference(nameInformation.name, nameInformation.superclass, RefType.INHERITANCE);
                }
                if ((string = node.getQualifiedName()) != null) {
                    NameAnalyzer.this.recordReference(nameInformation.name, string, RefType.REGULAR);
                }
                return;
            }
            if (node2.getType() == 52 && node2.getLastChild() == node) {
                JsName jsName = NameAnalyzer.this.getName(nameInformation.name, true);
                NameAnalyzer.this.refNodes.add(new InstanceOfCheckNode(jsName, node, node2, node2.getParent()));
                return;
            }
            NameInformation nameInformation2 = NameAnalyzer.this.getDependencyScope(node);
            String string = "";
            if (nameInformation2 != null) {
                string = nameInformation2.isPrototype ? nameInformation2.prototypeClass : nameInformation2.name;
            }
            String string2 = nameInformation.name;
            if (nameInformation.isExternallyReferenceable) {
                NameAnalyzer.this.recordReference(NameAnalyzer.WINDOW, string2, RefType.REGULAR);
                return;
            }
            if (NodeUtil.isLhs(node, node2)) {
                if (nameInformation2 != null) {
                    NameAnalyzer.this.recordReference(string, string2, RefType.REGULAR);
                }
                return;
            }
            if (this.nodesToKeep.contains(node)) {
                NameInformation nameInformation3 = NameAnalyzer.this.getEnclosingFunctionDependencyScope(nodeTraversal);
                if (nameInformation3 != null) {
                    NameAnalyzer.this.recordReference(nameInformation3.name, string2, RefType.REGULAR);
                } else {
                    NameAnalyzer.this.recordReference(NameAnalyzer.WINDOW, string2, RefType.REGULAR);
                }
            } else if (nameInformation2 != null) {
                if ((node2.getType() == 38 || node2.getType() == 86) && NameAnalyzer.this.scopes.get(node2) == nameInformation2) {
                    NameAnalyzer.this.recordAlias(string, string2);
                } else {
                    RefType refType = nameInformation2.onlyAffectsClassDef ? RefType.INHERITANCE : RefType.REGULAR;
                    NameAnalyzer.this.recordReference(string, string2, refType);
                }
            } else {
                for (Node node3 : node.getAncestors()) {
                    if (!NodeUtil.isAssignmentOp(node3) && !NodeUtil.isFunction(node3)) continue;
                    NameAnalyzer.this.recordReference(NameAnalyzer.WINDOW, string2, RefType.REGULAR);
                    break;
                }
            }
        }

        private class NodeAccumulator
        implements GatherSideEffectSubexpressionsCallback.SideEffectAccumulator {
            private NodeAccumulator() {
            }

            @Override
            public boolean classDefiningCallsHaveSideEffects() {
                return false;
            }

            @Override
            public void keepSubTree(Node node) {
                FindReferences.this.addAllChildren(node);
            }

            @Override
            public void keepSimplifiedShortCircuitExpression(Node node) {
                Node node2 = node.getFirstChild();
                Node node3 = node2.getNext();
                FindReferences.this.addAllChildren(node2);
                FindReferences.this.addSimplifiedChildren(node3);
            }

            @Override
            public void keepSimplifiedHookExpression(Node node, boolean bl, boolean bl2) {
                Node node2 = node.getFirstChild();
                Node node3 = node2.getNext();
                Node node4 = node3.getNext();
                FindReferences.this.addAllChildren(node2);
                if (bl) {
                    FindReferences.this.addSimplifiedChildren(node3);
                }
                if (bl2) {
                    FindReferences.this.addSimplifiedChildren(node4);
                }
            }
        }
    }

    private class FindDeclarationsAndSetters
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindDeclarationsAndSetters() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            JsName jsName;
            NameInformation nameInformation;
            Object object;
            if (nodeTraversal.inGlobalScope()) {
                if (NodeUtil.isVarDeclaration(node)) {
                    object = NameAnalyzer.this.createNameInformation(nodeTraversal, node, node2);
                    Preconditions.checkNotNull((Object)object);
                    this.recordSet(((NameInformation)object).name, node);
                } else if (NodeUtil.isFunctionDeclaration(node) && (nameInformation = NameAnalyzer.this.createNameInformation(nodeTraversal, (Node)(object = node.getFirstChild()), node)) != null) {
                    jsName = NameAnalyzer.this.getName(((Node)object).getString(), true);
                    this.recordSet(jsName.name, (Node)object);
                }
            }
            if (node.getType() == 86) {
                object = node.getFirstChild();
                nameInformation = NameAnalyzer.this.createNameInformation(nodeTraversal, (Node)object, node);
                if (nameInformation != null) {
                    if (nameInformation.isPrototype) {
                        this.recordPrototypeSet(nameInformation.prototypeClass, nameInformation.prototypeProperty, node);
                    } else {
                        this.recordSet(nameInformation.name, (Node)object);
                    }
                }
            } else if (node.getType() == 37 && (nameInformation = NameAnalyzer.this.createNameInformation(nodeTraversal, (Node)(object = node.getFirstChild()), node)) != null && nameInformation.onlyAffectsClassDef && (jsName = NameAnalyzer.this.getName(nameInformation.name, false)) != null) {
                NameAnalyzer.this.refNodes.add(new ClassDefiningFunctionNode(jsName, node, node2, node2.getParent()));
            }
        }

        private void recordSet(String string, Node node) {
            JsName jsName = NameAnalyzer.this.getName(string, true);
            JsNameRefNode jsNameRefNode = new JsNameRefNode(jsName, node);
            NameAnalyzer.this.refNodes.add(jsNameRefNode);
            if (node.getType() == 35) {
                this.recordWriteOnProperties(string);
            } else if (string.indexOf(46) != -1) {
                this.recordWriteOnProperties(string.substring(0, string.lastIndexOf(46)));
            }
        }

        private void recordPrototypeSet(String string, String string2, Node node) {
            JsName jsName = NameAnalyzer.this.getName(string, false);
            if (jsName != null) {
                jsName.prototypeNames.add(string2);
                NameAnalyzer.this.refNodes.add(new PrototypeSetNode(jsName, node));
                this.recordWriteOnProperties(string);
            }
        }

        private void recordWriteOnProperties(String string) {
            while (true) {
                JsName jsName = NameAnalyzer.this.getName(string, true);
                if (jsName.hasWrittenDescendants) {
                    return;
                }
                jsName.hasWrittenDescendants = true;
                if (string.indexOf(46) == -1) {
                    return;
                }
                string = string.substring(0, string.lastIndexOf(46));
            }
        }
    }

    private class HoistVariableAndFunctionDeclarations
    extends NodeTraversal.AbstractShallowCallback {
        private HoistVariableAndFunctionDeclarations() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (NodeUtil.isVarDeclaration(node)) {
                NameInformation nameInformation = NameAnalyzer.this.createNameInformation(nodeTraversal, node, node2);
                Preconditions.checkNotNull((Object)nameInformation, (Object)"NameInformation is null");
                NameAnalyzer.this.createName(nameInformation.name);
            } else if (NodeUtil.isFunctionDeclaration(node)) {
                Node node3 = node.getFirstChild();
                NameInformation nameInformation = NameAnalyzer.this.createNameInformation(nodeTraversal, node3, node);
                Preconditions.checkNotNull((Object)nameInformation, (Object)"NameInformation is null");
                NameAnalyzer.this.createName(node3.getString());
            }
        }
    }

    private class FindDependencyScopes
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindDependencyScopes() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            Node node3;
            Node node4;
            NameInformation nameInformation;
            if (!nodeTraversal.inGlobalScope()) {
                return;
            }
            if (node.getType() == 86) {
                Node node5 = node.getFirstChild();
                NameInformation nameInformation2 = NameAnalyzer.this.createNameInformation(nodeTraversal, node5, node);
                if (nameInformation2 != null) {
                    if (node2.getType() == 115 && !NodeUtil.isForIn(node2)) {
                        if (node2.getFirstChild().getNext() != node) {
                            this.recordDepScope(node, nameInformation2);
                        } else {
                            this.recordDepScope(node5, nameInformation2);
                        }
                    } else {
                        this.recordDepScope(node2, nameInformation2);
                    }
                }
            } else if (NodeUtil.isVarDeclaration(node)) {
                NameInformation nameInformation3 = NameAnalyzer.this.createNameInformation(nodeTraversal, node, node2);
                this.recordDepScope(node, nameInformation3);
            } else if (NodeUtil.isFunctionDeclaration(node)) {
                NameInformation nameInformation4 = NameAnalyzer.this.createNameInformation(nodeTraversal, node.getFirstChild(), node);
                this.recordDepScope(node, nameInformation4);
            } else if (NodeUtil.isExprCall(node) && (nameInformation = NameAnalyzer.this.createNameInformation(nodeTraversal, node4 = (node3 = node.getFirstChild()).getFirstChild(), node3)) != null && nameInformation.onlyAffectsClassDef) {
                this.recordDepScope(node, nameInformation);
            }
        }

        private void recordDepScope(Node node, NameInformation nameInformation) {
            NameAnalyzer.this.scopes.put(node, nameInformation);
        }
    }

    private class ProcessExternals
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExternals() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            NameInformation nameInformation = null;
            if (NodeUtil.isVarDeclaration(node)) {
                nameInformation = NameAnalyzer.this.createNameInformation(nodeTraversal, node, node2);
            } else if (NodeUtil.isFunctionDeclaration(node)) {
                nameInformation = NameAnalyzer.this.createNameInformation(nodeTraversal, node.getFirstChild(), node);
            }
            if (nameInformation != null) {
                JsName jsName = NameAnalyzer.this.getName(nameInformation.name, true);
                jsName.externallyDefined = true;
                NameAnalyzer.this.externalNames.add(nameInformation.name);
            }
        }
    }

    private class InstanceOfCheckNode
    extends SpecialReferenceNode {
        InstanceOfCheckNode(JsName jsName, Node node, Node node2, Node node3) {
            super(jsName, node, node2, node3);
            Preconditions.checkState((boolean)node.isQualifiedName());
            Preconditions.checkState((node2.getType() == 52 ? 1 : 0) != 0);
        }

        @Override
        public void remove() {
            NameAnalyzer.this.changeProxy.replaceWith(this.gramps, this.parent, new Node(43));
        }
    }

    private class ClassDefiningFunctionNode
    extends SpecialReferenceNode {
        ClassDefiningFunctionNode(JsName jsName, Node node, Node node2, Node node3) {
            super(jsName, node, node2, node3);
            Preconditions.checkState((node.getType() == 37 ? 1 : 0) != 0);
        }

        @Override
        public void remove() {
            Preconditions.checkState((this.node.getType() == 37 ? 1 : 0) != 0);
            if (NodeUtil.isExpressionNode(this.parent)) {
                NameAnalyzer.this.changeProxy.removeChild(this.gramps, this.parent);
            } else {
                NameAnalyzer.this.changeProxy.replaceWith(this.parent, this.node, new Node(122, Node.newNumber(0.0)));
            }
        }
    }

    private abstract class SpecialReferenceNode
    implements RefNode {
        JsName name;
        Node node;
        Node parent;
        Node gramps;

        SpecialReferenceNode(JsName jsName, Node node, Node node2, Node node3) {
            this.name = jsName;
            this.node = node;
            this.parent = node2;
            this.gramps = node3;
        }

        @Override
        public JsName name() {
            return this.name;
        }
    }

    private class PrototypeSetNode
    extends JsNameRefNode {
        PrototypeSetNode(JsName jsName, Node node) {
            super(jsName, node.getFirstChild());
            Preconditions.checkState((node.getType() == 86 ? 1 : 0) != 0);
        }

        @Override
        public void remove() {
            Node node = this.parent.getParent();
            if (NodeUtil.isExpressionNode(node)) {
                NameAnalyzer.this.changeProxy.removeChild(node.getParent(), node);
            } else {
                NameAnalyzer.this.changeProxy.replaceWith(node, this.parent, this.parent.getLastChild().cloneTree());
            }
        }
    }

    private class JsNameRefNode
    implements RefNode {
        JsName name;
        Node node;
        Node parent;

        JsNameRefNode(JsName jsName, Node node) {
            this.name = jsName;
            this.node = node;
            this.parent = node.getParent();
        }

        @Override
        public JsName name() {
            return this.name;
        }

        @Override
        public void remove() {
            Node node = this.parent.getParent();
            switch (this.parent.getType()) {
                case 118: {
                    Preconditions.checkState((boolean)this.parent.hasOneChild());
                    NameAnalyzer.this.replaceWithRhs(node, this.parent);
                    break;
                }
                case 105: {
                    NameAnalyzer.this.replaceWithRhs(node, this.parent);
                    break;
                }
                case 86: {
                    if (NodeUtil.isExpressionNode(node)) {
                        NameAnalyzer.this.replaceWithRhs(node.getParent(), node);
                        break;
                    }
                    NameAnalyzer.this.replaceWithRhs(node, this.parent);
                }
            }
        }
    }

    static interface RefNode {
        public JsName name();

        public void remove();
    }

    private static class JsName
    implements Comparable<JsName> {
        String name;
        List<String> prototypeNames = Lists.newArrayList();
        boolean externallyDefined = false;
        boolean referenced = false;
        boolean hasWrittenDescendants = false;

        private JsName() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.name);
            if (this.prototypeNames.size() > 0) {
                stringBuilder.append(" (CLASS)\n");
                stringBuilder.append(" - FUNCTIONS: ");
                Iterator<String> iterator = this.prototypeNames.iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append(iterator.next());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public int compareTo(JsName jsName) {
            return this.name.compareTo(jsName.name);
        }
    }

    private static class NameInformation {
        String name;
        boolean isExternallyReferenceable = false;
        boolean isPrototype = false;
        String prototypeClass = null;
        String prototypeProperty = null;
        String superclass = null;
        boolean onlyAffectsClassDef = false;

        private NameInformation() {
        }
    }

    private static class ReferencePropagationCallback
    implements FixedPointGraphTraversal.EdgeCallback<JsName, RefType> {
        private ReferencePropagationCallback() {
        }

        @Override
        public boolean traverseEdge(JsName jsName, RefType refType, JsName jsName2) {
            if (jsName.referenced && !jsName2.referenced) {
                jsName2.referenced = true;
                return true;
            }
            return false;
        }
    }

    private static enum RefType {
        REGULAR,
        INHERITANCE;

    }

    private static class AliasSet {
        Set<String> names = Sets.newHashSet();

        AliasSet(String string, String string2) {
            this.names.add(string);
            this.names.add(string2);
        }
    }
}

