/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorFormat;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MessageFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerErrorManager
extends BasicErrorManager {
    private final MessageFormatter formatter;
    private final Logger logger;

    public LoggerErrorManager(MessageFormatter messageFormatter, Logger logger) {
        this.formatter = messageFormatter;
        this.logger = logger;
    }

    public LoggerErrorManager(Logger logger) {
        this(ErrorFormat.SOURCELESS.toFormatter(null, false), logger);
    }

    @Override
    public void println(CheckLevel checkLevel, JSError jSError) {
        switch (checkLevel) {
            case ERROR: {
                this.logger.severe(jSError.format(checkLevel, this.formatter));
                break;
            }
            case WARNING: {
                this.logger.warning(jSError.format(checkLevel, this.formatter));
            }
        }
    }

    @Override
    protected void printSummary() {
        Level level;
        Level level2 = level = this.getErrorCount() + this.getWarningCount() == 0 ? Level.INFO : Level.WARNING;
        if (this.getTypedPercent() > 0.0) {
            this.logger.log(level, "{0} error(s), {1} warning(s), {2,number,#.#}% typed", new Object[]{this.getErrorCount(), this.getWarningCount(), this.getTypedPercent()});
        } else if (this.getErrorCount() + this.getWarningCount() > 0) {
            this.logger.log(level, "{0} error(s), {1} warning(s)", new Object[]{this.getErrorCount(), this.getWarningCount()});
        }
    }
}

