/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.SortedDependencies;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JSModule
implements DependencyInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    static final DiagnosticType CIRCULAR_DEPENDENCY_ERROR = DiagnosticType.error("JSC_CIRCULAR_DEP", "Circular dependency detected: {0}");
    private final String name;
    private final List<CompilerInput> inputs = new ArrayList<CompilerInput>();
    private final List<JSModule> deps = new ArrayList<JSModule>();
    private int depth;

    public JSModule(String string) {
        this.name = string;
        this.depth = -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getProvides() {
        return ImmutableList.of((Object)this.name);
    }

    public List<String> getRequires() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JSModule jSModule : this.deps) {
            builder.add((Object)jSModule.getName());
        }
        return builder.build();
    }

    @Override
    public String getPathRelativeToClosureBase() {
        throw new UnsupportedOperationException();
    }

    public void add(JSSourceFile jSSourceFile) {
        this.add(new CompilerInput(jSSourceFile));
    }

    public void addFirst(JSSourceFile jSSourceFile) {
        this.addFirst(new CompilerInput(jSSourceFile));
    }

    public void add(CompilerInput compilerInput) {
        this.inputs.add(compilerInput);
        compilerInput.setModule(this);
    }

    public void addFirst(CompilerInput compilerInput) {
        this.inputs.add(0, compilerInput);
        compilerInput.setModule(this);
    }

    public void addAfter(CompilerInput compilerInput, CompilerInput compilerInput2) {
        Preconditions.checkState((boolean)this.inputs.contains(compilerInput2));
        this.inputs.add(this.inputs.indexOf(compilerInput2), compilerInput);
        compilerInput.setModule(this);
    }

    public void addDependency(JSModule jSModule) {
        Preconditions.checkState((jSModule != this ? 1 : 0) != 0);
        this.deps.add(jSModule);
    }

    public void remove(CompilerInput compilerInput) {
        compilerInput.setModule(null);
        this.inputs.remove(compilerInput);
    }

    public void removeAll() {
        for (CompilerInput compilerInput : this.inputs) {
            compilerInput.setModule(null);
        }
        this.inputs.clear();
    }

    public List<JSModule> getDependencies() {
        return this.deps;
    }

    List<String> getSortedDependencyNames() {
        ArrayList arrayList = Lists.newArrayList();
        for (JSModule jSModule : this.getDependencies()) {
            arrayList.add(jSModule.getName());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public Set<JSModule> getAllDependencies() {
        HashSet hashSet = Sets.newHashSet(this.deps);
        ArrayList arrayList = Lists.newArrayList(this.deps);
        while (arrayList.size() > 0) {
            JSModule jSModule = (JSModule)arrayList.remove(arrayList.size() - 1);
            for (JSModule jSModule2 : jSModule.getDependencies()) {
                if (!hashSet.add(jSModule2)) continue;
                arrayList.add(jSModule2);
            }
        }
        return hashSet;
    }

    public Set<JSModule> getThisAndAllDependencies() {
        Set<JSModule> set = this.getAllDependencies();
        set.add(this);
        return set;
    }

    public List<CompilerInput> getInputs() {
        return this.inputs;
    }

    public CompilerInput getByName(String string) {
        for (CompilerInput compilerInput : this.inputs) {
            if (!string.equals(compilerInput.getName())) continue;
            return compilerInput;
        }
        return null;
    }

    public boolean removeByName(String string) {
        boolean bl = false;
        Iterator<CompilerInput> iterator = this.inputs.iterator();
        while (iterator.hasNext()) {
            CompilerInput compilerInput = iterator.next();
            if (!string.equals(compilerInput.getName())) continue;
            iterator.remove();
            compilerInput.setModule(null);
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.name;
    }

    public void clearAsts() {
        for (CompilerInput compilerInput : this.inputs) {
            compilerInput.clearAst();
        }
    }

    public void sortInputsByDeps(Compiler compiler) {
        for (CompilerInput compilerInput : this.inputs) {
            compilerInput.setCompiler(compiler);
        }
        try {
            List<CompilerInput> list = new SortedDependencies<CompilerInput>(Collections.unmodifiableList(this.inputs)).getSortedList();
            this.inputs.clear();
            this.inputs.addAll((Collection<CompilerInput>)list);
        }
        catch (SortedDependencies.CircularDependencyException circularDependencyException) {
            compiler.report(JSError.make(CIRCULAR_DEPENDENCY_ERROR, circularDependencyException.getMessage()));
        }
    }

    public static JSModule[] sortJsModules(Collection<JSModule> collection) throws SortedDependencies.CircularDependencyException {
        List list = new SortedDependencies(Lists.newArrayList(collection)).getSortedList();
        return list.toArray(new JSModule[list.size()]);
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public int getDepth() {
        return this.depth;
    }
}

