/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class FunctionArgumentInjector {
    private FunctionArgumentInjector() {
    }

    static Node inject(Node node, Node node2, Map<String, Node> map) {
        Node node3;
        if (node.getType() == 38 && (node3 = map.get(node.getString())) != null) {
            Preconditions.checkState((node2.getType() != 105 || node2.getType() != 118 || node2.getType() != 120 ? 1 : 0) != 0);
            Node node4 = node3.cloneTree();
            node2.replaceChild(node, node4);
            return node4;
        }
        for (node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
            node3 = FunctionArgumentInjector.inject(node3, node, map);
        }
        return node;
    }

    static LinkedHashMap<String, Node> getFunctionCallParameterMap(Node node, Node node2, Supplier<String> supplier) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        Node node3 = node2.getFirstChild().getNext();
        if (node2.getFirstChild().getType() != 38) {
            if (NodeUtil.isFunctionObjectCall(node2)) {
                Preconditions.checkNotNull((Object)node3);
                Preconditions.checkState((node3.getType() == 42 ? 1 : 0) != 0);
                node3 = node3.getNext();
            } else {
                Preconditions.checkState((!NodeUtil.isFunctionObjectApply(node2) ? 1 : 0) != 0);
            }
        }
        for (Node object : NodeUtil.getFnParameters(node).children()) {
            if (node3 != null) {
                linkedHashMap.put(object.getString(), node3);
                node3 = node3.getNext();
                continue;
            }
            Node node4 = node2;
            linkedHashMap.put(object.getString(), NodeUtil.newUndefinedNode(node4));
        }
        boolean bl = false;
        while (node3 != null) {
            String string = FunctionArgumentInjector.getUniqueAnonymousParameterName(supplier);
            linkedHashMap.put(string, node3);
            node3 = node3.getNext();
        }
        return linkedHashMap;
    }

    private static String getUniqueAnonymousParameterName(Supplier<String> supplier) {
        return "JSCompiler_inline_anon_param_" + (String)supplier.get();
    }

    static Set<String> findModifiedParameters(Node node) {
        Set<String> set = FunctionArgumentInjector.getFunctionParameterSet(node);
        HashSet hashSet = Sets.newHashSet();
        return FunctionArgumentInjector.findModifiedParameters(node, null, set, hashSet);
    }

    private static Set<String> findModifiedParameters(Node node, Node node2, Set<String> set, Set<String> set2) {
        Preconditions.checkArgument((set2 != null ? 1 : 0) != 0);
        if (node.getType() == 38 && set.contains(node.getString()) && FunctionArgumentInjector.canNameValueChange(node, node2)) {
            set2.add(node.getString());
        }
        for (Node node3 : node.children()) {
            FunctionArgumentInjector.findModifiedParameters(node3, node, set, set2);
        }
        return set2;
    }

    private static boolean canNameValueChange(Node node, Node node2) {
        int n = node2.getType();
        return n == 118 || n == 102 || n == 103 || NodeUtil.isAssignmentOp(node2) && node2.getFirstChild() == node;
    }

    static void maybeAddTempsForCallArguments(Node node, Map<String, Node> map, Set<String> set, CodingConvention codingConvention) {
        if (map.isEmpty()) {
            return;
        }
        Preconditions.checkArgument((node.getType() == 105 ? 1 : 0) != 0);
        Node node2 = node.getLastChild();
        Set<String> set2 = map.keySet();
        Set<String> set3 = FunctionArgumentInjector.findParametersReferencedAfterSideEffect(set2, node2);
        for (Map.Entry<String, Node> entry : map.entrySet()) {
            String string = entry.getKey();
            if (set.contains(string)) continue;
            Node node3 = entry.getValue();
            boolean bl = true;
            int n = NodeUtil.getNameReferenceCount(node2, string);
            if (NodeUtil.mayEffectMutableState(node3) && n > 0) {
                bl = false;
            } else if (NodeUtil.mayHaveSideEffects(node3)) {
                bl = false;
            } else if (NodeUtil.canBeSideEffected(node3) && set3.contains(string)) {
                bl = false;
            } else if (n > 1) {
                switch (node3.getType()) {
                    case 38: {
                        String string2 = node3.getString();
                        bl = !codingConvention.isExported(string2);
                        break;
                    }
                    case 39: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 122: {
                        bl = true;
                        break;
                    }
                    case 40: {
                        bl = node3.getString().length() < 2;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
            }
            if (bl) continue;
            set.add(string);
        }
    }

    private static Set<String> findParametersReferencedAfterSideEffect(Set<String> set, Node node) {
        HashSet hashSet = Sets.newHashSet(set);
        FunctionArgumentInjector.gatherLocalNames(node, hashSet);
        ReferencedAfterSideEffect referencedAfterSideEffect = new ReferencedAfterSideEffect(set, hashSet);
        NodeUtil.visitPostOrder(node, referencedAfterSideEffect, referencedAfterSideEffect);
        return referencedAfterSideEffect.getResults();
    }

    private static void gatherLocalNames(Node node, Set<String> set) {
        if (node.getType() == 105) {
            if (NodeUtil.isFunctionDeclaration(node)) {
                set.add(node.getFirstChild().getString());
            }
            return;
        }
        if (node.getType() == 38) {
            switch (node.getParent().getType()) {
                case 118: 
                case 120: {
                    set.add(node.getString());
                }
            }
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            FunctionArgumentInjector.gatherLocalNames(node2, set);
        }
    }

    private static Set<String> getFunctionParameterSet(Node node) {
        HashSet hashSet = Sets.newHashSet();
        for (Node node2 : NodeUtil.getFnParameters(node).children()) {
            hashSet.add(node2.getString());
        }
        return hashSet;
    }

    private static class ReferencedAfterSideEffect
    implements NodeUtil.Visitor,
    Predicate<Node> {
        private final Set<String> parameters;
        private final Set<String> locals;
        private boolean sideEffectSeen = false;
        private Set<String> parametersReferenced = Sets.newHashSet();
        private int loopsEntered = 0;

        ReferencedAfterSideEffect(Set<String> set, Set<String> set2) {
            this.parameters = set;
            this.locals = set2;
        }

        Set<String> getResults() {
            return this.parametersReferenced;
        }

        public boolean apply(Node node) {
            if (NodeUtil.isLoopStructure(node)) {
                ++this.loopsEntered;
            }
            return !this.sideEffectSeen || this.parameters.size() != this.parametersReferenced.size();
        }

        boolean inLoop() {
            return this.loopsEntered != 0;
        }

        @Override
        public void visit(Node node) {
            String string;
            if (NodeUtil.isLoopStructure(node)) {
                --this.loopsEntered;
                if (!this.inLoop() && !this.sideEffectSeen) {
                    this.parametersReferenced.clear();
                }
            }
            if (!this.sideEffectSeen && this.hasNonLocalSideEffect(node)) {
                this.sideEffectSeen = true;
            }
            if ((this.inLoop() || this.sideEffectSeen) && node.getType() == 38 && this.parameters.contains(string = node.getString())) {
                this.parametersReferenced.add(string);
            }
        }

        private boolean hasNonLocalSideEffect(Node node) {
            boolean bl = false;
            int n = node.getType();
            if (NodeUtil.isAssignmentOp(node) || n == 102 || n == 103) {
                Node node2 = node.getFirstChild();
                if (!this.isLocalName(node2)) {
                    bl = true;
                }
            } else if (n == 37) {
                bl = NodeUtil.functionCallHasSideEffects(node);
            } else if (n == 30) {
                bl = NodeUtil.constructorCallHasSideEffects(node);
            } else if (n == 31) {
                bl = true;
            }
            return bl;
        }

        private boolean isLocalName(Node node) {
            if (NodeUtil.isName(node)) {
                String string = node.getString();
                return this.locals.contains(string);
            }
            return false;
        }
    }
}

