/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.regex.Pattern;

class ExportTestFunctions
implements CompilerPass {
    private static final Pattern TEST_FUNCTIONS_NAME_PATTERN = Pattern.compile("^(?:setUpPage|setUp|tearDown|tearDownPage|test.*)$");
    private AbstractCompiler compiler;
    private final String exportSymbolFunction;

    ExportTestFunctions(AbstractCompiler abstractCompiler, String string) {
        Preconditions.checkNotNull((Object)abstractCompiler);
        this.compiler = abstractCompiler;
        this.exportSymbolFunction = string;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, new ExportTestFunctionsNodes());
    }

    private void exportTestFunction(String string, Node node, Node node2) {
        Node node3 = new Node(37, NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), this.exportSymbolFunction, node, string));
        node3.addChildToBack(Node.newString(string));
        node3.addChildToBack(NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), string, node, string));
        Node node4 = new Node(130, node3);
        node2.addChildAfter(node4, node);
        this.compiler.reportCodeChange();
    }

    private boolean isTestFunction(Node node, String string) {
        return string != null && TEST_FUNCTIONS_NAME_PATTERN.matcher(string).matches();
    }

    private class ExportTestFunctionsNodes
    extends NodeTraversal.AbstractPostOrderCallback {
        private ExportTestFunctionsNodes() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node2 != null && node2.getType() == 132) {
                String string;
                Node node3;
                if (NodeUtil.isFunctionDeclaration(node)) {
                    String string2 = NodeUtil.getFunctionName(node);
                    if (ExportTestFunctions.this.isTestFunction(node, string2)) {
                        ExportTestFunctions.this.exportTestFunction(string2, node, node2);
                    }
                } else if (this.isVarDeclaredFunction(node) && ExportTestFunctions.this.isTestFunction(node3 = node.getFirstChild().getFirstChild(), string = NodeUtil.getFunctionName(node3))) {
                    ExportTestFunctions.this.exportTestFunction(string, node, node2);
                }
            }
        }

        private boolean isVarDeclaredFunction(Node node) {
            if (node.getType() != 118) {
                return false;
            }
            Node node2 = node.getFirstChild().getFirstChild();
            return node2 != null && node2.getType() == 105;
        }
    }
}

