/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class Denormalize
implements CompilerPass,
NodeTraversal.Callback {
    private final AbstractCompiler compiler;

    Denormalize(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        this.maybeCollapseIntoForStatements(node, node2);
    }

    private void maybeCollapseIntoForStatements(Node node, Node node2) {
        if (node2 == null || !NodeUtil.isStatementBlock(node2)) {
            return;
        }
        if (!NodeUtil.isExpressionNode(node) && !NodeUtil.isVar(node)) {
            return;
        }
        Node node3 = node.getNext();
        if (node3 == null) {
            return;
        }
        if (NodeUtil.isForIn(node3)) {
            Node node4;
            Node node5 = node3;
            Node node6 = node5.getFirstChild();
            if (NodeUtil.isName(node6) && NodeUtil.isVar(node) && node.hasOneChild() && !(node4 = node.getFirstChild()).hasChildren() && node6.getString().equals(node4.getString())) {
                node2.removeChild(node);
                node5.replaceChild(node6, node);
                this.compiler.reportCodeChange();
            }
        } else if (node3.getType() == 115 && node3.getFirstChild().getType() == 124) {
            Node node7;
            if (NodeUtil.containsType(node, 51)) {
                return;
            }
            Node node8 = node3;
            Node node9 = node8.getFirstChild();
            node2.removeChild(node);
            if (NodeUtil.isVar(node)) {
                node7 = node;
            } else {
                Preconditions.checkState((boolean)node.hasOneChild());
                node7 = node.getFirstChild();
                node.removeChild(node7);
            }
            node8.replaceChild(node9, node7);
            this.compiler.reportCodeChange();
        }
    }

    static class StripConstantAnnotations
    extends NodeTraversal.AbstractPostOrderCallback
    implements CompilerPass {
        private AbstractCompiler compiler;

        StripConstantAnnotations(AbstractCompiler abstractCompiler) {
            this.compiler = abstractCompiler;
        }

        @Override
        public void process(Node node, Node node2) {
            NodeTraversal.traverse(this.compiler, node, this);
            NodeTraversal.traverse(this.compiler, node2, this);
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 38 || node.getType() == 40) {
                node.removeProp(42);
            }
        }
    }
}

