/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.LatticeElement;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionPrototypeType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import com.google.javascript.rhino.jstype.UnknownType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class ConcreteType
implements LatticeElement {
    static final ConcreteType NONE = new ConcreteNoneType();
    static final ConcreteType ALL = new ConcreteAll();
    private static final List<ConcreteFunctionType> NO_FUNCTIONS = Lists.newArrayList();
    private static final List<ConcreteInstanceType> NO_INSTANCES = Lists.newArrayList();
    private static final List<StaticSlot<ConcreteType>> NO_SLOTS = Lists.newArrayList();

    ConcreteType() {
    }

    protected static ConcreteType createForTypes(Collection<ConcreteType> collection) {
        if (collection == null || collection.size() == 0) {
            return NONE;
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        return new ConcreteUnionType(Sets.newHashSet(collection));
    }

    boolean isNone() {
        return false;
    }

    boolean isFunction() {
        return false;
    }

    boolean isInstance() {
        return false;
    }

    boolean isUnion() {
        return false;
    }

    boolean isAll() {
        return false;
    }

    boolean isSingleton() {
        return !this.isNone() && !this.isUnion() && !this.isAll();
    }

    ConcreteFunctionType toFunction() {
        return null;
    }

    ConcreteInstanceType toInstance() {
        return null;
    }

    ConcreteUnionType toUnion() {
        return null;
    }

    StaticScope<ConcreteType> getScope() {
        return null;
    }

    ConcreteType unionWith(ConcreteType concreteType) {
        Preconditions.checkState((boolean)this.isSingleton());
        if (!concreteType.isSingleton()) {
            return concreteType.unionWith(this);
        }
        if (this.equals(concreteType)) {
            return this;
        }
        return new ConcreteUnionType(this, concreteType);
    }

    ConcreteType intersectWith(ConcreteType concreteType) {
        if (!concreteType.isSingleton()) {
            return concreteType.intersectWith(this);
        }
        if (this.equals(concreteType)) {
            return this;
        }
        return NONE;
    }

    private <C> List<C> getMatchingTypes(TypeFilter<C> typeFilter) {
        Object e = null;
        if (this.isUnion()) {
            ArrayList arrayList = Lists.newArrayList();
            for (ConcreteType concreteType : this.toUnion().getAlternatives()) {
                C c = typeFilter.filter(concreteType);
                e = c;
                if (c == null) continue;
                arrayList.add(e);
            }
            return arrayList;
        }
        C c = typeFilter.filter(this);
        e = c;
        if (c != null) {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(e);
            return arrayList;
        }
        return typeFilter.emptyList;
    }

    List<ConcreteFunctionType> getFunctions() {
        return this.getMatchingTypes(new TypeFilter<ConcreteFunctionType>(NO_FUNCTIONS){

            @Override
            public ConcreteFunctionType filter(ConcreteType concreteType) {
                return concreteType.isFunction() ? concreteType.toFunction() : null;
            }
        });
    }

    List<ConcreteInstanceType> getInstances() {
        return this.getMatchingTypes(new TypeFilter<ConcreteInstanceType>(NO_INSTANCES){

            @Override
            public ConcreteInstanceType filter(ConcreteType concreteType) {
                return concreteType.isInstance() ? concreteType.toInstance() : null;
            }
        });
    }

    List<ConcreteInstanceType> getFunctionInstanceTypes() {
        return this.getMatchingTypes(new TypeFilter<ConcreteInstanceType>(NO_INSTANCES){

            @Override
            public ConcreteInstanceType filter(ConcreteType concreteType) {
                if (concreteType.isFunction()) {
                    return concreteType.toFunction().getInstanceType();
                }
                return null;
            }
        });
    }

    List<ConcreteInstanceType> getPrototypeTypes() {
        return this.getMatchingTypes(new TypeFilter<ConcreteInstanceType>(NO_INSTANCES){

            @Override
            public ConcreteInstanceType filter(ConcreteType concreteType) {
                if (concreteType.isInstance() && concreteType.toInstance().isFunctionPrototype()) {
                    return concreteType.toInstance();
                }
                return null;
            }
        });
    }

    List<ConcreteFunctionType> getSuperclassTypes() {
        return this.getMatchingTypes(new TypeFilter<ConcreteFunctionType>(NO_FUNCTIONS){

            @Override
            public ConcreteFunctionType filter(ConcreteType concreteType) {
                return concreteType.isFunction() && concreteType.toFunction().getSuperclassType() != null ? concreteType.toFunction().getSuperclassType() : null;
            }
        });
    }

    List<StaticSlot<ConcreteType>> getParameterSlots(final int n) {
        return this.getMatchingTypes(new TypeFilter<StaticSlot<ConcreteType>>(NO_SLOTS){

            @Override
            public StaticSlot<ConcreteType> filter(ConcreteType concreteType) {
                return concreteType.isFunction() && ConcreteType.this.toFunction().getParameterSlot(n) != null ? ConcreteType.this.toFunction().getParameterSlot(n) : null;
            }
        });
    }

    List<StaticSlot<ConcreteType>> getPropertySlots(final String string) {
        return this.getMatchingTypes(new TypeFilter<StaticSlot<ConcreteType>>(NO_SLOTS){

            @Override
            public StaticSlot<ConcreteType> filter(ConcreteType concreteType) {
                StaticSlot<ConcreteType> staticSlot = null;
                if (concreteType.isInstance()) {
                    staticSlot = concreteType.toInstance().getPropertySlot(string);
                }
                return staticSlot;
            }
        });
    }

    ConcreteType getPropertyType(String string) {
        ConcreteType concreteType = NONE;
        for (StaticSlot<ConcreteType> staticSlot : this.getPropertySlots(string)) {
            concreteType = concreteType.unionWith(staticSlot.getType());
        }
        return concreteType;
    }

    static interface Factory {
        public ConcreteFunctionType createConcreteFunction(Node var1, StaticScope<ConcreteType> var2);

        public ConcreteInstanceType createConcreteInstance(ObjectType var1);

        public ConcreteFunctionType getConcreteFunction(FunctionType var1);

        public ConcreteInstanceType getConcreteInstance(ObjectType var1);

        public StaticScope<ConcreteType> createFunctionScope(Node var1, StaticScope<ConcreteType> var2);

        public StaticScope<ConcreteType> createInstanceScope(ObjectType var1);

        public JSTypeRegistry getTypeRegistry();
    }

    static class ConcreteUniqueType
    extends ConcreteType {
        private final int id;

        ConcreteUniqueType(int n) {
            this.id = n;
            Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0);
        }

        public boolean equals(Object object) {
            return object instanceof ConcreteUniqueType && this.id == ((ConcreteUniqueType)object).id;
        }

        public int hashCode() {
            return ConcreteUniqueType.class.hashCode() ^ this.id;
        }

        public String toString() {
            return "Unique$" + this.id;
        }
    }

    private static class ConcreteAll
    extends ConcreteType {
        private ConcreteAll() {
        }

        @Override
        boolean isAll() {
            return true;
        }

        @Override
        ConcreteType unionWith(ConcreteType concreteType) {
            return this;
        }

        @Override
        ConcreteType intersectWith(ConcreteType concreteType) {
            return concreteType;
        }

        public String toString() {
            return "*";
        }
    }

    static class ConcreteUnionType
    extends ConcreteType {
        private final Set<ConcreteType> alternatives;

        ConcreteUnionType(ConcreteType ... concreteTypeArray) {
            this(Sets.newHashSet((Object[])concreteTypeArray));
        }

        ConcreteUnionType(Set<ConcreteType> set) {
            Preconditions.checkArgument((set.size() > 1 ? 1 : 0) != 0);
            this.alternatives = set;
        }

        @Override
        boolean isUnion() {
            return true;
        }

        @Override
        ConcreteUnionType toUnion() {
            return this;
        }

        @Override
        ConcreteType unionWith(ConcreteType concreteType) {
            if (concreteType.isSingleton()) {
                if (this.alternatives.contains(concreteType)) {
                    return this;
                }
                HashSet hashSet = Sets.newHashSet(this.alternatives);
                hashSet.add(concreteType);
                return new ConcreteUnionType(hashSet);
            }
            if (concreteType.isUnion()) {
                ConcreteUnionType concreteUnionType = concreteType.toUnion();
                if (this.alternatives.containsAll(concreteUnionType.alternatives)) {
                    return this;
                }
                if (concreteUnionType.alternatives.containsAll(this.alternatives)) {
                    return concreteUnionType;
                }
                HashSet hashSet = Sets.newHashSet(this.alternatives);
                hashSet.addAll(concreteUnionType.alternatives);
                return new ConcreteUnionType(hashSet);
            }
            Preconditions.checkArgument((concreteType.isNone() || concreteType.isAll() ? 1 : 0) != 0);
            return concreteType.unionWith(this);
        }

        @Override
        ConcreteType intersectWith(ConcreteType concreteType) {
            if (concreteType.isSingleton()) {
                if (this.alternatives.contains(concreteType)) {
                    return concreteType;
                }
                return NONE;
            }
            if (concreteType.isUnion()) {
                HashSet hashSet = Sets.newHashSet(this.alternatives);
                hashSet.retainAll(concreteType.toUnion().alternatives);
                return ConcreteUnionType.createForTypes(hashSet);
            }
            Preconditions.checkArgument((concreteType.isNone() || concreteType.isAll() ? 1 : 0) != 0);
            return concreteType.intersectWith(this);
        }

        Set<ConcreteType> getAlternatives() {
            return this.alternatives;
        }

        public boolean equals(Object object) {
            return object instanceof ConcreteUnionType && ((Object)this.alternatives).equals(((ConcreteUnionType)object).alternatives);
        }

        public int hashCode() {
            return ((Object)this.alternatives).hashCode() ^ 0x5F6E7D8C;
        }

        public String toString() {
            ArrayList arrayList = Lists.newArrayList();
            for (ConcreteType concreteType : this.alternatives) {
                arrayList.add(concreteType.toString());
            }
            Collections.sort(arrayList);
            return "(" + Joiner.on((String)",").join((Iterable)arrayList) + ")";
        }
    }

    static class ConcreteInstanceType
    extends ConcreteType {
        private final Factory factory;
        public final ObjectType instanceType;
        private ConcreteInstanceType prototype;
        private StaticScope<ConcreteType> scope;

        ConcreteInstanceType(Factory factory, ObjectType objectType) {
            this.factory = factory;
            this.instanceType = objectType;
            Preconditions.checkArgument((!(objectType instanceof UnknownType) ? 1 : 0) != 0);
        }

        @Override
        boolean isInstance() {
            return true;
        }

        @Override
        ConcreteInstanceType toInstance() {
            return this;
        }

        boolean isFunctionPrototype() {
            return this.instanceType.isFunctionPrototypeType();
        }

        StaticSlot<ConcreteType> getPropertySlot(String string) {
            return this.getScope().getSlot(string);
        }

        ConcreteInstanceType getInstanceTypeWithProperty(String string) {
            if (this.getScope().getOwnSlot(string) != null) {
                if (this.instanceType.getConstructor() != null) {
                    return this.getConstructorType().getPrototypeType();
                }
                return this;
            }
            if (this.getImplicitPrototype() != null) {
                return this.getImplicitPrototype().getInstanceTypeWithProperty(string);
            }
            return null;
        }

        ConcreteInstanceType getImplicitPrototype() {
            ObjectType objectType;
            if (this.prototype == null && this.instanceType.getImplicitPrototype() != null && (objectType = this.instanceType.getImplicitPrototype()) != this.instanceType && !(objectType instanceof UnknownType)) {
                this.prototype = this.factory.createConcreteInstance(objectType);
            }
            return this.prototype;
        }

        ConcreteFunctionType getConstructorType() {
            if (this.instanceType.isFunctionPrototypeType()) {
                FunctionPrototypeType functionPrototypeType = (FunctionPrototypeType)this.instanceType;
                return this.factory.getConcreteFunction(functionPrototypeType.getOwnerFunction());
            }
            FunctionType functionType = this.instanceType.getConstructor();
            return functionType != null ? this.factory.getConcreteFunction(functionType) : null;
        }

        @Override
        StaticScope<ConcreteType> getScope() {
            if (this.scope == null) {
                this.scope = this.factory.createInstanceScope(this.instanceType);
            }
            return this.scope;
        }

        public String toString() {
            return this.instanceType.toString();
        }
    }

    static class ConcreteFunctionType
    extends ConcreteType {
        static final String CALL_SLOT_NAME = ":call";
        static final String THIS_SLOT_NAME = ":this";
        static final String RETURN_SLOT_NAME = ":return";
        private final Factory factory;
        private final Node declaration;
        private final StaticScope<ConcreteType> parentScope;
        private StaticScope<ConcreteType> bodyScope;
        private ConcreteInstanceType instanceType;
        private ConcreteInstanceType prototypeType;

        ConcreteFunctionType(Factory factory, Node node, StaticScope<ConcreteType> staticScope) {
            this.factory = factory;
            this.declaration = node;
            this.parentScope = staticScope;
            Preconditions.checkArgument((node.getType() == 105 ? 1 : 0) != 0);
            Preconditions.checkArgument((node.getJSType() != null ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)node.getJSType().isFunctionType());
        }

        @Override
        boolean isFunction() {
            return true;
        }

        @Override
        ConcreteFunctionType toFunction() {
            return this;
        }

        StaticSlot<ConcreteType> getCallSlot() {
            return this.getScope().getOwnSlot(CALL_SLOT_NAME);
        }

        StaticSlot<ConcreteType> getThisSlot() {
            return this.getScope().getOwnSlot(THIS_SLOT_NAME);
        }

        StaticSlot<ConcreteType> getReturnSlot() {
            return this.getScope().getOwnSlot(RETURN_SLOT_NAME);
        }

        StaticSlot<ConcreteType> getParameterSlot(int n) {
            return this.getScope().getOwnSlot(this.getParameterName(n));
        }

        private String getParameterName(int n) {
            int n2 = 0;
            for (Node node = this.getFirstParameter(); node != null; node = node.getNext()) {
                if (n2++ != n) continue;
                return node.getString();
            }
            return null;
        }

        private Node getFirstParameter() {
            return this.declaration.getFirstChild().getNext().getFirstChild();
        }

        public FunctionType getJSType() {
            return (FunctionType)this.declaration.getJSType();
        }

        ConcreteInstanceType getInstanceType() {
            if (this.instanceType == null && this.getJSType().isConstructor()) {
                this.instanceType = this.factory.createConcreteInstance(this.getJSType().getInstanceType());
            }
            return this.instanceType;
        }

        ConcreteInstanceType getPrototypeType() {
            if (this.prototypeType == null) {
                this.prototypeType = this.factory.createConcreteInstance(this.getJSType().getPrototype());
            }
            return this.prototypeType;
        }

        ConcreteFunctionType getSuperclassType() {
            FunctionType functionType = this.getJSType().getSuperClassConstructor();
            return functionType != null ? this.factory.getConcreteFunction(functionType) : null;
        }

        @Override
        StaticScope<ConcreteType> getScope() {
            if (this.bodyScope == null) {
                this.bodyScope = this.factory.createFunctionScope(this.declaration, this.parentScope);
            }
            return this.bodyScope;
        }

        public String toString() {
            boolean bl;
            StringBuilder stringBuilder = new StringBuilder(32);
            stringBuilder.append("function (");
            boolean bl2 = bl = !this.getThisSlot().getType().isNone();
            if (bl) {
                stringBuilder.append("this:");
                stringBuilder.append(this.getThisSlot().getType().toString());
            }
            Node node = this.getFirstParameter();
            if (bl && node != null) {
                stringBuilder.append(", ");
            }
            int n = 0;
            while (node != null) {
                String string = node.getString();
                StaticSlot<ConcreteType> staticSlot = this.getScope().getOwnSlot(string);
                stringBuilder.append(staticSlot.getType());
                this.getParameterSlot(n).getType();
                if (node.getNext() != null) {
                    stringBuilder.append(", ");
                }
                ++n;
                node = node.getNext();
            }
            stringBuilder.append(")");
            if (this.getReturnSlot().getType() != null) {
                stringBuilder.append(": ");
                stringBuilder.append(this.getReturnSlot().getType().toString());
            }
            return stringBuilder.toString();
        }
    }

    private static class ConcreteNoneType
    extends ConcreteType {
        private ConcreteNoneType() {
        }

        @Override
        boolean isNone() {
            return true;
        }

        @Override
        ConcreteType unionWith(ConcreteType concreteType) {
            return concreteType;
        }

        @Override
        ConcreteType intersectWith(ConcreteType concreteType) {
            return NONE;
        }

        public String toString() {
            return "()";
        }
    }

    abstract class TypeFilter<C> {
        final List<C> emptyList;

        TypeFilter(List<C> list) {
            this.emptyList = list;
        }

        protected abstract C filter(ConcreteType var1);
    }
}

