/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ChainableReverseAbstractInterpreter;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.ClosureReverseAbstractInterpreter;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CodePrinter;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ComposeWarningsGuard;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DefaultPassConfig;
import com.google.javascript.jscomp.DiagnosticGroupWarningsGuard;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DotFormatter;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.ExternExportsPass;
import com.google.javascript.jscomp.FunctionInformationMap;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.JSSourceFile;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.LoggerErrorManager;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PerformanceTracker;
import com.google.javascript.jscomp.PhaseOptimizer;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.jscomp.PrintStreamErrorManager;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.RecordFunctionInformation;
import com.google.javascript.jscomp.Region;
import com.google.javascript.jscomp.RemoveTryCatch;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.ReverseAbstractInterpreter;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.SanityCheck;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.SemanticReverseAbstractInterpreter;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceInformationAnnotator;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.StripCode;
import com.google.javascript.jscomp.SuppressDocWarningsGuard;
import com.google.javascript.jscomp.SyntheticAst;
import com.google.javascript.jscomp.Tracer;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.jscomp.deps.SortedDependencies;
import com.google.javascript.jscomp.mozilla.rhino.ErrorReporter;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Compiler
extends AbstractCompiler {
    static final DiagnosticType MODULE_DEPENDENCY_ERROR = DiagnosticType.error("JSC_MODULE_DEPENDENCY_ERROR", "Bad dependency: {0} -> {1}. Modules must be listed in dependency order.");
    static final DiagnosticType MISSING_ENTRY_ERROR = DiagnosticType.error("JSC_MISSING_ENTRY_ERROR", "required entry point \"{0}\" never provided");
    CompilerOptions options = null;
    private PassConfig passes = null;
    private List<CompilerInput> externs;
    private List<JSModule> modules;
    private JSModuleGraph moduleGraph;
    private List<CompilerInput> inputs;
    private ErrorManager errorManager;
    private WarningsGuard warningsGuard;
    Node externsRoot;
    Node jsRoot;
    Node externAndJsRoot;
    private Map<String, CompilerInput> inputsByName;
    private SourceMap sourceMap;
    private String externExports = null;
    private int uniqueNameId = 0;
    private boolean useThreads = true;
    private boolean hasRegExpGlobalReferences = true;
    private FunctionInformationMap functionInformationMap;
    private final StringBuilder debugLog = new StringBuilder();
    CodingConvention defaultCodingConvention = new ClosureCodingConvention();
    private JSTypeRegistry typeRegistry;
    private Config parserConfig = null;
    private ReverseAbstractInterpreter abstractInterpreter;
    private TypeValidator typeValidator;
    public PerformanceTracker tracker;
    private final com.google.javascript.rhino.ErrorReporter oldErrorReporter = RhinoErrorReporter.forOldRhino(this);
    private final ErrorReporter defaultErrorReporter = RhinoErrorReporter.forNewRhino(this);
    public static final DiagnosticType OPTIMIZE_LOOP_ERROR = DiagnosticType.error("JSC_OPTIMIZE_LOOP_ERROR", "Exceeded max number of optimization iterations: {0}");
    public static final DiagnosticType MOTION_ITERATIONS_ERROR = DiagnosticType.error("JSC_OPTIMIZE_LOOP_ERROR", "Exceeded max number of code motion iterations: {0}");
    private static final long COMPILER_STACK_SIZE = 0x100000L;
    private static final Logger logger = Logger.getLogger("com.google.javascript.jscomp");
    private final PrintStream outStream;
    private static final DiagnosticType EMPTY_MODULE_LIST_ERROR = DiagnosticType.error("JSC_EMPTY_MODULE_LIST_ERROR", "At least one module must be provided");
    private static final DiagnosticType EMPTY_ROOT_MODULE_ERROR = DiagnosticType.error("JSC_EMPTY_ROOT_MODULE_ERROR", "Root module '{0}' must contain at least one source code input");
    static final DiagnosticType DUPLICATE_INPUT = DiagnosticType.error("JSC_DUPLICATE_INPUT", "Duplicate input: {0}");
    static final DiagnosticType DUPLICATE_EXTERN_INPUT = DiagnosticType.error("JSC_DUPLICATE_EXTERN_INPUT", "Duplicate extern input: {0}");
    private final PassFactory sanityCheck = new PassFactory("sanityCheck", false){

        @Override
        protected CompilerPass createInternal(AbstractCompiler abstractCompiler) {
            return new SanityCheck(abstractCompiler);
        }
    };
    private Tracer currentTracer = null;
    private String currentPassName = null;
    protected final CodeChangeHandler.RecentChange recentChange = new CodeChangeHandler.RecentChange();
    private final List<CodeChangeHandler> codeChangeHandlers = Lists.newArrayList();

    public Compiler() {
        this((PrintStream)null);
    }

    public Compiler(PrintStream printStream) {
        this.addChangeHandler(this.recentChange);
        this.outStream = printStream;
    }

    public Compiler(ErrorManager errorManager) {
        this();
        this.setErrorManager(errorManager);
    }

    public void setErrorManager(ErrorManager errorManager) {
        Preconditions.checkNotNull((Object)errorManager, (Object)"the error manager cannot be null");
        this.errorManager = errorManager;
    }

    private MessageFormatter createMessageFormatter() {
        boolean bl = this.options.shouldColorizeErrorOutput();
        return this.options.errorFormat.toFormatter(this, bl);
    }

    public void initOptions(CompilerOptions compilerOptions) {
        Object object;
        this.options = compilerOptions;
        if (this.errorManager == null) {
            if (this.outStream == null) {
                this.setErrorManager(new LoggerErrorManager(this.createMessageFormatter(), logger));
            } else {
                object = new PrintStreamErrorManager(this.createMessageFormatter(), this.outStream);
                ((PrintStreamErrorManager)object).setSummaryDetailLevel(compilerOptions.summaryDetailLevel);
                this.setErrorManager((ErrorManager)object);
            }
        }
        object = Lists.newArrayList();
        object.add(new SuppressDocWarningsGuard(this.getDiagnosticGroups().getRegisteredGroups()));
        WarningsGuard warningsGuard = compilerOptions.getWarningsGuard();
        if (warningsGuard != null) {
            object.add(compilerOptions.getWarningsGuard());
        }
        if (!(compilerOptions.checkSymbols || warningsGuard != null && warningsGuard.disables(DiagnosticGroups.CHECK_VARIABLES))) {
            object.add(new DiagnosticGroupWarningsGuard(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.OFF));
        }
        this.warningsGuard = new ComposeWarningsGuard((List<WarningsGuard>)object);
    }

    public void init(JSSourceFile[] jSSourceFileArray, JSSourceFile[] jSSourceFileArray2, CompilerOptions compilerOptions) {
        this.init(Lists.newArrayList((Object[])jSSourceFileArray), Lists.newArrayList((Object[])jSSourceFileArray2), compilerOptions);
    }

    public void init(List<JSSourceFile> list, List<JSSourceFile> list2, CompilerOptions compilerOptions) {
        JSModule jSModule = new JSModule("[singleton]");
        for (JSSourceFile jSSourceFile : list2) {
            jSModule.add(jSSourceFile);
        }
        this.initModules(list, Lists.newArrayList((Object[])new JSModule[]{jSModule}), compilerOptions);
    }

    public void init(JSSourceFile[] jSSourceFileArray, JSModule[] jSModuleArray, CompilerOptions compilerOptions) {
        this.initModules(Lists.newArrayList((Object[])jSSourceFileArray), Lists.newArrayList((Object[])jSModuleArray), compilerOptions);
    }

    public void initModules(List<JSSourceFile> list, List<JSModule> list2, CompilerOptions compilerOptions) {
        this.initOptions(compilerOptions);
        this.checkFirstModule(list2);
        Compiler.fillEmptyModules(list2);
        this.externs = this.makeCompilerInput(list, true);
        this.modules = list2;
        if (list2.size() > 1) {
            try {
                this.moduleGraph = new JSModuleGraph(list2);
            }
            catch (JSModuleGraph.ModuleDependenceException moduleDependenceException) {
                this.report(JSError.make(MODULE_DEPENDENCY_ERROR, moduleDependenceException.getModule().getName(), moduleDependenceException.getDependentModule().getName()));
                return;
            }
        } else {
            this.moduleGraph = null;
        }
        this.inputs = Compiler.getAllInputsFromModules(list2);
        this.initBasedOnOptions();
        this.initInputsByNameMap();
    }

    private void initBasedOnOptions() {
        if (this.options.sourceMapOutputPath != null) {
            this.sourceMap = this.options.sourceMapFormat.getInstance();
        }
    }

    private List<CompilerInput> makeCompilerInput(List<JSSourceFile> list, boolean bl) {
        ArrayList arrayList = Lists.newArrayList();
        for (JSSourceFile jSSourceFile : list) {
            arrayList.add(new CompilerInput(jSSourceFile, bl));
        }
        return arrayList;
    }

    private void checkFirstModule(List<JSModule> list) {
        if (list.isEmpty()) {
            this.report(JSError.make(EMPTY_MODULE_LIST_ERROR, new String[0]));
        } else if (list.get(0).getInputs().isEmpty() && list.size() > 1) {
            this.report(JSError.make(EMPTY_ROOT_MODULE_ERROR, list.get(0).getName()));
        }
    }

    private static void fillEmptyModules(List<JSModule> list) {
        for (JSModule jSModule : list) {
            if (!jSModule.getInputs().isEmpty()) continue;
            jSModule.add(JSSourceFile.fromCode("[" + jSModule.getName() + "]", ""));
        }
    }

    public void rebuildInputsFromModules() {
        this.inputs = Compiler.getAllInputsFromModules(this.modules);
        this.initInputsByNameMap();
    }

    private static List<CompilerInput> getAllInputsFromModules(List<JSModule> list) {
        ArrayList arrayList = Lists.newArrayList();
        HashMap hashMap = Maps.newHashMap();
        for (JSModule jSModule : list) {
            for (CompilerInput compilerInput : jSModule.getInputs()) {
                String string = compilerInput.getName();
                arrayList.add(compilerInput);
                hashMap.put(string, jSModule);
            }
        }
        return arrayList;
    }

    void initInputsByNameMap() {
        String string;
        this.inputsByName = new HashMap<String, CompilerInput>();
        for (CompilerInput compilerInput : this.externs) {
            string = compilerInput.getName();
            if (!this.inputsByName.containsKey(string)) {
                this.inputsByName.put(string, compilerInput);
                continue;
            }
            this.report(JSError.make(DUPLICATE_EXTERN_INPUT, string));
        }
        for (CompilerInput compilerInput : this.inputs) {
            string = compilerInput.getName();
            if (!this.inputsByName.containsKey(string)) {
                this.inputsByName.put(string, compilerInput);
                continue;
            }
            this.report(JSError.make(DUPLICATE_INPUT, string));
        }
    }

    public Result compile(JSSourceFile jSSourceFile, JSSourceFile jSSourceFile2, CompilerOptions compilerOptions) {
        return this.compile(jSSourceFile, new JSSourceFile[]{jSSourceFile2}, compilerOptions);
    }

    public Result compile(JSSourceFile jSSourceFile, JSSourceFile[] jSSourceFileArray, CompilerOptions compilerOptions) {
        return this.compile(new JSSourceFile[]{jSSourceFile}, jSSourceFileArray, compilerOptions);
    }

    public Result compile(JSSourceFile jSSourceFile, JSModule[] jSModuleArray, CompilerOptions compilerOptions) {
        return this.compile(new JSSourceFile[]{jSSourceFile}, jSModuleArray, compilerOptions);
    }

    public Result compile(JSSourceFile[] jSSourceFileArray, JSSourceFile[] jSSourceFileArray2, CompilerOptions compilerOptions) {
        return this.compile(Lists.newArrayList((Object[])jSSourceFileArray), Lists.newArrayList((Object[])jSSourceFileArray2), compilerOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compile(List<JSSourceFile> list, List<JSSourceFile> list2, CompilerOptions compilerOptions) {
        Preconditions.checkState((this.jsRoot == null ? 1 : 0) != 0);
        try {
            this.init(list, list2, compilerOptions);
            if (this.hasErrors()) {
                Result result = this.getResult();
                return result;
            }
            Result result = this.compile();
            return result;
        }
        finally {
            Tracer tracer = this.newTracer("generateReport");
            this.errorManager.generateReport();
            this.stopTracer(tracer, "generateReport");
        }
    }

    public Result compile(JSSourceFile[] jSSourceFileArray, JSModule[] jSModuleArray, CompilerOptions compilerOptions) {
        return this.compileModules(Lists.newArrayList((Object[])jSSourceFileArray), Lists.newArrayList((Object[])jSModuleArray), compilerOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compileModules(List<JSSourceFile> list, List<JSModule> list2, CompilerOptions compilerOptions) {
        Preconditions.checkState((this.jsRoot == null ? 1 : 0) != 0);
        try {
            this.initModules(list, list2, compilerOptions);
            if (this.hasErrors()) {
                Result result = this.getResult();
                return result;
            }
            Result result = this.compile();
            return result;
        }
        finally {
            Tracer tracer = this.newTracer("generateReport");
            this.errorManager.generateReport();
            this.stopTracer(tracer, "generateReport");
        }
    }

    private Result compile() {
        return this.runInCompilerThread(new Callable<Result>(){

            @Override
            public Result call() throws Exception {
                Compiler.this.compileInternal();
                return Compiler.this.getResult();
            }
        });
    }

    public void disableThreads() {
        this.useThreads = false;
    }

    private <T> T runInCompilerThread(Callable<T> callable) {
        return Compiler.runCallable(callable, this.useThreads, this.options.tracer.isOn());
    }

    static <T> T runCallableWithLargeStack(Callable<T> callable) {
        return Compiler.runCallable(callable, true, false);
    }

    static <T> T runCallable(final Callable<T> callable, boolean bl, boolean bl2) {
        Throwable[] throwableArray;
        Object[] objectArray;
        block5: {
            final boolean bl3 = bl2;
            objectArray = new Object[1];
            throwableArray = new Throwable[1];
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (bl3) {
                            Tracer.initCurrentThreadTrace();
                        }
                        objectArray[0] = callable.call();
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                    finally {
                        if (bl3) {
                            Tracer.logAndClearCurrentThreadTrace();
                        }
                    }
                }
            };
            if (bl) {
                Thread thread = new Thread(null, runnable, "jscompiler", 0x100000L);
                thread.start();
                while (true) {
                    try {
                        thread.join();
                        break block5;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            runnable.run();
        }
        if (throwableArray[0] != null) {
            throw new RuntimeException(throwableArray[0]);
        }
        return (T)objectArray[0];
    }

    private void compileInternal() {
        this.parse();
        if (this.hasErrors()) {
            return;
        }
        if (!this.precheck()) {
            return;
        }
        if (this.options.nameAnonymousFunctionsOnly) {
            this.check();
            return;
        }
        if (!this.options.skipAllPasses) {
            this.check();
            if (this.hasErrors()) {
                return;
            }
            if (this.options.isExternExportsEnabled() || this.options.externExportsPath != null) {
                this.externExports();
            }
            if (!this.options.ideMode) {
                this.optimize();
            }
        }
        if (this.options.recordFunctionInformation) {
            this.recordFunctionInformation();
        }
        if (this.options.devMode == CompilerOptions.DevMode.START_AND_END) {
            this.runSanityCheck();
        }
    }

    public void parse() {
        this.parseInputs();
    }

    PassConfig getPassConfig() {
        if (this.passes == null) {
            this.passes = this.createPassConfigInternal();
        }
        return this.passes;
    }

    PassConfig createPassConfigInternal() {
        return new DefaultPassConfig(this.options);
    }

    public void setPassConfig(PassConfig passConfig) {
        Preconditions.checkNotNull((Object)passConfig);
        if (this.passes != null) {
            throw new IllegalStateException("this.passes has already been assigned");
        }
        this.passes = passConfig;
    }

    boolean precheck() {
        return true;
    }

    public void check() {
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_CHECKS);
        PhaseOptimizer phaseOptimizer = new PhaseOptimizer(this, this.tracker);
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            phaseOptimizer.setSanityCheck(this.sanityCheck);
        }
        phaseOptimizer.consume(this.getPassConfig().getChecks());
        phaseOptimizer.process(this.externsRoot, this.jsRoot);
        if (this.hasErrors()) {
            return;
        }
        if (this.options.nameAnonymousFunctionsOnly) {
            return;
        }
        if (this.options.removeTryCatchFinally) {
            this.removeTryCatchFinally();
        }
        if (!(!this.options.getTweakProcessing().shouldStrip() && this.options.stripTypes.isEmpty() && this.options.stripNameSuffixes.isEmpty() && this.options.stripTypePrefixes.isEmpty() && this.options.stripNamePrefixes.isEmpty())) {
            this.stripCode(this.options.stripTypes, this.options.stripNameSuffixes, this.options.stripTypePrefixes, this.options.stripNamePrefixes);
        }
        this.runCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATIONS);
    }

    private void externExports() {
        logger.info("Creating extern file for exports");
        this.startPass("externExports");
        ExternExportsPass externExportsPass = new ExternExportsPass(this);
        this.process(externExportsPass);
        this.externExports = externExportsPass.getGeneratedExterns();
        this.endPass();
    }

    void process(CompilerPass compilerPass) {
        compilerPass.process(this.externsRoot, this.jsRoot);
    }

    private void maybeSanityCheck() {
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            this.runSanityCheck();
        }
    }

    private void runSanityCheck() {
        this.sanityCheck.create(this).process(this.externsRoot, this.jsRoot);
    }

    void removeTryCatchFinally() {
        logger.info("Remove try/catch/finally");
        this.startPass("removeTryCatchFinally");
        RemoveTryCatch removeTryCatch = new RemoveTryCatch(this);
        this.process(removeTryCatch);
        this.endPass();
    }

    void stripCode(Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4) {
        logger.info("Strip code");
        this.startPass("stripCode");
        StripCode stripCode = new StripCode(this, set, set2, set3, set4);
        if (this.options.getTweakProcessing().shouldStrip()) {
            stripCode.enableTweakStripping();
        }
        this.process(stripCode);
        this.endPass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCustomPasses(CustomPassExecutionTime customPassExecutionTime) {
        if (this.options.customPasses != null) {
            Tracer tracer = this.newTracer("runCustomPasses");
            try {
                for (CompilerPass compilerPass : this.options.customPasses.get((Object)customPassExecutionTime)) {
                    this.process(compilerPass);
                }
            }
            finally {
                this.stopTracer(tracer, "runCustomPasses");
            }
        }
    }

    void startPass(String string) {
        Preconditions.checkState((this.currentTracer == null ? 1 : 0) != 0);
        this.currentPassName = string;
        this.currentTracer = this.newTracer(string);
    }

    void endPass() {
        Preconditions.checkState((this.currentTracer != null ? 1 : 0) != 0, (Object)"Tracer should not be null at the end of a pass.");
        this.stopTracer(this.currentTracer, this.currentPassName);
        String string = this.currentPassName;
        this.currentPassName = null;
        this.currentTracer = null;
        this.maybeSanityCheck();
    }

    Tracer newTracer(String string) {
        String string2 = string + (this.recentChange.hasCodeChanged() ? " on recently changed AST" : "");
        if (this.options.tracer.isOn()) {
            this.tracker.recordPassStart(string);
        }
        return new Tracer("Compiler", string2);
    }

    void stopTracer(Tracer tracer, String string) {
        long l = tracer.stop();
        if (this.options.tracer.isOn()) {
            this.tracker.recordPassStop(string, l);
        }
    }

    public Result getResult() {
        PassConfig.State state = this.getPassConfig().getIntermediateState();
        return new Result(this.getErrors(), this.getWarnings(), this.debugLog.toString(), state.variableMap, state.propertyMap, state.anonymousFunctionNameMap, state.stringMap, this.functionInformationMap, this.sourceMap, this.externExports, state.cssNames, state.idGeneratorMap);
    }

    public JSError[] getMessages() {
        return this.getErrors();
    }

    public JSError[] getErrors() {
        return this.errorManager.getErrors();
    }

    public JSError[] getWarnings() {
        return this.errorManager.getWarnings();
    }

    public Node getRoot() {
        return this.externAndJsRoot;
    }

    private int nextUniqueNameId() {
        return this.uniqueNameId++;
    }

    @VisibleForTesting
    void resetUniqueNameId() {
        this.uniqueNameId = 0;
    }

    @Override
    Supplier<String> getUniqueNameIdSupplier() {
        final Compiler compiler = this;
        return new Supplier<String>(){

            public String get() {
                return String.valueOf(compiler.nextUniqueNameId());
            }
        };
    }

    @Override
    boolean areNodesEqualForInlining(Node node, Node node2) {
        if (this.options.ambiguateProperties || this.options.disambiguateProperties) {
            return node.checkTreeTypeAwareEqualsSilent(node2);
        }
        return node.checkTreeEqualsSilent(node2);
    }

    @Override
    public CompilerInput getInput(String string) {
        return this.inputsByName.get(string);
    }

    @Override
    public CompilerInput newExternInput(String string) {
        if (this.inputsByName.containsKey(string)) {
            throw new IllegalArgumentException("Conflicting externs name: " + string);
        }
        SyntheticAst syntheticAst = new SyntheticAst(string);
        CompilerInput compilerInput = new CompilerInput(syntheticAst, string, true);
        this.inputsByName.put(string, compilerInput);
        this.externsRoot.addChildToFront(syntheticAst.getAstRoot(this));
        return compilerInput;
    }

    void addIncrementalSourceAst(JsAst jsAst) {
        String string = jsAst.getSourceFile().getName();
        Preconditions.checkState((this.getInput(string) == null ? 1 : 0) != 0, (Object)("Duplicate input of name " + string));
        this.inputsByName.put(string, new CompilerInput(jsAst));
    }

    boolean replaceIncrementalSourceAst(JsAst jsAst) {
        String string = jsAst.getSourceFile().getName();
        CompilerInput compilerInput = (CompilerInput)Preconditions.checkNotNull((Object)this.getInput(string), (Object)("No input to replace: " + string));
        Node node = jsAst.getAstRoot(this);
        if (node == null) {
            return false;
        }
        Node node2 = compilerInput.getAstRoot(this);
        if (node2 != null) {
            node2.getParent().replaceChild(node2, node);
        } else {
            this.getRoot().getLastChild().addChildToBack(node);
        }
        this.inputsByName.put(string, new CompilerInput(jsAst));
        return true;
    }

    @Override
    JSModuleGraph getModuleGraph() {
        return this.moduleGraph;
    }

    @Override
    public JSTypeRegistry getTypeRegistry() {
        if (this.typeRegistry == null) {
            this.typeRegistry = new JSTypeRegistry(this.oldErrorReporter, this.options.looseTypes);
        }
        return this.typeRegistry;
    }

    @Override
    ScopeCreator getScopeCreator() {
        return this.getPassConfig().getScopeCreator();
    }

    @Override
    public Scope getTopScope() {
        return this.getPassConfig().getTopScope();
    }

    @Override
    public ReverseAbstractInterpreter getReverseAbstractInterpreter() {
        if (this.abstractInterpreter == null) {
            ChainableReverseAbstractInterpreter chainableReverseAbstractInterpreter = new SemanticReverseAbstractInterpreter(this.getCodingConvention(), this.getTypeRegistry());
            if (this.options.closurePass) {
                chainableReverseAbstractInterpreter = new ClosureReverseAbstractInterpreter(this.getCodingConvention(), this.getTypeRegistry()).append(chainableReverseAbstractInterpreter).getFirst();
            }
            this.abstractInterpreter = chainableReverseAbstractInterpreter;
        }
        return this.abstractInterpreter;
    }

    @Override
    TypeValidator getTypeValidator() {
        if (this.typeValidator == null) {
            this.typeValidator = new TypeValidator(this);
        }
        return this.typeValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    Node parseInputs() {
        boolean bl;
        boolean bl2 = bl = this.options.devMode != CompilerOptions.DevMode.OFF;
        if (this.externsRoot != null) {
            this.externsRoot.detachChildren();
        }
        if (this.jsRoot != null) {
            this.jsRoot.detachChildren();
        }
        this.jsRoot = new Node(125);
        this.jsRoot.setIsSyntheticBlock(true);
        if (this.options.tracer.isOn()) {
            this.tracker = new PerformanceTracker(this.jsRoot, this.options.tracer == CompilerOptions.TracerMode.ALL);
            this.addChangeHandler(this.tracker.getCodeChangeHandler());
        }
        Tracer tracer = this.newTracer("parseInputs");
        try {
            Object object;
            Object object22;
            Object object32;
            this.externsRoot = new Node(125);
            this.externsRoot.setIsSyntheticBlock(true);
            for (Object object32 : this.externs) {
                Object object4 = ((CompilerInput)object32).getAstRoot(this);
                if (this.hasErrors()) {
                    Node node = null;
                    return node;
                }
                this.externsRoot.addChildToBack((Node)object4);
            }
            if (this.options.manageClosureDependencies) {
                for (Object object32 : this.inputs) {
                    ((CompilerInput)object32).setCompiler(this);
                    for (Object object22 : ((CompilerInput)object32).getProvides()) {
                        this.getTypeRegistry().forwardDeclareType((String)object22);
                    }
                }
                try {
                    this.inputs = (this.moduleGraph == null ? new JSModuleGraph(this.modules) : this.moduleGraph).manageDependencies(this.options.manageClosureDependenciesEntryPoints, this.inputs);
                }
                catch (SortedDependencies.CircularDependencyException circularDependencyException) {
                    this.report(JSError.make(JSModule.CIRCULAR_DEPENDENCY_ERROR, circularDependencyException.getMessage()));
                    object32 = null;
                    this.stopTracer(tracer, "parseInputs");
                    return object32;
                }
                catch (SortedDependencies.MissingProvideException missingProvideException) {
                    this.report(JSError.make(MISSING_ENTRY_ERROR, missingProvideException.getMessage()));
                    object32 = null;
                    this.stopTracer(tracer, "parseInputs");
                    return object32;
                }
            }
            boolean bl3 = false;
            for (Object object4 : this.inputs) {
                object22 = ((CompilerInput)object4).getAstRoot(this);
                if (this.hasErrors()) {
                    object = null;
                    return object;
                }
                if (object22 == null || ((Node)object22).getJSDocInfo() == null) continue;
                object = ((Node)object22).getJSDocInfo();
                if (((JSDocInfo)object).isExterns()) {
                    this.externsRoot.addChildToBack((Node)object22);
                    ((CompilerInput)object4).setIsExtern(true);
                    ((CompilerInput)object4).getModule().remove((CompilerInput)object4);
                    this.externs.add((CompilerInput)object4);
                    bl3 = true;
                    continue;
                }
                if (!((JSDocInfo)object).isNoCompile()) continue;
                ((CompilerInput)object4).getModule().remove((CompilerInput)object4);
                bl3 = true;
            }
            if (bl3) {
                Compiler.fillEmptyModules(this.modules);
                this.rebuildInputsFromModules();
            }
            for (Object object4 : this.inputs) {
                object22 = ((CompilerInput)object4).getAstRoot(this);
                if (object22 == null) continue;
                if (bl) {
                    this.runSanityCheck();
                    if (this.hasErrors()) {
                        object = null;
                        return object;
                    }
                }
                if (this.options.sourceMapOutputPath != null || this.options.nameReferenceReportPath != null) {
                    object = new SourceInformationAnnotator(((CompilerInput)object4).getName(), this.options.devMode != CompilerOptions.DevMode.OFF);
                    NodeTraversal.traverse(this, (Node)object22, (NodeTraversal.Callback)object);
                }
                this.jsRoot.addChildToBack((Node)object22);
            }
            this.externAndJsRoot = new Node(125, this.externsRoot, this.jsRoot);
            this.externAndJsRoot.setIsSyntheticBlock(true);
            object32 = this.externAndJsRoot;
            return object32;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.stopTracer(tracer, "parseInputs");
        }
    }

    public Node parse(JSSourceFile jSSourceFile) {
        this.initCompilerOptionsIfTesting();
        this.addToDebugLog("Parsing: " + jSSourceFile.getName());
        return new JsAst(jSSourceFile).getAstRoot(this);
    }

    @Override
    Node parseSyntheticCode(String string) {
        CompilerInput compilerInput = new CompilerInput(JSSourceFile.fromCode(" [synthetic] ", string));
        this.inputsByName.put(compilerInput.getName(), compilerInput);
        return compilerInput.getAstRoot(this);
    }

    void initCompilerOptionsIfTesting() {
        if (this.options == null) {
            this.initOptions(new CompilerOptions());
        }
    }

    @Override
    Node parseSyntheticCode(String string, String string2) {
        this.initCompilerOptionsIfTesting();
        return this.parse(JSSourceFile.fromCode(string, string2));
    }

    @Override
    Node parseTestCode(String string) {
        this.initCompilerOptionsIfTesting();
        CompilerInput compilerInput = new CompilerInput(JSSourceFile.fromCode(" [testcode] ", string));
        if (this.inputsByName == null) {
            this.inputsByName = Maps.newHashMap();
        }
        this.inputsByName.put(compilerInput.getName(), compilerInput);
        return compilerInput.getAstRoot(this);
    }

    @Override
    ErrorReporter getDefaultErrorReporter() {
        return this.defaultErrorReporter;
    }

    public String toSource() {
        return this.runInCompilerThread(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                Tracer tracer = Compiler.this.newTracer("toSource");
                try {
                    CodeBuilder codeBuilder = new CodeBuilder();
                    if (Compiler.this.jsRoot != null) {
                        int n = 0;
                        for (Node node = Compiler.this.jsRoot.getFirstChild(); node != null; node = node.getNext()) {
                            Compiler.this.toSource(codeBuilder, n++, node);
                        }
                    }
                    String string = codeBuilder.toString();
                    return string;
                }
                finally {
                    Compiler.this.stopTracer(tracer, "toSource");
                }
            }
        });
    }

    public String[] toSourceArray() {
        return this.runInCompilerThread(new Callable<String[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] call() throws Exception {
                Tracer tracer = Compiler.this.newTracer("toSourceArray");
                try {
                    int n = Compiler.this.inputs.size();
                    String[] stringArray = new String[n];
                    CodeBuilder codeBuilder = new CodeBuilder();
                    for (int i = 0; i < n; ++i) {
                        Node node = ((CompilerInput)Compiler.this.inputs.get(i)).getAstRoot(Compiler.this);
                        codeBuilder.reset();
                        Compiler.this.toSource(codeBuilder, i, node);
                        stringArray[i] = codeBuilder.toString();
                    }
                    String[] stringArray2 = stringArray;
                    return stringArray2;
                }
                finally {
                    Compiler.this.stopTracer(tracer, "toSourceArray");
                }
            }
        });
    }

    public String toSource(final JSModule jSModule) {
        return this.runInCompilerThread(new Callable<String>(){

            @Override
            public String call() throws Exception {
                List<CompilerInput> list = jSModule.getInputs();
                int n = list.size();
                if (n == 0) {
                    return "";
                }
                CodeBuilder codeBuilder = new CodeBuilder();
                for (int i = 0; i < n; ++i) {
                    Node node = list.get(i).getAstRoot(Compiler.this);
                    if (node == null) {
                        throw new IllegalArgumentException("Bad module: " + jSModule.getName());
                    }
                    Compiler.this.toSource(codeBuilder, i, node);
                }
                return codeBuilder.toString();
            }
        });
    }

    public String[] toSourceArray(final JSModule jSModule) {
        return this.runInCompilerThread(new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                List<CompilerInput> list = jSModule.getInputs();
                int n = list.size();
                if (n == 0) {
                    return new String[0];
                }
                String[] stringArray = new String[n];
                CodeBuilder codeBuilder = new CodeBuilder();
                for (int i = 0; i < n; ++i) {
                    Node node = list.get(i).getAstRoot(Compiler.this);
                    if (node == null) {
                        throw new IllegalArgumentException("Bad module input: " + list.get(i).getName());
                    }
                    codeBuilder.reset();
                    Compiler.this.toSource(codeBuilder, i, node);
                    stringArray[i] = codeBuilder.toString();
                }
                return stringArray;
            }
        });
    }

    public void toSource(final CodeBuilder codeBuilder, final int n, final Node node) {
        this.runInCompilerThread(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String string;
                if (Compiler.this.options.printInputDelimiter) {
                    if (codeBuilder.getLength() > 0 && !codeBuilder.endsWith("\n")) {
                        codeBuilder.append("\n");
                    }
                    Preconditions.checkState((node.getType() == 132 ? 1 : 0) != 0);
                    string = Compiler.this.options.inputDelimiter;
                    String string2 = (String)node.getProp(16);
                    Preconditions.checkState((string2 != null ? 1 : 0) != 0);
                    Preconditions.checkState((!string2.isEmpty() ? 1 : 0) != 0);
                    string = string.replaceAll("%name%", string2).replaceAll("%num%", String.valueOf(n));
                    codeBuilder.append(string).append("\n");
                }
                if (node.getJSDocInfo() != null && node.getJSDocInfo().getLicense() != null) {
                    codeBuilder.append("/*\n").append(node.getJSDocInfo().getLicense()).append("*/\n");
                }
                if (Compiler.this.options.sourceMapOutputPath != null) {
                    Compiler.this.sourceMap.setStartingPosition(codeBuilder.getLineIndex(), codeBuilder.getColumnIndex());
                }
                if (!(string = Compiler.this.toSource(node, Compiler.this.sourceMap)).isEmpty()) {
                    boolean bl;
                    codeBuilder.append(string);
                    int n2 = string.length();
                    char c = string.charAt(n2 - 1);
                    char c2 = n2 >= 2 ? string.charAt(n2 - 2) : (char)'\u0000';
                    boolean bl2 = bl = c == ';' || c == '\n' && c2 == ';';
                    if (!bl) {
                        codeBuilder.append(";");
                    }
                }
                return null;
            }
        });
    }

    @Override
    String toSource(Node node) {
        this.initCompilerOptionsIfTesting();
        return this.toSource(node, null);
    }

    private String toSource(Node node, SourceMap sourceMap) {
        CodePrinter.Builder builder = new CodePrinter.Builder(node);
        builder.setPrettyPrint(this.options.prettyPrint);
        builder.setLineBreak(this.options.lineBreak);
        builder.setSourceMap(sourceMap);
        builder.setSourceMapDetailLevel(this.options.sourceMapDetailLevel);
        Charset charset = this.options.outputCharset != null ? Charset.forName(this.options.outputCharset) : null;
        builder.setOutputCharset(charset);
        return builder.build();
    }

    public void optimize() {
        this.normalize();
        PhaseOptimizer phaseOptimizer = new PhaseOptimizer(this, this.tracker);
        if (this.options.devMode == CompilerOptions.DevMode.EVERY_PASS) {
            phaseOptimizer.setSanityCheck(this.sanityCheck);
        }
        phaseOptimizer.consume(this.getPassConfig().getOptimizations());
        phaseOptimizer.process(this.externsRoot, this.jsRoot);
        if (this.hasErrors()) {
            return;
        }
    }

    @Override
    void setCssRenamingMap(CssRenamingMap cssRenamingMap) {
        this.options.cssRenamingMap = cssRenamingMap;
    }

    @Override
    CssRenamingMap getCssRenamingMap() {
        return this.options.cssRenamingMap;
    }

    public void processDefines() {
        new DefaultPassConfig((CompilerOptions)this.options).processDefines.create(this).process(this.externsRoot, this.jsRoot);
    }

    boolean isInliningForbidden() {
        return this.options.propertyRenaming == PropertyRenamingPolicy.HEURISTIC || this.options.propertyRenaming == PropertyRenamingPolicy.AGGRESSIVE_HEURISTIC;
    }

    ControlFlowGraph<Node> computeCFG() {
        logger.info("Computing Control Flow Graph");
        Tracer tracer = this.newTracer("computeCFG");
        ControlFlowAnalysis controlFlowAnalysis = new ControlFlowAnalysis(this, true, false);
        this.process(controlFlowAnalysis);
        this.stopTracer(tracer, "computeCFG");
        return controlFlowAnalysis.getCfg();
    }

    public void normalize() {
        logger.info("Normalizing");
        this.startPass("normalize");
        this.process(new Normalize(this, false));
        this.endPass();
    }

    @Override
    void prepareAst(Node node) {
        Tracer tracer = this.newTracer("prepareAst");
        PrepareAst prepareAst = new PrepareAst(this);
        prepareAst.process(null, node);
        this.stopTracer(tracer, "prepareAst");
    }

    void recordFunctionInformation() {
        logger.info("Recording function information");
        this.startPass("recordFunctionInformation");
        RecordFunctionInformation recordFunctionInformation = new RecordFunctionInformation(this, this.getPassConfig().getIntermediateState().functionNames);
        this.process(recordFunctionInformation);
        this.functionInformationMap = recordFunctionInformation.getMap();
        this.endPass();
    }

    @Override
    void addChangeHandler(CodeChangeHandler codeChangeHandler) {
        this.codeChangeHandlers.add(codeChangeHandler);
    }

    @Override
    void removeChangeHandler(CodeChangeHandler codeChangeHandler) {
        this.codeChangeHandlers.remove(codeChangeHandler);
    }

    @Override
    public void reportCodeChange() {
        for (CodeChangeHandler codeChangeHandler : this.codeChangeHandlers) {
            codeChangeHandler.reportChange();
        }
    }

    @Override
    public CodingConvention getCodingConvention() {
        CodingConvention codingConvention = this.options.getCodingConvention();
        codingConvention = codingConvention != null ? codingConvention : this.defaultCodingConvention;
        return codingConvention;
    }

    @Override
    public boolean isIdeMode() {
        return this.options.ideMode;
    }

    @Override
    public boolean acceptEcmaScript5() {
        return this.options.languageIn == CompilerOptions.LanguageMode.ECMASCRIPT5;
    }

    @Override
    Config getParserConfig() {
        if (this.parserConfig == null) {
            this.parserConfig = ParserRunner.createConfig(this.isIdeMode(), this.acceptEcmaScript5());
        }
        return this.parserConfig;
    }

    @Override
    public boolean isTypeCheckingEnabled() {
        return this.options.checkTypes;
    }

    protected DiagnosticGroups getDiagnosticGroups() {
        return new DiagnosticGroups();
    }

    @Override
    public void report(JSError jSError) {
        CheckLevel checkLevel;
        CheckLevel checkLevel2 = jSError.level;
        if (this.warningsGuard != null && (checkLevel = this.warningsGuard.level(jSError)) != null) {
            checkLevel2 = checkLevel;
        }
        if (checkLevel2.isOn()) {
            this.errorManager.report(checkLevel2, jSError);
        }
    }

    @Override
    public CheckLevel getErrorLevel(JSError jSError) {
        Preconditions.checkNotNull((Object)this.options);
        WarningsGuard warningsGuard = this.options.getWarningsGuard();
        if (warningsGuard == null) {
            return jSError.level;
        }
        return warningsGuard.level(jSError);
    }

    @Override
    void throwInternalError(String string, Exception exception) {
        String string2 = "INTERNAL COMPILER ERROR.\nPlease report this problem.\n" + string;
        RuntimeException runtimeException = new RuntimeException(string2, exception);
        if (exception != null) {
            runtimeException.setStackTrace(exception.getStackTrace());
        }
        throw runtimeException;
    }

    public int getErrorCount() {
        return this.errorManager.getErrorCount();
    }

    public int getWarningCount() {
        return this.errorManager.getWarningCount();
    }

    @Override
    boolean hasHaltingErrors() {
        return !this.isIdeMode() && this.getErrorCount() > 0;
    }

    public boolean hasErrors() {
        return this.hasHaltingErrors();
    }

    @Override
    void addToDebugLog(String string) {
        this.debugLog.append(string);
        this.debugLog.append('\n');
        logger.fine(string);
    }

    private SourceFile getSourceFileByName(String string) {
        if (this.inputsByName.containsKey(string)) {
            return this.inputsByName.get(string).getSourceFile();
        }
        return null;
    }

    @Override
    public String getSourceLine(String string, int n) {
        if (n < 1) {
            return null;
        }
        SourceFile sourceFile = this.getSourceFileByName(string);
        if (sourceFile != null) {
            return sourceFile.getLine(n);
        }
        return null;
    }

    @Override
    public Region getSourceRegion(String string, int n) {
        if (n < 1) {
            return null;
        }
        SourceFile sourceFile = this.getSourceFileByName(string);
        if (sourceFile != null) {
            return sourceFile.getRegion(n);
        }
        return null;
    }

    @Override
    Node getNodeForCodeInsertion(JSModule jSModule) {
        if (jSModule == null) {
            if (this.inputs.isEmpty()) {
                throw new IllegalStateException("No inputs");
            }
            return this.inputs.get(0).getAstRoot(this);
        }
        List<CompilerInput> list = jSModule.getInputs();
        if (list.size() > 0) {
            return list.get(0).getAstRoot(this);
        }
        throw new IllegalStateException("Root module has no inputs");
    }

    public SourceMap getSourceMap() {
        return this.sourceMap;
    }

    VariableMap getVariableMap() {
        return this.getPassConfig().getIntermediateState().variableMap;
    }

    VariableMap getPropertyMap() {
        return this.getPassConfig().getIntermediateState().propertyMap;
    }

    CompilerOptions getOptions() {
        return this.options;
    }

    FunctionInformationMap getFunctionalInformationMap() {
        return this.functionInformationMap;
    }

    public static void setLoggingLevel(Level level) {
        logger.setLevel(level);
    }

    public String getAstDotGraph() throws IOException {
        if (this.jsRoot != null) {
            ControlFlowAnalysis controlFlowAnalysis = new ControlFlowAnalysis(this, true, false);
            controlFlowAnalysis.process(null, this.jsRoot);
            return DotFormatter.toDot(this.jsRoot, controlFlowAnalysis.getCfg());
        }
        return "";
    }

    @Override
    public ErrorManager getErrorManager() {
        if (this.options == null) {
            this.initOptions(new CompilerOptions());
        }
        return this.errorManager;
    }

    @Override
    List<CompilerInput> getInputsInOrder() {
        return Collections.unmodifiableList(this.inputs);
    }

    public IntermediateState getState() {
        IntermediateState intermediateState = new IntermediateState();
        intermediateState.externsRoot = this.externsRoot;
        intermediateState.jsRoot = this.jsRoot;
        intermediateState.externs = this.externs;
        intermediateState.inputs = this.inputs;
        intermediateState.modules = this.modules;
        intermediateState.passConfigState = this.getPassConfig().getIntermediateState();
        intermediateState.typeRegistry = this.typeRegistry;
        intermediateState.lifeCycleStage = this.getLifeCycleStage();
        return intermediateState;
    }

    public void setState(IntermediateState intermediateState) {
        this.externsRoot = intermediateState.externsRoot;
        this.jsRoot = intermediateState.jsRoot;
        this.externs = intermediateState.externs;
        this.inputs = intermediateState.inputs;
        this.modules = intermediateState.modules;
        this.passes = this.createPassConfigInternal();
        this.getPassConfig().setIntermediateState(intermediateState.passConfigState);
        this.typeRegistry = intermediateState.typeRegistry;
        this.setLifeCycleStage(intermediateState.lifeCycleStage);
    }

    @VisibleForTesting
    List<CompilerInput> getInputsForTesting() {
        return this.inputs;
    }

    @VisibleForTesting
    List<CompilerInput> getExternsForTesting() {
        return this.externs;
    }

    @Override
    boolean hasRegExpGlobalReferences() {
        return this.hasRegExpGlobalReferences;
    }

    @Override
    void setHasRegExpGlobalReferences(boolean bl) {
        this.hasRegExpGlobalReferences = bl;
    }

    public static class IntermediateState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Node externsRoot;
        private Node jsRoot;
        private List<CompilerInput> externs;
        private List<CompilerInput> inputs;
        private List<JSModule> modules;
        private PassConfig.State passConfigState;
        private JSTypeRegistry typeRegistry;
        private AbstractCompiler.LifeCycleStage lifeCycleStage;

        private IntermediateState() {
        }
    }

    public static class CodeBuilder {
        private final StringBuilder sb = new StringBuilder();
        private int lineCount = 0;
        private int colCount = 0;

        void reset() {
            this.sb.setLength(0);
        }

        CodeBuilder append(String string) {
            int n;
            this.sb.append(string);
            int n2 = n = -1;
            while ((n = string.indexOf(10, n + 1)) >= 0) {
                ++this.lineCount;
                n2 = n;
            }
            this.colCount = n2 == -1 ? (this.colCount += string.length()) : string.length() - (n2 + 1);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }

        public int getLength() {
            return this.sb.length();
        }

        int getLineIndex() {
            return this.lineCount;
        }

        int getColumnIndex() {
            return this.colCount;
        }

        boolean endsWith(String string) {
            return this.sb.length() > string.length() && string.equals(this.sb.substring(this.sb.length() - string.length()));
        }
    }
}

