/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Position;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.TypedCodeGenerator;
import com.google.javascript.rhino.Node;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

class CodePrinter {
    static final int DEFAULT_LINE_LENGTH_THRESHOLD = 500;

    CodePrinter() {
    }

    private static String toSource(Node node, Format format, boolean bl, int n, SourceMap sourceMap, SourceMap.DetailLevel detailLevel, Charset charset) {
        Preconditions.checkState((detailLevel != null ? 1 : 0) != 0);
        boolean bl2 = sourceMap != null;
        MappedCodePrinter mappedCodePrinter = format == Format.COMPACT ? new CompactCodePrinter(bl, n, bl2, detailLevel) : new PrettyCodePrinter(n, bl2, detailLevel);
        CodeGenerator codeGenerator = format == Format.TYPED ? new TypedCodeGenerator(mappedCodePrinter, charset) : new CodeGenerator(mappedCodePrinter, charset);
        codeGenerator.add(node);
        mappedCodePrinter.endFile();
        String string = mappedCodePrinter.getCode();
        if (bl2) {
            mappedCodePrinter.generateSourceMap(sourceMap);
        }
        return string;
    }

    static enum Format {
        COMPACT,
        PRETTY,
        TYPED;

    }

    static class Builder {
        private final Node root;
        private boolean prettyPrint = false;
        private boolean lineBreak = false;
        private boolean outputTypes = false;
        private int lineLengthThreshold = 500;
        private SourceMap sourceMap = null;
        private SourceMap.DetailLevel sourceMapDetailLevel = SourceMap.DetailLevel.ALL;
        private Charset outputCharset = null;

        Builder(Node node) {
            this.root = node;
        }

        Builder setPrettyPrint(boolean bl) {
            this.prettyPrint = bl;
            return this;
        }

        Builder setLineBreak(boolean bl) {
            this.lineBreak = bl;
            return this;
        }

        Builder setOutputTypes(boolean bl) {
            this.outputTypes = bl;
            return this;
        }

        Builder setLineLengthThreshold(int n) {
            this.lineLengthThreshold = n;
            return this;
        }

        Builder setSourceMap(SourceMap sourceMap) {
            this.sourceMap = sourceMap;
            return this;
        }

        Builder setSourceMapDetailLevel(SourceMap.DetailLevel detailLevel) {
            Preconditions.checkState((detailLevel != null ? 1 : 0) != 0);
            this.sourceMapDetailLevel = detailLevel;
            return this;
        }

        Builder setOutputCharset(Charset charset) {
            this.outputCharset = charset;
            return this;
        }

        String build() {
            if (this.root == null) {
                throw new IllegalStateException("Cannot build without root node being specified");
            }
            Format format = this.outputTypes ? Format.TYPED : (this.prettyPrint ? Format.PRETTY : Format.COMPACT);
            return CodePrinter.toSource(this.root, format, this.lineBreak, this.lineLengthThreshold, this.sourceMap, this.sourceMapDetailLevel, this.outputCharset);
        }
    }

    static class CompactCodePrinter
    extends MappedCodePrinter {
        private final boolean lineBreak;
        private int lineStartPosition = 0;
        private int preferredBreakPosition = 0;

        private CompactCodePrinter(boolean bl, int n, boolean bl2, SourceMap.DetailLevel detailLevel) {
            super(n, bl2, detailLevel);
            this.lineBreak = bl;
        }

        @Override
        void append(String string) {
            this.code.append(string);
            this.lineLength += string.length();
        }

        @Override
        void startNewLine() {
            if (this.lineLength > 0) {
                this.code.append('\n');
                this.lineLength = 0;
                ++this.lineIndex;
                this.lineStartPosition = this.code.length();
            }
        }

        @Override
        void maybeLineBreak() {
            char c;
            int n;
            if (this.lineBreak && this.sawFunction) {
                this.startNewLine();
                this.sawFunction = false;
            }
            if (this.preferredBreakPosition == (n = this.code.length()) - 1 && (c = this.code.charAt(n - 1)) == ';') {
                this.preferredBreakPosition = n;
            }
            this.maybeCutLine();
        }

        @Override
        void maybeCutLine() {
            if (this.lineLength > this.lineLengthThreshold) {
                if (this.preferredBreakPosition > this.lineStartPosition && this.preferredBreakPosition < this.lineStartPosition + this.lineLength) {
                    int n = this.preferredBreakPosition;
                    this.code.insert(n, '\n');
                    this.reportLineCut(this.lineIndex, n - this.lineStartPosition);
                    ++this.lineIndex;
                    this.lineLength -= n - this.lineStartPosition;
                    this.lineStartPosition = n + 1;
                } else {
                    this.startNewLine();
                }
            }
        }

        @Override
        void notePreferredLineBreak() {
            this.preferredBreakPosition = this.code.length();
        }
    }

    static class PrettyCodePrinter
    extends MappedCodePrinter {
        static final String INDENT = "  ";
        private int indent = 0;

        private PrettyCodePrinter(int n, boolean bl, SourceMap.DetailLevel detailLevel) {
            super(n, bl, detailLevel);
        }

        @Override
        void append(String string) {
            if (this.lineLength == 0) {
                for (int i = 0; i < this.indent; ++i) {
                    this.code.append(INDENT);
                    this.lineLength += INDENT.length();
                }
            }
            this.code.append(string);
            this.lineLength += string.length();
        }

        @Override
        void startNewLine() {
            if (this.lineLength > 0) {
                this.code.append('\n');
                ++this.lineIndex;
                this.lineLength = 0;
            }
        }

        @Override
        void maybeLineBreak() {
            this.maybeCutLine();
        }

        @Override
        void maybeCutLine() {
            if (this.lineLength > this.lineLengthThreshold) {
                this.startNewLine();
            }
        }

        @Override
        void endLine() {
            this.startNewLine();
        }

        @Override
        void appendBlockStart() {
            this.append(" {");
            ++this.indent;
        }

        @Override
        void appendBlockEnd() {
            this.endLine();
            --this.indent;
            this.append("}");
        }

        @Override
        void listSeparator() {
            this.add(", ");
            this.maybeLineBreak();
        }

        @Override
        void endFunction(boolean bl) {
            super.endFunction(bl);
            if (bl) {
                this.startNewLine();
            }
        }

        @Override
        void beginCaseBody() {
            super.beginCaseBody();
            ++this.indent;
            this.endLine();
        }

        @Override
        void endCaseBody() {
            super.endCaseBody();
            --this.indent;
            this.endStatement();
        }

        @Override
        void appendOp(String string, boolean bl) {
            if (bl) {
                if (this.getLastChar() != ' ') {
                    this.append(" ");
                }
                this.append(string);
                this.append(" ");
            } else {
                this.append(string);
            }
        }

        @Override
        boolean shouldPreserveExtraBlocks() {
            return true;
        }

        private Node getTryForCatch(Node node) {
            return node.getParent().getParent();
        }

        @Override
        boolean breakAfterBlockFor(Node node, boolean bl) {
            Preconditions.checkState((node.getType() == 125 ? 1 : 0) != 0);
            Node node2 = node.getParent();
            if (node2 != null) {
                int n = node2.getType();
                switch (n) {
                    case 114: {
                        return false;
                    }
                    case 105: {
                        return false;
                    }
                    case 77: {
                        return node != node2.getFirstChild();
                    }
                    case 120: {
                        return !NodeUtil.hasFinally(this.getTryForCatch(node2));
                    }
                    case 108: {
                        return node == node2.getLastChild();
                    }
                }
            }
            return true;
        }

        @Override
        void endFile() {
            this.maybeEndStatement();
        }
    }

    private static abstract class MappedCodePrinter
    extends CodeConsumer {
        private final Deque<Mapping> mappings;
        private final List<Mapping> allMappings;
        private final boolean createSrcMap;
        private final SourceMap.DetailLevel sourceMapDetailLevel;
        protected final StringBuilder code = new StringBuilder(1024);
        protected final int lineLengthThreshold;
        protected int lineLength = 0;
        protected int lineIndex = 0;

        MappedCodePrinter(int n, boolean bl, SourceMap.DetailLevel detailLevel) {
            Preconditions.checkState((detailLevel != null ? 1 : 0) != 0);
            this.lineLengthThreshold = n;
            this.createSrcMap = bl;
            this.sourceMapDetailLevel = detailLevel;
            this.mappings = bl ? new ArrayDeque() : null;
            this.allMappings = bl ? new ArrayList() : null;
        }

        @Override
        void startSourceMapping(Node node) {
            Preconditions.checkState((this.sourceMapDetailLevel != null ? 1 : 0) != 0);
            Preconditions.checkState((node != null ? 1 : 0) != 0);
            if (this.createSrcMap && node.getProp(16) != null && node.getLineno() > 0 && this.sourceMapDetailLevel.apply(node)) {
                int n = this.getCurrentLineIndex();
                int n2 = this.getCurrentCharIndex();
                Preconditions.checkState((n >= 0 ? 1 : 0) != 0);
                Mapping mapping = new Mapping();
                mapping.node = node;
                mapping.start = new Position(n, n2);
                this.mappings.push(mapping);
                this.allMappings.add(mapping);
            }
        }

        @Override
        void endSourceMapping(Node node) {
            if (this.createSrcMap && !this.mappings.isEmpty() && this.mappings.peek().node == node) {
                Mapping mapping = this.mappings.pop();
                int n = this.getCurrentLineIndex();
                int n2 = this.getCurrentCharIndex();
                Preconditions.checkState((n >= 0 ? 1 : 0) != 0);
                mapping.end = new Position(n, n2);
            }
        }

        void generateSourceMap(SourceMap sourceMap) {
            if (this.createSrcMap) {
                for (Mapping mapping : this.allMappings) {
                    sourceMap.addMapping(mapping.node, mapping.start, mapping.end);
                }
            }
        }

        void reportLineCut(int n, int n2) {
            if (this.createSrcMap) {
                for (Mapping mapping : this.allMappings) {
                    mapping.start = this.convertPosition(mapping.start, n, n2);
                    if (mapping.end == null) continue;
                    mapping.end = this.convertPosition(mapping.end, n, n2);
                }
            }
        }

        private Position convertPosition(Position position, int n, int n2) {
            int n3 = position.getLineNumber();
            int n4 = position.getCharacterIndex();
            if (n3 == n && n4 >= n2) {
                return new Position(n3 + 1, n4 - n2);
            }
            return position;
        }

        public String getCode() {
            return this.code.toString();
        }

        @Override
        char getLastChar() {
            return this.code.length() > 0 ? this.code.charAt(this.code.length() - 1) : (char)'\u0000';
        }

        protected final int getCurrentCharIndex() {
            return this.lineLength;
        }

        protected final int getCurrentLineIndex() {
            return this.lineIndex;
        }

        private static class Mapping {
            Node node;
            Position start;
            Position end;

            private Mapping() {
            }
        }
    }
}

