/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;

class CheckPathsBetweenNodes<N, E> {
    private final Predicate<N> nodePredicate;
    private final Predicate<DiGraph.DiGraphEdge<N, E>> edgePredicate;
    private final boolean inclusive;
    private static final Annotation BACK_EDGE = new Annotation(){};
    private static final Annotation WHITE = null;
    private static final Annotation GRAY = new Annotation(){};
    private static final Annotation BLACK = new Annotation(){};
    private final DiGraph<N, E> graph;
    private final DiGraph.DiGraphNode<N, E> start;
    private final DiGraph.DiGraphNode<N, E> end;

    CheckPathsBetweenNodes(DiGraph<N, E> diGraph, DiGraph.DiGraphNode<N, E> diGraphNode, DiGraph.DiGraphNode<N, E> diGraphNode2, Predicate<N> predicate, Predicate<DiGraph.DiGraphEdge<N, E>> predicate2, boolean bl) {
        this.graph = diGraph;
        this.start = diGraphNode;
        this.end = diGraphNode2;
        this.nodePredicate = predicate;
        this.edgePredicate = predicate2;
        this.inclusive = bl;
    }

    CheckPathsBetweenNodes(DiGraph<N, E> diGraph, DiGraph.DiGraphNode<N, E> diGraphNode, DiGraph.DiGraphNode<N, E> diGraphNode2, Predicate<N> predicate, Predicate<DiGraph.DiGraphEdge<N, E>> predicate2) {
        this(diGraph, diGraphNode, diGraphNode2, predicate, predicate2, true);
    }

    public boolean allPathsSatisfyPredicate() {
        this.setUp();
        boolean bl = this.checkAllPathsWithoutBackEdges(this.start, this.end);
        this.tearDown();
        return bl;
    }

    public boolean somePathsSatisfyPredicate() {
        this.setUp();
        boolean bl = this.checkSomePathsWithoutBackEdges(this.start, this.end);
        this.tearDown();
        return bl;
    }

    private void setUp() {
        this.graph.pushNodeAnnotations();
        this.graph.pushEdgeAnnotations();
        this.discoverBackEdges(this.start);
    }

    private void tearDown() {
        this.graph.popNodeAnnotations();
        this.graph.popEdgeAnnotations();
    }

    private void discoverBackEdges(DiGraph.DiGraphNode<N, E> diGraphNode) {
        diGraphNode.setAnnotation(GRAY);
        for (DiGraph.DiGraphEdge<N, E> diGraphEdge : diGraphNode.getOutEdges()) {
            if (this.ignoreEdge(diGraphEdge)) continue;
            DiGraph.DiGraphNode<N, E> diGraphNode2 = diGraphEdge.getDestination();
            if (diGraphNode2.getAnnotation() == WHITE) {
                this.discoverBackEdges(diGraphNode2);
                continue;
            }
            if (diGraphNode2.getAnnotation() != GRAY) continue;
            diGraphEdge.setAnnotation(BACK_EDGE);
        }
        diGraphNode.setAnnotation(BLACK);
    }

    private boolean ignoreEdge(DiGraph.DiGraphEdge<N, E> diGraphEdge) {
        return !this.edgePredicate.apply(diGraphEdge);
    }

    private boolean checkAllPathsWithoutBackEdges(DiGraph.DiGraphNode<N, E> diGraphNode, DiGraph.DiGraphNode<N, E> diGraphNode2) {
        if (this.nodePredicate.apply(diGraphNode.getValue()) && (this.inclusive || diGraphNode != this.start && diGraphNode != this.end)) {
            return true;
        }
        if (diGraphNode == diGraphNode2) {
            return false;
        }
        for (DiGraph.DiGraphEdge<N, E> diGraphEdge : diGraphNode.getOutEdges()) {
            DiGraph.DiGraphNode<N, E> diGraphNode3;
            if (this.ignoreEdge(diGraphEdge) || diGraphEdge.getAnnotation() == BACK_EDGE || this.checkAllPathsWithoutBackEdges(diGraphNode3 = diGraphEdge.getDestination(), diGraphNode2)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSomePathsWithoutBackEdges(DiGraph.DiGraphNode<N, E> diGraphNode, DiGraph.DiGraphNode<N, E> diGraphNode2) {
        if (this.nodePredicate.apply(diGraphNode.getValue()) && (this.inclusive || diGraphNode != this.start && diGraphNode != this.end)) {
            return true;
        }
        if (diGraphNode == diGraphNode2) {
            return false;
        }
        for (DiGraph.DiGraphEdge<N, E> diGraphEdge : diGraphNode.getOutEdges()) {
            DiGraph.DiGraphNode<N, E> diGraphNode3;
            if (this.ignoreEdge(diGraphEdge) || diGraphEdge.getAnnotation() == BACK_EDGE || !this.checkSomePathsWithoutBackEdges(diGraphNode3 = diGraphEdge.getDestination(), diGraphNode2)) continue;
            return true;
        }
        return false;
    }
}

