/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Set;
import javax.annotation.Nullable;

class StripCode
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Set<String> stripTypes;
    private final Set<String> stripNameSuffixes;
    private final Set<String> stripTypePrefixes;
    private final Set<String> stripNamePrefixes;
    private final Set<Scope.Var> varsToRemove;
    static final DiagnosticType STRIP_TYPE_INHERIT_ERROR = DiagnosticType.error("JSC_STRIP_TYPE_INHERIT_ERROR", "Non-strip type {0} cannot inherit from strip type {1}");
    static final DiagnosticType STRIP_ASSIGNMENT_ERROR = DiagnosticType.error("JSC_STRIP_ASSIGNMENT_ERROR", "Unable to strip assignment to {0}");

    StripCode(AbstractCompiler abstractCompiler, Set<String> set, Set<String> set2, Set<String> set3, Set<String> set4) {
        this.compiler = abstractCompiler;
        this.stripTypes = set;
        this.stripNameSuffixes = set2;
        this.stripTypePrefixes = set3;
        this.stripNamePrefixes = set4;
        this.varsToRemove = Sets.newHashSet();
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, new Strip());
    }

    private class Strip
    extends NodeTraversal.AbstractPostOrderCallback {
        private Strip() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 118: {
                    this.removeVarDeclarationsByNameOrRvalue(nodeTraversal, node, node2);
                    break;
                }
                case 38: {
                    this.maybeRemoveReferenceToRemovedVariable(nodeTraversal, node, node2);
                    break;
                }
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: {
                    this.maybeEliminateAssignmentByLvalueName(nodeTraversal, node, node2);
                    break;
                }
                case 30: 
                case 37: {
                    this.maybeRemoveCall(nodeTraversal, node, node2);
                    break;
                }
                case 64: {
                    this.eliminateKeysWithStripNamesFromObjLit(nodeTraversal, node);
                    break;
                }
                case 130: {
                    this.maybeEliminateExpressionByName(nodeTraversal, node, node2);
                }
            }
        }

        void removeVarDeclarationsByNameOrRvalue(NodeTraversal nodeTraversal, Node node, Node node2) {
            for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                String string = node3.getString();
                if (!this.isStripName(string) && !this.isCallWhoseReturnValueShouldBeStripped(node3.getFirstChild())) continue;
                Scope scope = nodeTraversal.getScope();
                StripCode.this.varsToRemove.add(scope.getVar(string));
                node.removeChild(node3);
                StripCode.this.compiler.reportCodeChange();
            }
            if (!node.hasChildren()) {
                this.replaceWithEmpty(node, node2);
                StripCode.this.compiler.reportCodeChange();
            }
        }

        void maybeRemoveReferenceToRemovedVariable(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node2.getType()) {
                case 118: {
                    break;
                }
                case 33: 
                case 35: {
                    if (node2.getFirstChild() != node || !this.isReferenceToRemovedVar(nodeTraversal, node)) break;
                    this.replaceHighestNestedCallWithNull(node2, node2.getParent());
                    break;
                }
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: {
                    if (!this.isReferenceToRemovedVar(nodeTraversal, node)) break;
                    if (node2.getFirstChild() == node) {
                        Node node3 = node2.getParent();
                        if (NodeUtil.isExpressionNode(node3)) {
                            Node node4 = node3.getParent();
                            this.replaceWithEmpty(node3, node4);
                            StripCode.this.compiler.reportCodeChange();
                            break;
                        }
                        Node node5 = node.getNext();
                        node2.removeChild(node5);
                        node3.replaceChild(node2, node5);
                        StripCode.this.compiler.reportCodeChange();
                        break;
                    }
                    this.replaceWithNull(node, node2);
                    StripCode.this.compiler.reportCodeChange();
                    break;
                }
                default: {
                    if (!this.isReferenceToRemovedVar(nodeTraversal, node)) break;
                    this.replaceWithNull(node, node2);
                    StripCode.this.compiler.reportCodeChange();
                }
            }
        }

        void replaceHighestNestedCallWithNull(Node node, Node node2) {
            Node node3 = node2;
            Node node4 = node;
            while (true) {
                if (node3.getFirstChild() != node4) {
                    this.replaceWithNull(node4, node3);
                    break;
                }
                if (NodeUtil.isExpressionNode(node3)) {
                    Node node5 = node3.getParent();
                    this.replaceWithEmpty(node3, node5);
                    break;
                }
                int n = node3.getType();
                if (n != 33 && n != 35 && n != 37) {
                    this.replaceWithNull(node4, node3);
                    break;
                }
                node4 = node3;
                node3 = node3.getParent();
            }
            StripCode.this.compiler.reportCodeChange();
        }

        void maybeEliminateAssignmentByLvalueName(NodeTraversal nodeTraversal, Node node, Node node2) {
            Node node3 = node.getFirstChild();
            if (this.nameEndsWithFieldNameToStrip(node3) || this.qualifiedNameBeginsWithStripType(node3)) {
                if (NodeUtil.isExpressionNode(node2)) {
                    Node node4 = node2.getParent();
                    this.replaceWithEmpty(node2, node4);
                    StripCode.this.compiler.reportCodeChange();
                } else {
                    nodeTraversal.report(node, STRIP_ASSIGNMENT_ERROR, node3.getQualifiedName());
                }
            }
        }

        void maybeEliminateExpressionByName(NodeTraversal nodeTraversal, Node node, Node node2) {
            Node node3 = node.getFirstChild();
            if (this.nameEndsWithFieldNameToStrip(node3) || this.qualifiedNameBeginsWithStripType(node3)) {
                if (NodeUtil.isExpressionNode(node2)) {
                    Node node4 = node2.getParent();
                    this.replaceWithEmpty(node2, node4);
                } else {
                    this.replaceWithEmpty(node, node2);
                }
                StripCode.this.compiler.reportCodeChange();
            }
        }

        void maybeRemoveCall(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (this.isMethodOrCtorCallThatTriggersRemoval(nodeTraversal, node, node2)) {
                this.replaceHighestNestedCallWithNull(node, node2);
            }
        }

        void eliminateKeysWithStripNamesFromObjLit(NodeTraversal nodeTraversal, Node node) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getType() == 40 && this.isStripName(node2.getString())) {
                    Node node3 = node2.getFirstChild();
                    Node node4 = node2.getNext();
                    node.removeChild(node2);
                    node2 = node4;
                    StripCode.this.compiler.reportCodeChange();
                    continue;
                }
                node2 = node2.getNext();
            }
        }

        boolean isCallWhoseReturnValueShouldBeStripped(@Nullable Node node) {
            return !(node == null || node.getType() != 37 && node.getType() != 30 || !node.hasChildren() || !this.qualifiedNameBeginsWithStripType(node.getFirstChild()) && !this.nameEndsWithFieldNameToStrip(node.getFirstChild()));
        }

        boolean qualifiedNameBeginsWithStripType(Node node) {
            String string = node.getQualifiedName();
            return this.qualifiedNameBeginsWithStripType(string);
        }

        boolean qualifiedNameBeginsWithStripType(String string) {
            if (string != null) {
                for (String string2 : StripCode.this.stripTypes) {
                    if (!string.equals(string2) && !string.startsWith(string2 + ".")) continue;
                    return true;
                }
                for (String string2 : StripCode.this.stripTypePrefixes) {
                    if (!string.startsWith(string2)) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isReferenceToRemovedVar(NodeTraversal nodeTraversal, Node node) {
            String string = node.getString();
            Scope scope = nodeTraversal.getScope();
            Scope.Var var = scope.getVar(string);
            return StripCode.this.varsToRemove.contains(var);
        }

        boolean isMethodOrCtorCallThatTriggersRemoval(NodeTraversal nodeTraversal, Node node, Node node2) {
            Node node3;
            Node node4 = node.getFirstChild();
            if (node4 == null || node4.getType() != 33) {
                return false;
            }
            if (node2 != null && node2.getType() == 38 && (node3 = node2.getParent()) != null && node3.getType() == 118) {
                return false;
            }
            node3 = node4.getFirstChild();
            return this.nameEndsWithFieldNameToStrip(node3) || this.nameEndsWithFieldNameToStrip(node4) || this.qualifiedNameBeginsWithStripType(node4) || this.actsOnStripType(nodeTraversal, node);
        }

        boolean nameEndsWithFieldNameToStrip(@Nullable Node node) {
            if (node != null && node.getType() == 33) {
                Node node2 = node.getLastChild();
                return node2 != null && node2.getType() == 40 && this.isStripName(node2.getString());
            }
            return false;
        }

        private boolean actsOnStripType(NodeTraversal nodeTraversal, Node node) {
            CodingConvention.SubclassRelationship subclassRelationship = StripCode.this.compiler.getCodingConvention().getClassesDefinedByCall(node);
            if (subclassRelationship != null) {
                if (this.qualifiedNameBeginsWithStripType(subclassRelationship.subclassName)) {
                    return true;
                }
                if (this.qualifiedNameBeginsWithStripType(subclassRelationship.superclassName)) {
                    nodeTraversal.report(node, STRIP_TYPE_INHERIT_ERROR, subclassRelationship.subclassName, subclassRelationship.superclassName);
                }
            }
            return false;
        }

        boolean isStripName(String string) {
            if (StripCode.this.stripNameSuffixes.contains(string) || StripCode.this.stripNamePrefixes.contains(string)) {
                return true;
            }
            if (string.length() == 0 || Character.isUpperCase(string.charAt(0))) {
                return false;
            }
            String string2 = string.toLowerCase();
            for (String string3 : StripCode.this.stripNamePrefixes) {
                if (!string2.startsWith(string3.toLowerCase())) continue;
                return true;
            }
            for (String string3 : StripCode.this.stripNameSuffixes) {
                if (!string2.endsWith(string3.toLowerCase())) continue;
                return true;
            }
            return false;
        }

        void replaceWithNull(Node node, Node node2) {
            node2.replaceChild(node, new Node(41));
        }

        void replaceWithEmpty(Node node, Node node2) {
            NodeUtil.removeChild(node2, node);
        }
    }
}

