/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.rhino.Node;
import javax.annotation.Nullable;

public class JSError {
    private final DiagnosticType type;
    public final String description;
    public final String sourceName;
    final Node node;
    public final int lineNumber;
    @Deprecated
    public final CheckLevel level;
    private final CheckLevel defaultLevel;
    private final int charno;

    public static JSError make(DiagnosticType type, String ... arguments) {
        return new JSError(null, null, -1, -1, type, null, arguments);
    }

    public static JSError make(String sourceName, int lineno, int charno, DiagnosticType type, String ... arguments) {
        return new JSError(sourceName, null, lineno, charno, type, null, arguments);
    }

    public static JSError make(String sourceName, int lineno, int charno, CheckLevel level, DiagnosticType type, String ... arguments) {
        return new JSError(sourceName, null, lineno, charno, type, level, arguments);
    }

    public static JSError make(String sourceName, Node n, DiagnosticType type, String ... arguments) {
        return new JSError(sourceName, n, type, arguments);
    }

    public static JSError make(String sourceName, Node n, CheckLevel level, DiagnosticType type, String ... arguments) {
        return new JSError(sourceName, n, n.getLineno(), n.getCharno(), type, level, arguments);
    }

    private JSError(String sourceName, @Nullable Node node, int lineno, int charno, DiagnosticType type, CheckLevel level, String ... arguments) {
        this.type = type;
        this.node = node;
        this.description = type.format.format(arguments);
        this.lineNumber = lineno;
        this.charno = charno;
        this.sourceName = sourceName;
        this.defaultLevel = level == null ? type.level : level;
        this.level = level == null ? type.level : level;
    }

    private JSError(String sourceName, @Nullable Node node, DiagnosticType type, String ... arguments) {
        this(sourceName, node, node != null ? node.getLineno() : -1, node != null ? node.getCharno() : -1, type, null, arguments);
    }

    public DiagnosticType getType() {
        return this.type;
    }

    public String format(CheckLevel level, MessageFormatter formatter) {
        switch (level) {
            case ERROR: {
                return formatter.formatError(this);
            }
            case WARNING: {
                return formatter.formatWarning(this);
            }
        }
        return null;
    }

    public String toString() {
        return this.type.key + ". " + this.description + " at " + (this.sourceName != null && this.sourceName.length() > 0 ? this.sourceName : "(unknown source)") + " line " + (this.lineNumber != -1 ? String.valueOf(this.lineNumber) : "(unknown line)") + " : " + (this.charno != -1 ? String.valueOf(this.charno) : "(unknown column)");
    }

    public int getCharno() {
        return this.charno;
    }

    public int getNodeSourceOffset() {
        return this.node != null ? this.node.getSourceOffset() : -1;
    }

    public int getNodeLength() {
        return this.node != null ? this.node.getLength() : 0;
    }

    public CheckLevel getDefaultLevel() {
        return this.defaultLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSError jsError = (JSError)o;
        if (this.charno != jsError.charno) {
            return false;
        }
        if (this.lineNumber != jsError.lineNumber) {
            return false;
        }
        if (!this.description.equals(jsError.description)) {
            return false;
        }
        if (this.defaultLevel != jsError.defaultLevel) {
            return false;
        }
        if (this.sourceName != null ? !this.sourceName.equals(jsError.sourceName) : jsError.sourceName != null) {
            return false;
        }
        return this.type.equals(jsError.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + (this.sourceName != null ? this.sourceName.hashCode() : 0);
        result = 31 * result + this.lineNumber;
        result = 31 * result + this.defaultLevel.hashCode();
        result = 31 * result + this.charno;
        return result;
    }
}

