/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.sql;

import com.google.cloud.spring.autoconfigure.core.GcpProperties;
import com.google.cloud.spring.autoconfigure.sql.GcpCloudSqlProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.core.env.Environment;

class PropertiesRetriever {
    private Binder binder;

    PropertiesRetriever(Environment environment) {
        this.binder = new Binder(ConfigurationPropertySources.get((Environment)environment), (PlaceholdersResolver)new NonSecretsManagerPropertiesPlaceholdersResolver(environment), null, null, null);
    }

    GcpCloudSqlProperties getCloudSqlProperties() {
        String cloudSqlPropertiesPrefix = GcpCloudSqlProperties.class.getAnnotation(ConfigurationProperties.class).value();
        return (GcpCloudSqlProperties)this.binder.bind(cloudSqlPropertiesPrefix, GcpCloudSqlProperties.class).orElse((Object)new GcpCloudSqlProperties());
    }

    GcpProperties getGcpProperties() {
        String gcpPropertiesPrefix = GcpProperties.class.getAnnotation(ConfigurationProperties.class).value();
        return (GcpProperties)this.binder.bind(gcpPropertiesPrefix, GcpProperties.class).orElse((Object)new GcpProperties());
    }

    private static class NonSecretsManagerPropertiesPlaceholdersResolver
    implements PlaceholdersResolver {
        private PlaceholdersResolver resolver;

        NonSecretsManagerPropertiesPlaceholdersResolver(Environment environment) {
            this.resolver = new PropertySourcesPlaceholdersResolver(environment);
        }

        public Object resolvePlaceholders(Object value) {
            if (value.toString().contains("sm://")) {
                return value;
            }
            return this.resolver.resolvePlaceholders(value);
        }
    }
}

