/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base;

import com.google.appengine.repackaged.com.google.io.base.CoreMarshallers;
import com.google.appengine.repackaged.com.google.io.base.Marshaller;
import com.google.appengine.repackaged.com.google.io.base.VarInt;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Marshallers
extends CoreMarshallers {
    public static final Marshaller<String> UTF8_MARSHALLER = CoreMarshallers.UTF8_MARSHALLER;
    public static final Marshaller<String> ISO_8859_1_MARSHALLER = CoreMarshallers.ISO_8859_1_MARSHALLER;
    public static final Marshaller<String> US_ASCII_MARSHALLER = CoreMarshallers.US_ASCII_MARSHALLER;
    public static final Marshaller<Integer> STRING_INTEGER_MARSHALLER = CoreMarshallers.STRING_INTEGER_MARSHALLER;
    public static final Marshaller<Long> STRING_LONG_MARSHALLER = CoreMarshallers.STRING_LONG_MARSHALLER;
    public static final Marshaller<Float> FLOAT_MARSHALLER = CoreMarshallers.FLOAT_MARSHALLER;
    public static final Marshaller<Float> BIG_ENDIAN_FLOAT_MARSHALLER = CoreMarshallers.BIG_ENDIAN_FLOAT_MARSHALLER;
    public static final Marshaller<Double> DOUBLE_MARSHALLER = CoreMarshallers.DOUBLE_MARSHALLER;
    public static final Marshaller<Double> BIG_ENDIAN_DOUBLE_MARSHALLER = CoreMarshallers.BIG_ENDIAN_DOUBLE_MARSHALLER;
    public static final Marshaller<Integer> INTEGER_MARSHALLER = CoreMarshallers.INTEGER_MARSHALLER;
    public static final Marshaller<Integer> BIG_ENDIAN_INTEGER_MARSHALLER = CoreMarshallers.BIG_ENDIAN_INTEGER_MARSHALLER;
    public static final Marshaller<Short> SHORT_MARSHALLER = CoreMarshallers.SHORT_MARSHALLER;
    public static final Marshaller<Short> BIG_ENDIAN_SHORT_MARSHALLER = CoreMarshallers.BIG_ENDIAN_SHORT_MARSHALLER;
    public static final Marshaller<Long> LONG_MARSHALLER = CoreMarshallers.LONG_MARSHALLER;
    public static final Marshaller<Long> BIG_ENDIAN_LONG_MARSHALLER = CoreMarshallers.BIG_ENDIAN_LONG_MARSHALLER;
    public static final Marshaller<Double> STRING_DOUBLE_MARSHALLER = CoreMarshallers.STRING_DOUBLE_MARSHALLER;
    public static final Marshaller<Long> VAR_LONG_MARSHALLER = new VarLongMarshaller();
    public static final Marshaller<byte[]> BYTE_ARRAY_MARSHALLER = CoreMarshallers.BYTE_ARRAY_MARSHALLER;
    public static final Marshaller<byte[]> ALIASING_BYTE_ARRAY_MARSHALLER = CoreMarshallers.ALIASING_BYTE_ARRAY_MARSHALLER;
    public static final Marshaller<ByteBuffer> BYTE_BUFFER_MARSHALLER = CoreMarshallers.BYTE_BUFFER_MARSHALLER;
    public static final Marshaller<ByteBuffer> ALIASING_BYTE_BUFFER_MARSHALLER = CoreMarshallers.ALIASING_BYTE_BUFFER_MARSHALLER;

    private Marshallers() {
    }

    public static Marshaller<String> stringMarshaller(String encoding) {
        return CoreMarshallers.stringMarshaller(encoding);
    }

    public static <T extends ProtocolMessage<T>> Marshaller<T> protocolMessageMarshaller(T template) {
        return new SafeProtocolMessageMarshaller<T>(template);
    }

    public static <T extends ProtocolMessage<T>> Marshaller<T> recyclingProtocolMessageMarshaller(T template) {
        return new RecyclingProtocolMessageMarshaller<T>(template);
    }

    public static <T extends Serializable> Marshaller<T> serializationMarshaller() {
        return CoreMarshallers.serializationMarshaller();
    }

    public static <T> Marshaller<T> nullMarshaller() {
        return CoreMarshallers.nullMarshaller();
    }

    public static <T> byte[] toByteArray(Marshaller<T> marshaller, ByteOrder order, T object) {
        return CoreMarshallers.toByteArray(marshaller, order, object);
    }

    public static <T> byte[] toByteArray(Marshaller<T> marshaller, T object) {
        return CoreMarshallers.toByteArray(marshaller, object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VarLongMarshaller
    extends VariableSizeLocalMarshaller<Long> {
        private VarLongMarshaller() {
        }

        @Override
        public void marshal(Long object, ByteBuffer sink) {
            VarInt.putVarLong(object, sink);
        }

        @Override
        public Long unmarshal(ByteBuffer source) {
            return VarInt.getVarLong(source);
        }

        @Override
        public int maxEncodingSize(Long object) {
            return 10;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecyclingProtocolMessageMarshaller<T extends ProtocolMessage<T>>
    extends AbstractProtocolMessageMarshaller<T> {
        private static final long serialVersionUID = 1027309L;

        RecyclingProtocolMessageMarshaller(T template) {
            super(((ProtocolMessage)template).newInstance());
        }

        @Override
        public T unmarshal(ByteBuffer source) {
            this.template.parseFrom(source);
            return (T)this.template;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SafeProtocolMessageMarshaller<T extends ProtocolMessage<T>>
    extends AbstractProtocolMessageMarshaller<T> {
        private static final long serialVersionUID = 16435934L;

        SafeProtocolMessageMarshaller(T template) {
            super(template);
        }

        @Override
        public T unmarshal(ByteBuffer source) {
            Object result = this.template.newInstance();
            if (((ProtocolMessage)result).mergeFrom(source)) {
                return result;
            }
            throw new IllegalArgumentException("protocol message parse failed");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractProtocolMessageMarshaller<T extends ProtocolMessage<T>>
    extends VariableSizeMarshaller<T> {
        final T template;
        private static final long serialVersionUID = 233811181L;

        AbstractProtocolMessageMarshaller(T template) {
            this.template = template;
        }

        @Override
        public void marshal(T message, ByteBuffer sink) {
            ((ProtocolMessage)message).outputTo(sink);
        }

        @Override
        public int maxEncodingSize(T message) {
            return ((ProtocolMessage)message).maxEncodingSize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DelegatingMarshaller<T>
    extends CoreMarshallers.DelegatingMarshaller<T> {
        protected DelegatingMarshaller(Marshaller<T> delegate) {
            super(delegate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class VariableSizeMarshaller<T>
    extends CoreMarshallers.VariableSizeMarshaller<T> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class VariableSizeLocalMarshaller<T>
    extends CoreMarshallers.VariableSizeLocalMarshaller<T> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ConstantSizeMarshaller<T>
    extends CoreMarshallers.ConstantSizeMarshaller<T> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ConstantSizeLocalMarshaller<T>
    extends CoreMarshallers.ConstantSizeLocalMarshaller<T> {
    }
}

