/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend.system;

import com.google.appengine.repackaged.com.google.common.flogger.backend.LoggerBackend;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Platform;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Tags;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.BackendFactory;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.Clock;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.EmptyLoggingContext;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.LoggingContext;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.SimpleBackendFactory;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.StackBasedCallerFinder;
import com.google.appengine.repackaged.com.google.common.flogger.backend.system.SystemClock;
import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class DefaultPlatform
extends Platform {
    private static final String BACKEND_FACTORY = "backend_factory";
    private static final String LOGGING_CONTEXT = "logging_context";
    private static final String CLOCK = "clock";
    private final BackendFactory backendFactory;
    private final LoggingContext context;
    private final Clock clock;
    private final Platform.LogCallerFinder callerFinder;

    public DefaultPlatform() {
        BackendFactory factory = DefaultPlatform.resolveAttribute(BACKEND_FACTORY, BackendFactory.class);
        this.backendFactory = factory != null ? factory : SimpleBackendFactory.getInstance();
        LoggingContext context = DefaultPlatform.resolveAttribute(LOGGING_CONTEXT, LoggingContext.class);
        this.context = context != null ? context : EmptyLoggingContext.getInstance();
        Clock clock = DefaultPlatform.resolveAttribute(CLOCK, Clock.class);
        this.clock = clock != null ? clock : SystemClock.getInstance();
        this.callerFinder = StackBasedCallerFinder.getInstance();
    }

    DefaultPlatform(BackendFactory factory, LoggingContext context, Clock clock, Platform.LogCallerFinder callerFinder) {
        this.backendFactory = factory;
        this.context = context;
        this.clock = clock;
        this.callerFinder = callerFinder;
    }

    @Override
    protected Platform.LogCallerFinder getCallerFinderImpl() {
        return this.callerFinder;
    }

    @Override
    protected LoggerBackend getBackendImpl(String className) {
        return this.backendFactory.create(className);
    }

    @Override
    protected boolean shouldForceLoggingImpl(String loggerName, Level level, boolean isEnabled) {
        return this.context.shouldForceLogging(loggerName, level, isEnabled);
    }

    @Override
    protected Tags getInjectedTagsImpl() {
        return this.context.getTags();
    }

    @Override
    protected long getCurrentTimeNanosImpl() {
        return this.clock.getCurrentTimeNanos();
    }

    @Override
    protected String getConfigInfoImpl() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.backendFactory);
        String string3 = String.valueOf(this.clock);
        String string4 = String.valueOf(this.context);
        String string5 = String.valueOf(this.callerFinder);
        return new StringBuilder(71 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("Platform: ").append(string).append("\nBackendFactory: ").append(string2).append("\nClock: ").append(string3).append("\nLoggingContext: ").append(string4).append("\nLogCallerFinder: ").append(string5).append("\n").toString();
    }

    @NullableDecl
    private static <T> T resolveAttribute(String attributeName, Class<T> type) {
        String getter = DefaultPlatform.readProperty(attributeName);
        if (getter == null) {
            return null;
        }
        int idx = getter.indexOf(35);
        if (idx <= 0 || idx == getter.length() - 1) {
            DefaultPlatform.error("invalid getter (expected <class>#<method>): %s\n", getter);
            return null;
        }
        return DefaultPlatform.callStaticMethod(getter.substring(0, idx), getter.substring(idx + 1), type);
    }

    private static String readProperty(String attributeName) {
        Checks.checkNotNull(attributeName, "attribute name");
        String string = String.valueOf(attributeName);
        String propertyName = string.length() != 0 ? "flogger.".concat(string) : new String("flogger.");
        try {
            return System.getProperty(propertyName);
        }
        catch (SecurityException e) {
            DefaultPlatform.error("cannot read property name %s: %s", propertyName, e);
            return null;
        }
    }

    private static <T> T callStaticMethod(String className, String methodName, Class<T> type) {
        try {
            return type.cast(Class.forName(className).getMethod(methodName, new Class[0]).invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ClassCastException e) {
            DefaultPlatform.error("cannot cast result of calling '%s#%s' to '%s': %s\n", className, methodName, type.getName(), e);
        }
        catch (Exception e) {
            DefaultPlatform.error("cannot call expected no-argument static method '%s#%s': %s\n", className, methodName, e);
        }
        return null;
    }

    private static void error(String msg, Object ... args) {
        String string = String.valueOf(DefaultPlatform.class);
        String string2 = String.format(msg, args);
        System.err.println(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString());
    }
}

