package com.cybelia.sandra.services.local;

import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.TypeConnectionEnum;
import com.cybelia.sandra.entities.UserIndicateurs;
import javax.ejb.Local;
import org.jboss.ejb3.annotation.LocalBinding;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

/**
 * @author sletellier
 */
@Local
@LocalBinding(jndiBinding="ServiceCommonImpl/local")
public interface ServiceCommonLocal {

    /**
     * Verifie que l'utilisateur a le droit en lecture sur l'entite ayant ce topiaId
     *
     * @param topiaId
     * @return
     */
    boolean canReadEntity(TopiaContext context, String topiaId);

    /**
     * Verifie que l'utilisateur a le droit en ecriture sur l'entite ayant ce topiaId
     *
     * @param topiaId
     * @return
     */
    boolean canUpdateEntity(TopiaContext context, String topiaId);

    /**
     * Classe utilitaire pour retrouver le label corresondant
     */
    String getLabel(TopiaContext context, String category, String id) throws TopiaException;

    void notifyChangedBreeder(TopiaContext context, String notifierName, String userLogin, Eleveur eleveurOld, Eleveur eleveur) throws TopiaException;

    void notifyChangedBreeder(TopiaContext context, String notifierName, String userLogin, Eleveur eleveurOld, Eleveur eleveur, InfoAccess accesOld, InfoAccess acces) throws TopiaException;

    void notifyChangedInfoAccess(TopiaContext context, String notifierName, String userLogin, String breederTopiaId, InfoAccess infoAccesOld, InfoAccess infoAcces) throws TopiaException;

    void notifyChangedInfoAccess(TopiaContext context, String notifierName, String userLogin, String breederTopiaId, InfoAccess infoAccesOld, InfoAccess infoAcces, Double oldX, Double oldY) throws TopiaException;

    /*
     * Methods to copy if necessary field of bean
     *
     */
    <E extends TopiaEntity> E copyEntityIfNecessary(TopiaContext transaction, E beanFrom, E beanTo, String field);

    // Methods used to increment User indicators
    UserIndicateurs incSynch(TopiaContext transaction, TypeConnectionEnum typeConnection, boolean gprs, boolean update) throws TopiaException;

    UserIndicateurs incNbOctetsReceivedGPRS(int inc) throws TopiaException;

    UserIndicateurs incNbOctetsReceivedGPRS(TopiaContext transaction, int inc) throws TopiaException;

    UserIndicateurs incNbOctetsReceivedGPRS(TopiaContext transaction, int inc, boolean update) throws TopiaException;

    UserIndicateurs incNbOctetsReceivedGPRS(UserIndicateurs userIndicateurs, int inc) throws TopiaException;

    UserIndicateurs incNbOctetsSendGPRS(int inc) throws TopiaException;

    UserIndicateurs incNbOctetsSendGPRS(TopiaContext transaction, int inc) throws TopiaException;

    UserIndicateurs incNbOctetsSendGPRS(TopiaContext transaction, int inc, boolean update) throws TopiaException;

    UserIndicateurs incNbOctetsSendGPRS(UserIndicateurs userIndicateurs, int inc) throws TopiaException;

    UserIndicateurs incNbOctetsReceivedWifi(int inc) throws TopiaException;

    UserIndicateurs incNbOctetsReceivedWifi(TopiaContext transaction, int inc) throws TopiaException;

    UserIndicateurs incNbOctetsReceivedWifi(TopiaContext transaction, int inc, boolean update) throws TopiaException;

    UserIndicateurs incNbOctetsReceivedWifi(UserIndicateurs userIndicateurs, int inc) throws TopiaException;

    UserIndicateurs incNbOctetsSendWifi(int inc) throws TopiaException;

    UserIndicateurs incNbOctetsSendWifi(TopiaContext transaction, int inc) throws TopiaException;

    UserIndicateurs incNbOctetsSendWifi(TopiaContext transaction, int inc, boolean update) throws TopiaException;

    UserIndicateurs incNbOctetsSendWifi(UserIndicateurs userIndicateurs, int inc) throws TopiaException;

    UserIndicateurs incNbSynchKo(TopiaContext transaction, int inc) throws TopiaException;

    UserIndicateurs incNbSynchKo(TopiaContext transaction, int inc, boolean update) throws TopiaException;

    UserIndicateurs incNbSynchKo(UserIndicateurs userIndicateurs, int inc) throws TopiaException;

    UserIndicateurs incNbNotifs() throws TopiaException;

    UserIndicateurs incNbNotifs(TopiaContext transaction) throws TopiaException;

    UserIndicateurs incNbNotifs(TopiaContext transaction, boolean update) throws TopiaException;

    UserIndicateurs incNbNotifs(UserIndicateurs userIndicateurs) throws TopiaException;

    UserIndicateurs incNbSynchAuto() throws TopiaException;

    UserIndicateurs incNbSynchAuto(TopiaContext transaction) throws TopiaException;

    UserIndicateurs incNbSynchAuto(TopiaContext transaction, boolean update) throws TopiaException;

    UserIndicateurs incNbSynchAuto(UserIndicateurs userIndicateurs) throws TopiaException;

    UserIndicateurs incNbSynchKo() throws TopiaException;

    UserIndicateurs incNbGpsMaj() throws TopiaException;

    UserIndicateurs incNbGpsMaj(TopiaContext transaction) throws TopiaException;

    UserIndicateurs incNbGpsMaj(TopiaContext transaction, boolean update) throws TopiaException;

    UserIndicateurs incNbGpsMaj(UserIndicateurs userIndicateurs) throws TopiaException;

    UserIndicateurs incNbSecuMaj() throws TopiaException;

    UserIndicateurs incNbSecuMaj(TopiaContext transaction) throws TopiaException;

    UserIndicateurs incNbSecuMaj(TopiaContext transaction, boolean update) throws TopiaException;

    UserIndicateurs incNbSecuMaj(UserIndicateurs userIndicateurs) throws TopiaException;

    UserIndicateurs incNbMaj() throws TopiaException;

    UserIndicateurs incNbMaj(TopiaContext transaction) throws TopiaException;

    UserIndicateurs incNbMaj(TopiaContext transaction, boolean update) throws TopiaException;

    UserIndicateurs incNbMaj(UserIndicateurs userIndicateurs) throws TopiaException;

    UserIndicateurs incNbSynchWifi() throws TopiaException;

    UserIndicateurs incNbSynchWifi(TopiaContext transaction) throws TopiaException;

    UserIndicateurs incNbSynchWifi(TopiaContext transaction, boolean update) throws TopiaException;

    UserIndicateurs incNbSynchWifi(UserIndicateurs userIndicateurs) throws TopiaException;

    UserIndicateurs incNbSynchGprs() throws TopiaException;

    UserIndicateurs incNbSynchGprs(TopiaContext transaction) throws TopiaException;

    UserIndicateurs incNbSynchGprs(TopiaContext transaction, boolean update) throws TopiaException;

    UserIndicateurs incNbSynchGprs(UserIndicateurs userIndicateurs) throws TopiaException;
}
