package com.cybelia.sandra.services.ejb3;


import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.log4j.Level;

/**
 * @author sletellier
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Transaction {

    boolean commit() default true;

    boolean close() default true;

    /**
     * use n_ to translate message
     *
     * @return i18n message to log on error
     */
    String errorMsg() default StringUtils.EMPTY;

    LogLevel errorLevel() default LogLevel.ERROR;

    public static enum LogLevel {
        FATAL(Level.FATAL),
        ERROR(Level.ERROR),
        WARN(Level.FATAL),
        INFO(Level.INFO),
        DEBUG(Level.DEBUG),
        TRACE(Level.TRACE);

        protected Level logLevel;

        LogLevel(Level logLevel) {
            this.logLevel = logLevel;
        }

        public void logError(Log log, String msg, Throwable eee) {
            switch (this) {
                case FATAL:
                    if (log.isFatalEnabled()) {
                        log.fatal(msg, eee);
                    }
                case ERROR:
                    if (log.isErrorEnabled()) {
                        log.error(msg, eee);
                    }
                case WARN:
                    if (log.isWarnEnabled()) {
                        log.warn(msg, eee);
                    }
                case INFO:
                    if (log.isInfoEnabled()) {
                        log.info(msg, eee);
                    }
                case DEBUG:
                    if (log.isDebugEnabled()) {
                        log.debug(msg, eee);
                    }
                case TRACE:
                    if (log.isTraceEnabled()) {
                        log.trace(msg, eee);
                    }
            }
        }
    }
}
