package com.cybelia.sandra.services.ejb3;

import com.cybelia.sandra.EmailHelper;
import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraConfigHelper;
import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.ActionSecurite;
import com.cybelia.sandra.entities.ActionSecuriteDAO;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.ChargementUsineConfig;
import com.cybelia.sandra.entities.ChargementUsineConfigDAO;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.ChauffeurDAO;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveurDAO;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.EtapeDAO;
import com.cybelia.sandra.entities.GPSStateEnum;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoAccessDAO;
import com.cybelia.sandra.entities.InfoAccessEtat;
import com.cybelia.sandra.entities.InfoChargement;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.LabelDAO;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Note;
import com.cybelia.sandra.entities.NoteDAO;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourDAO;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.entities.TransporteurDAO;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.UserIndicateursDAO;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.UsineDAO;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.PointGPSDAO;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviEtapeDAO;
import com.cybelia.sandra.entities.trace.SuiviLigneProduit;
import com.cybelia.sandra.entities.trace.SuiviLigneProduitDAO;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviTourDAO;
import com.cybelia.sandra.ibu.injector.InjectorEleveurDuplicated;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import com.cybelia.sandra.security.NotifierSecurityHelper;
import com.cybelia.sandra.security.ProfilManager;
import com.cybelia.sandra.security.SecurityHelper;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceHelper;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.services.local.ServiceCommonLocal;
import com.cybelia.sandra.services.local.ServiceNotifierLocal;
import com.cybelia.sandra.services.local.ServiceScheduleLocal;
import com.cybelia.sandra.services.local.ServiceWebLocal;
import com.google.common.collect.Lists;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper;
import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.taas.TaasUtil;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasAuthorizationDAO;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasPrincipalDAO;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;
import org.nuiton.util.DateUtil;

@Stateless
@SecurityDomain("sandra")
@PermitAll
public class ServiceWebImpl extends BaseServiceImpl implements ServiceWeb, ServiceWebLocal {

    protected static final Log log = LogFactory.getLog(ServiceWebImpl.class);

    @EJB
    ServiceNotifierLocal serviceNotifier;

    @EJB
    ServiceScheduleLocal serviceSchedule;

    @EJB
    ServiceCommonLocal serviceCommon;

    public void setServiceNotifier(ServiceNotifierLocal serviceNotifier) {
        this.serviceNotifier = serviceNotifier;
    }

    public void setServiceSchedule(ServiceScheduleLocal serviceSchedule) {
        this.serviceSchedule = serviceSchedule;
    }

    public void setServiceCommon(ServiceCommonLocal serviceCommon) {
        this.serviceCommon = serviceCommon;
    }

    protected TaasUser getRestoredUser(TopiaContext transaction) throws TopiaException {
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO(transaction);

        // Search user
        TaasUser privateCredential = SecurityHelper.getUser();

        TaasUser user = userDAO.findByTopiaId(privateCredential.getTopiaId());

        return user;
    }

//    @Override
//    @Transaction
//    public void createMissingGPS(TopiaContext transaction) throws TopiaException {
//        log.info("createMissingGPS");
//
//        GeometryFactory geometryFactory = new GeometryFactory();
//        Coordinate coordinate = new Coordinate(0, 0);
//        Point point = geometryFactory.createPoint(coordinate);
//
//        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);
//        List<Eleveur> eleveurs = eleveurDAO.findAllByTomtomGPS(null);
//
//        for (Eleveur eleveur : eleveurs) {
//            PointGPSDAO pointGPSDAO = SandraDAOHelper.getPointGPSDAO(transaction);
//            PointGPS pointGPS = pointGPSDAO.create("point", point);
//            eleveur.setTomtomGPS(pointGPS);
//            eleveurDAO.update(eleveur);
//        }
//
//        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);
//        List<InfoAccess> infoAccesss = infoAccessDAO.findAllByGps(null);
//
//        for (InfoAccess infoAccess : infoAccesss) {
//            PointGPSDAO pointGPSDAO = SandraDAOHelper.getPointGPSDAO(transaction);
//            PointGPS pointGPS = pointGPSDAO.create("point", point);
//            infoAccess.setGps(pointGPS);
//            infoAccessDAO.update(infoAccess);
//        }
//    }

    @Override
    @Transaction
    public void createAllActionSecurityForEleveurs(TopiaContext transaction) throws TopiaException {
        log.info("createAllActionSecurityForEleveurs");

        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);

        String hql = "SELECT silo" +
                " FROM " + InfoAccess.class.getName() +
                " silo WHERE silo.niveauSecurite > 1" +
                " AND silo.eleveur IS NOT NULL";

        // Empty creation
        List<InfoAccess> silos = transaction.findAll(hql);
        for (InfoAccess silo : silos) {
            Eleveur eleveur = silo.getEleveur();
            SandraHelper.createActionSecuriteIfNeeded(transaction, null, eleveur, silo);

            eleveurDAO.update(eleveur);
            infoAccessDAO.update(silo);
        }
    }

    @Override
    @Transaction
    public void createMissingPrincipalsForCamions(TopiaContext transaction) throws TopiaException {
        log.info("createMissingPrincipalsForCamions");
        CamionDAO camionDAO = SandraDAOHelper.getCamionDAO(transaction);
        UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO(transaction);
        TaasPrincipalDAO taasPrincipalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO(transaction);
        TaasUserDAO taasUserDAO = TopiaSecurityDAOHelper.getTaasUserDAO(transaction);
        List<Camion> camions = camionDAO.findAll();
        for (Camion camion : camions) {
            UserIndicateurs userIndicateurs = camion.getUserIndicateurs();

            Societe societe = camion.getSociete();

            if (userIndicateurs == null) {

                // Create also taas user
                TaasUser taasUser = taasUserDAO.create();
                taasUser.setLogin(societe.getCode() + "-" + camion.getCode());
                taasUser.setLink(societe.getTopiaId());
                taasUser.setEnabled(true);
                taasUser = taasUserDAO.update(taasUser);

                // Create user indicator
                userIndicateurs = userIndicateursDAO.createByNaturalId(taasUser);
                userIndicateurs = SandraHelper.razUserIndicateurs(userIndicateurs);
                userIndicateurs = userIndicateursDAO.update(userIndicateurs);

                camion.setUserIndicateurs(userIndicateurs);

                camion = camionDAO.update(camion);
            }

            TaasUser taasUser = userIndicateurs.getTaasUser();
            Collection<TaasPrincipal> principals = taasUser.getPrincipals();
            if (principals == null || principals.size() < 2) {

                String codeSocieteCamion = societe.getCode() + "-" + camion.getCode();

                boolean synchroExist = false;
                boolean principalExist = false;

                if (principals != null) {
                    for (TaasPrincipal principal : principals) {
                        if ("synchro".equals(principal.getName())) {
                            synchroExist = true;
                        } else if (codeSocieteCamion.equals(principal.getName())) {
                            principalExist = true;
                        }
                    }
                }

                if (!synchroExist) {
                    TaasPrincipal taasPrincipal = taasPrincipalDAO.create();
                    taasPrincipal.setName("synchro");
                    taasPrincipalDAO.update(taasPrincipal);

                    taasUser.addPrincipals(taasPrincipal);
                }

                if (!principalExist) {
                    TaasPrincipal taasPrincipal = taasPrincipalDAO.create();
                    taasPrincipal.setName(codeSocieteCamion);
                    taasPrincipalDAO.update(taasPrincipal);

                    taasUser.addPrincipals(taasPrincipal);
                }

                taasUserDAO.update(taasUser);
            }
        }

    }

    @Override
    @Transaction
    public void deleteDuplicatedEtapesAndCreateUniqueIndex(TopiaContext transaction) throws TopiaException {
        log.info("deleteDuplicatedEtapesAndCreateUniqueIndex");

        String sql = "SELECT e1.topiaid as topiaId1, e2.topiaid as topiaid2 FROM sandra.etape e1, sandra.etape e2 WHERE e1.ordre=e2.ordre AND e1.tour=e2.tour AND e1.eleveur=e2.eleveur AND e1.topiaId<>e2.topiaId;";
        SQLQuery sqlQuery = ((TopiaContextImpl) transaction).getHibernate().createSQLQuery(sql);
        List<Object[]> list = sqlQuery.list();

        EtapeDAO etapeDAO = SandraDAOHelper.getEtapeDAO(transaction);

        do {
            List<Object> cachedTopiaid = new ArrayList<Object>();

            int size = list.size() / 2;
            log.info("Will delete " + size + " etapes");

            int i = 0;
            for (Object[] ids : list) {

                Object id1 = ids[0];
                Object id2 = ids[1];

                if (!cachedTopiaid.contains(id2)) {
                    log.info("Will delete etape : " + id2);

                    cachedTopiaid.add(id1);
                    cachedTopiaid.add(id2);

                    Etape etapeToDelete = etapeDAO.findByTopiaId(String.valueOf(id2));

                    // remove from tour
//                    Tour tour = etapeToDelete.getTour();
//                    tour.removeEtapes(etapeToDelete);
//                    tourDAO.update(tour);
//
//                    List<SuiviEtape> suiviEtapesToDelete = suiviEtapeDAO.findAllByEtape(etapeToDelete);
//
//                    if (suiviEtapesToDelete != null) {
//                        // remove from suiviTour
//                        for (SuiviEtape suiviEtape : suiviEtapesToDelete) {
//                            suiviEtape.setEtape(null);
//                            suiviEtapeDAO.update(suiviEtape);
//                        }
//                    }
//
//                    List<LigneProduit> produits = etapeToDelete.getProduits();
//                    for (LigneProduit produit : produits) {
//
//                        // some ligneProduit are referenced by other suiviLigneProduit than current etape...
//                        String deleteSuiviLigneProduitSQL = "UPDATE sandra.suiviLigneProduit SET ligneProduit=null WHERE ligneProduit='" + produit.getTopiaId() + "'";
//                        ((TopiaContextImpl) transaction).getHibernate().createSQLQuery(deleteSuiviLigneProduitSQL).executeUpdate();
//                    }
//
//                    etapeDAO.delete(etapeToDelete);

                    SandraHelper.deleteEtape(transaction, etapeToDelete);

                    log.info("Etape " + (++i) + "/" + size + " deleted : " + id2);
                }
            }
            transaction.commitTransaction();

            sqlQuery = ((TopiaContextImpl) transaction).getHibernate().createSQLQuery(sql);
            list = sqlQuery.list();


        } while (!list.isEmpty());

        // remove old index
        String removeIndexSql = "DROP INDEX sandra.etape_key;";
        ((TopiaContextImpl) transaction).getHibernate().createSQLQuery(removeIndexSql).executeUpdate();

        // creating unique index
        String addUniqueIndexSql = "CREATE UNIQUE INDEX etape_key ON sandra.etape(ordre, tour, eleveur);";
        ((TopiaContextImpl) transaction).getHibernate().createSQLQuery(addUniqueIndexSql).executeUpdate();

        log.info("End deleteDuplicatedEtapesAndCreateUniqueIndex");
    }

    @Override
    @Transaction
    public void deleteDuplicatedToursAndCreateUniqueIndex(TopiaContext transaction) throws TopiaException {
        log.info("deleteDuplicatedToursAndCreateUniqueIndex");

        String sql = "SELECT t1.topiaid as topiaId1, t2.topiaid as topiaid2 FROM sandra.tour t1, sandra.tour t2 WHERE t1.numero=t2.numero AND t1.dateLivraison=t2.dateLivraison AND t1.camion=t2.camion AND t1.topiaId<>t2.topiaId;";
        SQLQuery sqlQuery = ((TopiaContextImpl) transaction).getHibernate().createSQLQuery(sql);
        List<Object[]> list = sqlQuery.list();

        TourDAO tourDAO = SandraDAOHelper.getTourDAO(transaction);
        SuiviTourDAO suiviTourDAO = SandraDAOHelper.getSuiviTourDAO(transaction);

        do {
            List<Object> cachedTopiaid = new ArrayList<Object>();

            int size = list.size() / 2;
            log.info("Will delete " + size + " tours");

            int i = 0;
            for (Object[] ids : list) {

                Object id1 = ids[0];
                Object id2 = ids[1];

                if (!cachedTopiaid.contains(id2)) {

                    cachedTopiaid.add(id1);
                    cachedTopiaid.add(id2);

                    Tour tourToDelete = tourDAO.findByTopiaId(String.valueOf(id2));

                    SuiviTour suiviTour = tourToDelete.getSuiviTour();
                    if (suiviTour != null) {
                        suiviTourDAO.delete(suiviTour);
                    }

                    List<Etape> etapes = tourToDelete.getEtapes();
                    for (Etape etape : etapes) {

                        SandraHelper.deleteEtape(transaction, etape);
                    }

                    tourDAO.delete(tourToDelete);

                    log.info("Tour " + (++i) + "/" + size + " deleted : " + id2);
                }

            }

            transaction.commitTransaction();

            sqlQuery = ((TopiaContextImpl) transaction).getHibernate().createSQLQuery(sql);
            list = sqlQuery.list();


        } while (!list.isEmpty());

        // remove old index
        String removeIndexSql = "DROP INDEX sandra.tour_key;";
        ((TopiaContextImpl) transaction).getHibernate().createSQLQuery(removeIndexSql).executeUpdate();

        // creating unique index
        String addUniqueIndexSql = "CREATE UNIQUE INDEX tour_key ON sandra.tour(dateLivraison, numero, camion);";
        ((TopiaContextImpl) transaction).getHibernate().createSQLQuery(addUniqueIndexSql).executeUpdate();

        log.info("End deleteDuplicatedToursAndCreateUniqueIndex");
    }

    @Override
    @Transaction
    public void createAndFillAccessEleveur(TopiaContext transaction) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("createAndFillAccessEleveur");
        }

        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);

        String hql = "select eleveur FROM " + Eleveur.class.getName() + " eleveur" +
                " WHERE acceseleveur IS NULL";

        List<Eleveur> eleveurs = transaction.findAll(hql);
        int cnt = 0;
        for (Eleveur e : eleveurs) {
            InfoAccess infoAccess = infoAccessDAO.create();
            infoAccess.setCommentaireSecurite(e.getCommentaire());
            if (e.getNiveauSecurite() == 0) {
                infoAccess.setNiveauSecurite(-1);
            }

            e.setAccesEleveur(infoAccess);
            SandraDAOHelper.getEleveurDAO(transaction).update(e);
            infoAccessDAO.update(infoAccess);
            cnt++;
        }

        log.info(cnt + " access breeders are created");
    }

    @Override
    public void resetAllUserIndicateurs() {
        if (log.isDebugEnabled()) {
            log.debug("resetAllUserIndicateurs");
        }
        try {
            Thread notif = new Thread(new Runnable(){
                @Override
                public void run() {
                    try {
                        serviceSchedule.razNumberOfConnection(null);
                    } catch (Exception eee) {
                        log.error("Error on resetAllUserIndicateurs : ", eee);
                    }
                }
            });
            notif.start();
        } catch (Exception eee) {
            log.error("Failed to resetAllUserIndicateurs", eee);
        }
    }

    @Override
    public void sendStatNotification() {
        if (log.isDebugEnabled()) {
            log.debug("sendStatNotification");
        }
        try {
            Thread notif = new Thread(new Runnable(){
                @Override
                public void run() {
                    try {
                        serviceSchedule.sendStatNotification(null);
                    } catch (Exception eee) {
                        log.error("Error on sending stats : ", eee);
                    }
                }
            });
            notif.start();
        } catch (Exception eee) {
            log.error("Failed to sendStatNotification", eee);
        }
    }

    @Override
    @Transaction
    public void sendFindDangerousBreeder(TopiaContext transaction) {
        if (log.isDebugEnabled()) {
            log.debug("sendFindDangerousBreeder");
        }
        try {
            serviceSchedule.sendFindDangerousBreeder(transaction);
        } catch (Exception eee) {
            log.error("Failed to sendFindDangerousBreeder", eee);
        }
    }

    @Override
    @Transaction
    public void updateAllWorstSecurityLevel(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("updateAllWorstSecurityLevel");
        }

        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);

        List<Eleveur> eleveurs = eleveurDAO.findAll();
        for (Eleveur e : eleveurs) {
            int securityLevel = SandraHelper.getWorstSecurityLevel(e);
            e.setNiveauSecurite(securityLevel);

            PointGPS pointGPS = e.getTomtomGPS();
            if (pointGPS != null && pointGPS.getPoint() != null) {
                Point point = pointGPS.getPoint();
                if (point.getX() == 0 && point.getY() == 0) {
                    e.setTomtomGPS(null);
                }
            }

            eleveurDAO.update(e);
        }
    }

    @Override
    @Transaction(commit = false)
    public int getToursCount(TopiaContext transaction, Date dateDebut, Date dateFin, boolean planifie,
                             boolean termine, String topiaIdSociete, String topiaIdTransporteur,
                             String topiaIdCamion, String topiaIdChauffeur) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getToursCount");
        }

        List<Object> arguments = new ArrayList<Object>();
        String requete = createTourQuery("SELECT count(*)", transaction,
                dateDebut, dateFin, planifie, termine, topiaIdSociete, topiaIdTransporteur, topiaIdCamion, topiaIdChauffeur, arguments);

        int count = ProfilManager.count(transaction, Tour.class, requete, arguments.toArray());
        if (log.isDebugEnabled()) {
            log.debug("count tours [" + requete + "] : " + count);
        }

        return count;
    }

    @Override
    @Transaction
    public List<Tour> getTours(TopiaContext transaction, Date dateDebut, Date dateFin, boolean planifie,
                               boolean termine, String topiaIdSociete, String topiaIdTransporteur,
                               String topiaIdCamion, String topiaIdChauffeur) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getTours");
        }
        List<Object> arguments = new ArrayList<Object>();
        String requete = createTourQuery("SELECT tour", transaction,
                dateDebut, dateFin, planifie, termine, topiaIdSociete, topiaIdTransporteur, topiaIdCamion, topiaIdChauffeur, arguments);

        List<Tour> tours = ProfilManager.find(transaction, Tour.class, requete, arguments.toArray());
        return tours;
    }

    @Override
    @Transaction
    public List<Tour> getTours(TopiaContext transaction, Date dateDebut, Date dateFin, boolean planifie,
                               boolean termine, String topiaIdSociete,
                               String topiaIdTransporteur, String topiaIdCamion,
                               String topiaIdChauffeur, int startIndex, int endIndex,
                               String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getTours [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">");
        }

        List<Object> arguments = new ArrayList<Object>();
        String requete = createTourQuery("SELECT tour", transaction,
                dateDebut, dateFin, planifie, termine, topiaIdSociete, topiaIdTransporteur, topiaIdCamion, topiaIdChauffeur, arguments);
        //fixme : ne fonctionne pas si on met le order by avant les clauses where : on obtient un NPE
        String order;
        if (sortCriterion == null) {
            // let the service give a,default sorting order given by : dateLivraison / camion.code / etape.numero
            order = " ORDER BY tour.dateLivraison, tour.camion.code, tour.numero";
        } else {
            order = SandraHelper.addOrder("tour", sortCriterion, sortDirection);
        }
        if (log.isDebugEnabled()) {
            log.debug("use tour sorting " + order);
        }
        requete += order;
        if (log.isDebugEnabled()) {
            log.debug("request : " + requete + ", arguments " + arguments);
        }
        List<Tour> tours = ProfilManager.findWithBounds(transaction, Tour.class, requete, startIndex, endIndex, arguments.toArray());
        return tours;
    }

    @Override
    public Pair<Etape, SuiviEtape> getEtape(TopiaContext transaction, String topiaId) throws LogicException, TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("getTour " + topiaId);
        }

        String query = "SELECT etape FROM " + Etape.class.getName() + " etape WHERE etape.topiaId = :topiaId";
        Etape etape = ProfilManager.findUnique("error.service.etape.unfound", transaction, Etape.class,
                query, "topiaId", topiaId);

        Pair<Etape, SuiviEtape> result = Pair.of(etape, SandraDAOHelper.getSuiviEtapeDAO(transaction).findByEtape(etape));
        return result;
    }

    @Override
    @Transaction
    public Tour getTour(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getTour " + topiaId);
        }

        String query = "SELECT tour FROM " + Tour.class.getName() + " tour WHERE tour.topiaId = :topiaId";
        Tour tour = ProfilManager.findUnique("error.service.tour.unfound", transaction, Tour.class,
                query, "topiaId", topiaId);
        return tour;
    }

    @Override
    @Transaction
    public List<Tour> getToursByCamionAndDates(TopiaContext transaction, String camionTopiaId, Date dateDebut, Date dateFin) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("getTourByCamionAndDate");
        }
        List<Object> arguments = new ArrayList<Object>();
        String requete = createTourQuery("SELECT tour", transaction,
                dateDebut, dateFin, true, true, null, null, camionTopiaId, null, arguments);

        requete += " ORDER BY tour.dateLivraison, tour.numero";

        Object[] args = arguments.toArray();

        if (log.isDebugEnabled()) {
            log.debug("getToursByCamionAndDates final request : " + requete + " with args " + Arrays.toString(args));
        }

        List<Tour> tours = ProfilManager.find(transaction, Tour.class, requete, args);
        return tours;
    }

    @Override
    @Transaction
    public List<Pair<Etape, SuiviEtape>> getEtapesByEleveurs(TopiaContext transaction,
                                           Date dateLivraisonStart,
                                           Date dateLivraisonEnd,
                                           String breederTopiaId,
                                           int startIndex,
                                           int endIndex,
                                           String sortCriterion,
                                           int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getToursByEleveurs [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">");
        }

        List<Object> arguments = new ArrayList<Object>();

        String hql = getEtapesByEleveurHQL("SELECT etape ", dateLivraisonStart, dateLivraisonEnd, breederTopiaId, arguments);

        //fixme : ne fonctionne pas si on met le order by avant les clauses where : on obtient un NPE
        String order;
        if (sortCriterion == null) {
            // let the service give a,default sorting order given by : dateLivraison / camion.code / etape.numero
            order = " ORDER BY etape.tour.dateLivraison, etape.tour.camion.code, etape.tour.numero";
        } else {
            order = SandraHelper.addOrder("etape.tour", sortCriterion, sortDirection);
        }
        if (log.isDebugEnabled()) {
            log.debug("use tour sorting " + order);
        }
        hql += order;
        if (log.isDebugEnabled()) {
            log.debug("request : " + hql + ", arguments " + arguments);
        }
        List<Etape> etapes = ProfilManager.findWithBounds(transaction, Etape.class, hql, startIndex, endIndex, arguments.toArray());

        List<Pair<Etape, SuiviEtape>> result = Lists.newArrayList();
        for (Etape etape : etapes) {
            result.add(Pair.of(etape, SandraDAOHelper.getSuiviEtapeDAO(transaction).findByEtape(etape)));
        }
        return result;
    }

    @Override
    @Transaction
    public int getEtapesByEleveursCount(TopiaContext transaction,
                                       Date dateLivraisonStart,
                                       Date dateLivraisonEnd,
                                       String breederTopiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getToursByEleveursCount");
        }

        List<Object> arguments = new ArrayList<Object>();

        String hql = getEtapesByEleveurHQL("SELECT COUNT(etape) ", dateLivraisonStart, dateLivraisonEnd, breederTopiaId, arguments);

        if (log.isDebugEnabled()) {
            log.debug("request : " + hql + ", arguments " + arguments);
        }
        int count = ProfilManager.count(transaction, Etape.class, hql, arguments.toArray());

        return count;
    }

    protected String getEtapesByEleveurHQL(String hqlStart,
                                          Date dateLivraisonStart,
                                          Date dateLivraisonEnd,
                                          String breederTopiaId,
                                          List<Object> arguments) {

        String result = hqlStart + " FROM " + Etape.class.getName() + " etape WHERE etape.tour.dateLivraison >= :dateLivraisonStart" +
                " AND etape.tour.dateLivraison <= :dateLivraisonEnd AND etape.eleveur.topiaId=:breederTopiaId";

        arguments.add("dateLivraisonStart");
        arguments.add(dateLivraisonStart);
        arguments.add("dateLivraisonEnd");
        arguments.add(dateLivraisonEnd);
        arguments.add("breederTopiaId");
        arguments.add(breederTopiaId);

        return result;
    }

    @Override
    @Transaction
    public List<Tour> getLoading(TopiaContext transaction, Date dateDebut, Date dateFin, String topiaIdUsine) throws TopiaException, LogicException {
        String query = "SELECT tour FROM " + Tour.class.getName() + " tour JOIN tour.etapes AS etape JOIN etape.produits AS produit " +
                //date chargement prevu
                " WHERE (tour.dateChargement >= :dateDebut AND tour.dateChargement <= :dateFin AND produit.usine.topiaId = :topiaIdUsine) OR" +
                //date chargement reel
                " (tour IN (SELECT info.ligneProduit.etape.tour FROM " + InfoChargement.class.getName() + " info WHERE info.date >= :dateDebut AND info.date <= :dateFin AND info.ligneProduit.usine.topiaId = :topiaIdUsine)) OR" +
                //date chargement PDA
                " (tour.suiviTour IN (SELECT suiviTour FROM " + SuiviTour.class.getName() + " suiviTour JOIN suiviTour.suiviUsines AS suiviUsine WHERE suiviUsine.dateChargementPrevue >= :dateDebut AND suiviUsine.dateChargementPrevue <= :dateFin AND suiviUsine.usine.topiaId = :topiaIdUsine))" +
                //trie par camion
                " ORDER BY tour.camion.societe.code, tour.camion.code";
        List<Tour> tours = ProfilManager.find(transaction, Tour.class, query, "dateDebut", dateDebut, "dateFin", dateFin, "topiaIdUsine", topiaIdUsine);
        return tours;
    }

    @Override
    @Transaction
    public List<LigneProduit> getProduitsLoading(TopiaContext transaction, String topiaIdUsine, String topiaIdTour) throws TopiaException, LogicException {
        String query = "SELECT produit FROM " + LigneProduit.class.getName() + " produit WHERE produit.usine.topiaId = :topiaIdUsine AND produit.etape.tour.topiaId = :topiaIdTour";
        List<LigneProduit> produits = ProfilManager.find(transaction, LigneProduit.class, query, "topiaIdUsine", topiaIdUsine, "topiaIdTour", topiaIdTour);
        return produits;
    }

    @Override
    @Transaction
    public void saveProduitDisponible(TopiaContext transaction, String topiaIdProduit, boolean disponible) throws TopiaException, LogicException {

        String query = "SELECT produit FROM " + LigneProduit.class.getName() + " produit WHERE produit.topiaId = :topiaIdProduit";
        LigneProduit produit = ProfilManager.findUnique("error.service.ligneproduit.unfound", transaction, LigneProduit.class, query, "topiaIdProduit", topiaIdProduit);

        produit.setDisponible(disponible);
        SandraDAOHelper.getLigneProduitDAO(transaction).update(produit);
    }

    @Override
    @Transaction
    public Camion setActifCamion(TopiaContext transaction, String topiaId, boolean actif) throws TopiaException {

        CamionDAO camionDAO = SandraDAOHelper.getCamionDAO(transaction);
        Camion camion = camionDAO.findByTopiaId(topiaId);
        camion.setActif(actif);
        camion = camionDAO.update(camion);

        return camion;
    }

    @Override
    @Transaction
    public List<Camion> getCamions(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getCamions");
        }
        String query = "SELECT camion FROM " + Camion.class.getName() + " camion ORDER BY camion.societe.code, camion.code";
        List<Camion> camions = ProfilManager.find(transaction, Camion.class, query);
        return camions;
    }

    @Override
    @Transaction
    public List<Camion> getCamions(TopiaContext transaction, String societeId, boolean actif) throws TopiaException, LogicException {

        String query = "SELECT camion FROM " + Camion.class.getName() + " camion WHERE ";

        List<Object> arguments = new ArrayList<Object>();
        arguments.add("actif");
        arguments.add(actif);

        Societe societe = SandraDAOHelper.getSocieteDAO(transaction).findByTopiaId(societeId);

        if (societe != null) {
            arguments.add("societe");
            arguments.add(societe);
            query += " societe=:societe AND ";

        }
        query += Camion.PROPERTY_ACTIF + "=:actif ORDER BY camion.societe.code, camion.code";


        List<Camion> camions = ProfilManager.find(transaction, Camion.class, query, arguments.toArray());
        return camions;
    }

    @Override
    @Transaction
    public List<Camion> getCamions(TopiaContext transaction, String societeId, boolean actif, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {

        String query = "SELECT camion FROM " + Camion.class.getName() + " camion WHERE ";

        List<Object> arguments = new ArrayList<Object>();
        arguments.add("actif");
        arguments.add(actif);

        Societe societe = SandraDAOHelper.getSocieteDAO(transaction).findByTopiaId(societeId);

        if (societe != null) {
            arguments.add("societe");
            arguments.add(societe);
            query += " societe=:societe AND ";

        }
        query += Camion.PROPERTY_ACTIF + "=:actif "
                + SandraHelper.addOrder("camion", sortCriterion, sortDirection);

        List<Camion> camions = ProfilManager.findWithBounds(transaction, Camion.class, query, startIndex, endIndex, arguments.toArray());
        return camions;
    }

    @Override
    @Transaction
    public Camion getCamion(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isInfoEnabled()) {
            log.info("getCamion " + topiaId);
        }
        String query = "SELECT camion FROM " + Camion.class.getName() + " camion WHERE camion.topiaId = :topiaId";
        Camion camion = ProfilManager.findUnique("error.service.camion.unfound", transaction, Camion.class,
                query, "topiaId", topiaId);
        return camion;
    }

    @Override
    @Transaction
    public Camion saveCamion(TopiaContext transaction, Camion camion) throws TopiaException, LogicException {
        Camion camion2;
        CamionDAO dao = SandraDAOHelper.getCamionDAO(transaction);
        String code = camion.getCode();
        String topiaId = camion.getTopiaId();
        // get back societe from database
        Societe societe = getSociete(transaction, camion.getSociete().getTopiaId());
        camion.setSociete(societe);
        // get back transporteur from database
        Transporteur transporteur = getTransporteur(transaction, camion.getTransporteur().getTopiaId());
        camion.setTransporteur(transporteur);
        if (StringUtils.isEmpty(topiaId)) {

            if (dao.findByCode(code) != null) {
                throw new LogicException("error.service.camion.already.exists");
            }

            // create
            camion2 = dao.createByNaturalId(code, camion.getSociete());

            // Create also taas user
            TaasUserDAO taasUserDAO = TopiaSecurityDAOHelper.getTaasUserDAO(transaction);
            TaasUser taasUser = taasUserDAO.create();
            taasUser.setLogin(societe.getCode() + "-" + camion.getCode());
            taasUser.setLink(societe.getTopiaId());
            taasUser.setEnabled(true);

            // Create synchro permission
            TaasPrincipalDAO taasPrincipalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO(transaction);
            TaasPrincipal synchroPrincipal = taasPrincipalDAO.findByName("synchro");

            TaasPrincipal taasPrincipal = taasPrincipalDAO.create();
            taasPrincipal.setName(societe.getCode() + "-" + camion.getCode());
            taasPrincipalDAO.update(taasPrincipal);

            taasUser.addPrincipals(taasPrincipal);
            taasUser.addPrincipals(synchroPrincipal);

            taasUser = taasUserDAO.update(taasUser);

            // Create user indicator
            UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO(transaction);
            UserIndicateurs userIndicateurs = userIndicateursDAO.createByNaturalId(taasUser);
            userIndicateurs = SandraHelper.razUserIndicateurs(userIndicateurs);

            camion2.setUserIndicateurs(userIndicateurs);
            camion2.setActif(true);

            if (log.isInfoEnabled()) {
                log.info("has created camion " + camion2.getTopiaId());
            }
        } else {
            // update
            camion2 = dao.findByTopiaId(topiaId);
            // check if code has changed thaht it is available
            if (!camion2.getCode().equals(code) && dao.findByCode(code) != null) {
                throw new LogicException("error.service.camion.already.exists");
            }
            if (log.isInfoEnabled()) {
                log.info("update camion " + camion2.getTopiaId());
            }
        }

        // Data
        camion2.setTransporteur(camion.getTransporteur());
        camion2.setNombreCompartiments(camion.getNombreCompartiments());

        dao.update(camion2);
        return camion2;
    }

    @Override
    @Transaction
    public List<Camion> getCamionsPrincipaux(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getCamionsPrincipaux");
        }
        List<Camion> camions = getCamions(transaction);
        if (camions == null || camions.isEmpty()) {
            return null;
        }
        // pour contenir la liste de tous les camions non principaux
        List<String> camionsNonPrincipauxId = new java.util.ArrayList<String>();
        for (Camion camion : camions) {
            List<Camion> camionsAssocies = camion.getCamionsAssocies();
            if (camionsAssocies == null || camionsAssocies.isEmpty()) {
                // le camion ne possede pas de camion associe, on peut passer au suivant
                continue;
            }
            for (Camion camionsAssocy : camionsAssocies) {
                camionsNonPrincipauxId.add(camionsAssocy.getTopiaId());
            }

        }
        // les camions principaux sont tous ceux dont l'id n'est pas dans la liste calculee
        List<Camion> camionsPrincipaux = new java.util.ArrayList<Camion>();
        for (Camion camion : camions) {
            if (!camionsNonPrincipauxId.contains(camion.getTopiaId())) {
                camionsPrincipaux.add(camion);
            }
        }
        return camionsPrincipaux;
    }

    @Override
    @Transaction
    public Camion getCamionPrincipal(TopiaContext transaction, String camionId) throws TopiaException, LogicException {
        Camion camion = getCamion(transaction, camionId);
        if (camion.getCamionsAssocies() != null && !camion.getCamionsAssocies().isEmpty()) {
            // le camion possede des camions associes, donc c'est un camion principal
            return null;
        }
        for (Camion camionPrincipal : getCamions(transaction)) {
            List<Camion> camionsAssocies = camionPrincipal.getCamionsAssocies();
            if (camionsAssocies == null || camionsAssocies.isEmpty()) {
                // le camion ne possede pas de camion associe, ce n'est donc pas celui recherche
                continue;
            }
            for (Camion camionsAssocy : camionsAssocies) {
                if (camionId.equals(camionsAssocy.getTopiaId())) {
                    // on a trouve le camion principal
                    return camionPrincipal;
                }
            }
        }
        // le camion n'est contenu par aucun autre camion, il est donc principal
        return null;
    }

    @Override
    @Transaction
    public void addCamionToCamionPrincipal(TopiaContext transaction, String camionId, String camionPrincipalId) throws LogicException, TopiaException {
        CamionDAO dao = SandraDAOHelper.getCamionDAO(transaction);
        Camion camion = getCamion(transaction, camionId);
        Camion camionPrincipal = getCamion(transaction, camionPrincipalId);
        camionPrincipal.getCamionsAssocies().add(camion);
        dao.update(camionPrincipal);
    }

    @Override
    @Transaction
    public List<Chauffeur> getChauffeurs(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getChauffeurs");
        }
        String query = "SELECT chauffeur FROM " + Chauffeur.class.getName() + " chauffeur ORDER BY chauffeur.nom, chauffeur.prenom";
        List<Chauffeur> chauffeurs = ProfilManager.find(transaction, Chauffeur.class, query);
        return chauffeurs;
    }

    @Override
    @Transaction
    public List<Chauffeur> getChauffeurs(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getChauffeurs [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">");
        }
        String order;
        if (sortCriterion == null) {
            order = " ORDER BY chauffeur.nom, chauffeur.prenom";
        } else {
            order = SandraHelper.addOrder("chauffeur", sortCriterion, sortDirection);
        }
        String query = "SELECT chauffeur FROM " + Chauffeur.class.getName() + " chauffeur" + order;
        List<Chauffeur> chauffeurs = ProfilManager.findWithBounds(transaction, Chauffeur.class, query, startIndex, endIndex);
        return chauffeurs;
    }

    @Override
    @Transaction
    public Chauffeur getChauffeur(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getChauffeur " + topiaId);
        }
        String query = "SELECT chauffeur FROM " + Chauffeur.class.getName() + " chauffeur WHERE chauffeur.topiaId = :topiaId";
        Chauffeur chauffeur = ProfilManager.findUnique("error.service.chauffeur.unfound", transaction, Chauffeur.class,
                query, "topiaId", topiaId);
        //fixme lazy camions pb...
        chauffeur.getCamions().size();
        return chauffeur;
    }

    @Override
    @Transaction
    public Chauffeur saveChauffeur(TopiaContext transaction, Chauffeur chauffeur) throws TopiaException, LogicException {
        Chauffeur chauffeur2;
        ChauffeurDAO dao = SandraDAOHelper.getChauffeurDAO(transaction);
        String code = chauffeur.getCode();
        String topiaId = chauffeur.getTopiaId();
        // get back societe from database
        Societe societe = getSociete(transaction, chauffeur.getSociete().getTopiaId());
        chauffeur.setSociete(societe);
        if (topiaId == null || "".equals(topiaId)) {

            if (dao.findByCode(code) != null) {
                throw new LogicException("error.service.chauffeur.already.exists");
            }
            // create
            chauffeur2 = dao.create();
            if (log.isInfoEnabled()) {
                log.info("has created usine " + chauffeur2.getTopiaId());
            }
        } else {
            // update
            chauffeur2 = dao.findByTopiaId(topiaId);
            // check if code has changed thaht it is available
            if (!chauffeur2.getCode().equals(code) && dao.findByCode(code) != null) {
                throw new LogicException("error.service.chauffeur.already.exists");
            }
            if (log.isInfoEnabled()) {
                log.info("update chauffeur " + chauffeur2.getTopiaId());
            }
        }

        // Data
        chauffeur2.setCode(code);
        chauffeur2.setNom(chauffeur.getNom());
        chauffeur2.setPrenom(chauffeur.getPrenom());
        chauffeur2.setTrigramme(chauffeur.getTrigramme());
        chauffeur2.setSociete(chauffeur.getSociete());

        dao.update(chauffeur2);
        return chauffeur2;
    }

    @Override
    @Transaction
    public void addCamionsToChauffeur(TopiaContext transaction, String topiaIdChauffeur, String... topiaIdCamion) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("addCamionsToChauffeur chauffeur:" + topiaIdChauffeur);
        }
        ChauffeurDAO dao = SandraDAOHelper.getChauffeurDAO(transaction);
        CamionDAO cdao = SandraDAOHelper.getCamionDAO(transaction);
        Chauffeur chauffeur = dao.findByTopiaId(topiaIdChauffeur);
        Collection<Camion> camions = new java.util.ArrayList<Camion>(chauffeur.getCamions());
        for (String s : topiaIdCamion) {
            Camion camion = cdao.findByTopiaId(s);
            if (log.isDebugEnabled()) {
                log.debug("add camion " + camion.getTopiaId());
            }
            camions.add(camion);
        }
        //TODO why we have to do this, otherwise added are duplicated ?
        chauffeur.clearCamions();
        chauffeur.setCamions(camions);
        dao.update(chauffeur);
    }

    @Override
    @Transaction
    public void deleteCamionsToChauffeur(TopiaContext transaction, String topiaIdChauffeur, String... topiaIdCamion) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("deleteCamionsToChauffeur chauffeur:" + topiaIdChauffeur);
        }
        ChauffeurDAO dao = SandraDAOHelper.getChauffeurDAO(transaction);
        CamionDAO cdao = SandraDAOHelper.getCamionDAO(transaction);
        Chauffeur chauffeur = dao.findByTopiaId(topiaIdChauffeur);
        for (String s : topiaIdCamion) {
            Camion camion = cdao.findByTopiaId(s);
            if (log.isInfoEnabled()) {
                log.info("delete camion " + camion.getTopiaId());
            }
            chauffeur.removeCamions(camion);
        }
        dao.update(chauffeur);
    }

    @Override
    @Transaction
    public List<Societe> getSocietes(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getSocietes");
        }
        String query = "SELECT societe FROM " + Societe.class.getName() + " societe ORDER BY societe.code";
        List<Societe> societes = ProfilManager.find(transaction, Societe.class, query);
        return societes;
    }

    @Override
    @Transaction
    public List<Societe> getSocietes(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getSocietes [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">");
        }
        List<Societe> societes = null;
        String query = "SELECT societe FROM " + Societe.class.getName() + " societe" + SandraHelper.addOrder("societe", sortCriterion, sortDirection);
        societes = ProfilManager.findWithBounds(transaction, Societe.class, query, startIndex, endIndex);
        return societes;
    }

    @Override
    @Transaction
    public Societe getSociete(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getSociete " + topiaId);
        }
        String query = "SELECT societe FROM " + Societe.class.getName() + " societe WHERE societe.topiaId = :topiaId";
        Societe societe = ProfilManager.findUnique("error.service.societe.unfound", transaction, Societe.class, query, "topiaId", topiaId);
        return societe;
    }

    @Override
    @Transaction
    public Societe saveSociete(TopiaContext transaction, Societe societe) throws TopiaException, LogicException {
        Societe societe2;
        SocieteDAO dao = SandraDAOHelper.getSocieteDAO(transaction);
        String code = societe.getCode();
        String topiaId = societe.getTopiaId();

        if (topiaId == null || "".equals(topiaId)) {
            if (dao.findByCode(code) != null) {
                throw new LogicException("error.service.societe.already.exists");
            }
            // create
            societe2 = dao.createByNaturalId(code);
            if (log.isInfoEnabled()) {
                log.info("has created societe " + societe2.getTopiaId());
            }
        } else {
            societe2 = dao.findByTopiaId(topiaId);
            // check if code has changed, code is available
            if (!societe2.getCode().equals(code) && dao.findByCode(code) != null) {
                throw new LogicException("error.service.societe.already.exists");
            }
            // update
            if (log.isInfoEnabled()) {
                log.info("update societe " + societe2.getTopiaId());
            }
        }

        // Data

        dao.update(societe2);
        return societe2;
    }

    @Override
    @Transaction
    public List<Transporteur> getTransporteurs(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getTransporteurs");
        }
        List<Transporteur> transporteurs = ProfilManager.find(transaction, Transporteur.class,
                    "SELECT transporteur FROM " + Transporteur.class.getName() + " transporteur ORDER BY transporteur.name");
        return transporteurs;
    }

    @Override
    @Transaction
    public List<Transporteur> getTransporteurs(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getTransporteurs [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">");
        }
        String query = "SELECT transporteur FROM " + Transporteur.class.getName() + " transporteur" + SandraHelper.addOrder("transporteur", sortCriterion, sortDirection);
        List<Transporteur> transporteurs = ProfilManager.findWithBounds(transaction, Transporteur.class, query, startIndex, endIndex);
        return transporteurs;
    }

    @Override
    @Transaction
    public Transporteur getTransporteur(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getTransporteur " + topiaId);
        }
        String query = "SELECT transporteur FROM " + Transporteur.class.getName() + " transporteur WHERE transporteur.topiaId= :topiaId";
        Transporteur transporteur = ProfilManager.findUnique("error.service.transporteur.unfound", transaction, Transporteur.class, query, "topiaId", topiaId);
        return transporteur;
    }

    @Override
    @Transaction
    public Transporteur saveTransporteur(TopiaContext transaction, Transporteur transporteur) throws TopiaException, LogicException {
        Transporteur transporteur2;
        TransporteurDAO dao = SandraDAOHelper.getTransporteurDAO(transaction);
        String code = transporteur.getCode();
        String topiaId = transporteur.getTopiaId();
        // get back societe from database since
        Societe societe = getSociete(transaction, transporteur.getSociete().getTopiaId());
        transporteur.setSociete(societe);
        if (topiaId == null || "".equals(topiaId)) {

            if (dao.findByCode(code) != null) {
                throw new LogicException("error.service.transporteur.already.exists");
            }
            // create
            transporteur2 = dao.createByNaturalId(code, transporteur.getSociete());
            if (log.isDebugEnabled()) {
                log.debug("has created transporteur " + transporteur2.getTopiaId());
            }
        } else {
            // update
            transporteur2 = dao.findByTopiaId(topiaId);
            // check if code has changed thaht it is available
            if (!transporteur2.getCode().equals(code) && dao.findByCode(code) != null) {
                throw new LogicException("error.service.transporteur.already.exists");
            }
            if (log.isDebugEnabled()) {
                log.debug("update transporteur " + transporteur2.getTopiaId());
            }
        }

        // Data
        transporteur2.setName(transporteur.getName());

        dao.update(transporteur2);
        return transporteur2;
    }

    @Override
    @Transaction
    public List<Usine> getUsines(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getUsines");
        }
        List<Usine> usines = ProfilManager.find(transaction, Usine.class,
                "SELECT usine FROM " + Usine.class.getName() + " usine ORDER BY usine.code");
        return usines;
    }

    @Override
    @Transaction
    public List<Usine> getUsines(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isInfoEnabled()) {
            log.info("getUsines [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">");
        }
        String query = "SELECT usine FROM " + Usine.class.getName() + " usine" + SandraHelper.addOrder("usine", sortCriterion, sortDirection);
        List<Usine> usines = ProfilManager.findWithBounds(transaction, Usine.class, query, startIndex, endIndex);
        return usines;
    }

    @Override
    @Transaction
    public Usine getUsine(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getUsine " + topiaId);
        }
        String query = "SELECT usine FROM " + Usine.class.getName() + " usine WHERE usine.topiaId = :topiaId";
        Usine usine = ProfilManager.findUnique("error.service.factory.unfound", transaction, Usine.class, query, "topiaId", topiaId);
        return usine;
    }

    @Override
    @Transaction
    public Usine saveUsine(TopiaContext transaction, Usine usine) throws TopiaException, LogicException {
        Usine usine2;
        UsineDAO dao = SandraDAOHelper.getUsineDAO(transaction);
        String code = usine.getCode();
        String topiaId = usine.getTopiaId();
        if (topiaId == null || "".equals(topiaId)) {

            if (dao.findByCode(code) != null) {
                throw new LogicException("error.service.factory.already.exists");
            }
            // create
            usine2 = dao.createByNaturalId(code);
            if (log.isInfoEnabled()) {
                log.info("has created usine " + usine2.getTopiaId());
            }
        } else {
            // update
            usine2 = dao.findByTopiaId(topiaId);
            // check if code has changed thaht it is available
            if (!usine2.getCode().equals(code) && dao.findByCode(code) != null) {
                throw new LogicException("error.service.factory.already.exists");
            }
            if (log.isInfoEnabled()) {
                log.info("update usine " + usine2.getTopiaId());
            }
        }

        // Data
        usine2.setAdresse(usine.getAdresse());
        usine2.setCodePostal(usine.getCodePostal());
        usine2.setVille(usine.getVille());

        dao.update(usine2);
        return usine2;
    }

    @Override
    @Transaction
    public List<Eleveur> getEleveurs(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getEleveurs");
        }
        List<Eleveur> eleveurs = ProfilManager.find(transaction, Eleveur.class, "SELECT eleveur FROM " + Eleveur.class.getName() + " eleveur ORDER BY eleveur.raisonSociale");
        return eleveurs;
    }

    @Override
    @Transaction
    public List<Eleveur> getEleveurs(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getEleveurs [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">");
        }
        String query = "SELECT eleveur FROM " + Eleveur.class.getName() + " eleveur" + SandraHelper.addOrder("eleveur", sortCriterion, sortDirection);
        List<Eleveur> eleveurs = ProfilManager.findWithBounds(transaction, Eleveur.class, query, startIndex, endIndex);
        return eleveurs;
    }

    @Override
    @Transaction
    public List<Eleveur> getEleveurs(TopiaContext transaction, String breederQuery, String gpsKey, String nivSecu, String camion,
                                     String societe, Date dateLivraison, String operator, int startIndex, int endIndex,
                                     String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getEleveurs with query '" + breederQuery + "' gps : " + gpsKey +
                    " niveau de secu : " + nivSecu + " code camion : " + camion +
                    " code societe " + societe + " Date livraison : " + dateLivraison +
                    " [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">");
        }
        List<Object> arguments = new ArrayList<Object>();

        // Begin of query
        String startQuery = "SELECT eleveur FROM " + Eleveur.class.getName() + " eleveur";
        String query = buildEleveurQuery(startQuery, breederQuery, gpsKey, nivSecu, camion,
                societe, dateLivraison, operator, arguments);

        if (sortCriterion != null) {
            query += SandraHelper.addOrder("eleveur", sortCriterion, sortDirection);
        }

        if (log.isDebugEnabled()) {
            log.debug("final query : " + query);
        }

        List<Eleveur> eleveurs = ProfilManager.findWithBounds(transaction, Eleveur.class, query, startIndex, endIndex, arguments.toArray());
        return eleveurs;
    }

    @Override
    @Transaction
    public int getEleveursCount(TopiaContext transaction, String breederQuery, String gpsKey, String nivSecu, String camion, String societe, Date livraisonDate, String operator) throws TopiaException, LogicException {

        List<Object> arguments = new ArrayList<Object>();

        // Begin of query
        String startQuery = "SELECT COUNT(eleveur.topiaId) FROM " + Eleveur.class.getName() + " eleveur";
        String query = buildEleveurQuery(startQuery, breederQuery, gpsKey, nivSecu, camion,
                                 societe, livraisonDate, operator, arguments);

        Object[] args = arguments.toArray();

        if (log.isDebugEnabled()) {
            log.debug("final count query : " + query + " with args : " + Arrays.toString(args));
        }

        int eleveursCount = ProfilManager.count(transaction, Eleveur.class, query, args);
        return eleveursCount;
    }

    protected String buildEleveurQuery(String startQuery, String breederQuery, String gpsKey, String nivSecu, String camion,
                                     String societe, Date dateLivraison, String operator, List<Object> arguments) {

        if (dateLivraison != null){
            return buildEleveurQuery(startQuery,
                                    breederQuery,
                                    gpsKey,
                                    nivSecu,
                                    camion,
                                    societe,
                                    DateUtil.setMinTimeOfDay(dateLivraison),
                                    DateUtil.setMaxTimeOfDay(dateLivraison),
                                    operator,
                                    arguments);
        }
        return buildEleveurQuery(startQuery,
                                breederQuery,
                                gpsKey,
                                nivSecu,
                                camion,
                                societe,
                                null,
                                null,
                                operator,
                                arguments);
    }

    protected String buildEleveurQuery(String startQuery, String breederQuery, String gpsKey, String nivSecu, String camion,
                                     String societe, Date dateLivraisonStart, Date dateLivraisonEnd, String operator, List<Object> arguments) {

        String query = "";
        String endQuery = "";
        if (dateLivraisonStart != null || dateLivraisonEnd != null || !StringUtils.isEmpty(camion)) {
            query += ", " + Etape.class.getName() + " etape";
            endQuery = " eleveur.topiaId = etape.eleveur AND etape.tour IN (SELECT tour FROM " + Tour.class.getName() +
                " tour WHERE";

            if (dateLivraisonStart != null) {
                endQuery += " tour.dateLivraison >= :beginDateLivraison AND";
                arguments.add("beginDateLivraison");
                arguments.add(dateLivraisonStart);

            }
            if (dateLivraisonEnd != null) {
                endQuery += " tour.dateLivraison < :endDateLivraison AND";
                arguments.add("endDateLivraison");
                arguments.add(DateUtil.setMaxTimeOfDay(dateLivraisonEnd));
            }

            if (!StringUtils.isEmpty(camion)) {
                endQuery += " tour.camion.topiaId = :camion";
                arguments.add("camion");
                arguments.add(camion);
            }

            endQuery = removeEndOfRequest(endQuery);
            endQuery += ")";
        }

        query += " WHERE";

        // Adding like on query
        if (!StringUtils.isEmpty(breederQuery)) {
            query += " (lower(eleveur.raisonSociale) LIKE '%" +
                    breederQuery.toLowerCase() +
                    "%' OR lower(eleveur.ville) LIKE '%" +
                    breederQuery.toLowerCase() + "%') AND";
        }

        if (!StringUtils.isEmpty(societe)) {
            query += " eleveur.societe.topiaId = :societe AND";
            arguments.add("societe");
            arguments.add(societe);
        }

        if (!StringUtils.isEmpty(gpsKey) && !StringUtils.isEmpty(nivSecu)) {
            Integer nivSecuAsInt = Integer.parseInt(nivSecu);

            // AND by default
            if (StringUtils.isEmpty(operator)) {
                operator = "AND";
            }
            query +=  " (" + getGpsQuery(gpsKey) + " " + operator +
                " eleveur.accesEleveur.niveauSecurite = :nivSecu) AND";
            arguments.add("nivSecu");
            if (nivSecuAsInt.equals(0)) {
                nivSecuAsInt = -1;
            }
            arguments.add(nivSecuAsInt);
        } else {
            if (!StringUtils.isEmpty(gpsKey)) {
                query +=  getGpsQuery(gpsKey) + " AND";
            } else if (!StringUtils.isEmpty(nivSecu)){
                Integer nivSecuAsInt = Integer.parseInt(nivSecu);
                query +=  " eleveur.accesEleveur.niveauSecurite = :nivSecu AND";
                arguments.add("nivSecu");
                if (nivSecuAsInt.equals(0)) {
                    nivSecuAsInt = -1;
                }
                arguments.add(nivSecuAsInt);
            }
        }

        String finalQuery = startQuery + query + endQuery;
        finalQuery = removeEndOfRequest(finalQuery);
        if (log.isDebugEnabled()) {
            log.debug("Final query is : " + finalQuery);
        }
        return finalQuery;
    }

    protected String removeEndOfRequest(String query) {
        if (query.endsWith("AND")) {
            query = query.substring(0, query.length() - 3);
        }
        if (query.endsWith("WHERE")) {
            query = query.substring(0, query.length() - 5);
        }
        return query;
    }

    protected String getGpsQuery(String gpsKey) {
        GPSStateEnum state = GPSStateEnum.getGPSState(gpsKey);
        String result = "";
        switch (state) {
            case GPS_EMPTY:
                result = " (eleveur.tomtomGPS IS NULL)";
                break;
            case GPS_LOCKED:
                result = " (eleveur.nbTomTomGPSModif > 3)";
                break;
            case GPS_OK:
                result = " (eleveur.tomtomGPS IS NOT NULL AND eleveur.nbTomTomGPSModif <= 3)";
                break;
        }
        return result;
    }

    @Override
    @Transaction
    public Eleveur getEleveur(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getEleveur " + topiaId);
        }
        String query = "SELECT eleveur FROM " + Eleveur.class.getName() + " eleveur WHERE eleveur.topiaId = :topiaId";
        Eleveur eleveur = ProfilManager.findUnique("error.service.eleveur.unfound", transaction, Eleveur.class, query, "topiaId", topiaId);
        return eleveur;
    }

    @Override
    @Transaction
    public void saveEleveurGPS(TopiaContext transaction, String topiaId, Point point) throws TopiaException, LogicException {
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);
        Eleveur eleveur = eleveurDAO.findByTopiaId(topiaId);
        if (eleveur == null) {
            throw new LogicException("error.service.eleveur.unfound");
        }

        PointGPS pointGPSOld = null;
        // Suprresion de l'ancienne coordonnees GPS
        if (eleveur.getTomtomGPS() != null) {
            pointGPSOld = eleveur.getTomtomGPS();
            PointGPS pointGPS = eleveur.getTomtomGPS();
            SandraDAOHelper.getPointGPSDAO(transaction).delete(pointGPS);
        }

        // Création de la coordonnees GPS
        if (eleveur.getNbTomTomGPSModif() <= 3) {

            if (point.getX() != 0 && point.getY() != 0) {
                PointGPSDAO pointGPSDAO = SandraDAOHelper.getPointGPSDAO(transaction);
                PointGPS pointGPS = pointGPSDAO.create("point", point);
                eleveur.setTomtomGPS(pointGPS);
            } else {
                eleveur.setTomtomGPS(null);
            }
        }

        // Modification du nombre de modification du tomtomGPS
        eleveur.setNbTomTomGPSModif(0);

        eleveurDAO.update(eleveur);

        // Get old gps points
        double oldX = pointGPSOld == null || pointGPSOld.getPoint() == null ? 0 : pointGPSOld.getPoint().getX();
        double oldY = pointGPSOld == null || pointGPSOld.getPoint() == null ? 0 : pointGPSOld.getPoint().getY();

        // Get new GPS points
        double newX = point.getX();
        double newY = point.getY();

        // gps point has really changed
        if (oldX != newX || oldY != newY) {

            // gps point has really changed
            serviceNotifier.notifyEvent("updateWebBreederGPS", ServiceHelper.getSandraName(),
                    ServiceHelper.getSandraUrl(), SecurityHelper.getUser().getLogin(), eleveur.getTopiaId(),
                    String.valueOf(oldX),
                    String.valueOf(oldY),
                    String.valueOf(newX),
                    String.valueOf(newY));
        }
    }

    @Override
    @Transaction
    public void lockEleveurGPS(TopiaContext transaction, String topiaId, boolean lock) throws TopiaException, LogicException {
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);
        Eleveur eleveur = eleveurDAO.findByTopiaId(topiaId);
        if (eleveur == null) {
            throw new LogicException("error.service.eleveur.unfound");
        }

        if (lock) {
            eleveur.setNbTomTomGPSModif(Integer.MAX_VALUE);
        } else {
            eleveur.setNbTomTomGPSModif(0);

            // Get email of user was lock
            InfoAccess accesEleveur = eleveur.getAccesEleveur();
            Collection<TaasUser> users = accesEleveur.getUsersVerrouillage();

            if (users != null && !users.isEmpty()) {
                for (TaasUser user : users) {
                    String email = user.getEmail();

                    // Send email
                    if (!StringUtils.isEmpty(email)) {
                        String eleveurLbl = eleveur.getRaisonSociale() + eleveur.getVille() + " (" + eleveur.getCodePostal().substring(0, 2) + ")";
                        String eleveurUrl = ServiceHelper.getSandraUrl() + "/appli/breeder/view.do?topiaId=" + eleveur.getTopiaId().replace("#", "%23");
                        EmailHelper.sendEmail(email, "[" + ServiceHelper.getSandraUrl() + "] Le GPS de l'éleveur '" + eleveurLbl + "' est déverrouillé.",
                                "Le GPS de l'éleveur '" + eleveurLbl + "' vient d'être déverrouillé : " + eleveurUrl);
                    }
                }

                // Clear all user verrouillage
                accesEleveur.clearUsersVerrouillage();

                InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);
                infoAccessDAO.update(accesEleveur);
            }
        }
        eleveurDAO.update(eleveur);
    }

    @Override
    @Transaction
    public String getMessageBienvenue(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getMessageBienvenue");
        }
        String valeur = null;
        LabelDAO labelDAO = SandraDAOHelper.getLabelDAO(transaction);
        Label label = labelDAO.findById("msg0");
        if (label != null) {
            valeur = label.getValeur();
        }
        return valeur;
    }

    @Override
    @Transaction
    public String getCopyright(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getCopyright");
        }
        String valeur = null;
        LabelDAO labelDAO = SandraDAOHelper.getLabelDAO(transaction);
        Label label = labelDAO.findById("copyright");

        if (label != null) {
            valeur = label.getValeur();
        }
        return valeur;
    }

    @Override
    @Transaction
    public int getUsersCount(TopiaContext transaction, boolean viewCamion) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getUsersCount");
        }
        String hql = "SELECT COUNT(user.topiaId) FROM " + TaasUser.class.getName() + " user";
        hql += getUserHql(viewCamion);
        int count = ProfilManager.count(transaction, TaasUser.class, hql);
        return count;
    }

    @Override
    @Transaction
    public List<TaasUser> getAllUsers(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getAllUsers");
        }
        String hql = "SELECT user FROM " + TaasUser.class.getName() + " user" + getUserHql(false);
        List<TaasUser> users = ProfilManager.find(transaction, TaasUser.class, hql);
        for (TaasUser user : users) {
            //fixme : pb de lazy...
            user.getPrincipals().size();
        }
        return users;
    }

    @Override
    @Transaction
    public List<UserIndicateurs> getAllUserIndicateurs(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getAllUsers");
        }
        String hql = "SELECT userIndicateur FROM " + UserIndicateurs.class.getName() +
                " userIndicateur JOIN userIndicateur.taasUser AS taasUser " + getUserHql(true);
        List<UserIndicateurs> users = ProfilManager.find(transaction, UserIndicateurs.class, hql);
        return users;
    }

    @Override
    @Transaction
    public List<TaasUser> getAllUsers(TopiaContext transaction, boolean isCamion) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.info("getAllUsers");
        }
        List<TaasUser> users;
        if (!isCamion) {
            users = getAllUsers(transaction);
        } else {
            users = getAllCamionUser(transaction);
        }
        return users;
    }

    @Override
    @Transaction
    public List<TaasUser> getAllCamionUser(TopiaContext transaction) throws TopiaException, LogicException {
        return SandraHelper.getAllCamionUser(transaction);
    }

    @Override
    @Transaction
    public List<TaasUser> getUsers(TopiaContext transaction, boolean viewCamion, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("gtUsers [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">");
        }
        String hql = "SELECT user FROM " + TaasUser.class.getName() + " user";
        hql += getUserHql(viewCamion);
        hql += SandraHelper.addOrder("user", true, sortCriterion, sortDirection);
        List<TaasUser> users = ProfilManager.findWithBounds(transaction, TaasUser.class, hql, startIndex, endIndex);
        for (TaasUser user : users) {
            //fixme : pb de lazy...
            user.getPrincipals().size();
        }
        return users;
    }

    protected static String getUserHql(boolean viewCamion){
        if (viewCamion){
            return " WHERE user IN (" +
                    " SELECT user FROM " + TaasUser.class.getName() +
                    " user JOIN user.principals AS principal WHERE" +
                    " principal.name = 'synchro' AND user.login != 'synchro')";
        }
        return " WHERE user NOT IN (" +
                " SELECT user2 FROM " + TaasUser.class.getName() + " user2" +
                " JOIN user2.principals AS principal WHERE" +
                " principal.name = 'synchro')";
    }

    @Override
    @Transaction
    public int getUserIndicateursCount(TopiaContext transaction, boolean viewCamion) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getUserIndicateursCount");
        }
        String hql = "SELECT COUNT(userIndicateurs.topiaId) FROM " + UserIndicateurs.class.getName() +
                " userIndicateurs WHERE userIndicateurs.taasUser IN (SELECT user FROM " + TaasUser.class.getName() + " user";
        hql += getUserIndicateurHql(viewCamion);
        hql += ")";
        return ProfilManager.count(transaction, UserIndicateurs.class, hql);
    }

    @Override
    @Transaction
    public List<UserIndicateurs> getUserIndicateurs(TopiaContext transaction, boolean viewCamion, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("gtUsersIndicator [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">");
        }

        String hql = "SELECT userIndicateurs FROM " + UserIndicateurs.class.getName() +
                " userIndicateurs WHERE userIndicateurs.taasUser IN (SELECT user FROM " + TaasUser.class.getName() + " user";
        hql += getUserIndicateurHql(viewCamion);
        if ("login".equals(sortCriterion) ||
            "email".equals(sortCriterion) ||
            "lastConnectionDate".equals(sortCriterion) ||
            "link".equals(sortCriterion)) {

            hql += SandraHelper.addOrder("user", true, sortCriterion, sortDirection);
        } else {
            hql += SandraHelper.addOrder("userIndicateurs", true, sortCriterion, sortDirection);
        }
        hql += ")";
        return ProfilManager.findWithBounds(transaction, UserIndicateurs.class, hql, startIndex, endIndex);
    }

    protected static String getUserIndicateurHql(boolean viewCamion){
        if (viewCamion){
            return " WHERE user IN (" +
                " SELECT user FROM " + TaasUser.class.getName() +
                " user JOIN user.principals AS principal WHERE" +
                " principal.name = 'synchro' AND user.login != 'synchro')";
        }
        return " WHERE user NOT IN (" +
            " SELECT user2 FROM " + TaasUser.class.getName() + " user2" +
            " JOIN user2.principals AS principal WHERE" +
            " principal.name = 'synchro')";
    }

    @Override
    @Transaction
    public TaasUser getUser(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getUser " + topiaId);
        }
        String query = "SELECT user FROM " + TaasUser.class.getName() + " user WHERE user.topiaId = :topiaId";
        TaasUser user = ProfilManager.findUnique("error.service.user.unfound", transaction, TaasUser.class, query, "topiaId", topiaId);
        //fixme : pb de lazy...
        user.getPrincipals().size();
        return user;
    }

    @Override
    @Transaction
    public TaasUser getSafeUser(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        TaasUser user;
        try {
            user = getUser(transaction, topiaId);
        } catch (LogicException eee) {
            // If not ifound search with userIndicateur
            UserIndicateurs userIndicateurs = getUserIndicateurs(transaction, topiaId);
            user = userIndicateurs.getTaasUser();
        }
        return user;
    }

    @Override
    @Transaction
    public UserIndicateurs getUserIndicateurs(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getUser " + topiaId);
        }
        String query = "SELECT userIndicateurs FROM " + UserIndicateurs.class.getName() + " userIndicateurs WHERE userIndicateurs.topiaId = :topiaId";
        UserIndicateurs user = ProfilManager.findUnique("error.service.user.unfound", transaction, UserIndicateurs.class, query, "topiaId", topiaId);

        return user;
    }

    @Override
    public TaasUser getUser() throws TopiaException {
        return SecurityHelper.getUser();
    }

    protected String getUserLogin() throws TopiaException {
        String login = "not found";
        TaasUser user = getUser();
        if (user != null) {
            login = user.getLogin();
        }

        return login;
    }

    @Override
    @Transaction
    public TaasUser saveUser(TopiaContext transaction, TaasUser user, boolean isWeb, boolean isAdmin, String profil)
            throws TopiaException, LogicException {
        TaasUser user2;
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO(transaction);
        TaasPrincipalDAO principalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO(transaction);
        TaasAuthorizationDAO authorizationDAO = TopiaSecurityDAOHelper.getTaasAuthorizationDAO(transaction);

        String topiaId = user.getTopiaId();
        String login = user.getLogin();
        String email = user.getEmail();

        if (topiaId == null || "".equals(topiaId)) {
            // Create user
            if (principalDAO.findByName(login) != null || userDAO.findByEmail(email) != null) {
                throw new LogicException("error.service.user.already.exists");
            }

            // Création de l'utilisateur
            user2 = userDAO.create();
            topiaId = user2.getTopiaId();

            // Mot de passe
            String passwd = RandomStringUtils.randomAlphanumeric(7);
            user2.setPassword(TaasUtil.hash(passwd));

            EmailHelper.sendEmail(email, "[" + ServiceHelper.getSandraUrl() + "] Bienvenue sur Sandra",
                    "Votre compte a été crée. Votre login est : " + login + ", votre mot de passe est : " + passwd);

            // Ajout de l'authorisation de modification sur lui-même
            TaasPrincipal principalUser = principalDAO.create("name", login);
            TaasAuthorization authorization = authorizationDAO.create(
                    "expression", topiaId,
                    "actions", TaasUtil.UPDATE);
            principalUser.addAuthorizations(authorization);
            user2.addPrincipals(principalUser);

        } else {
            user2 = userDAO.findByTopiaId(topiaId);

            // Modification du login
            String beforeLogin = user2.getLogin();
            if (!login.equals(beforeLogin)) {
                TaasPrincipal principalUser = principalDAO.findByName(beforeLogin);
                principalUser.setName(login);
            }
        }

        // Data
        user2.setLogin(login);
        user2.setEmail(email);
        user2.setEnabled(user.getEnabled());
        user2.setLink(user.getLink());

        // Update web principal
        TaasPrincipal principalWeb = principalDAO.findByName("web");
        if (isWeb) {
            if (!user2.getPrincipals().contains(principalWeb)) {
                user2.addPrincipals(principalWeb);
            }
        } else {
            user2.getPrincipals().remove(principalWeb);
        }

        // Update admin profil
        String principalAdminName = NotifierSecurityHelper.getAdminProfilValue(profil);
        if (principalAdminName != null) {
            TaasPrincipal principalAdmin = principalDAO.findByName(principalAdminName);
            if (isAdmin) {
                if (!user2.getPrincipals().contains(principalAdmin)) {
                    user2.addPrincipals(principalAdmin);
                }
            } else {
                user2.getPrincipals().remove(principalAdmin);
            }
        }

        SandraHelper.createUserIndicateurIfDontExist(transaction, user);

        userDAO.update(user2);
        return user2;
    }

    @Override
    @Transaction
    public void addProfilUser(TopiaContext transaction, String topiaIdUser, String topiaIdProfil)
            throws TopiaException, LogicException {

        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO(transaction);
        TaasPrincipalDAO principalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO(transaction);
        TaasAuthorizationDAO authorizationDAO = TopiaSecurityDAOHelper.getTaasAuthorizationDAO(transaction);

        TaasUser user = null;
        // Search user
        user = checkUserExists(userDAO.findByTopiaId(topiaIdUser));

        // Add profil type
        TaasPrincipal principal = principalDAO.findByName(user.getLogin());
        if (principal.getAuthorizations().size() == 1) { // Pas empty car contient l'autorisation de modification de son compte
            String principalTypeName = SecurityHelper.getProfilName(topiaIdProfil);
            TaasPrincipal principalType = principalDAO.findByName(principalTypeName);
            user.addPrincipals(principalType);
        }

        // Search or create authorization
        TaasAuthorization authorization = authorizationDAO.findByProperties(
                TaasAuthorization.EXPRESSION, topiaIdProfil,
                TaasAuthorization.ACTIONS, TaasUtil.LOAD);
        if (authorization == null) {
            authorization = authorizationDAO.create(
                    TaasAuthorization.EXPRESSION, topiaIdProfil,
                    TaasAuthorization.ACTIONS, TaasUtil.LOAD);
        }

        // Add
        principal.addAuthorizations(authorization);
    }

    @Override
    @Transaction
    public void deleteProfilUser(TopiaContext transaction, String topiaIdUser, String topiaIdProfil) throws TopiaException, LogicException {

        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO(transaction);
        TaasPrincipalDAO principalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO(transaction);
        TaasAuthorizationDAO authorizationDAO = TopiaSecurityDAOHelper.getTaasAuthorizationDAO(transaction);

        // Search user
        TaasUser user = checkUserExists(userDAO.findByTopiaId(topiaIdUser));

        // Search authorization
        TaasAuthorization authorization = authorizationDAO.findByProperties(
                TaasAuthorization.EXPRESSION, topiaIdProfil,
                TaasAuthorization.ACTIONS, TaasUtil.LOAD);
        if (authorization == null) {
            throw new LogicException("error.service.authorization.unfound");
        }

        // Delete
        TaasPrincipal principal = principalDAO.findByName(user.getLogin());
        principal.removeAuthorizations(authorization);
        transaction.commitTransaction();

        // Delete profil type
        if (principal.getAuthorizations().size() == 1) { // Pas empty car contient l'autorisation de modification de son compte
            // Profil
            String principalTypeName = SecurityHelper.getProfilName(topiaIdProfil);
            TaasPrincipal principalType = principalDAO.findByName(principalTypeName);
            user.getPrincipals().remove(principalType);

            // Admin profil
            String principalAdminName = NotifierSecurityHelper.getAdminProfilName(topiaIdProfil);
            TaasPrincipal principalAdmin = principalDAO.findByName(principalAdminName);
            user.getPrincipals().remove(principalAdmin);
        }
    }

    @Override
    @Transaction
    public void passwdUser(TopiaContext transaction, String passwdBefore, String passwdNew) throws TopiaException, LogicException {
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO(transaction);

        // Search user
        TaasUser privateCredential = SecurityHelper.getUser();

        TaasUser user = userDAO.findByTopiaId(privateCredential.getTopiaId());
        if (!user.getPassword().equals(TaasUtil.hash(passwdBefore))) {
            throw new LogicException("error.service.user.unvalid.beforePassword");
        }

        user.setPassword(TaasUtil.hash(passwdNew));
    }

    @Override
    @Transaction
    public void sendPasswdUser(TopiaContext transaction, String email) throws TopiaException, LogicException {
        TaasUserDAO userDAO = TopiaSecurityDAOHelper.getTaasUserDAO(transaction);

        // Search user
        TaasUser user = checkUserExists(userDAO.findByEmail(email));

        String passwd = RandomStringUtils.randomAlphanumeric(7);
        user.setPassword(TaasUtil.hash(passwd));

        EmailHelper.sendEmail(email, "[" + ServiceHelper.getSandraName() + "] Nouveau mot de passe",
                "Votre nouveau mot de passe pour l'instance " + ServiceHelper.getSandraUrl() + " est : " + passwd);
    }

    @Override
    @Transaction
    public List<TaasUser> getUsersPrincipal(TopiaContext transaction, String name) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getUsersByPrincipal " + name);
        }
        String query = "SELECT user FROM " + TaasUser.class.getName() + " user JOIN user.principals AS principal WHERE principal.name = :name ORDER BY user.login";
        List<TaasUser> users = ProfilManager.find(transaction, TaasUser.class, query, "name", name);
        return users;
    }

    /**
     * Pour verifier qu'un utilisateur existe bien.
     * <p/>
     * On teste juste le fait que le user n'est pas <code>null</code>, sinon on souleve une exception logique.
     *
     * @param user l'utilisateur donne
     * @return l'utilisateur s'il est non null.
     * @throws LogicException si l'utiliseur n'existe pas (i.e si user==<code>null</code>)
     */
    protected TaasUser checkUserExists(TaasUser user) throws LogicException {
        if (user == null) {
            throw new LogicException("error.service.user.unfound");
        }
        return user;
    }

    protected String createTourQuery(String beginQuery, TopiaContext transaction,
                                     Date dateDebut, Date dateFin, boolean planifie, boolean termine,
                                     String topiaIdSociete, String topiaIdTransporteur,
                                     String topiaIdCamion, String topiaIdChauffeur,
                                     List<Object> arguments) throws TopiaException {

        List<String> criteres = new ArrayList<String>();

        Societe societe = null;
        Transporteur transporteur = null;
        Camion camion = null;
        Chauffeur chauffeur = null;

        if (topiaIdSociete != null) {
            SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(transaction);
            societe = societeDAO.findByTopiaId(topiaIdSociete);
        }
        if (topiaIdTransporteur != null) {
            TransporteurDAO transporteurDAO = SandraDAOHelper.getTransporteurDAO(transaction);
            transporteur = transporteurDAO.findByTopiaId(topiaIdTransporteur);
        }
        if (topiaIdCamion != null) {
            CamionDAO camionDAO = SandraDAOHelper.getCamionDAO(transaction);
            camion = camionDAO.findByTopiaId(topiaIdCamion);
        }
        if (topiaIdChauffeur != null) {
            ChauffeurDAO chauffeurDAO = SandraDAOHelper.getChauffeurDAO(transaction);
            chauffeur = chauffeurDAO.findByTopiaId(topiaIdChauffeur);
        }

        String requete = beginQuery;

        arguments.add("dateDebut");
        arguments.add(DateUtil.setMinTimeOfDay(dateDebut));
        criteres.add("tour.dateLivraison >= :dateDebut");

        arguments.add("dateFin");
        arguments.add(DateUtil.setMaxTimeOfDay(dateFin));
        criteres.add("tour.dateLivraison <= :dateFin");

        // only actifs tours
        criteres.add("tour.actif = true");

        // TODO sle 04/11/10 : refactor status
        // suivi tour is null for planifie (PDA)
        // -1 for termine (PDA)
        boolean useJoin = false;
        if (!planifie && !termine) {
            arguments.add("statusTourTermine");
            arguments.add(-1);
            criteres.add("(suiviTour IS NOT NULL AND " +
                    "suiviTour.status != :statusTourTermine)");

            useJoin = true;
        } else if (planifie && !termine) {
            criteres.add("tour.suiviTour IS NULL");

        } else if (!planifie && termine) {
            arguments.add("statusTourTermine");
            arguments.add(-1);
            criteres.add("suiviTour.status = :statusTourTermine");
            useJoin = true;
        }

        if (societe != null) {
            arguments.add("societe");
            arguments.add(societe);
            criteres.add("tour.camion.societe = :societe");
        }

        if (transporteur != null) {
            arguments.add("transporteur");
            arguments.add(transporteur);
            criteres.add("tour.camion.transporteur = :transporteur");
        }

        if (camion != null) {
            arguments.add("camion");
            arguments.add(camion);
            criteres.add("tour.camion = :camion");
        }

        if (chauffeur != null) {
            arguments.add("chauffeur");
            arguments.add(chauffeur);
            criteres.add("tour.defautChauffeur = :chauffeur");
        }

        // Création de la requete
        if (!criteres.isEmpty()) {
            if (!useJoin) {
                requete += " FROM  " +
                    Tour.class.getName() + " tour WHERE ";
            } else {
                requete += " FROM " +
                    Tour.class.getName() + " tour LEFT JOIN tour.suiviTour AS suiviTour WHERE ";
            }
        }

        String and = "";
        for (String critere : criteres) {
            requete += and + critere;
            and = " AND ";
        }
        return requete;
    }

    @Override
    @Transaction
    public InputStream getFileNote(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        NoteDAO dao = SandraDAOHelper.getNoteDAO(transaction);

        Note note = dao.findByTopiaId(topiaId);
        if (note == null) {
            throw new LogicException("error.service.note.unfound");
        }

        String name = SandraConfigHelper.getNoteDir(SandraConfig.getConfig()) + File.separator + note.getNom();
        InputStream inputStream;
        try {
            inputStream = new FileInputStream(name);
        } catch (FileNotFoundException ex) {
            throw new LogicException("error.service.file.unfound", ex);
        }
        return inputStream;
    }

    @Override
    @Transaction
    public Note saveNote(TopiaContext transaction, Note note, InputStream inputStream) throws TopiaException, LogicException {
        Note note2;
        NoteDAO dao = SandraDAOHelper.getNoteDAO(transaction);

        Note noteByNom = dao.findByNom(note.getNom());
        if (noteByNom != null) {
            throw new LogicException("error.service.note.exist");
        }

        String topiaId = note.getTopiaId();
        if (topiaId == null || "".equals(topiaId)) {

            // create
            note2 = dao.create();
            if (log.isInfoEnabled()) {
                log.info("has created note " + note2.getTopiaId());
            }
        } else {
            // update
            note2 = dao.findByTopiaId(topiaId);
            if (log.isInfoEnabled()) {
                log.info("update note " + note2.getTopiaId());
            }
        }

        // Data
        note2.setNom(note.getNom());
        note2.setDescription(note.getDescription());
        note2.setContentType(note.getContentType());

        // store file
        String name = SandraConfigHelper.getNoteDir(SandraConfig.getConfig()) + File.separator + note2.getNom();
        try {
            OutputStream outputStream = new FileOutputStream(name);
            IOUtils.copy(inputStream, outputStream);
        } catch (IOException ex) {
            log.error("error.service.file.copy", ex);
            throw new LogicException("error.service.file.copy", ex);
        }

        dao.update(note2);
        return note2;
    }

    @Override
    @Transaction
    public void addNote(TopiaContext transaction, String eleveurTopiaId, String noteTopiaId) throws TopiaException, LogicException {
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);
        Eleveur eleveur = eleveurDAO.findByTopiaId(eleveurTopiaId);
        if (eleveur == null) {
            throw new LogicException("error.service.eleveur.unfound");
        }

        NoteDAO noteDAO = SandraDAOHelper.getNoteDAO(transaction);
        Note note = noteDAO.findByTopiaId(noteTopiaId);
        if (note == null) {
            throw new LogicException("error.service.note.unfound");
        }

        eleveur.addNotes(note);
        eleveurDAO.update(eleveur);
    }

    @Override
    @Transaction
    public void deleteNote(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        NoteDAO dao = SandraDAOHelper.getNoteDAO(transaction);
        Note note = dao.findByTopiaId(topiaId);
        if (note == null) {
            throw new LogicException("error.service.note.unfound");
        }

        dao.delete(note);
        String name = SandraConfigHelper.getNoteDir(SandraConfig.getConfig()) + File.separator + note.getNom();
        boolean deleted = new File(name).delete();
        if (!deleted) {
            log.error("Cant delete note : " + name);
        }
    }

    @Override
    @Transaction
    public Note getNote(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getNote " + topiaId);
        }
        String query = "SELECT note FROM " + Note.class.getName() + " note WHERE note.topiaId = :topiaId";
        Note note = ProfilManager.findUnique("error.service.note.unfound", transaction, Note.class, query, "topiaId", topiaId);
        return note;
    }

    @Override
    @Transaction
    public List<Label> getLabels(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getLabels");
        }
        List<Label> labels = ProfilManager.find(transaction, Label.class,
                    "SELECT label FROM " + Label.class.getName() + " label ORDER BY label.categorie, label.id");
        return labels;
    }

    @Override
    @Transaction
    public List<Label> getLabels(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getLabels [" + startIndex + "-" + endIndex + "]<" + sortCriterion + "-" + sortDirection + ">");
        }
        String query = "SELECT label FROM " + Label.class.getName() + " label";
        String order;
        if (sortCriterion == null) {
            order = " ORDER BY label.categorie, label.id";
        } else {
            order = SandraHelper.addOrder("label", sortCriterion, sortDirection);
        }
        query += order;
        List<Label> labels = ProfilManager.findWithBounds(transaction, Label.class, query, startIndex, endIndex);
        return labels;
    }

    @Override
    @Transaction
    public Label getLabel(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getLabel " + topiaId);
        }
        String query = "SELECT label FROM " + Label.class.getName() + " label WHERE label.topiaId = :topiaId";
        Label usine = ProfilManager.findUnique("error.service.label.unfound", transaction, Label.class, query, "topiaId", topiaId);
        return usine;
    }

    @Override
    @Transaction
    public Label saveLabel(TopiaContext transaction, Label label) throws TopiaException, LogicException {
        Label label2;
        LabelDAO dao = SandraDAOHelper.getLabelDAO(transaction);
        String categorie = label.getCategorie();
        String id = label.getId();
        String topiaId = label.getTopiaId();
        if (topiaId == null || "".equals(topiaId)) {

            if (dao.findByNaturalId(id, categorie) != null) {

                throw new LogicException("error.service.label.already.exists");
            }
            // create
            label2 = dao.create();
            if (log.isInfoEnabled()) {
                log.info("has created label " + label2.getTopiaId());
            }
        } else {
            // update
            label2 = dao.findByTopiaId(topiaId);
            // check if categorie or id has changed and new data are available
            if ((!label2.getCategorie().equals(categorie) || !label2.getId().equals(id))
                    && dao.findByProperties(id, categorie) != null) {
                throw new LogicException("error.service.label.already.exists");
            }
            if (log.isInfoEnabled()) {
                log.info("update label " + label2.getTopiaId());
            }
        }

        // Data
        label2.setCategorie(categorie);
        label2.setId(id);
        label2.setValeur(label.getValeur());

        dao.update(label2);
        return label2;
    }

    @Override
    @Transaction
    public void deleteLabel(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("deleteLabel " + topiaId);
        }
        Label label = getLabel(transaction, topiaId);
        SandraDAOHelper.getLabelDAO(transaction).delete(label);
    }

    @Override
    @Transaction
    public ChargementUsineConfig getChargementUsineConfigForUsine(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getChargementUsineConfigForUsine " + topiaId);
        }
        String query = "SELECT config FROM " + ChargementUsineConfig.class.getName() + " config WHERE config.usine.topiaId = :topiaId";
        ChargementUsineConfig config;
        try {
            config = ProfilManager.findUnique("error.service.loading.usine.unfound", transaction, ChargementUsineConfig.class, query, "topiaId", topiaId);
        } catch (LogicException e) {
            // get usine
            Usine usine = getUsine(transaction, topiaId);

            // create a new one with default values
            ChargementUsineConfigDAO dao = SandraDAOHelper.getChargementUsineConfigDAO(transaction);
            config = dao.create();
            config.setUsine(usine);
            // default configuration
            config.setNombreHeures(25);
            config.setPositionHeureActuelle(40);
            dao.update(config);
        }
        return config;
    }

    @Override
    @Transaction
    public ChargementUsineConfig getChargementUsineConfig(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getChargementUsineConfig " + topiaId);
        }
        String query = "SELECT config FROM " + ChargementUsineConfig.class.getName() + " config WHERE config.topiaId = :topiaId";
        ChargementUsineConfig config = ProfilManager.findUnique("error.service.label.unfound", transaction, ChargementUsineConfig.class, query, "topiaId", topiaId);
        return config;
    }

    @Override
    @Transaction
    public ChargementUsineConfig saveChargementUsineConfig(TopiaContext transaction, ChargementUsineConfig chargementUsineConfig) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("saveChargementUsineConfig " + chargementUsineConfig.getTopiaId());
        }

        ChargementUsineConfig chargementUsineConfig2;
        ChargementUsineConfigDAO dao = SandraDAOHelper.getChargementUsineConfigDAO(transaction);
        String topiaId = chargementUsineConfig.getTopiaId();
        if (topiaId == null || "".equals(topiaId)) {

            // create
            chargementUsineConfig2 = dao.create();

        } else {
            // update
            chargementUsineConfig2 = dao.findByTopiaId(topiaId);

        }

        Usine usine = getUsine(transaction, chargementUsineConfig.getUsine().getTopiaId());

        // Data
        chargementUsineConfig2.setUsine(usine);
        chargementUsineConfig2.setNombreHeures(chargementUsineConfig.getNombreHeures());
        chargementUsineConfig2.setPositionHeureActuelle(chargementUsineConfig.getPositionHeureActuelle());
        chargementUsineConfig2.setTempFixeParTournee(chargementUsineConfig.getTempFixeParTournee());
        chargementUsineConfig2.setTempFixeParLigneProduit(chargementUsineConfig.getTempFixeParLigneProduit());
        chargementUsineConfig2.setTempVariableParQuantite(chargementUsineConfig.getTempVariableParQuantite());

        dao.update(chargementUsineConfig2);
        return chargementUsineConfig2;
    }

    @Override
    @Transaction
    public Eleveur saveEleveur(TopiaContext transaction, Eleveur breeder) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("saveEleveur " + breeder.getTopiaId());
        }

        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(transaction);

        String breederTopiaId = breeder.getTopiaId();
        InfoAccess infoAccess = breeder.getAccesEleveur();
        String accessEleveurTopiaId = breeder.getAccesEleveur().getTopiaId();

        // Get eleveur en base
        Eleveur breederOld = eleveurDAO.findByTopiaId(breederTopiaId);

        // Get access eleveur en based
        InfoAccess infoAccessOld = infoAccessDAO.findByTopiaId(accessEleveurTopiaId);

        // Verification de son existance
        if (infoAccessOld == null) {
            log.error("acces eleveur is null !!!!!");

            // Sinon on le crée
            infoAccessOld = infoAccessDAO.create();
            infoAccessOld.setNiveauSecurite(-1);
            infoAccessOld.setEtat(InfoAccessEtat.INFOACCESS_ACTIF);
            infoAccessOld.setType(0);
        }

        // Notification en cas de changement
        serviceCommon.notifyChangedBreeder(transaction, "updateWebBreeder",
                getUserLogin(), breederOld, breeder, infoAccessOld, infoAccess);

        // https://jira.groupe-glon.fr/browse/SDRAMTNC-295
        // set raisonSocial, adresse and ville only on creation and on web
        breederOld.setRaisonSociale(breeder.getRaisonSociale());

        breederOld.setAdresse(breeder.getAdresse());
        breederOld.setCodeINSEE(breeder.getCodeINSEE());
        breederOld.setCodePostal(breeder.getCodePostal());
        breederOld.setContrainteHoraire(breeder.getContrainteHoraire());
        breederOld.setMobile(breeder.getMobile());
        breederOld.setEmail(breeder.getEmail());
        breederOld.setTelephone(breeder.getTelephone());
        breederOld.setVille(breeder.getVille());
        breederOld.setCommentaire(breeder.getCommentaire());

        Societe societe = societeDAO.findByTopiaId(breeder.getSociete().getTopiaId());
        if (societe != null) {
            breederOld.setSociete(societe);
        } else {
            log.error("societe is null !!!!!");
        }

        // create action security
        SandraHelper.createActionSecuriteIfNeeded(transaction, getUserLogin(), breeder, infoAccess);

        infoAccessOld.addAllRisques(infoAccess.getRisques());
        infoAccessOld.setAccesSilo(infoAccess.getAccesSilo());
        infoAccessOld.setCommentaireSecurite(infoAccess.getCommentaireSecurite());
        infoAccessOld.setEtat(infoAccess.getEtat());
        infoAccessOld.setGps(infoAccess.getGps());
        infoAccessOld.setModeChargement(infoAccess.getModeChargement());
        infoAccessOld.setNiveauSecurite(infoAccess.getNiveauSecurite());
        infoAccessOld.setNomAcces(infoAccess.getNomAcces());
        infoAccessOld.setRisques(infoAccess.getRisques());
        infoAccessOld.setTrace(infoAccess.getTrace());
        infoAccessOld.setType(infoAccess.getType());

        infoAccessDAO.update(infoAccessOld);
        eleveurDAO.update(breederOld);

        return breederOld;
    }


    @Override
    @Transaction
    public InfoAccess getInfoAccess(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getAccesSilo " + topiaId);
        }

        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);

        InfoAccess infoAccess = infoAccessDAO.findByTopiaId(topiaId);
        return infoAccess;
    }

    @Override
    @Transaction
    public Eleveur findEleveurByAccesSilo(TopiaContext transaction, String infoAccessTopiaId) throws TopiaException, LogicException {
        if (log.isInfoEnabled()) {
            log.info("findEleveurByAccesSilo " + infoAccessTopiaId);
        }
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);

        InfoAccess silo = infoAccessDAO.findByTopiaId(infoAccessTopiaId);

        Eleveur breeder = silo.getEleveur();
        return breeder;
    }

    @Override
    @Transaction
    public InfoAccess saveInfoAccess(TopiaContext transaction, InfoAccess infoAccess, String breederTopiaID) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("saveInfoAccess " + infoAccess.getTopiaId());
        }

        InfoAccessDAO dao = SandraDAOHelper.getInfoAccessDAO(transaction);
        String topiaId = infoAccess.getTopiaId();

        // Find acces silo
        InfoAccess infoAccess2 = dao.findByTopiaId(topiaId);

        // Sauvegarde du GPS
        PointGPS oldGPS = null;
        Point newGPS = infoAccess.getGps().getPoint();

        // Suprresion de l'ancienne coordonnees GPS
        if (infoAccess2.getGps() != null) {
            oldGPS = infoAccess2.getGps();
            PointGPS pointGPS = infoAccess2.getGps();
            SandraDAOHelper.getPointGPSDAO(transaction).delete(pointGPS);
        }

        // Création de la coordonnees GPS
        if (infoAccess2.getEtat() == InfoAccessEtat.INFOACCESS_ACTIF) {
            PointGPSDAO pointGPSDAO = SandraDAOHelper.getPointGPSDAO(transaction);
            PointGPS pointGPS = pointGPSDAO.create("point", newGPS);
            infoAccess2.setGps(pointGPS);
        }

        // Envoie de la notif
        serviceCommon.notifyChangedInfoAccess(transaction,
                "updateWebAccesSilo",
                getUserLogin(),
                breederTopiaID,
                infoAccess2,
                infoAccess,
                oldGPS == null ? 0 : oldGPS.getPoint().getX(),
                oldGPS == null ? 0 : oldGPS.getPoint().getY());

        // Update
        infoAccess2.setAccesSilo(infoAccess.getAccesSilo());
        infoAccess2.setCommentaireSecurite(infoAccess.getCommentaireSecurite());
        infoAccess2.setModeChargement(infoAccess.getModeChargement());
        infoAccess2.setNiveauSecurite(infoAccess.getNiveauSecurite());
        infoAccess2.setRisques(infoAccess.getRisques());
        infoAccess2.setTrace(infoAccess.getTrace());
        infoAccess2.setType(infoAccess.getType());

        // create action security
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);
        Eleveur breeder = eleveurDAO.findByTopiaId(breederTopiaID);
        SandraHelper.createActionSecuriteIfNeeded(transaction, getUserLogin(), breeder, infoAccess2);

        dao.update(infoAccess2);
        return infoAccess2;
    }

    @Override
    @Transaction
    public void deleteAccesSilo(TopiaContext transaction, String infoAccessTopiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("deleteAccesSilo " + infoAccessTopiaId);
        }

        InjectorEleveurDuplicated.deleteAccesSilo(transaction, infoAccessTopiaId);
    }

    @Override
    @Transaction
    public void lockOrUnlockInfoAccess(TopiaContext transaction, String infoAccessTopiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("lockOrUnlockInfoAccess " + infoAccessTopiaId);
        }
        InfoAccessDAO dao = SandraDAOHelper.getInfoAccessDAO(transaction);

        InfoAccess infoAccess = dao.findByTopiaId(infoAccessTopiaId);

        if (infoAccess.getEtat() == InfoAccessEtat.INFOACCESS_ACTIF) {
            infoAccess.setEtat(InfoAccessEtat.INFOACCESS_VERROU);
        } else {
            infoAccess.setEtat(InfoAccessEtat.INFOACCESS_ACTIF);

            // Get email of user was lock
            Collection<TaasUser> users = infoAccess.getUsersVerrouillage();

            if (users != null && !users.isEmpty()) {

                for (TaasUser user : users) {
                    String email = user.getEmail();

                    // Send email
                    if (!StringUtils.isEmpty(email)) {
                        Eleveur eleveur = infoAccess.getEleveur();
                        String eleveurLbl = eleveur.getRaisonSociale() + eleveur.getVille() + eleveur.getCodePostal().substring(0, 2);
                        String siloLbl = infoAccess.getNomAcces();
                        String siloUrl = ServiceHelper.getSandraUrl() + "/appli/breeder/infoAccess/view.do?topiaId=" + infoAccess.getTopiaId().replace("#", "%23");
                        EmailHelper.sendEmail(email, "[" + ServiceHelper.getSandraUrl() + "] Le GPS du silo '" + siloLbl + "'de l'éleveur '" + eleveurLbl + "' est déverrouillé.",
                            "Le GPS du silo '" + siloLbl + "' de l'éleveur '" + eleveurLbl + "' est déverrouillé : " + siloUrl);
                    }
                }
                infoAccess.clearUsersVerrouillage();
            }
        }

        dao.update(infoAccess);
    }

    @Override
    @Transaction
    public void findAndDeleteDuplicateInfoAccess(TopiaContext transaction) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("findAndDeleteDuplicateInfoAccess");
        }

        InfoAccessDAO dao = SandraDAOHelper.getInfoAccessDAO(transaction);

        int cnt = 0;
        List<InfoAccess> infoAccessList = dao.findAll();
        Map<String, InfoAccess> infoAccessNames = new HashMap<String, InfoAccess>();

        for (InfoAccess infoAccess : infoAccessList) {
            InfoAccess cached = infoAccessNames.get(infoAccess.getNomAcces());
            if (cached != null) {
                Eleveur cachedEleveur = findEleveurByAccesSilo(transaction, cached.getTopiaId());
                Eleveur eleveur = findEleveurByAccesSilo(transaction, infoAccess.getTopiaId());
                if (cachedEleveur != null && eleveur != null && cachedEleveur.getTopiaId().equals(eleveur.getTopiaId())) {
                    dao.delete(infoAccess);
                    cnt = cnt + 1;
                }
            } else {
                String name = infoAccess.getNomAcces();
                if (name != null && !name.trim().isEmpty()) {
                    infoAccessNames.put(name, infoAccess);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("All duplicate info access are deleted, found : " + cnt);
        }
    }

    @Override
    @Transaction
    public SuiviLigneProduit getSuiviProduit(TopiaContext transaction, LigneProduit product) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("getSuiviProduit : " + product.getTopiaId());
        }
        SuiviLigneProduitDAO suiviLigneProduitDAO = SandraDAOHelper.getSuiviLigneProduitDAO(transaction);

        SuiviLigneProduit suiviProduit = suiviLigneProduitDAO.findByLigneProduit(product);
        if (log.isDebugEnabled()) {
            log.debug("getSuiviProduit : " + (suiviProduit == null ? "null" : suiviProduit.getTopiaId()));
        }
        return suiviProduit;
    }

    @Override
    @Transaction
    public ActionSecurite saveActionSecurite(TopiaContext transaction, ActionSecurite action, String eleveurId, String siloId) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("saveActionSecurite : " + action.getTopiaId() + " for eleveur " + eleveurId + " and silo " + siloId);
        }
        // Get dao
        ActionSecuriteDAO actionDAO = SandraDAOHelper.getActionSecuriteDAO(transaction);
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);

        String topiaId = action.getTopiaId();

        ActionSecurite actionRestored;
        if (topiaId == null || "".equals(topiaId)) {

            // create
            actionRestored = actionDAO.create();

            // Set creation info
            actionRestored.setDateCreation(new Date());
            actionRestored.setUserCreation(getRestoredUser(transaction).getLogin());
        } else {
            // update
            actionRestored = actionDAO.findByTopiaId(topiaId);
        }

        // Update
        actionRestored.setDateAction(action.getDateAction());
        actionRestored.setCommentaire(action.getCommentaire());
        actionRestored.setInfoAccess(action.getInfoAccess());
        actionRestored.setType(action.getType());
        Eleveur eleveur = eleveurDAO.findByTopiaId(eleveurId);
        actionRestored.setEleveur(eleveur);

        InfoAccess silo = infoAccessDAO.findByTopiaId(siloId);
        actionRestored.setInfoAccess(silo);

        // Update breeder
        eleveur.addActionSecurite(actionRestored);

        actionRestored = actionDAO.update(actionRestored);
        eleveurDAO.update(eleveur);

        return actionRestored;
    }

    @Override
    @Transaction
    public void deleteActionSecurite(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("deleteActionSecurite : " + topiaId);
        }
        ActionSecuriteDAO dao = SandraDAOHelper.getActionSecuriteDAO(transaction);
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);
        ActionSecurite action = dao.findByTopiaId(topiaId);
        if (action == null) {
            throw new LogicException("error.service.action.unfound");
        }
        Eleveur eleveur = action.getEleveur();
        eleveur.removeActionSecurite(action);

        eleveurDAO.update(eleveur);
        dao.delete(action);
    }

    @Override
    @Transaction
    public ActionSecurite getActionSecurite(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getActionSecurite : " + topiaId);
        }
        ActionSecuriteDAO dao = SandraDAOHelper.getActionSecuriteDAO(transaction);
        ActionSecurite action = dao.findByTopiaId(topiaId);
        if (action == null) {
            throw new LogicException("error.service.action.unfound");
        }

        return action;
    }

    @Override
    @Transaction
    public Societe getUserSociete(TopiaContext transaction, TaasUser user) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("getUserSociete : " + user);
        }
        SocieteDAO dao = SandraDAOHelper.getSocieteDAO(transaction);
        Societe societe = dao.findByTopiaId(user.getLink());
        if (societe == null) {
            throw new LogicException("error.service.societe.unfound");
        }

        return societe;
    }

    @Override
    @Transaction
    public void requestToUnlockBreeder(TopiaContext transaction, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("requestToUnlockBreeder : " + topiaId);
        }

        TaasUser user = getUser();

        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);
        Eleveur eleveur = eleveurDAO.findByTopiaId(topiaId);
        InfoAccess accesEleveur = eleveur.getAccesEleveur();
        accesEleveur.addUsersVerrouillage(user);
        infoAccessDAO.update(accesEleveur);
        serviceNotifier.notifyEvent("requestUnlockGPS", ServiceHelper.getSandraName(), ServiceHelper.getSandraUrl(), user.getLogin(), topiaId);
    }

    @Override
    @Transaction
    public void requestToUnlockInfoAcces(TopiaContext transaction, Eleveur eleveur, String topiaId) throws TopiaException, LogicException {
        if (log.isDebugEnabled()) {
            log.debug("requestToUnlockBreeder : eleveur[" + eleveur.getTopiaId() + "] silo[" + topiaId + "]");
        }

        TaasUser user = getUser();

        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);
        InfoAccess silo = infoAccessDAO.findByTopiaId(topiaId);
        silo.addUsersVerrouillage(user);
        infoAccessDAO.update(silo);

        serviceNotifier.notifyEvent("requestUnlockInfoAccess",
                ServiceHelper.getSandraUrl(),
                user.getLogin(),
                eleveur.getTopiaId(),
                topiaId);
    }

    @Override
    @Transaction
    public Eleveur registerBreederAsDuplicated(TopiaContext transaction, String eleveurId, String eleveurDuplicatedId) throws TopiaException, LogicException {

        ManagerInjector managerInjector = new ManagerInjector();
        managerInjector.setTransaction(transaction);
        Eleveur eleveur = InjectorEleveurDuplicated.registerBreederAsDuplicated(managerInjector, eleveurId, eleveurDuplicatedId, true);
        return eleveur;
    }
} //ServiceWebImpl
    