package com.cybelia.sandra.services.ejb3;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.ChauffeurDAO;
import com.cybelia.sandra.entities.InfoChargement;
import com.cybelia.sandra.entities.InfoChargementDAO;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.LabelDAO;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourDAO;
import com.cybelia.sandra.entities.TourTypeModif;
import com.cybelia.sandra.entities.synchro.Log;
import com.cybelia.sandra.services.ServiceTour;
import com.cybelia.sandra.services.local.ServiceTourLocal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import org.apache.commons.logging.LogFactory;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.DateUtil;

@Stateless
@SecurityDomain("sandra")
@PermitAll
public class ServiceTourImpl extends BaseServiceImpl implements ServiceTour, ServiceTourLocal {

    private static final org.apache.commons.logging.Log log = LogFactory.getLog(ServiceTourImpl.class);

    @Override
    @Transaction
    public List<Camion> getAssociatedCamionForPrincipalCamion(String codeSociete, String codeCamion)
            throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public List<Camion> getAssociatedCamionForPrincipalCamion(TopiaContext transaction, String codeSociete, String codeCamion)
            throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " getAssociatedCamionForPrincipalCamion codeSociete[" + codeSociete + "] codeCamion[" + codeCamion + "]");
        }

        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(transaction);
        Societe societe = societeDAO.findByCode(codeSociete);

        CamionDAO dao = SandraDAOHelper.getCamionDAO(transaction);
        Camion camion = dao.findByNaturalId(codeCamion, societe);

        if (camion == null) {
            throw new TopiaException("codeCamion is not an existing Camion.codeCamion");
        }
        //        if (!camion.getPrincipal()) {
        //            throw new TopiaException("Requested Camion is not principal");
        //        }
        List<Camion> camionsAssocies = camion.getCamionsAssocies();
        return camionsAssocies;
    }

    /**
     * Récupére tous les camions associés
     *
     * @param codeSociete
     * @param codeCamion
     * @return
     * @throws TopiaException
     */
    protected List<Camion> findAllAssociatedCamions(TopiaContext transaction, String codeSociete, String codeCamion)
            throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " findAllAssociatedCamions codeSociete[" + codeSociete + "] codeCamion[" + codeCamion + "]");
        }

        List<Camion> result = null;

        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(transaction);
        Societe societe = societeDAO.findByCode(codeSociete);

        CamionDAO dao = SandraDAOHelper.getCamionDAO(transaction);
        Camion camion = dao.findByNaturalId(codeCamion, societe);

        if (camion == null) {
            throw new TopiaException("codeCamion is not an existing Camion.codeCamion");
        }
        boolean isPrincipal = !camion.getCamionsAssocies().isEmpty();
        Camion principal = camion;
        if (!isPrincipal) {
            Camion found = dao.findContainsCamionsAssocies(camion);
            if (found != null) {
                principal = found;
                log.info("Principal found for camion '" +
                        camion.getSociete().getCode() + "-" + camion.getCode() + "' found : " +
                        principal.getSociete().getCode() + "-" + principal.getCode());
            }
        }
        result = new ArrayList<Camion>(principal.getCamionsAssocies());
        result.add(principal);
        return result;
    }

    @Override
    @Transaction
    public List<Chauffeur> getChauffeursForCamion(String codeSociete, String codeCamion) {
        throw new RuntimeException("This method must be never call");
    }

    public List<Chauffeur> getChauffeursForCamion(TopiaContext transaction, String codeSociete, String codeCamion)
            throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " getChauffeursForCamion codeSociete[" + codeSociete + "] codeCamion[" + codeCamion + "]");
        }

        Set<Chauffeur> chauffeurs = new HashSet<Chauffeur>();
        List<Camion> camions = findAllAssociatedCamions(transaction, codeSociete, codeCamion);
        for (Camion camion : camions) {
            chauffeurs.addAll(camion.getDefautChauffeurs());
        }
        return new ArrayList<Chauffeur>(chauffeurs);
    }

    @Override
    @Deprecated
    @Transaction
    public Chauffeur getChauffeursWithId(String codeSociete, String chauffeurCode)
            throws TopiaException {

        throw new RuntimeException("This method must be never call");
    }

    @Deprecated
    public Chauffeur getChauffeursWithId(TopiaContext transaction, String codeSociete, String chauffeurCode)
            throws TopiaException {

        return this.getChauffeursWithId(transaction, chauffeurCode);
    }

    @Override
    @Transaction
    public Chauffeur getChauffeursWithId(String chauffeurCode)
            throws TopiaException {

        throw new RuntimeException("This method must be never call");
    }

    public Chauffeur getChauffeursWithId(TopiaContext transaction, String chauffeurCode)
            throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " getChauffeursWithId chauffeurCode[" + chauffeurCode + "]");
        }

        ChauffeurDAO dao = SandraDAOHelper.getChauffeurDAO(transaction);
        Chauffeur chauffeurs = dao.findByNaturalId(chauffeurCode);
        return chauffeurs;
    }

    @Override
    @Deprecated
    @Transaction
    public Chauffeur getChauffeursWithTrigramme(String codeSociete, String chauffeurTrigramme)
            throws TopiaException {

        throw new RuntimeException("This method must be never call");
    }

    @Deprecated
    public Chauffeur getChauffeursWithTrigramme(TopiaContext transaction, String codeSociete, String chauffeurTrigramme)
            throws TopiaException {

        return getChauffeursWithTrigramme(transaction, chauffeurTrigramme);
    }

    @Override
    @Transaction
    public Chauffeur getChauffeursWithTrigramme(String chauffeurTrigramme)
            throws TopiaException {

        throw new RuntimeException("This method must be never call");
    }

    public Chauffeur getChauffeursWithTrigramme(TopiaContext transaction, String chauffeurTrigramme)
            throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " getChauffeursWithTrigramme chauffeurTrigramme[" + chauffeurTrigramme + "]");
        }

        ChauffeurDAO dao = SandraDAOHelper.getChauffeurDAO(transaction);
        Chauffeur chauffeurs = dao.findByTrigramme(chauffeurTrigramme);
        return chauffeurs;
    }

    @Override
    @Transaction
    public Camion getPrincipalCamionWithCamionId(String codeSociete, String codeCamion)
            throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public Camion getPrincipalCamionWithCamionId(TopiaContext transaction, String codeSociete, String codeCamion)
            throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " getPrincipalCamionWithCamionId codeSociete[" + codeSociete + "] codeCamion[" + codeCamion + "]");
        }

        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(transaction);
        Societe societe = societeDAO.findByCode(codeSociete);

        CamionDAO dao = SandraDAOHelper.getCamionDAO(transaction);
        Camion camions = dao.findByNaturalId(codeCamion, societe);

        return camions;
    }

    @Override
    @Transaction
    public List<Label> getLabelListForCategorie(String categorie)
            throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public List<Label> getLabelListForCategorie(TopiaContext transaction, String categorie)
            throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " getLabelListForCategorie categorie[" + categorie + "]");
        }

        LabelDAO dao = SandraDAOHelper.getLabelDAO(transaction);
        List<Label> labels = dao.findAllByCategorie(categorie);
        return labels;
    }

    @Override
    @Transaction
    public void createLabel(Label label) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void createLabel(TopiaContext transaction, Label label) throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " createLabel label[" + label + "]");
        }

        LabelDAO dao = SandraDAOHelper.getLabelDAO(transaction);
        Label dbLabel = dao.findByNaturalId(label.getId(), label.getCategorie());

        if (dbLabel == null) {
            dbLabel = dao.createByNaturalId(label.getId(), label.getCategorie());
        }
        dbLabel.setValeur(label.getValeur());
        dao.update(dbLabel);
    }

    @Override
    @Transaction
    public List<String> getTopiaIDTourForCamion(String codeSociete, String codeCamion) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public List<String> getTopiaIDTourForCamion(TopiaContext transaction, String codeSociete, String codeCamion) throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " getTopiaIDTourForCamion codeSociete[" + codeSociete + "] codeCamion[" + codeCamion + "]");
        }

        String requete = "FROM com.cybelia.sandra.entities.Tour tour WHERE tour.dateLivraison >= :dateDebut AND camion = :camion AND tour.actif = true";

        // Calcul de la date
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -7);
        Date date = DateUtil.setMinTimeOfDay(calendar.getTime());

        List<Camion> camions = findAllAssociatedCamions(transaction, codeSociete, codeCamion);
        List<String> topiaIdtours = new ArrayList<String>();
        for (Camion camion : camions) {
            List<Object> arguments = new ArrayList<Object>();
            arguments.add("dateDebut");
            arguments.add(date);
            arguments.add("camion");
            arguments.add(camion);

            List<Tour> tours = transaction.findAll(requete, arguments.toArray());
            for (Tour tour : tours) {
                topiaIdtours.add(tour.getTopiaId());
            }
        }

        return topiaIdtours;
    }

    @Override
    @Transaction
    public List<TourTypeModif> getModifiedTopiaIDTourForCamionSince(String codeSociete, String codeCamion, Long syncNumber) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public List<TourTypeModif> getModifiedTopiaIDTourForCamionSince(TopiaContext transaction, String codeSociete, String codeCamion, Long syncNumber) throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " getModifiedTopiaIDTourForCamionSince codeSociete[" + codeSociete + "] codeCamion[" + codeCamion + "] syncNumber[" + syncNumber + "]");
        }

        List<TourTypeModif> result = new ArrayList<TourTypeModif>();
        List<String> topiaIdtours;
        if (syncNumber == 0L) {
            topiaIdtours = getTopiaIDTourForCamion(transaction, codeSociete, codeCamion);

            for (String topiaId : topiaIdtours) {
                result.add(new TourTypeModif(topiaId, TourTypeModif.NOENTRY));
            }
            return result;

        } else {
            String request = "FROM com.cybelia.sandra.entities.synchro.Log WHERE " +
                    "typeModif IN (1, 2, 3) AND timeStamp >= :timeStampLess5 " +
                    "AND synchroNumber >= :syncNumber " +
                    "AND camionTopiaID IN (:camions)";

            // Calcul de la date
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(Calendar.DAY_OF_YEAR, -5);

            long tsLess5 = calendar.getTimeInMillis();

            List<Camion> camions = findAllAssociatedCamions(transaction, codeSociete, codeCamion);
            List<String> camionsTopiaIds = new ArrayList<String>();
            if (camions != null) {
                for (Camion c : camions) {
                    camionsTopiaIds.add(c.getTopiaId());
                }
            }
            List<Object> arguments = new ArrayList<Object>();
            arguments.add("timeStampLess5");
            arguments.add(tsLess5);
            arguments.add("syncNumber");
            arguments.add(syncNumber);
            arguments.add("camions");
            arguments.add(camionsTopiaIds.toArray());
            List<Log> logs = transaction.findAll(request, arguments.toArray());

            if (log.isDebugEnabled()){
                log.debug(logs.size() + " logs found by request : " + request + " with args : " + Arrays.toString(arguments.toArray()));
            }
            if (logs != null && !logs.isEmpty()) {
                for (Log l : logs) {
                    //                    if (!topiaIdtours.contains(l.getTourTopiaID())){
                    //                        topiaIdtours.add(l.getTourTopiaID());
                    result.add(new TourTypeModif(l.getTourTopiaID(), l.getTypeModif()));
                    //                    }

                    if (log.isDebugEnabled()){
                        log.debug("Return tour type modif " + l.getTypeModif() + " for tour : " + l.getTourTopiaID());
                    }
                }
            }
        }
        return result;
    }

    @Override
    @Transaction
    public Tour getTourWhithId(String topiaId) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public Tour getTourWhithId(TopiaContext transaction, String topiaId) throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " getTourWhithId topiaId[" + topiaId + "]");
        }

        TourDAO tourDAO = SandraDAOHelper.getTourDAO(transaction);
        Tour tour = tourDAO.findByTopiaId(topiaId);
        return tour;
    }

    @Override
    @Transaction
    public void clearInfoChargement(String topiaIdInfoChargement) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void clearInfoChargement(TopiaContext transaction, String topiaIdInfoChargement) throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " clearInfoChargement topiaIdInfoChargement[" + topiaIdInfoChargement + "]");
        }

        InfoChargementDAO infoChargementDAO = SandraDAOHelper.getInfoChargementDAO(transaction);
        InfoChargement infoChargement = infoChargementDAO.findByTopiaId(topiaIdInfoChargement);
        infoChargement.setNotifier(false);
        infoChargement = infoChargementDAO.update(infoChargement);
    }

    @Override
    @Transaction
    public List<LigneProduit> notifyInfoChargement(String topiaIdTour) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public List<LigneProduit> notifyInfoChargement(TopiaContext transaction, String topiaIdTour) throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " notifyInfoChargement topiaIdTour[" + topiaIdTour + "]");
        }

        List<LigneProduit> ligneProduits = transaction.findAll(
                "FROM com.cybelia.sandra.entities.LigneProduit ligneProduit WHERE " +
                "ligneProduit.etape.tour.topiaId = :topiaIdTour AND " +
                "ligneProduit.infoChargement.notifier = true", "topiaIdTour", topiaIdTour);

        return ligneProduits;
    }

} //ServiceTourImpl
