package com.cybelia.sandra.services.ejb3;

import com.cybelia.sandra.ibu.manager.SynchNumberManager;
import com.cybelia.sandra.services.ServiceSynchNumber;
import com.cybelia.sandra.services.local.ServiceSynchNumberLocal;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * @author sletellier
 */
@Stateless
@SecurityDomain("sandra")
@PermitAll
public class ServiceSynchNumberImpl extends BaseServiceImpl implements ServiceSynchNumberLocal, ServiceSynchNumber {

    @Override
    @Transaction
    public Long getNextSynchroNumber() throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public Long getNextSynchroNumber(TopiaContext transaction) throws TopiaException {
        return SynchNumberManager.getNextSynchroNumber(transaction);
    }

    @Override
    @Transaction
    public Long getCurrentSynchroNumber() throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public Long getCurrentSynchroNumber(TopiaContext transaction) throws TopiaException {
        return SynchNumberManager.getCurrentSynchroNumber(transaction);
    }
}
